/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.border;

import com.github.weisj.darklaf.util.ColorUtil;
import com.github.weisj.darklaf.util.Disposable;
import com.github.weisj.darklaf.util.ImageUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.ImageObserver;
import java.awt.image.Kernel;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.border.Border;

public class DropShadowBorder
implements Border,
Serializable {
    private static final Map<ImageHashKey, BufferedImage[]> CACHE = new HashMap<ImageHashKey, BufferedImage[]>();
    private Color shadowColor;
    private int shadowSize;
    private float shadowOpacity;
    private int cornerSize;

    public DropShadowBorder() {
        this(Color.BLACK, 5);
    }

    public DropShadowBorder(Color shadowColor, int shadowSize) {
        this(shadowColor, shadowSize, 0.5f, 12);
    }

    public DropShadowBorder(Color shadowColor, int shadowSize, float shadowOpacity, int cornerSize) {
        this.setShadowColor(shadowColor);
        this.setShadowSize(shadowSize);
        this.setShadowOpacity(shadowOpacity);
        this.setCornerSize(cornerSize);
    }

    @Override
    public void paintBorder(Component c, Graphics graphics, int x, int y, int width, int height) {
        BufferedImage[] images = this.getImages();
        Graphics2D g2 = (Graphics2D)graphics.create();
        try (Disposable ignored = g2::dispose;){
            int cornerImageSize = this.cornerImageSize();
            Point topLeftShadowPoint = new Point(x, y);
            Point bottomLeftShadowPoint = new Point(x, y + height - cornerImageSize);
            Point bottomRightShadowPoint = new Point(x + width - cornerImageSize, y + height - cornerImageSize);
            Point topRightShadowPoint = new Point(x + width - cornerImageSize, y);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            this.drawImage(g2, images[Position.LEFT.ordinal()], topLeftShadowPoint.x, topLeftShadowPoint.y + cornerImageSize, this.shadowSize, bottomLeftShadowPoint.y - topLeftShadowPoint.y - cornerImageSize, c);
            this.drawImage(g2, images[Position.BOTTOM.ordinal()], bottomLeftShadowPoint.x + cornerImageSize, y + height - this.shadowSize, bottomRightShadowPoint.x - bottomLeftShadowPoint.x - cornerImageSize, this.shadowSize, c);
            this.drawImage(g2, images[Position.RIGHT.ordinal()], x + width - this.shadowSize, topRightShadowPoint.y + cornerImageSize, this.shadowSize, bottomRightShadowPoint.y - topRightShadowPoint.y - cornerImageSize, c);
            this.drawImage(g2, images[Position.TOP.ordinal()], topLeftShadowPoint.x + cornerImageSize, topLeftShadowPoint.y, topRightShadowPoint.x - topLeftShadowPoint.x - cornerImageSize, this.shadowSize, c);
            this.drawImage(g2, images[Position.TOP_LEFT.ordinal()], topLeftShadowPoint.x, topLeftShadowPoint.y, cornerImageSize, cornerImageSize, c);
            this.drawImage(g2, images[Position.BOTTOM_LEFT.ordinal()], bottomLeftShadowPoint.x, bottomLeftShadowPoint.y, cornerImageSize, cornerImageSize, c);
            this.drawImage(g2, images[Position.BOTTOM_RIGHT.ordinal()], bottomRightShadowPoint.x, bottomRightShadowPoint.y, cornerImageSize, cornerImageSize, c);
            this.drawImage(g2, images[Position.TOP_RIGHT.ordinal()], topRightShadowPoint.x, topRightShadowPoint.y, cornerImageSize, cornerImageSize, c);
        }
    }

    protected void drawImage(Graphics g, Image image, int x, int y, int w, int h, ImageObserver observer) {
        g.drawImage(image, x, y, w, h, observer);
    }

    private int cornerImageSize() {
        return this.getCornerSize() + this.getShadowSize();
    }

    private BufferedImage[] getImages() {
        BufferedImage[] images = CACHE.get(new ImageHashKey(this.shadowSize, this.cornerSize, this.shadowColor, this.shadowOpacity));
        if (images == null) {
            images = new BufferedImage[Position.count()];
            int rectArc = this.shadowSize + this.cornerSize;
            int rectWidth = 2 * rectArc + 1;
            RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, rectWidth, rectWidth, rectArc, rectArc);
            int kernelSize = 3 * this.shadowSize / 4;
            int imageSize = rectWidth + 2 * kernelSize;
            BufferedImage image = ImageUtil.createCompatibleTranslucentImage((int)imageSize, (int)imageSize);
            Graphics2D buffer = (Graphics2D)image.getGraphics();
            try (Disposable ignored = buffer::dispose;){
                buffer.setPaint(ColorUtil.toAlpha((Color)this.shadowColor, (double)this.shadowOpacity));
                double offset = (double)(imageSize - rectWidth) / 2.0;
                buffer.translate(offset, offset);
                buffer.fill(rect);
            }
            float blurry = 1.0f / (float)(kernelSize * kernelSize);
            float[] blurKernel = new float[kernelSize * kernelSize];
            Arrays.fill(blurKernel, blurry);
            ConvolveOp blur = new ConvolveOp(new Kernel(kernelSize, kernelSize, blurKernel));
            BufferedImage targetImage = blur.filter(image, null);
            int cornerImageSize = this.cornerImageSize();
            int sideImageSize = this.shadowSize;
            int cornerOppositeOffset = imageSize - cornerImageSize;
            int sideOppositeOffset = imageSize - sideImageSize;
            images[Position.TOP_LEFT.ordinal()] = this.getSubImage(targetImage, 0, 0, cornerImageSize, cornerImageSize);
            images[Position.BOTTOM_LEFT.ordinal()] = this.getSubImage(targetImage, 0, cornerOppositeOffset, cornerImageSize, cornerImageSize);
            images[Position.BOTTOM_RIGHT.ordinal()] = this.getSubImage(targetImage, cornerOppositeOffset, cornerOppositeOffset, cornerImageSize, cornerImageSize);
            images[Position.TOP_RIGHT.ordinal()] = this.getSubImage(targetImage, cornerOppositeOffset, 0, cornerImageSize, cornerImageSize);
            images[Position.LEFT.ordinal()] = this.getSubImage(targetImage, 0, cornerImageSize, sideImageSize, 1);
            images[Position.BOTTOM.ordinal()] = this.getSubImage(targetImage, cornerImageSize, sideOppositeOffset, 1, sideImageSize);
            images[Position.RIGHT.ordinal()] = this.getSubImage(targetImage, sideOppositeOffset, cornerImageSize, sideImageSize, 1);
            images[Position.TOP.ordinal()] = this.getSubImage(targetImage, cornerImageSize, 0, 1, sideImageSize);
            image.flush();
            targetImage.flush();
            CACHE.put(new ImageHashKey(this.shadowSize, this.cornerSize, this.shadowColor, this.shadowOpacity), images);
        }
        return images;
    }

    private BufferedImage getSubImage(BufferedImage img, int x, int y, int w, int h) {
        BufferedImage ret = ImageUtil.createCompatibleTranslucentImage((int)w, (int)h);
        Graphics2D g = ret.createGraphics();
        try (Disposable ignored = g::dispose;){
            g.drawImage(img, 0, 0, w, h, x, y, x + w, y + h, null);
        }
        return ret;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.shadowSize, this.shadowSize, this.shadowSize, this.shadowSize);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public int getShadowSize() {
        return this.shadowSize;
    }

    public void setShadowSize(int shadowSize) {
        this.shadowSize = shadowSize;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(Color shadowColor) {
        this.shadowColor = shadowColor;
        if (shadowColor == null) {
            this.shadowColor = Color.BLACK;
        }
    }

    public float getShadowOpacity() {
        return this.shadowOpacity;
    }

    public void setShadowOpacity(float shadowOpacity) {
        this.shadowOpacity = shadowOpacity;
    }

    public int getCornerSize() {
        return this.cornerSize;
    }

    public void setCornerSize(int cornerSize) {
        this.cornerSize = Math.min(this.shadowSize, cornerSize);
    }

    private static enum Position {
        TOP,
        TOP_LEFT,
        LEFT,
        BOTTOM_LEFT,
        BOTTOM,
        BOTTOM_RIGHT,
        RIGHT,
        TOP_RIGHT;


        static int count() {
            return 8;
        }
    }

    private static final class ImageHashKey {
        private final int shadowSize;
        private final int cornerSize;
        private final Color shadowColor;
        private final float opacity;

        private ImageHashKey(int shadowSize, int cornerSize, Color shadowColor, float opacity) {
            this.shadowSize = shadowSize;
            this.cornerSize = cornerSize;
            this.shadowColor = shadowColor;
            this.opacity = opacity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ImageHashKey)) {
                return false;
            }
            ImageHashKey that = (ImageHashKey)o;
            return this.shadowSize == that.shadowSize && this.cornerSize == that.cornerSize && Float.compare(that.opacity, this.opacity) == 0 && Objects.equals(this.shadowColor, that.shadowColor);
        }

        public int hashCode() {
            return Objects.hash(this.shadowSize, this.cornerSize, this.shadowColor, Float.valueOf(this.opacity));
        }
    }
}

