/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.iconeditor;

import com.github.weisj.darklaf.DarkLaf;
import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.components.ComponentHelper;
import com.github.weisj.darklaf.components.DynamicUI;
import com.github.weisj.darklaf.components.border.DarkBorders;
import com.github.weisj.darklaf.components.chooser.ListChooser;
import com.github.weisj.darklaf.components.color.QuickColorChooser;
import com.github.weisj.darklaf.components.iconeditor.Named;
import com.github.weisj.darklaf.components.iconeditor.NamedColor;
import com.github.weisj.darklaf.components.iconeditor.NamedInt;
import com.github.weisj.darklaf.components.popup.AttachedPopupComponent;
import com.github.weisj.darklaf.components.popup.SharedComponent;
import com.github.weisj.darklaf.components.renderer.SimpleListCellRenderer;
import com.github.weisj.darklaf.iconset.AllIcons;
import com.github.weisj.darklaf.layout.LayoutHelper;
import com.github.weisj.darklaf.properties.PropertyLoader;
import com.github.weisj.darklaf.properties.icons.CustomThemedIcon;
import com.github.weisj.darklaf.properties.icons.DarkSVGIcon;
import com.github.weisj.darklaf.properties.icons.IconColorMapper;
import com.github.weisj.darklaf.properties.icons.IconDelegate;
import com.github.weisj.darklaf.properties.icons.MutableThemedIcon;
import com.github.weisj.darklaf.properties.icons.SolidColorIcon;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.util.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class IconEditorPanel
extends JPanel {
    private static final int GAP = 2;
    private final Theme theme;
    private final JLabel renderer;
    private final JPanel valuePanel;
    private final JButton reset;
    private final JButton save;
    private final Map<Object, Object> propertyBackup = new HashMap<Object, Object>();
    private final Map<Object, Object> properties = new HashMap<Object, Object>();
    private final Map<Object, Consumer<Object>> updateAction = new HashMap<Object, Consumer<Object>>();
    private final HashSet<String> changedKeys = new HashSet();
    private Dimension pickerSize;
    private Insets spinnerInsets;
    private Icon icon;
    private MutableThemedIcon themedIcon;

    public IconEditorPanel(Icon icon) {
        this(icon, LafManager.getTheme());
    }

    public IconEditorPanel(Icon icon, Theme theme) {
        this.theme = theme;
        this.setLayout(new BorderLayout());
        this.valuePanel = new JPanel(new BorderLayout());
        this.valuePanel.setBorder(LayoutHelper.createEmptyContainerBorder());
        this.reset = DynamicUI.withLocalizedTooltip(ComponentHelper.createIconOnlyButton(AllIcons.Action.Revert.get(), AllIcons.Action.Revert.disabled()), "Actions.revert");
        this.reset.addActionListener(e -> this.restore());
        this.save = DynamicUI.withLocalizedTooltip(ComponentHelper.createIconOnlyButton(AllIcons.Action.Save.get(), AllIcons.Action.Save.disabled()), "Actions.save");
        this.save.addActionListener(e -> this.save());
        int topBottomPad = this.save.getPreferredSize().height;
        JPanel rendererPanel = new JPanel(new GridBagLayout());
        this.renderer = new JLabel();
        rendererPanel.add(this.renderer);
        rendererPanel.setBackground(new Color(IconValues.getIconDefaults(theme).defaults.getColor("background").getRGB(), true));
        rendererPanel.setBorder(BorderFactory.createCompoundBorder(DarkBorders.createBottomBorderWithSpacing(), BorderFactory.createEmptyBorder(topBottomPad, 0, topBottomPad, 0)));
        JPanel holder = new JPanel(new BorderLayout());
        holder.add((Component)LayoutHelper.createPanelWithHoverOverlay(rendererPanel, LayoutHelper.createHorizontalBox(2, this.save, this.reset)), "North");
        holder.add((Component)this.valuePanel, "Center");
        this.add((Component)holder, "Center");
        this.setIcon(icon);
        this.updateButtons();
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        if (icon instanceof MutableThemedIcon) {
            this.themedIcon = (MutableThemedIcon)icon;
            if (this.themedIcon instanceof CustomThemedIcon) {
                this.themedIcon = (CustomThemedIcon)((CustomThemedIcon)this.themedIcon).copy();
            }
        } else if (icon instanceof DarkSVGIcon) {
            CustomThemedIcon svgIcon = new CustomThemedIcon((DarkSVGIcon)icon);
            svgIcon.setDirectRenderingMode(true);
            this.themedIcon = svgIcon;
        } else {
            this.themedIcon = new MutableThemedIconStub(icon);
        }
        this.themedIcon.setContextProperties((Map)IconValues.getIconDefaults(this.theme).defaults);
        if (this.themedIcon instanceof CustomThemedIcon) {
            ((CustomThemedIcon)this.themedIcon).mergeProperties(CustomThemedIcon.MergeMode.REPLACE_REFERENCES, icon instanceof DarkSVGIcon ? (DarkSVGIcon)icon : null);
        }
        this.renderer.setIcon((Icon)this.themedIcon);
        this.updateEditor();
    }

    private void updateEditor() {
        this.properties.clear();
        this.propertyBackup.clear();
        this.updateAction.clear();
        this.valuePanel.removeAll();
        Map props = this.themedIcon.getProperties();
        this.properties.putAll(props);
        this.propertyBackup.putAll(props);
        List keys = props.entrySet().stream().sorted((e1, e2) -> {
            boolean color1 = e1.getValue() instanceof Color;
            boolean color2 = e2.getValue() instanceof Color;
            if (color1 && !color2) {
                return -1;
            }
            if (color2 && !color1) {
                return 1;
            }
            return e1.getKey().toString().compareTo(e2.getKey().toString());
        }).map(e -> e.getKey().toString()).collect(Collectors.toList());
        this.valuePanel.add(LayoutHelper.createTitledColumn(keys.stream().map(s -> s + ":").collect(Collectors.toList()), keys.stream().map(k -> this.createValueEditor((String)k, this.get((String)k, (Class)Object.class))).collect(Collectors.toList()), LayoutHelper.getDefaultSpacing()));
        this.revalidate();
        this.repaint();
        SwingUtilities.invokeLater(() -> {
            this.revalidate();
            this.repaint();
        });
    }

    private JComponent createValueEditor(String key, Object value) {
        if (value instanceof Color) {
            Color color = (Color)value;
            JButton palette = this.createPaletteButton();
            AttachedPopupComponent.attachChooser(palette, () -> IconValues.getSwatchChooser(this.theme), c -> {
                if (c != null) {
                    this.updateAction.get(key).accept(c);
                    this.put(key, c);
                }
            }, () -> {
                Pair<Object, Color> entry = this.getEntry(key, Color.class);
                return new NamedColor(entry.getFirst().toString(), (Color)entry.getSecond());
            });
            if (this.pickerSize == null || this.spinnerInsets == null) {
                this.pickerSize = palette.getPreferredSize();
                JSpinner sp = new JSpinner(new SpinnerNumberModel(10, 0, 100, 1));
                this.spinnerInsets = sp.getBorder().getBorderInsets(sp);
                this.pickerSize.width = sp.getPreferredSize().width - this.spinnerInsets.left - this.spinnerInsets.right;
            }
            QuickColorChooser chooser = new QuickColorChooser(null, color, (b, c) -> this.put(key, c), false, this.pickerSize);
            chooser.setDragEnabled(true);
            DynamicUI.withLocalizedTooltip(chooser, "Labels.colorChooser");
            chooser.setBorder(LayoutHelper.createEmptyBorder(this.spinnerInsets));
            this.updateAction.put(key, o -> {
                if (o instanceof Color) {
                    chooser.setColor((Color)o, false);
                }
            });
            return LayoutHelper.createHorizontalBox(2, chooser, palette);
        }
        if (value instanceof Integer) {
            JButton palette = this.createPaletteButton();
            AttachedPopupComponent.attachChooser(palette, () -> IconValues.getOpacityChooser(this.theme), i -> {
                if (i != null) {
                    this.updateAction.get(key).accept(i.getValue());
                    this.put(key, i);
                }
            }, () -> {
                Pair<Object, Integer> entry = this.getEntry(key, Integer.class);
                return new NamedInt(entry.getFirst().toString(), (Integer)entry.getSecond());
            });
            SpinnerNumberModel numberModel = new SpinnerNumberModel((Integer)value, 0, 100, 1);
            numberModel.addChangeListener(e -> this.put(key, numberModel.getValue()));
            this.updateAction.put(key, o -> {
                if (o instanceof Integer) {
                    numberModel.setValue(o);
                }
            });
            return LayoutHelper.createHorizontalBox(2, new JSpinner(numberModel), palette);
        }
        return new JLabel(value.toString());
    }

    private JButton createPaletteButton() {
        return DynamicUI.withLocalizedTooltip(ComponentHelper.createIconOnlyButton(AllIcons.Misc.Palette.get(), AllIcons.Misc.Palette.disabled()), "Actions.predefinedValues");
    }

    private <T> Pair<Object, T> getEntry(String key, Class<T> type) {
        return IconColorMapper.getEntry(this.properties, (Map)IconValues.getIconDefaults(this.theme).defaults, (Object)key, null, type);
    }

    private <T> T get(String key, Class<T> type) {
        return (T)IconColorMapper.get(this.properties, (Map)IconValues.getIconDefaults(this.theme).defaults, (Object)key, null, type);
    }

    private void put(String key, Object value) {
        if (value == null) {
            return;
        }
        Object effectiveValue = value;
        if (value instanceof Named) {
            effectiveValue = PropertyLoader.getReferencePrefix() + ((Named)value).getName();
        }
        Object prevEff = this.properties.put(key, effectiveValue);
        Object prev = this.propertyBackup.get(key);
        if (!effectiveValue.equals(prev)) {
            this.changedKeys.add(key);
        } else {
            this.changedKeys.remove(key);
        }
        this.updateButtons();
        if (!effectiveValue.equals(prevEff)) {
            this.peek();
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    private void peek() {
        this.themedIcon.setProperties(this.properties);
        this.renderer.repaint();
    }

    public void save() {
        this.peek();
        this.propertyBackup.putAll(this.properties);
        this.changedKeys.clear();
        this.updateButtons();
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void restore() {
        this.themedIcon.setProperties(new HashMap<Object, Object>(this.propertyBackup));
        this.properties.clear();
        this.properties.putAll(this.propertyBackup);
        this.properties.forEach((k, v) -> {
            Consumer<Object> cons = this.updateAction.get(k);
            if (cons != null) {
                cons.accept(this.get(k.toString(), Object.class));
            }
        });
        this.changedKeys.clear();
        this.renderer.repaint();
        this.updateButtons();
    }

    public Map<String, Object> exportProperties() {
        return this.properties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), Map.Entry::getValue));
    }

    private void updateButtons() {
        boolean changed = !this.changedKeys.isEmpty();
        this.reset.getParent().setVisible(changed);
        this.reset.setEnabled(changed);
        this.save.setEnabled(changed);
    }

    static final class IconValues {
        private static final Map<Theme, SharedComponent<ColorPaletteChooser>> chooserMap = new HashMap<Theme, SharedComponent<ColorPaletteChooser>>();
        private static final Map<Theme, SharedComponent<OpacityChooser>> opacityChooserMap = new HashMap<Theme, SharedComponent<OpacityChooser>>();
        private static final Map<Theme, ThemeIconDefaults> themePropertyMap = new HashMap<Theme, ThemeIconDefaults>();

        IconValues() {
        }

        public static ColorPaletteChooser getSwatchChooser(Theme theme) {
            return (ColorPaletteChooser)chooserMap.computeIfAbsent(theme, t -> new SharedComponent<ColorPaletteChooser>(() -> IconValues.createSwatchChooser(t))).get();
        }

        public static OpacityChooser getOpacityChooser(Theme theme) {
            return (OpacityChooser)opacityChooserMap.computeIfAbsent(theme, t -> new SharedComponent<OpacityChooser>(() -> IconValues.createOpacityChooser(t))).get();
        }

        public static ThemeIconDefaults getIconDefaults(Theme theme) {
            return themePropertyMap.computeIfAbsent(theme, t -> {
                UIDefaults defaults = theme.equals((Object)LafManager.getInstalledTheme()) ? UIManager.getLookAndFeelDefaults() : new DarkLaf((Theme)t){
                    final /* synthetic */ Theme val$t;
                    {
                        this.val$t = theme;
                    }

                    @Override
                    public Theme getTheme() {
                        return this.val$t;
                    }
                }.getDefaults();
                Properties props = new Properties();
                theme.loadIconTheme(props, defaults, DarkUIUtil.iconResolver());
                props.entrySet().forEach(e -> e.setValue(defaults.get(e.getKey())));
                return new ThemeIconDefaults(defaults, props);
            });
        }

        private static ColorPaletteChooser createSwatchChooser(Theme theme) {
            ThemeIconDefaults defaults = IconValues.getIconDefaults(theme);
            if (defaults.colors == null) {
                List entries = defaults.props.entrySet().stream().filter(e -> e.getValue() instanceof Color && e.getKey() instanceof String).map(e -> new Pair((Object)e.getKey().toString(), (Object)((Color)e.getValue()))).collect(Collectors.toList());
                defaults.colors = entries.stream().map(p -> new NamedColor((String)p.getFirst(), (Color)p.getSecond())).sorted((c1, c2) -> {
                    boolean p2;
                    String n1 = c1.getName();
                    String n2 = c2.getName();
                    boolean p1 = n1.startsWith("palette.");
                    if (p1 == (p2 = n2.startsWith("palette."))) {
                        return n1.compareTo(n2);
                    }
                    return Boolean.compare(p1, p2);
                }).collect(Collectors.toList());
            }
            return new ColorPaletteChooser(defaults.colors);
        }

        private static OpacityChooser createOpacityChooser(Theme theme) {
            ThemeIconDefaults defaults = IconValues.getIconDefaults(theme);
            if (defaults.opacities == null) {
                List entries = defaults.props.entrySet().stream().filter(e -> e.getValue() instanceof Integer && e.getKey() instanceof String).map(e -> new Pair((Object)e.getKey().toString(), (Object)((Integer)e.getValue()))).collect(Collectors.toList());
                defaults.opacities = entries.stream().map(p -> new NamedInt((String)p.getFirst(), (Integer)p.getSecond())).collect(Collectors.toList());
            }
            return new OpacityChooser(defaults.opacities);
        }

        public static class ThemeIconDefaults {
            private final UIDefaults defaults;
            private final Properties props;
            private List<NamedColor> colors;
            private List<NamedInt> opacities;

            private ThemeIconDefaults(UIDefaults defaults, Properties props) {
                this.props = props;
                this.defaults = defaults;
            }

            public UIDefaults getDefaults() {
                return this.defaults;
            }
        }
    }

    private static class MutableThemedIconStub
    extends IconDelegate
    implements MutableThemedIcon {
        public MutableThemedIconStub(Icon icon) {
            super(icon);
        }

        public Map<Object, Object> getProperties() {
            return Collections.emptyMap();
        }

        public void setProperties(Map<Object, Object> props) {
        }

        public void setContextProperties(Map<Object, Object> props) {
        }

        public Map<Object, Object> getContextProperties() {
            return Collections.emptyMap();
        }
    }

    private static class OpacityChooser
    extends ListChooser<NamedInt> {
        protected OpacityChooser(List<NamedInt> values) {
            super(values);
            this.setBorder(LayoutHelper.createEmptyContainerBorder());
            this.listComp.setCellRenderer(SimpleListCellRenderer.create(v -> v.getValue() + "% " + v.getName()));
        }
    }

    private static class ColorPaletteChooser
    extends ListChooser<NamedColor> {
        private final SolidColorIcon icon = new SolidColorIcon();

        protected ColorPaletteChooser(List<NamedColor> values) {
            super(values);
            this.setBorder(LayoutHelper.createEmptyContainerBorder());
            this.listComp.setCellRenderer(SimpleListCellRenderer.create((c, v) -> {
                this.icon.setColor(v.getColor());
                c.setIcon((Icon)this.icon);
                c.setText(v.getName());
            }));
            this.listComp.setVisibleRowCount(15);
        }
    }
}

