/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.tabframe;

import com.github.weisj.darklaf.components.tabframe.PanelPopup;
import com.github.weisj.darklaf.components.tabframe.TabArea;
import com.github.weisj.darklaf.components.tabframe.TabFrameContent;
import com.github.weisj.darklaf.components.tabframe.TabFrameContentPane;
import com.github.weisj.darklaf.components.tabframe.TabFramePopup;
import com.github.weisj.darklaf.components.tabframe.TabFrameTab;
import com.github.weisj.darklaf.components.tabframe.TabFrameTabContainer;
import com.github.weisj.darklaf.components.tabframe.TabFrameTabLabel;
import com.github.weisj.darklaf.components.tabframe.TabFrameUI;
import com.github.weisj.darklaf.ui.tabframe.TabFrameTransferHandler;
import com.github.weisj.darklaf.util.Alignment;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class JTabFrame
extends JComponent {
    public static final String KEY_DND = "dndEnabled";
    private final JComponent bottomTabs = this.createTabContainer();
    private final JComponent topTabs = this.createTabContainer();
    private final JComponent leftTabs = this.createTabContainer();
    private final JComponent rightTabs = this.createTabContainer();
    private final TabFrameContent content = this.createContentPane();
    private final List<TabFrameTab>[] tabLists;
    private final List<TabFramePopup>[] popupLists;
    private final int[] selectedIndices;
    private int tabSize = -1;
    private int maxTabWidth = -1;
    private boolean inTransfer;
    private Alignment transferAlign;
    private int transferIndex;
    private boolean dndEnabled;

    public JTabFrame() {
        this.updateUI();
        this.add(this.content.getComponent());
        int count = Alignment.values().length;
        this.tabLists = new ArrayList[count];
        this.popupLists = new ArrayList[count];
        for (int i = 0; i < count; ++i) {
            this.tabLists[i] = new ArrayList<TabFrameTab>();
            this.popupLists[i] = new ArrayList<TabFramePopup>();
        }
        this.selectedIndices = new int[count];
        this.setDndEnabled(true);
    }

    @Override
    public void updateUI() {
        this.updatePopupUIs();
        this.setUI(UIManager.getUI(this));
    }

    protected void updatePopupUIs() {
        if (this.popupLists != null) {
            for (List<TabFramePopup> list : this.popupLists) {
                if (list == null) continue;
                for (TabFramePopup popup : list) {
                    if (popup == null) continue;
                    popup.updateContentUI();
                }
            }
        }
    }

    @Override
    public TabFrameUI getUI() {
        return (TabFrameUI)this.ui;
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        if (!(newUI instanceof TabFrameUI)) {
            throw new IllegalArgumentException("UI class must be of type TabFrameUI");
        }
        super.setUI(newUI);
    }

    @Override
    public String getUIClassID() {
        return "TabFrameUI";
    }

    public int getTabSize() {
        return this.tabSize >= 0 ? this.tabSize : this.getUI().getTabSize(this);
    }

    public void setTabSize(int size) {
        this.tabSize = size;
    }

    public int getMaxTabWidth() {
        return this.maxTabWidth;
    }

    public void setMaxTabWidth(int maxTabWidth) {
        this.maxTabWidth = maxTabWidth;
    }

    public int getTopTabCount() {
        return this.getTabCountAt(Alignment.NORTH) + this.getTabCountAt(Alignment.NORTH_EAST);
    }

    public int getTabCountAt(Alignment a) {
        return this.tabsForAlignment(a).size();
    }

    public void insertTab(Component c, Alignment a, int index) {
        String title = c.getName();
        this.insertTab(c, title == null ? "" : title, a, index);
    }

    public int getBottomTabCount() {
        return this.getTabCountAt(Alignment.SOUTH) + this.getTabCountAt(Alignment.SOUTH_WEST);
    }

    public int getLeftTabCount() {
        return this.getTabCountAt(Alignment.WEST) + this.getTabCountAt(Alignment.NORTH_WEST);
    }

    public int getRightTabCount() {
        return this.getTabCountAt(Alignment.EAST) + this.getTabCountAt(Alignment.SOUTH_EAST);
    }

    public Component getContent() {
        return this.content.getContent();
    }

    public void setContent(Component c) {
        this.content.setContent(c);
    }

    protected JComponent createTabContainer() {
        return new TabArea();
    }

    protected TabFrameContent createContentPane() {
        return new TabFrameContentPane();
    }

    public void insertTab(Component c, String title, Alignment a, int index) {
        this.insertTab(c, title, null, a, index);
    }

    public void insertTab(Component c, String title, Icon icon, Alignment a, int index) {
        PanelPopup popup = new PanelPopup(title, icon, c);
        this.insertTab(popup, title, icon, a, index);
    }

    public void insertTab(TabFramePopup c, String title, Icon icon, Alignment a, int index) {
        if (a == Alignment.CENTER) {
            return;
        }
        this.insertTab(c, this.createDefaultTab(title, icon, a, index), a, index);
    }

    public void insertTab(TabFramePopup c, TabFrameTab tab, Alignment a, int index) {
        if (a == Alignment.CENTER) {
            return;
        }
        this.insertTabComp(tab, a, index);
        this.compsForAlignment(a).add(index, c);
        c.setEnabled(false);
        c.setTabFrame(this);
        c.setAlignment(a);
        c.setIndex(index);
    }

    private void insertTabComp(TabFrameTab tabComp, Alignment a, int index) {
        tabComp.setOrientation(a);
        this.getTabContainer(a).add(tabComp.getComponent());
        List<TabFrameTab> tabs = this.tabsForAlignment(a);
        ListIterator<TabFrameTab> iterator = tabs.listIterator(index);
        while (iterator.hasNext()) {
            TabFrameTab tab = (TabFrameTab)iterator.next();
            tab.setIndex(tab.getIndex() + 1);
        }
        tabComp.setIndex(index);
        tabComp.setOrientation(a);
        tabs.add(index, tabComp);
    }

    protected TabFrameTab createDefaultTab(String text, Icon icon, Alignment a, int index) {
        return new TabFrameTabLabel(text, icon, a, index, this);
    }

    public List<TabFramePopup> compsForAlignment(Alignment a) {
        return this.popupLists[a.ordinal()];
    }

    public JComponent getTabContainer(Alignment a) {
        switch (a) {
            case NORTH: 
            case NORTH_EAST: {
                return this.getTopTabContainer();
            }
            case SOUTH: 
            case SOUTH_WEST: {
                return this.getBottomTabContainer();
            }
            case EAST: 
            case SOUTH_EAST: {
                return this.getRightTabContainer();
            }
            case WEST: 
            case NORTH_WEST: {
                return this.getLeftTabContainer();
            }
            case CENTER: {
                throw new IllegalArgumentException("invalid alignment: " + a);
            }
        }
        throw new IllegalArgumentException();
    }

    public List<TabFrameTab> tabsForAlignment(Alignment a) {
        return this.tabLists[a.ordinal()];
    }

    public JComponent getTopTabContainer() {
        return this.topTabs;
    }

    public JComponent getBottomTabContainer() {
        return this.bottomTabs;
    }

    public JComponent getRightTabContainer() {
        return this.rightTabs;
    }

    public JComponent getLeftTabContainer() {
        return this.leftTabs;
    }

    public void setTabAt(TabFramePopup c, String title, Icon icon, Alignment a, int index) {
        if (a == Alignment.CENTER) {
            return;
        }
        String text = title == null ? c.getComponent().getName() : title;
        text = text == null ? c.getTitle() : text;
        TabFrameTab tabComponent = this.createDefaultTab(text, icon, a, index);
        c.setTitle(text);
        c.setIcon(icon);
        c.setTabFrame(this);
        c.setAlignment(a);
        c.setIndex(index);
        tabComponent.setSelected(this.getTabComponentAt(a, index).isSelected());
        this.setTabComponent(tabComponent, a, index);
        this.compsForAlignment(a).set(index, c);
        if (tabComponent.isSelected()) {
            this.getComponentAt(a, index).doLayout();
            this.getComponentAt(a, index).repaint();
        }
    }

    public TabFrameTab getTabComponentAt(Alignment a, int index) {
        List<TabFrameTab> tabs = this.tabsForAlignment(a);
        return tabs.get(index);
    }

    private void setTabComponent(TabFrameTab tab, Alignment a, int index) {
        List<TabFrameTab> tabs = this.tabsForAlignment(a);
        TabFrameTab oldComp = tabs.get(index);
        this.getTabContainer(a).remove(oldComp.getComponent());
        this.getTabContainer(a).add(tab.getComponent());
        tabs.set(index, tab);
    }

    public Component getComponentAt(Alignment a, int index) {
        List<TabFramePopup> tabs = this.compsForAlignment(a);
        return tabs.get(index).getContentPane();
    }

    public void closeTab(Component c) {
        TabFramePosition res = this.findComponent(c);
        if (res != null) {
            this.closeTab(res.getAlignment(), res.getIndex());
        }
    }

    public TabFramePosition findComponent(Component c) {
        for (Alignment a : Alignment.values()) {
            List<TabFramePopup> list = this.popupLists[a.ordinal()];
            for (int i = 0; i < list.size(); ++i) {
                if (!Objects.equals(list.get(i).getContentPane(), c)) continue;
                return new TabFramePosition(a, i);
            }
        }
        return null;
    }

    public void closeTab(Alignment a, int index) {
        this.toggleTab(a, index, false);
    }

    public void toggleTab(Alignment a, int index, boolean enabled) {
        int oldIndex = this.selectedIndices[a.getIndex()];
        if (this.content.isEnabled(a) == enabled && oldIndex == index) {
            return;
        }
        TabFrameTab compAtIndex = this.getTabComponentAt(a, index);
        if (!compAtIndex.isEnabled()) {
            return;
        }
        compAtIndex.setSelected(enabled);
        this.compsForAlignment(a).get(index).setOpen(enabled);
        this.notifySelectionChange(compAtIndex);
        this.setPopupVisibility(compAtIndex, enabled);
        if (enabled) {
            this.getPopupComponentAt(a).doLayout();
            this.getPopupComponentAt(a).requestFocusInWindow();
        }
        this.firePropertyChange("visibleTab", new TabFramePosition(a, oldIndex), new TabFramePosition(a, index));
    }

    public boolean isTabSelected(Alignment a, int index) {
        if (this.getTabCountAt(a) <= index) {
            return false;
        }
        TabFrameTab compAtIndex = this.getTabComponentAt(a, index);
        return compAtIndex != null && compAtIndex.isSelected();
    }

    public void setTabEnabled(Alignment a, int index, boolean enabled) {
        this.getTabComponentAt(a, index).setEnabled(enabled);
    }

    public void notifySelectionChange(TabFrameTab tabComponent) {
        if (tabComponent == null) {
            return;
        }
        Alignment a = tabComponent.getOrientation();
        int n = this.selectedIndices[a.ordinal()] = tabComponent.isSelected() ? tabComponent.getIndex() : -1;
        if (tabComponent.isSelected()) {
            for (TabFrameTab tc : this.tabsForAlignment(a)) {
                if (tc == null || tc == tabComponent) continue;
                tc.setSelected(false);
            }
        }
    }

    private void setPopupVisibility(TabFrameTab tabComponent, boolean selected) {
        Alignment a = tabComponent.getOrientation();
        TabFramePopup c = this.compsForAlignment(a).get(tabComponent.getIndex());
        c.setEnabled(selected);
        this.content.setComponentAt(a, c.getComponent());
        this.content.setEnabled(a, selected);
        this.doLayout();
    }

    public TabFramePopup getPopupAt(Alignment a) {
        List<TabFramePopup> tabs = this.compsForAlignment(a);
        return tabs.get(Math.max(Math.min(tabs.size() - 1, this.selectedIndices[a.ordinal()]), 0));
    }

    public Component getPopupComponentAt(Alignment a) {
        return this.getPopupAt(a).getComponent();
    }

    public TabFramePopup getPopupAt(Alignment a, int index) {
        List<TabFramePopup> tabs = this.compsForAlignment(a);
        return tabs.get(index);
    }

    public Component getPopupComponentAt(Alignment a, int index) {
        return this.getPopupAt(a, index).getComponent();
    }

    public void closeTab(TabFramePopup c) {
        if (c == null) {
            return;
        }
        this.closeTab(c.getAlignment(), c.getIndex());
    }

    public void openTab(Component c) {
        TabFramePosition res = this.findComponent(c);
        if (res != null) {
            this.openTab(res.getAlignment(), res.getIndex());
        }
    }

    public void openTab(Alignment a, int index) {
        this.toggleTab(a, index, true);
    }

    public void openTab(TabFramePopup c) {
        if (c == null) {
            return;
        }
        this.openTab(c.getAlignment(), c.getIndex());
    }

    public void addTab(Component c, String title, Alignment a) {
        this.addTab(c, title, null, a);
    }

    public void addTab(Component c, String title, Icon icon, Alignment a) {
        this.insertTab(c, title, icon, a, this.tabsForAlignment(a).size());
    }

    public void addTab(TabFramePopup c, String title, Icon icon, Alignment a) {
        this.insertTab(c, title, icon, a, this.tabsForAlignment(a).size());
    }

    public void moveTab(TabFrameTab tabComp, Alignment a) {
        if (a == tabComp.getOrientation()) {
            return;
        }
        boolean oldSelected = tabComp.isSelected();
        Alignment oldAlign = tabComp.getOrientation();
        int oldIndex = tabComp.getIndex();
        this.closeTab(oldAlign, oldIndex);
        TabFramePopup comp = this.compsForAlignment(oldAlign).get(oldIndex);
        this.removeTab(oldAlign, oldIndex);
        this.addTab(comp, tabComp, a);
        if (oldSelected) {
            this.openTab(a, tabComp.getIndex());
        }
        this.doLayout();
        this.getTabContainer(a).repaint();
    }

    public void removeTab(Alignment a, int index) {
        TabFramePopup comp = this.compsForAlignment(a).get(index);
        comp.close();
        comp.setTabFrame(null);
        comp.setIndex(-1);
        this.removeTabComp(a, index);
        this.doLayout();
        this.getTabContainer(a).repaint();
    }

    public void addTab(TabFramePopup c, TabFrameTab tab, Alignment a) {
        this.insertTab(c, tab, a, this.tabsForAlignment(a).size());
    }

    private void removeTabComp(Alignment a, int index) {
        TabFrameTab tab;
        List<TabFrameTab> tabs = this.tabsForAlignment(a);
        ListIterator<TabFrameTab> iterator = tabs.listIterator(index);
        while (iterator.hasNext()) {
            tab = (TabFrameTab)iterator.next();
            tab.setIndex(tab.getIndex() - 1);
        }
        tab = tabs.remove(index);
        this.getTabContainer(a).remove(tab.getComponent());
    }

    public Component getUserTabComponentAt(Alignment a, int index) {
        TabFrameTab tab = this.getTabComponentAt(a, index);
        if (tab instanceof TabFrameTabContainer) {
            return ((TabFrameTabContainer)tab).getContent();
        }
        return null;
    }

    public void setUserTabComponentAt(JComponent component, Alignment a, int index) {
        List<TabFrameTab> tabs = this.tabsForAlignment(a);
        TabFrameTab tabContainer = tabs.get(index);
        if (component == null) {
            if (tabContainer instanceof TabFrameTabContainer) {
                this.setTabComponent(((TabFrameTabContainer)tabContainer).oldTab, a, index);
            }
        } else if (tabContainer instanceof TabFrameTabContainer) {
            ((TabFrameTabContainer)tabContainer).setContent(component);
        } else {
            TabFrameTabContainer cont = new TabFrameTabContainer(this, component, tabContainer, a, index);
            this.setTabComponent(cont, a, index);
        }
    }

    public void setAcceleratorAt(int accelerator, Alignment a, int index) {
        this.getTabComponentAt(a, index).setAccelerator(accelerator);
    }

    public Alignment getPeer(Alignment a) {
        switch (a) {
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                return a.clockwise();
            }
            case NORTH_EAST: 
            case SOUTH_WEST: 
            case SOUTH_EAST: 
            case NORTH_WEST: {
                return a.anticlockwise();
            }
        }
        return a;
    }

    public boolean isInTransfer() {
        return this.inTransfer;
    }

    public void initTransfer(Alignment a, int index) {
        this.getContentPane().getComponent().setEnabled(false);
        this.inTransfer = true;
        this.transferAlign = a;
        this.transferIndex = index;
    }

    public TabFrameContent getContentPane() {
        return this.content;
    }

    public boolean isSelected(Alignment a, int index) {
        if (a == null) {
            return false;
        }
        return this.selectedIndices[a.ordinal()] == index;
    }

    public int getSelectedIndex(Alignment a) {
        return this.selectedIndices[a.ordinal()];
    }

    public void endTransfer() {
        this.getContentPane().getComponent().setEnabled(true);
        this.inTransfer = false;
        this.transferAlign = null;
        this.transferIndex = -10;
    }

    public TabFramePosition getTransferInfo() {
        return new TabFramePosition(this.transferAlign, this.transferIndex);
    }

    public boolean isDndEnabled() {
        return this.dndEnabled && this.getTransferHandler() instanceof TabFrameTransferHandler;
    }

    public void setDndEnabled(boolean dndEnabled) {
        boolean old = this.dndEnabled;
        this.dndEnabled = dndEnabled;
        if (this.getDropTarget() != null) {
            this.getDropTarget().setActive(dndEnabled);
        }
        this.firePropertyChange(KEY_DND, old, dndEnabled);
    }

    public void setComponentAt(Component c, Alignment a, int index) {
        this.compsForAlignment(a).get(index).setContentPane(c);
    }

    public static class TabFramePosition {
        private Alignment a;
        private int index;

        public TabFramePosition(Alignment a, int index) {
            this.a = a;
            this.index = index;
        }

        public Alignment getAlignment() {
            return this.a;
        }

        public void setAlignment(Alignment a) {
            this.a = a;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String toString() {
            return "[" + this.a + "," + this.index + "]";
        }
    }
}

