/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.tooltip;

import com.github.weisj.darklaf.components.alignment.AlignmentStrategy;
import com.github.weisj.darklaf.ui.tooltip.AlignableTooltipBorder;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.util.Alignment;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Area;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;

public class ToolTipContext {
    private static ToolTipContext defaultContext;
    private final Insets calcInsets = new Insets(0, 0, 0, 0);
    private JComponent target;
    private JComponent layoutTarget;
    private final MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseExited(MouseEvent e) {
            this.checkExit(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (ToolTipContext.this.hotSpotArea == null) {
                return;
            }
            this.checkExit(e);
        }

        private void checkExit(MouseEvent e) {
            if (!ToolTipContext.this.hideOnExit) {
                return;
            }
            if (ToolTipContext.this.hotSpotArea != null) {
                if (!ToolTipContext.this.hotSpotArea.contains(e.getPoint())) {
                    ToolTipManager.sharedInstance().mousePressed(null);
                }
            } else {
                JComponent targetComp = ToolTipContext.this.getTarget();
                if (targetComp != null && !targetComp.contains(e.getPoint())) {
                    JComponent layoutComp = ToolTipContext.this.getLayoutTarget();
                    if (layoutComp != null && layoutComp.contains(SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), layoutComp))) {
                        return;
                    }
                    ToolTipManager.sharedInstance().mousePressed(null);
                }
            }
        }
    };
    private Alignment alignment;
    private Alignment centerAlignment;
    private boolean alignInside;
    private AlignmentStrategy alignmentStrategy;
    private Function<MouseEvent, Rectangle> toolTipRectSupplier;
    private boolean applyInsetsToRect;
    private Area hotSpotArea;
    private boolean hideOnExit;
    private JToolTip toolTip;
    private Insets insets;
    private boolean ignoreBorder;
    private boolean bestFit;
    private boolean chooseBestInitialAlignment;
    private FallBackPositionProvider fallBackPositionProvider;

    public static ToolTipContext getDefaultContext() {
        if (defaultContext == null) {
            defaultContext = ToolTipContext.createDefaultContext();
        }
        return defaultContext;
    }

    public static ToolTipContext createDefaultContext() {
        return new ToolTipContext().setAlignment(Alignment.SOUTH).setCenterAlignment(Alignment.SOUTH).setAlignInside(false).setIgnoreBorder(true).setUseBestFit(true).setChooseBestInitialAlignment(true);
    }

    public static void setDefaultContext(ToolTipContext defaultContext) {
        ToolTipContext.defaultContext = defaultContext;
    }

    public ToolTipContext() {
        this(null, null, null, null, true, null);
    }

    public ToolTipContext(JComponent target) {
        this(target, null, null, null, true, null);
    }

    public ToolTipContext(JComponent target, Alignment alignment, Alignment centerAlignment, AlignmentStrategy alignmentStrategy, boolean alignInside, Function<MouseEvent, Rectangle> toolTipRectSupplier) {
        this.setTarget(target);
        this.setHideOnExit(false);
        this.setFallBackPositionProvider(null);
        this.setAlignInside(alignInside);
        this.setAlignment(alignment);
        this.setCenterAlignment(centerAlignment);
        this.setAlignmentStrategy(alignmentStrategy);
        this.setToolTipRectSupplier(toolTipRectSupplier);
    }

    public ToolTipContext(JComponent target, Alignment alignment) {
        this(target, alignment, null, null, true, null);
    }

    public ToolTipContext setAlignInside(boolean alignInside) {
        this.alignInside = alignInside;
        return this;
    }

    public boolean isIgnoreBorder() {
        return this.ignoreBorder;
    }

    public boolean isBestFit() {
        return this.bestFit;
    }

    public boolean isChooseBestInitialAlignment() {
        return this.chooseBestInitialAlignment;
    }

    public ToolTipContext setAlignment(Alignment alignment) {
        this.alignment = alignment;
        if (alignment == null) {
            this.alignment = Alignment.CENTER;
        }
        return this;
    }

    public ToolTipContext setCenterAlignment(Alignment centerAlignment) {
        this.centerAlignment = centerAlignment;
        if (centerAlignment == null) {
            this.centerAlignment = Alignment.NORTH;
        }
        return this;
    }

    public ToolTipContext setAlignmentStrategy(AlignmentStrategy alignmentStrategy) {
        this.alignmentStrategy = alignmentStrategy;
        if (alignmentStrategy == null) {
            this.alignmentStrategy = AlignmentStrategy.COMPONENT_BOTH;
        }
        return this;
    }

    public ToolTipContext(JComponent target, Alignment alignment, Alignment centerAlignment) {
        this(target, alignment, centerAlignment, null, true, null);
    }

    public ToolTipContext(JComponent target, Alignment alignment, boolean alignInside) {
        this(target, alignment, null, null, alignInside, null);
    }

    public ToolTipContext(JComponent target, Alignment alignment, Alignment centerAlignment, boolean alignInside) {
        this(target, alignment, centerAlignment, null, alignInside, null);
    }

    public ToolTipContext(JComponent target, Alignment alignment, AlignmentStrategy alignmentStrategy) {
        this(target, alignment, null, alignmentStrategy, true, null);
    }

    public ToolTipContext(JComponent target, Alignment alignment, Alignment centerAlignment, AlignmentStrategy alignmentStrategy) {
        this(target, alignment, centerAlignment, alignmentStrategy, true, null);
    }

    public ToolTipContext(JComponent target, Alignment alignment, AlignmentStrategy alignmentStrategy, boolean alignInside) {
        this(target, alignment, null, alignmentStrategy, alignInside, null);
    }

    public ToolTipContext setHideOnExit(boolean hideOnExit) {
        this.hideOnExit = hideOnExit;
        JComponent targetComp = this.getTarget();
        if (targetComp != null) {
            if (hideOnExit) {
                targetComp.addMouseListener(this.mouseListener);
            } else {
                targetComp.removeMouseListener(this.mouseListener);
            }
        }
        return this;
    }

    public ToolTipContext setToolTipRectSupplier(Function<MouseEvent, Rectangle> toolTipRectSupplier) {
        this.toolTipRectSupplier = toolTipRectSupplier;
        if (toolTipRectSupplier == null) {
            this.toolTipRectSupplier = e -> {
                JComponent targetComp = this.getLayoutTarget();
                return new Rectangle(0, 0, targetComp.getWidth(), targetComp.getHeight());
            };
        }
        return this;
    }

    public void updateToolTip() {
        if (this.toolTip != null) {
            this.toolTip.putClientProperty("JToolTip.pointerLocation", this.alignment == Alignment.CENTER ? this.centerAlignment.opposite() : (this.alignInside ? this.alignment : this.alignment.opposite()));
            this.toolTip.putClientProperty("JToolTip.insets", this.insets);
            this.toolTip.doLayout();
        }
    }

    public ToolTipContext setInsideArea(Area insideRect) {
        this.hotSpotArea = insideRect;
        return this;
    }

    public ToolTipContext setApplyComponentInsetsToRect(boolean applyInsetsToRect) {
        this.applyInsetsToRect = applyInsetsToRect;
        return this;
    }

    public ToolTipContext setInsideArea(Rectangle insideRect) {
        return this.setInsideArea(new Area(insideRect));
    }

    public ToolTipContext setToolTipInsets(Insets insets) {
        this.insets = insets;
        return this;
    }

    public Point getToolTipLocation(MouseEvent event) {
        Point mp = SwingUtilities.convertPoint((Component)event.getSource(), event.getPoint(), this.getTarget());
        return this.getToolTipLocation(mp, event);
    }

    public ToolTipContext setIgnoreBorder(boolean ignoreBorder) {
        this.ignoreBorder = ignoreBorder;
        return this;
    }

    public ToolTipContext setUseBestFit(boolean bestFit) {
        this.bestFit = bestFit;
        return this;
    }

    public ToolTipContext setChooseBestInitialAlignment(boolean chooseBestInitialAlignment) {
        this.chooseBestInitialAlignment = chooseBestInitialAlignment;
        return this;
    }

    public Point getToolTipLocation(Point mp, MouseEvent mouseEvent) {
        return this.getToolTipLocation(mp, mouseEvent, false, false);
    }

    public Point getToolTipLocation(Point mp, MouseEvent mouseEvent, boolean centerHorizontally, boolean centerVertically) {
        Point mousePoint;
        Point compPoint;
        JComponent targetComp = this.getTarget();
        JComponent layoutTarget = this.getLayoutTarget();
        if (targetComp == null || layoutTarget == null) {
            return null;
        }
        this.updateToolTip();
        MouseEvent event = this.processEvent(mouseEvent, mp);
        Rectangle rect = this.getTargetRect(event, centerHorizontally, centerVertically);
        if (this.applyInsetsToRect) {
            DarkUIUtil.applyInsets(rect, this.getLayoutTarget().getInsets(this.calcInsets));
        }
        this.getToolTip().setTipText(targetComp.getToolTipText(event));
        Dimension dim = this.getContentSize();
        Rectangle mRect = new Rectangle(mp.x, mp.y, 1, 1);
        if (this.alignment == Alignment.CENTER) {
            compPoint = this.alignCenter(dim, rect);
            mousePoint = this.alignCenter(dim, mRect);
        } else {
            compPoint = this.alignInside ? this.alignInside(dim, rect) : this.alignOutside(dim, rect);
            mousePoint = this.alignInside ? this.alignInside(dim, mRect) : this.alignOutside(dim, mRect);
        }
        return this.alignmentStrategy.align(compPoint, mousePoint);
    }

    private Rectangle getTargetRect(MouseEvent event, boolean centerHorizontally, boolean centerVertically) {
        Border border;
        Rectangle rect = this.toolTipRectSupplier.apply(event);
        JComponent layoutTarget = this.getLayoutTarget();
        if (this.ignoreBorder && (border = layoutTarget.getBorder()) != null) {
            Insets ins = border.getBorderInsets(layoutTarget);
            rect.x += ins.left;
            rect.y += ins.top;
            rect.width -= ins.left + ins.right;
            rect.height -= ins.top + ins.bottom;
        }
        if (centerHorizontally) {
            rect.x += rect.width / 2;
            rect.width = 0;
        }
        if (centerVertically) {
            rect.y += rect.height / 2;
            rect.height = 0;
        }
        return SwingUtilities.convertRectangle(layoutTarget, rect, this.getTarget());
    }

    private MouseEvent processEvent(MouseEvent mouseEvent, Point mp) {
        if (mouseEvent != null) {
            return mouseEvent;
        }
        return new MouseEvent(this.getTarget(), 503, System.currentTimeMillis(), 0, mp.x, mp.y, 0, false, 0);
    }

    public JComponent getTarget() {
        return this.target;
    }

    public JComponent getLayoutTarget() {
        return this.layoutTarget != null ? this.layoutTarget : this.getTarget();
    }

    public ToolTipContext setTarget(JComponent target) {
        this.target = target;
        return this;
    }

    public ToolTipContext setLayoutTarget(JComponent layoutTarget) {
        this.layoutTarget = layoutTarget;
        return this;
    }

    public JToolTip getToolTip() {
        if (this.toolTip == null) {
            this.setToolTip(new JToolTip());
        }
        return this.toolTip;
    }

    public void updateToolTipUI() {
        if (this.toolTip != null) {
            this.toolTip.updateUI();
        }
    }

    private Dimension getContentSize() {
        Dimension dim = this.toolTip.getPreferredSize();
        Alignment align = this.alignment == Alignment.CENTER ? this.centerAlignment : this.alignment;
        Border border = this.toolTip.getBorder();
        if (border instanceof AlignableTooltipBorder) {
            ((AlignableTooltipBorder)((Object)border)).adjustContentSize(this.toolTip, dim, align);
        }
        return dim;
    }

    private Point alignCenter(Dimension dim, Rectangle rect) {
        rect.x += rect.width / 2;
        rect.y += rect.height / 2;
        rect.width = 1;
        rect.height = 1;
        Point p = this.centerAlignment.alignOutside(dim, rect);
        return this.adjustPoint(p, this.centerAlignment, dim, true);
    }

    private Point alignInside(Dimension dim, Rectangle rect) {
        Point p = this.alignment.alignInside(dim, rect);
        return this.adjustPoint(p, this.alignment, dim, false);
    }

    private Point alignOutside(Dimension dim, Rectangle rect) {
        Point p = this.alignment.alignOutside(dim, rect);
        return this.adjustPoint(p, this.alignment, dim, true);
    }

    private Point adjustPoint(Point p, Alignment align, Dimension dim, boolean outside) {
        Border b = this.toolTip.getBorder();
        if (b instanceof AlignableTooltipBorder) {
            AlignableTooltipBorder border = (AlignableTooltipBorder)((Object)b);
            return border.alignTooltip(this.toolTip, p, align, dim, outside);
        }
        return p;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public Alignment getCenterAlignment() {
        return this.centerAlignment;
    }

    public AlignmentStrategy getAlignmentStrategy() {
        return this.alignmentStrategy;
    }

    public boolean isAlignInside() {
        return this.alignInside;
    }

    public void setToolTip(JToolTip toolTip) {
        if (toolTip == null) {
            return;
        }
        this.toolTip = toolTip;
        JComponent targetComp = this.getTarget();
        if (targetComp != toolTip.getComponent()) {
            this.toolTip.setComponent(targetComp);
        }
    }

    public FallBackPositionProvider getFallBackPositionProvider() {
        return this.fallBackPositionProvider;
    }

    public ToolTipContext setFallBackPositionProvider(FallBackPositionProvider fallBackPositionProvider) {
        this.fallBackPositionProvider = fallBackPositionProvider;
        if (fallBackPositionProvider == null) {
            this.fallBackPositionProvider = c -> null;
        }
        return this;
    }

    public static interface FallBackPositionProvider {
        public Point calculateFallbackPosition(ToolTipContext var1);

        default public boolean providesAbsolutePosition() {
            return true;
        }
    }
}

