/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.graphics;

import com.github.weisj.darklaf.graphics.DefaultInterpolator;
import com.github.weisj.darklaf.graphics.Interpolator;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class Animator {
    public static final String ANIMATIONS_FLAG = "darklaf.animations";
    private static final ScheduledExecutorService scheduler = Animator.createScheduler();
    private static final int DEFAULT_FPS = 60;
    private final long animationDurationMillis;
    private final long delayMillis;
    private final int fps;
    private RepeatMode repeatMode;
    private Interpolator interpolator;
    private boolean reverse = false;
    private final AtomicBoolean isScheduled = new AtomicBoolean(false);
    private ScheduledFuture<?> ticker;
    private double fraction;
    private double fractionDelta;
    private boolean enabled = true;

    static ScheduledExecutorService scheduler() {
        return scheduler;
    }

    public Animator(long animationDurationMillis, int fps) {
        this(animationDurationMillis, fps, DefaultInterpolator.LINEAR);
    }

    public Animator(long animationDurationMillis, int fps, Interpolator interpolator) {
        this(animationDurationMillis, fps, interpolator, RepeatMode.DO_NOT_REPEAT);
    }

    public Animator(long animationDurationMillis) {
        this(animationDurationMillis, 60);
    }

    public Animator(long animationDurationMillis, Interpolator interpolator) {
        this(animationDurationMillis, 60, interpolator, RepeatMode.DO_NOT_REPEAT);
    }

    public Animator(long animationDurationMillis, int fps, Interpolator interpolator, RepeatMode repeatMode) {
        this(animationDurationMillis, 0L, fps, interpolator, repeatMode);
    }

    public Animator(long animationDurationMillis, long delayMillis, int fps, Interpolator interpolator, RepeatMode repeatMode) {
        this.animationDurationMillis = animationDurationMillis;
        this.delayMillis = delayMillis;
        this.fps = fps;
        this.interpolator = interpolator;
        this.repeatMode = repeatMode;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    public Interpolator interpolator() {
        return this.interpolator;
    }

    public boolean isRunning() {
        return this.ticker != null;
    }

    public double currentState() {
        return this.fraction;
    }

    public RepeatMode repeatMode() {
        return this.repeatMode;
    }

    public void setRepeatMode(RepeatMode repeatMode) {
        this.repeatMode = repeatMode;
    }

    private boolean animationsEnabled() {
        return this.enabled && PropertyUtil.getSystemFlag((String)ANIMATIONS_FLAG);
    }

    public void play() {
        this.resumeAt(0.0, true);
    }

    public void playForwards() {
        this.playForwards(true);
    }

    public void playForwards(boolean skipDelay) {
        if (this.reverse || !this.isRunning()) {
            this.pause();
            this.reverse = false;
            this.resumeAt(0.0, skipDelay);
        }
    }

    public void playBackwards() {
        this.playBackwards(true);
    }

    public void playBackwards(boolean skipDelay) {
        if (!this.reverse || !this.isRunning()) {
            this.pause();
            this.reverse = true;
            this.resumeAt(1.0, skipDelay);
        }
    }

    public void resume(JComponent target) {
        this.resumeAt(this.fraction, true, target);
    }

    public void resumeAt(double startFraction, boolean skipDelay, JComponent target) {
        if (!(target == null || target.isVisible() && target.isShowing())) {
            this.stop();
            return;
        }
        this.resumeAt(startFraction, skipDelay);
    }

    public void resume() {
        this.resumeAt(this.fraction, true);
    }

    public void resumeAt(double startFraction, boolean skipDelay) {
        if (startFraction < 0.0 || startFraction > 1.0) {
            throw new IllegalArgumentException("Starting fraction must be between 0.0 and 1.0.");
        }
        if (this.animationDurationMillis == 0L || !this.animationsEnabled()) {
            this.stop();
            return;
        }
        if (this.ticker == null) {
            this.fractionDelta = 1.0f / ((float)((long)this.fps * this.animationDurationMillis) / 1000.0f);
            long initialDelay = skipDelay ? 0L : this.delayMillis;
            long millisPerFrame = (long)((float)this.animationDurationMillis * ((float)this.fps / 1000.0f));
            this.isScheduled.set(false);
            this.ticker = scheduler.scheduleWithFixedDelay(() -> {
                if (this.isRunning() && this.tick()) {
                    this.submitAnimationFrame();
                }
            }, initialDelay, millisPerFrame, TimeUnit.MILLISECONDS);
        }
    }

    private void submitAnimationFrame() {
        if (!this.isScheduled.get()) {
            this.isScheduled.set(true);
            SwingUtilities.invokeLater(() -> {
                if (this.isRunning()) {
                    this.paintAnimationFrame(this.interpolator.interpolate((float)this.fraction));
                }
                this.isScheduled.set(false);
            });
        }
    }

    private boolean tick() {
        double oldFraction = this.fraction;
        this.fraction = this.reverse ? oldFraction - this.fractionDelta : oldFraction + this.fractionDelta;
        switch (this.repeatMode) {
            case DO_NOT_REPEAT: {
                if (this.fraction > 1.0 && !this.reverse) {
                    this.stop();
                    return false;
                }
                if (!(this.fraction < 0.0) || !this.reverse) break;
                this.stop();
                return false;
            }
            case DO_NOT_REPEAT_FREEZE: {
                if (this.fraction > 1.0 && !this.reverse) {
                    this.pause();
                }
                if (!(this.fraction < 0.0) || !this.reverse) break;
                this.pause();
                break;
            }
            case CYCLE: {
                if (this.reverse) {
                    if (!(this.fraction < 0.0)) break;
                    this.fraction = 1.0 + this.fraction;
                    break;
                }
                if (!(this.fraction > 1.0)) break;
                this.fraction -= 1.0;
                break;
            }
            case CYCLE_FLIP: {
                if (this.reverse) {
                    if (!(this.fraction < 0.0)) break;
                    this.fraction = -this.fraction;
                    this.reverse = false;
                    break;
                }
                if (!(this.fraction > 1.0)) break;
                this.fraction = 1.0 - (this.fraction - Math.floor(this.fraction));
                this.reverse = true;
            }
        }
        this.fraction = Math.max(Math.min(1.0, this.fraction), 0.0);
        return true;
    }

    public void stop() {
        if (this.cancel()) {
            this.onAnimationFinished();
        }
    }

    public boolean cancel() {
        if (this.pause()) {
            this.reset();
            return true;
        }
        this.reset();
        return false;
    }

    public void reset() {
        this.fraction = this.reverse ? 1.0 : 0.0;
    }

    public boolean pause() {
        if (this.ticker != null) {
            this.ticker.cancel(false);
            this.ticker = null;
            return true;
        }
        return false;
    }

    protected abstract void paintAnimationFrame(float var1);

    protected void onAnimationFinished() {
    }

    private static ScheduledExecutorService createScheduler() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, r -> {
            Thread thread = new Thread(r, "Animations Thread");
            thread.setDaemon(true);
            thread.setPriority(10);
            return thread;
        });
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return executor;
    }

    public static enum RepeatMode {
        DO_NOT_REPEAT,
        DO_NOT_REPEAT_FREEZE,
        CYCLE,
        CYCLE_FLIP;


        public boolean isRepeating() {
            switch (this) {
                case DO_NOT_REPEAT: 
                case DO_NOT_REPEAT_FREEZE: {
                    return false;
                }
            }
            return true;
        }
    }
}

