/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.nativelaf;

import com.github.weisj.darklaf.platform.preferences.SystemPreferencesManager;
import com.github.weisj.darklaf.theme.event.ThemeEvent;
import com.github.weisj.darklaf.theme.event.ThemeEventListener;
import com.github.weisj.darklaf.theme.event.ThemeEventSupport;
import com.github.weisj.darklaf.theme.event.ThemePreferenceChangeEvent;
import com.github.weisj.darklaf.theme.event.ThemePreferenceListener;
import com.github.weisj.darklaf.theme.spec.PreferredThemeStyle;
import com.github.weisj.darklaf.util.PropertyUtil;
import javax.swing.SwingUtilities;

public class ThemePreferencesHandler {
    public static final String PREFERENCE_REPORTING_FLAG = "darklaf.enableNativePreferences";
    private static ThemePreferencesHandler sharedInstance;
    private final ThemeEventSupport<ThemePreferenceChangeEvent, ThemePreferenceListener> changeSupport = new ThemeEventSupport();
    private final SystemPreferencesManager systemPreferencesManager = new SystemPreferencesManager(this.isNativePreferencesEnabled());

    public static ThemePreferencesHandler getSharedInstance() {
        if (sharedInstance == null) {
            ThemePreferencesHandler.setSharedInstance(new ThemePreferencesHandler());
        }
        return sharedInstance;
    }

    public static void setSharedInstance(ThemePreferencesHandler handler) {
        sharedInstance = handler;
    }

    protected ThemePreferencesHandler() {
        this.systemPreferencesManager.addListener(this::onChange);
    }

    private void onChange(PreferredThemeStyle style) {
        SwingUtilities.invokeLater(() -> this.changeSupport.dispatchEvent((ThemeEvent)new ThemePreferenceChangeEvent(style)));
    }

    public void addThemePreferenceChangeListener(ThemePreferenceListener listener) {
        this.changeSupport.addListener((ThemeEventListener)listener);
    }

    public void removeThemePreferenceChangeListener(ThemePreferenceListener listener) {
        this.changeSupport.removeListener((ThemeEventListener)listener);
    }

    public void enablePreferenceChangeReporting(boolean enabled) {
        this.systemPreferencesManager.enableReporting(enabled);
    }

    private boolean isNativePreferencesEnabled() {
        return PropertyUtil.getSystemFlag((String)PREFERENCE_REPORTING_FLAG) && PropertyUtil.getSystemFlag((String)"darklaf.allowNativeCode");
    }

    public boolean isPreferenceChangeReportingEnabled() {
        return this.systemPreferencesManager.isReportingEnabled() && PropertyUtil.getSystemFlag((String)PREFERENCE_REPORTING_FLAG);
    }

    public boolean canReport() {
        return this.systemPreferencesManager.provider().canReport();
    }

    public boolean supportsNativeFontSize() {
        return this.systemPreferencesManager.provider().supportsNativeFontSize();
    }

    public boolean supportsNativeAccentColor() {
        return this.systemPreferencesManager.provider().supportsNativeAccentColor();
    }

    public boolean supportsNativeSelectionColor() {
        return this.systemPreferencesManager.provider().supportsNativeSelectionColor();
    }

    public boolean supportsNativeTheme() {
        return this.systemPreferencesManager.provider().supportsNativeTheme();
    }

    public PreferredThemeStyle getPreferredThemeStyle() {
        return this.systemPreferencesManager.getPreferredThemeStyle();
    }
}

