/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.settings;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.nativelaf.ThemePreferencesHandler;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.spec.AccentColorRule;
import com.github.weisj.darklaf.theme.spec.FontPrototype;
import com.github.weisj.darklaf.theme.spec.FontSizeRule;
import com.github.weisj.darklaf.theme.spec.PreferredThemeStyle;
import java.awt.Color;
import java.io.Serializable;
import java.util.Objects;

public class SettingsConfiguration
implements Serializable {
    private boolean isSystemPreferencesEnabled;
    private boolean isAccentColorFollowsSystem;
    private boolean isFontSizeFollowsSystem;
    private boolean isThemeFollowsSystem;
    private boolean isSelectionColorFollowsSystem;
    private AccentColorRule accentColorRule;
    private FontSizeRule fontSizeRule;
    private FontPrototype fontPrototype;
    private Theme theme;

    public void load(SettingsConfiguration config) {
        this.setSystemPreferencesEnabled(config.isSystemPreferencesEnabled());
        this.setAccentColorFollowsSystem(config.isAccentColorFollowsSystem());
        this.setSelectionColorFollowsSystem(config.isSelectionColorFollowsSystem());
        this.setFontSizeFollowsSystem(config.isFontSizeFollowsSystem());
        this.setThemeFollowsSystem(config.isThemeFollowsSystem());
        this.setFontSizeRule(config.getFontSizeRule());
        this.setFontPrototype(config.getFontPrototype());
        this.setAccentColorRule(config.getAccentColorRule());
        this.setTheme(config.getTheme());
    }

    public final Theme getEffectiveTheme() {
        return this.getEffectiveTheme(LafManager.getPreferredThemeStyle());
    }

    public final Theme getEffectiveTheme(PreferredThemeStyle themeStyle) {
        Theme baseTheme = this.getEffectiveBaseTheme(themeStyle);
        if (baseTheme == null) {
            return null;
        }
        FontSizeRule fontSizeRule = this.getEffectiveFontSizeRule(themeStyle);
        AccentColorRule accentColorRule = this.getEffectiveAccentColorRule(baseTheme, themeStyle);
        return baseTheme.derive(fontSizeRule, this.getFontPrototype(), accentColorRule);
    }

    public final PreferredThemeStyle getEffectiveThemeStyle(PreferredThemeStyle themeStyle) {
        Theme baseTheme = this.getEffectiveBaseTheme(themeStyle);
        FontSizeRule fontSizeRule = this.getEffectiveFontSizeRule(themeStyle);
        AccentColorRule accentColorRule = this.getEffectiveAccentColorRule(baseTheme, themeStyle);
        return new PreferredThemeStyle(themeStyle.getContrastRule(), themeStyle.getColorToneRule(), accentColorRule, fontSizeRule);
    }

    private AccentColorRule getEffectiveAccentColorRule(Theme baseTheme, PreferredThemeStyle preferredThemeStyle) {
        AccentColorRule accentColorRule = this.getAccentColorRule();
        if (accentColorRule == null) {
            accentColorRule = AccentColorRule.getDefault();
        }
        AccentColorRule systemAccentColorRule = preferredThemeStyle.getAccentColorRule();
        Color accentColor = accentColorRule.getAccentColor();
        Color selectionColor = accentColorRule.getSelectionColor();
        if (this.isAccentColorFollowsSystem() && (baseTheme == null || baseTheme.supportsCustomAccentColor())) {
            accentColor = systemAccentColorRule.getAccentColor();
        }
        if (this.isSelectionColorFollowsSystem() && (baseTheme == null || baseTheme.supportsCustomSelectionColor())) {
            selectionColor = systemAccentColorRule.getSelectionColor();
        }
        return AccentColorRule.fromColor((Color)accentColor, (Color)selectionColor);
    }

    private Theme getEffectiveBaseTheme(PreferredThemeStyle preferredThemeStyle) {
        return this.isThemeFollowsSystem() ? LafManager.themeForPreferredStyle(preferredThemeStyle) : this.getTheme();
    }

    private FontSizeRule getEffectiveFontSizeRule(PreferredThemeStyle preferredThemeStyle) {
        return this.isFontSizeFollowsSystem() ? preferredThemeStyle.getFontSizeRule() : this.getFontSizeRule();
    }

    public boolean isSystemPreferencesEnabled() {
        return this.isSystemPreferencesEnabled;
    }

    public boolean isAccentColorFollowsSystem() {
        return this.isAccentColorFollowsSystem;
    }

    public boolean isFontSizeFollowsSystem() {
        return this.isFontSizeFollowsSystem;
    }

    public boolean isSelectionColorFollowsSystem() {
        return this.isSelectionColorFollowsSystem;
    }

    public boolean isThemeFollowsSystem() {
        return this.isThemeFollowsSystem;
    }

    public AccentColorRule getAccentColorRule() {
        return this.accentColorRule;
    }

    public FontSizeRule getFontSizeRule() {
        return this.fontSizeRule;
    }

    public FontPrototype getFontPrototype() {
        return this.fontPrototype;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setSystemPreferencesEnabled(boolean enabled) {
        this.isSystemPreferencesEnabled = enabled;
    }

    public void setAccentColorFollowsSystem(boolean accentColorFollowsSystem) {
        this.isAccentColorFollowsSystem = accentColorFollowsSystem;
    }

    public void setFontSizeFollowsSystem(boolean fontSizeFollowsSystem) {
        this.isFontSizeFollowsSystem = fontSizeFollowsSystem;
    }

    public void setSelectionColorFollowsSystem(boolean selectionColorFollowsSystem) {
        this.isSelectionColorFollowsSystem = selectionColorFollowsSystem;
    }

    public void setThemeFollowsSystem(boolean themeFollowsSystem) {
        this.isThemeFollowsSystem = themeFollowsSystem;
    }

    public void setAccentColorRule(AccentColorRule accentColorRule) {
        this.accentColorRule = accentColorRule;
    }

    public void setFontSizeRule(FontSizeRule fontSizeRule) {
        this.fontSizeRule = fontSizeRule;
    }

    public void setFontPrototype(FontPrototype fontPrototype) {
        this.fontPrototype = fontPrototype;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    public boolean isSystemPreferencesSupported() {
        return ThemePreferencesHandler.getSharedInstance().canReport();
    }

    public boolean isSystemAccentColorSupported() {
        return this.isSystemAccentColorSupported(true);
    }

    public boolean isSystemFontSizeSupported() {
        return this.isSystemFontSizeSupported(true);
    }

    public boolean isSystemSelectionColorSupported() {
        return this.isSystemSelectionColorSupported(true);
    }

    public boolean isSystemThemeSupported() {
        return this.isSystemThemeSupported(true);
    }

    protected final boolean isSystemAccentColorSupported(boolean checkSystemPreferencesEnabled) {
        return (!checkSystemPreferencesEnabled || this.isSystemPreferencesEnabled()) && ThemePreferencesHandler.getSharedInstance().supportsNativeAccentColor();
    }

    protected final boolean isSystemFontSizeSupported(boolean checkSystemPreferencesEnabled) {
        return (!checkSystemPreferencesEnabled || this.isSystemPreferencesEnabled()) && ThemePreferencesHandler.getSharedInstance().supportsNativeFontSize();
    }

    protected final boolean isSystemSelectionColorSupported(boolean checkSystemPreferencesEnabled) {
        return (!checkSystemPreferencesEnabled || this.isSystemPreferencesEnabled()) && ThemePreferencesHandler.getSharedInstance().supportsNativeSelectionColor();
    }

    protected final boolean isSystemThemeSupported(boolean checkSystemPreferencesEnabled) {
        return (!checkSystemPreferencesEnabled || this.isSystemPreferencesEnabled()) && ThemePreferencesHandler.getSharedInstance().supportsNativeTheme();
    }

    public String toString() {
        return "SettingsConfiguration{isSystemPreferencesEnabled=" + this.isSystemPreferencesEnabled + ", isAccentColorFollowsSystem=" + this.isAccentColorFollowsSystem + ", isFontSizeFollowsSystem=" + this.isFontSizeFollowsSystem + ", isThemeFollowsSystem=" + this.isThemeFollowsSystem + ", isSelectionColorFollowsSystem=" + this.isSelectionColorFollowsSystem + ", accentColorRule=" + this.accentColorRule + ", fontSizeRule=" + this.fontSizeRule + ", fontPrototype=" + this.fontPrototype + ", theme=" + this.theme + '}';
    }

    public boolean isResultingAppearanceEqualTo(SettingsConfiguration other) {
        return other.isSystemPreferencesEnabled() == this.isSystemPreferencesEnabled() && other.isThemeFollowsSystem() == this.isThemeFollowsSystem() && other.isAccentColorFollowsSystem() == this.isAccentColorFollowsSystem() && other.isSelectionColorFollowsSystem() == this.isSelectionColorFollowsSystem() && other.isFontSizeFollowsSystem() == this.isFontSizeFollowsSystem() && Objects.equals(other.getAccentColorRule(), this.getAccentColorRule()) && Objects.equals(other.getFontSizeRule(), this.getFontSizeRule()) && Objects.equals(other.getFontPrototype(), this.getFontPrototype()) && Objects.equals(Theme.baseThemeOf((Theme)other.getTheme()), Theme.baseThemeOf((Theme)this.getTheme()));
    }
}

