/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.settings;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.components.DefaultButton;
import com.github.weisj.darklaf.components.DynamicUI;
import com.github.weisj.darklaf.properties.icons.IconLoader;
import com.github.weisj.darklaf.settings.DefaultSettingsConfiguration;
import com.github.weisj.darklaf.settings.SettingsConfiguration;
import com.github.weisj.darklaf.settings.ThemeSettingsPanel;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.event.ThemePreferenceChangeEvent;
import com.github.weisj.darklaf.theme.event.ThemePreferenceListener;
import com.github.weisj.darklaf.theme.spec.AccentColorRule;
import com.github.weisj.darklaf.theme.spec.FontPrototype;
import com.github.weisj.darklaf.theme.spec.FontSizeRule;
import com.github.weisj.darklaf.theme.spec.PreferredThemeStyle;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.ui.util.UIThread;
import com.github.weisj.darklaf.util.LazyValue;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.value.WeakShared;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ThemeSettings
implements ThemePreferenceListener {
    private static final Logger LOGGER = LogUtil.getLogger(ThemeSettings.class);
    private static final LazyValue<ThemeSettings> instance = new LazyValue(ThemeSettings::new);
    private static final LazyValue<Icon> icon = new LazyValue(() -> UIManager.getIcon("ThemeSettings.icon"));
    private final WeakShared<ThemeSettingsPanel> settingsPanel;
    private ThemeSettingsPanel customThemeSettingsPanel;
    private JDialog dialog;
    private final SettingsConfiguration savedConfiguration;
    private final SettingsConfiguration currentConfiguration;

    public static ThemeSettings getInstance() {
        return (ThemeSettings)instance.get();
    }

    public static boolean isInitialized() {
        return instance.isInitialized();
    }

    public static void showSettingsDialog(Component parent) {
        ThemeSettings.showSettingsDialog(parent, Dialog.ModalityType.MODELESS);
    }

    public static void showSettingsDialog(Component parent, Dialog.ModalityType modalityType) {
        ThemeSettings.getInstance().showDialog(parent, modalityType);
    }

    protected ThemeSettings() {
        LafManager.addThemePreferenceChangeListener(this);
        this.currentConfiguration = new DefaultSettingsConfiguration();
        this.savedConfiguration = new DefaultSettingsConfiguration();
        this.settingsPanel = new WeakShared(() -> {
            ThemeSettingsPanel panel = new ThemeSettingsPanel();
            panel.loadConfiguration(this.currentConfiguration);
            return panel;
        });
    }

    protected JDialog createDialog(Window parent) {
        JDialog dialog = new JDialog(parent);
        dialog.setIconImage(IconLoader.createFrameIcon((Icon)ThemeSettings.getIcon(), (Window)dialog));
        dialog.setTitle(this.getTitle());
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)this.settingsPanel.get(), "Center");
        contentPane.add(this.createButtonPanel(), "South");
        dialog.setContentPane(contentPane);
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.setLocationByPlatform(true);
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    public void showDialog(Component parent, Dialog.ModalityType modal) {
        Window parentWindow = DarkUIUtil.getWindow(this.getSettingsPanel());
        if (parentWindow != null && parentWindow != DarkUIUtil.getWindow(this.dialog)) {
            throw new IllegalStateException("Can't show dialog while settings panel is used elsewhere");
        }
        if (this.dialog != null && this.dialog.isVisible()) {
            this.dialog.requestFocus();
            return;
        }
        this.refresh();
        Window window = DarkUIUtil.getWindow(parent);
        this.dialog = this.createDialog(window);
        this.dialog.setModalityType(modal);
        this.dialog.setVisible(true);
    }

    public ThemeSettingsPanel getSettingsPanel() {
        return (ThemeSettingsPanel)this.settingsPanel.get();
    }

    public void setThemeSettingsPanel(ThemeSettingsPanel panel) {
        if (panel != null) {
            this.customThemeSettingsPanel = panel;
            panel.loadConfiguration(this.currentConfiguration);
        } else {
            this.customThemeSettingsPanel = null;
        }
    }

    public boolean isSystemPreferencesEnabled() {
        return this.currentConfiguration.isSystemPreferencesEnabled();
    }

    public boolean isAccentColorFollowsSystem() {
        return this.currentConfiguration.isAccentColorFollowsSystem();
    }

    public boolean isFontSizeFollowsSystem() {
        return this.currentConfiguration.isFontSizeFollowsSystem();
    }

    public boolean isSelectionColorFollowsSystem() {
        return this.currentConfiguration.isSelectionColorFollowsSystem();
    }

    public boolean isThemeFollowsSystem() {
        return this.currentConfiguration.isThemeFollowsSystem();
    }

    public AccentColorRule getAccentColorRule() {
        return this.currentConfiguration.getAccentColorRule();
    }

    public FontSizeRule getFontSizeRule() {
        return this.currentConfiguration.getFontSizeRule();
    }

    public FontPrototype getFontPrototype() {
        return this.currentConfiguration.getFontPrototype();
    }

    public Theme getTheme() {
        return this.currentConfiguration.getTheme();
    }

    public void setSystemPreferencesEnabled(boolean enabled) {
        if (this.isSystemPreferencesEnabled() != enabled) {
            LOGGER.info("Setting systemPreferencesEnabled = " + enabled);
            this.currentConfiguration.setSystemPreferencesEnabled(enabled);
            this.updateSettingsPanel();
        }
    }

    public void setAccentColorFollowsSystem(boolean accentColorFollowsSystem) {
        if (this.isAccentColorFollowsSystem() != accentColorFollowsSystem) {
            LOGGER.info("Setting accentColorFollowsSystem = " + accentColorFollowsSystem);
            this.currentConfiguration.setAccentColorFollowsSystem(accentColorFollowsSystem);
            this.updateSettingsPanel();
        }
    }

    public void setFontSizeFollowsSystem(boolean fontSizeFollowsSystem) {
        if (this.isFontSizeFollowsSystem() != fontSizeFollowsSystem) {
            LOGGER.info("Setting fontSizeFollowsSystem = " + fontSizeFollowsSystem);
            this.currentConfiguration.setFontSizeFollowsSystem(fontSizeFollowsSystem);
            this.updateSettingsPanel();
        }
    }

    public void setSelectionColorFollowsSystem(boolean selectionColorFollowsSystem) {
        if (this.isSelectionColorFollowsSystem() != selectionColorFollowsSystem) {
            LOGGER.info("Setting selectionColorFollowsSystem = " + selectionColorFollowsSystem);
            this.currentConfiguration.setSelectionColorFollowsSystem(selectionColorFollowsSystem);
            this.updateSettingsPanel();
        }
    }

    public void setThemeFollowsSystem(boolean themeFollowsSystem) {
        if (this.isThemeFollowsSystem() != themeFollowsSystem) {
            LOGGER.info("Setting themeFollowsSystem = " + themeFollowsSystem);
            this.currentConfiguration.setThemeFollowsSystem(themeFollowsSystem);
            this.updateSettingsPanel();
        }
    }

    public void setAccentColorRule(AccentColorRule accentColorRule) {
        if (!Objects.equals(this.getAccentColorRule(), accentColorRule)) {
            LOGGER.info("Setting accentColorRule = " + accentColorRule);
            this.currentConfiguration.setAccentColorRule(accentColorRule);
            this.updateSettingsPanel();
        }
    }

    public void setFontSizeRule(FontSizeRule fontSizeRule) {
        if (!Objects.equals(this.getFontSizeRule(), fontSizeRule)) {
            LOGGER.info("Setting fontSizeRule = " + fontSizeRule);
            this.currentConfiguration.setFontSizeRule(fontSizeRule);
            this.updateSettingsPanel();
        }
    }

    public void setFontPrototype(FontPrototype fontPrototype) {
        if (!Objects.equals(this.getFontPrototype(), fontPrototype)) {
            LOGGER.info("Setting fontPrototype = " + fontPrototype);
            this.currentConfiguration.setFontPrototype(fontPrototype);
            this.updateSettingsPanel();
        }
    }

    public void setTheme(Theme theme) {
        if (!Objects.equals(this.getTheme(), theme)) {
            LOGGER.info("Setting theme = " + theme);
            this.currentConfiguration.setTheme(theme);
            this.updateSettingsPanel();
        }
    }

    protected Component createButtonPanel() {
        JButton ok = DynamicUI.withLocalizedText(new DefaultButton(""), "settings.dialog_ok");
        ok.setDefaultCapable(true);
        ok.addActionListener(e -> {
            this.apply();
            this.dialog.dispatchEvent(new WindowEvent(this.dialog, 201));
        });
        JButton cancel = DynamicUI.withLocalizedText(new JButton(), "settings.dialog_cancel");
        cancel.addActionListener(e -> {
            this.revert();
            this.dialog.dispatchEvent(new WindowEvent(this.dialog, 201));
        });
        JButton apply = DynamicUI.withLocalizedText(new JButton(), "settings.dialog_apply");
        apply.addActionListener(e -> this.apply());
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(ok);
        box.add(cancel);
        box.add(apply);
        box.setBorder(((ThemeSettingsPanel)this.settingsPanel.get()).getBorder());
        return box;
    }

    public void refresh() {
        Theme theme = LafManager.getTheme();
        this.currentConfiguration.setTheme(theme);
        this.currentConfiguration.setFontSizeRule(theme.getFontSizeRule());
        this.currentConfiguration.setAccentColorRule(theme.getAccentColorRule());
        this.currentConfiguration.setSystemPreferencesEnabled(LafManager.isPreferenceChangeReportingEnabled());
        this.updateSettingsPanel();
    }

    private ThemeSettingsPanel getThemeSettingsPanelWeak() {
        if (this.customThemeSettingsPanel != null) {
            return this.customThemeSettingsPanel;
        }
        return (ThemeSettingsPanel)this.settingsPanel.getIfPresent();
    }

    private void updateSettingsPanel() {
        ThemeSettingsPanel panel = this.getThemeSettingsPanelWeak();
        if (panel != null) {
            panel.loadConfiguration(this.currentConfiguration);
        }
    }

    private void fetchFromSettingsPanel() {
        ThemeSettingsPanel panel = this.getThemeSettingsPanelWeak();
        if (panel != null) {
            panel.updateConfiguration();
        }
    }

    public void save() {
        this.save(true);
    }

    private void save(boolean fetchFromPanel) {
        if (fetchFromPanel) {
            this.fetchFromSettingsPanel();
        }
        LafManager.enabledPreferenceChangeReporting(this.currentConfiguration.isSystemPreferencesEnabled());
        this.savedConfiguration.load(this.currentConfiguration);
        LOGGER.fine(() -> "Saving settings " + this.savedConfiguration);
    }

    public void setConfiguration(SettingsConfiguration configuration) {
        this.setCurrentConfiguration(configuration);
        this.save(false);
    }

    void setCurrentConfiguration(SettingsConfiguration configuration) {
        this.currentConfiguration.load(configuration);
    }

    public SettingsConfiguration exportConfiguration() {
        SettingsConfiguration config = new SettingsConfiguration();
        config.load(this.currentConfiguration);
        return config;
    }

    public void apply() {
        this.save();
        this.peek();
    }

    public void peek() {
        this.applyTheme(this.currentConfiguration.getEffectiveTheme());
    }

    public PreferredThemeStyle computeEffectiveStyle(PreferredThemeStyle style) {
        return this.currentConfiguration.getEffectiveThemeStyle(style);
    }

    public void revert() {
        this.currentConfiguration.load(this.savedConfiguration);
        this.refresh();
    }

    protected void applyTheme(Theme theme) {
        if (theme == null) {
            return;
        }
        if (LafManager.isInstalled() && LafManager.getInstalledTheme().appearsEqualTo(theme)) {
            return;
        }
        UIThread.runOnUIThread(() -> {
            LafManager.installTheme(theme);
            this.refresh();
        });
    }

    public static Icon getIcon() {
        return (Icon)icon.get();
    }

    public String getTitle() {
        return UIManager.getString((Object)"settings.title", Locale.getDefault());
    }

    public void themePreferenceChanged(ThemePreferenceChangeEvent e) {
        this.refresh();
        this.applyTheme(this.currentConfiguration.getEffectiveTheme(e.getPreferredThemeStyle()));
    }
}

