/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.task;

import com.github.weisj.darklaf.task.CSSBuilder;
import com.github.weisj.darklaf.task.DefaultsInitTask;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.util.ColorUtil;
import java.awt.Color;
import java.awt.Font;
import javax.swing.UIDefaults;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class StyleSheetInitTask
implements DefaultsInitTask {
    private UIDefaults defaults;

    @Override
    public void run(Theme currentTheme, UIDefaults defaults) {
        this.defaults = defaults;
        StyleSheet styleSheet = new StyleSheet();
        Font font = defaults.getFont("html.font");
        CSSBuilder builder = new CSSBuilder();
        builder.group("body").fontSize(this.pt(14)).fontFamily(font.getFamily(), font.getName()).fontWeight("normal").marginRight(0).marginLeft(0).color(this.hex("textForeground"));
        builder.group("p").marginTop(this.px(15));
        builder.group("h1").fontSize("x-large").fontWeight("bold").marginTop(this.px(10)).marginBottom(this.px(10));
        builder.group("h2").fontSize("large").fontWeight("bold").marginTop(this.px(10)).marginBottom(this.px(10));
        builder.group("h3").fontSize("medium").fontWeight("bold").marginTop(this.px(10)).marginBottom(this.px(10));
        builder.group("h4").fontSize("small").fontWeight("bold").marginTop(this.px(10)).marginBottom(this.px(10));
        builder.group("h5").fontSize("x-small").fontWeight("bold").marginTop(this.px(10)).marginBottom(this.px(10));
        builder.group("h6").fontSize("xx-small").fontWeight("bold").marginTop(this.px(10)).marginBottom(this.px(10));
        builder.group("li p").marginTop(0).marginBottom(0);
        builder.group("td p").marginTop(0);
        builder.group("menu li p").marginTop(0).marginBottom(0);
        builder.group("menu li").margin(0);
        builder.group("menu").marginLeftLTR(this.px(40)).marginRightRTL(this.px(40)).marginTop(this.px(10)).marginBottom(this.px(10));
        builder.group("dir li p").marginTop(0).marginBottom(0);
        builder.group("dir li").margin(0);
        builder.group("dir").marginLeftLTR(this.px(40)).marginRightRTL(this.px(40)).marginTop(this.px(10)).marginBottom(this.px(10));
        builder.group("dd").marginLeftLTR(this.px(40)).marginRightRTL(this.px(40)).marginTop(this.px(10)).marginBottom(this.px(10));
        builder.group("dd p").margin(0);
        builder.group("dt").marginTop(0).marginBottom(0);
        builder.group("dl").marginLeft(0).marginTop(this.px(10)).marginBottom(this.px(10));
        builder.group("ol li").margin(0);
        builder.group("ol").marginTop(this.px(10)).marginBottom(this.px(10)).marginLeftLTR(this.px(50)).marginRightRTL(this.px(50)).listStyleType("decimal");
        builder.group("ol li p").marginTop(0).marginBottom(0);
        builder.group("ul li").margin(0);
        builder.group("ul").marginTop(this.px(10)).marginBottom(this.px(10)).marginLeftLTR(this.px(50)).marginRightRTL(this.px(50)).listStyleType("disc").property("-bullet-gap", this.px(10));
        builder.group("ul li ul li").margin(0);
        builder.group("ul li ul").marginLeftLTR(this.px(25)).marginRightRTL(this.px(25)).listStyleType("circle");
        builder.group("ul li ul li ul li").margin(0);
        builder.group("ul li menu").marginLeftLTR(this.px(25)).marginRightRTL(this.px(25)).listStyleType("circle");
        builder.group("ul li p").marginTop(0).marginBottom(0);
        builder.group("a").color(this.hex("hyperlink")).textDecoration("underline");
        builder.group("address").color(this.hex("hyperlink")).fontStyle("italic");
        builder.group("big").fontSize("x-large");
        builder.group("small").fontSize("x-small");
        builder.group("samp").fontSize("small").fontFamily("Monospaced", "monospace");
        builder.group("code").fontSize("small").fontFamily("Monospaced", "monospace");
        builder.group("kbd").fontSize("small").fontFamily("Monospaced", "monospace");
        builder.group("cite").fontStyle("italic");
        builder.group("dfn").fontStyle("italic");
        builder.group("em").fontStyle("italic");
        builder.group("i").fontStyle("italic");
        builder.group("b").fontWeight("bold");
        builder.group("strong").fontWeight("bold");
        builder.group("strike").textDecoration("line-through");
        builder.group("s").textDecoration("line-through");
        builder.group("sub").property("vertical-align", "sub");
        builder.group("sup").property("vertical-align", "sub");
        builder.group("tt").fontFamily("Monospaced", "monospace");
        builder.group("u").textDecoration("underline");
        builder.group("var").fontWeight("bold").fontStyle("italic");
        builder.group("table").borderStyle("none").borderCollapse("collapse");
        builder.group("td").borderColor(this.hex("border")).borderStyle("none").borderWidth(this.px(1)).padding(this.px(3)).borderCollapse("collapse");
        builder.group("th").borderColor(this.hex("border")).borderStyle("solid").borderWidth(this.px(1)).padding(this.px(3)).fontWeight("bold").borderCollapse("collapse");
        builder.group("tr").property("text-align", "left");
        builder.group("blockquote").margin(this.px(5) + " " + this.px(35));
        builder.group("center").property("text-align", "center");
        builder.group("pre").marginTop(this.px(5)).marginBottom(this.px(5)).fontFamily("Monospaced", "monospace");
        builder.group("pre p").marginTop(0);
        builder.group("caption").property("caption-side", "top").property("text-align", "center");
        builder.group("nobr").property("white-space", "nowrap");
        builder.group("input").border("none");
        builder.group("div").borderColor(this.hex("borderSecondary")).borderWidth(this.px(1));
        styleSheet.addRule(builder.toString());
        StyleSheet custom = currentTheme.loadStyleSheet();
        if (custom.getStyleNames().hasMoreElements()) {
            styleSheet.addStyleSheet(custom);
        }
        new HTMLEditorKit().setStyleSheet(styleSheet);
    }

    protected String hex(String key) {
        Color c = this.defaults.getColor(key);
        return "#" + ColorUtil.toHex((Color)c);
    }

    protected String px(int px) {
        return px + "px";
    }

    protected String pt(int pt) {
        return pt + "pt";
    }

    @Override
    public boolean onlyDuringInstallation() {
        return true;
    }
}

