/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.task;

import com.github.weisj.darklaf.DarkLaf;
import com.github.weisj.darklaf.iconset.IconSet;
import com.github.weisj.darklaf.nativelaf.DecorationsHandler;
import com.github.weisj.darklaf.platform.SystemInfo;
import com.github.weisj.darklaf.properties.PropertyLoader;
import com.github.weisj.darklaf.properties.icons.IconResolver;
import com.github.weisj.darklaf.task.AccentColorAdjustmentTask;
import com.github.weisj.darklaf.task.DefaultsAdjustmentTask;
import com.github.weisj.darklaf.task.DefaultsInitTask;
import com.github.weisj.darklaf.task.ForegroundColorGenerationTask;
import com.github.weisj.darklaf.task.UserDefaultsAdjustmentTask;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import javax.swing.UIDefaults;

public class ThemeDefaultsInitTask
implements DefaultsInitTask {
    private static final String GLOBAL_PREFIX = "global.";
    private static final String MAC_OS_MENU_BAR_KEY = "apple.laf.useScreenMenuBar";
    private static final String[] UI_PROPERTIES = new String[]{"borders", "button", "cell", "checkBox", "colorChooser", "comboBox", "fileChooser", "tristate", "internalFrame", "label", "list", "menu", "menuBar", "menuItem", "numberingPane", "optionPane", "panel", "popupMenu", "progressBar", "radioButton", "rootPane", "scrollBar", "scrollPane", "separator", "slider", "spinner", "splitPane", "statusBar", "tabbedPane", "tabFrame", "table", "taskPane", "text", "toggleButton", "toolBar", "toolTip", "tree", "misc"};
    private static final String[] ICON_PROPERTIES = new String[]{"checkBox", "radioButton", "slider", "frame"};
    private static final String ACCENT_COLOR_KEY = "effectiveAccentColor";
    private static final String ACCENT_COLOR_BACKUP_KEY = "themeAccentColor";
    private static final String ACCENT_COLOR_SOURCE_KEY = "widgetFillDefault";
    private static final String SELECTION_COLOR_KEY = "effectiveSelectionColor";
    private static final String SELECTION_COLOR_BACKUP_KEY = "themeSelectionColor";
    private static final String SELECTION_COLOR_SOURCE_KEY = "textCompSelectionBackground";
    private final DefaultsAdjustmentTask userPreferenceAdjustment = new UserDefaultsAdjustmentTask();
    private final DefaultsAdjustmentTask accentColorAdjustment = new AccentColorAdjustmentTask();
    private final DefaultsAdjustmentTask foregroundGeneration = new ForegroundColorGenerationTask();

    @Override
    public void run(Theme currentTheme, UIDefaults defaults) {
        this.loadThemeDefaults(currentTheme, defaults);
    }

    private void loadThemeDefaults(Theme currentTheme, UIDefaults defaults) {
        Properties uiProps = new Properties();
        currentTheme.loadDefaults(uiProps, defaults, DarkUIUtil.iconResolver());
        this.backupAccentColors(uiProps);
        this.userPreferenceAdjustment.run(currentTheme, uiProps);
        this.accentColorAdjustment.run(currentTheme, uiProps);
        this.foregroundGeneration.run(currentTheme, uiProps);
        this.initGlobals(currentTheme, defaults, uiProps);
        this.initUIProperties(currentTheme, defaults, uiProps);
        this.initIconTheme(currentTheme, defaults, uiProps);
        this.initPlatformProperties(currentTheme, defaults, uiProps);
        DecorationsHandler.getSharedInstance().loadDecorationProperties(uiProps, defaults);
        this.adjustPlatformSpecifics(uiProps);
        this.initAccentProperties(currentTheme, uiProps);
        defaults.putAll(uiProps);
    }

    private void backupAccentColors(Properties uiProps) {
        uiProps.put(ACCENT_COLOR_BACKUP_KEY, Objects.requireNonNull(uiProps.get(ACCENT_COLOR_SOURCE_KEY), ACCENT_COLOR_SOURCE_KEY));
        uiProps.put(SELECTION_COLOR_BACKUP_KEY, Objects.requireNonNull(uiProps.get(SELECTION_COLOR_SOURCE_KEY), SELECTION_COLOR_SOURCE_KEY));
    }

    private void initAccentProperties(Theme currentTheme, Properties uiProps) {
        Color accentColor = currentTheme.getAccentColorRule().getAccentColor();
        Color selectionColor = currentTheme.getAccentColorRule().getSelectionColor();
        uiProps.put(ACCENT_COLOR_KEY, accentColor != null ? accentColor : uiProps.get(ACCENT_COLOR_BACKUP_KEY));
        uiProps.put(SELECTION_COLOR_KEY, selectionColor != null ? selectionColor : uiProps.get(SELECTION_COLOR_BACKUP_KEY));
    }

    private void initGlobals(Theme currentTheme, UIDefaults defaults, Properties uiProps) {
        IconResolver iconResolver = DarkUIUtil.iconResolver();
        PropertyLoader.putProperties((Properties)PropertyLoader.loadProperties(DarkLaf.class, (String)"globals", (String)""), (Properties)uiProps, (UIDefaults)defaults, (IconResolver)iconResolver);
        currentTheme.customizeGlobals(uiProps, defaults, iconResolver);
        this.installGlobals(uiProps, defaults);
    }

    private void installGlobals(Properties uiProps, UIDefaults defaults) {
        HashMap<String, Object> globalSettings = new HashMap<String, Object>();
        for (Object key : uiProps.keySet()) {
            if (!(key instanceof String) || !((String)key).startsWith(GLOBAL_PREFIX)) continue;
            globalSettings.put(((String)key).substring(GLOBAL_PREFIX.length()), uiProps.get(key));
        }
        PropertyLoader.replaceProperties((Map)defaults, e -> e.getKey() instanceof String && ((String)e.getKey()).contains("."), e -> {
            String s = (String)e.getKey();
            String globalKey = s.substring(s.lastIndexOf(46) + 1);
            return globalSettings.get(globalKey);
        });
    }

    private void initUIProperties(Theme currentTheme, UIDefaults defaults, Properties uiProps) {
        IconResolver iconResolver = DarkUIUtil.iconResolver();
        for (String property : UI_PROPERTIES) {
            PropertyLoader.putProperties((Properties)PropertyLoader.loadProperties(DarkLaf.class, (String)property, (String)"ui/"), (Properties)uiProps, (UIDefaults)defaults, (IconResolver)iconResolver);
        }
        currentTheme.customizeUIProperties(uiProps, defaults, iconResolver);
    }

    private void initIconTheme(Theme currentTheme, UIDefaults defaults, Properties uiProps) {
        IconResolver iconResolver = DarkUIUtil.iconResolver();
        currentTheme.loadIconTheme(uiProps, defaults, iconResolver);
        for (String property : ICON_PROPERTIES) {
            PropertyLoader.putProperties((Properties)PropertyLoader.loadProperties(IconSet.class, (String)property, (String)""), (Properties)uiProps, (UIDefaults)defaults, (IconResolver)iconResolver);
        }
        currentTheme.customizeIconTheme(uiProps, defaults, iconResolver);
    }

    private void initPlatformProperties(Theme currentTheme, UIDefaults defaults, Properties uiProps) {
        IconResolver iconResolver = DarkUIUtil.iconResolver();
        Consumer<String> osPlatformLoader = osName -> PropertyLoader.putProperties((Properties)PropertyLoader.loadProperties(DarkLaf.class, (String)osName, (String)"nativelaf/"), (Properties)uiProps, (UIDefaults)defaults, (IconResolver)iconResolver);
        osPlatformLoader.accept(this.getOsName());
        if (SystemInfo.isWindows11()) {
            osPlatformLoader.accept("windows11");
        }
        currentTheme.customizePlatformProperties(uiProps, defaults, iconResolver);
    }

    private String getOsName() {
        String osName = System.getProperty("darklaf.internal.osname");
        return osName != null ? osName : SystemInfo.getOsName();
    }

    private void adjustPlatformSpecifics(Properties uiProps) {
        PropertyUtil.installSystemProperty((String)MAC_OS_MENU_BAR_KEY, (String)"true");
        boolean useScreenMenuBar = Boolean.getBoolean(MAC_OS_MENU_BAR_KEY);
        if (SystemInfo.isMac && useScreenMenuBar) {
            uiProps.remove("MenuBarUI");
        }
    }
}

