/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.transfer;

import com.github.weisj.darklaf.properties.icons.IconUtil;
import com.github.weisj.darklaf.transfer.ObjectTransferable;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.Pair;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public final class TransferUtil {
    private static final Logger LOGGER = LogUtil.getLogger(TransferUtil.class);

    private TransferUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static <T> Pair<DropTarget, AtomicBoolean> setupDnD(JComponent c, final int sourceActions, final Class<T> dataType, final Supplier<T> exporter, final Consumer<T> importer, final Function<T, Icon> dragImageCreator) {
        DragSource ds = new DragSource();
        AtomicBoolean dragEnabled = new AtomicBoolean(true);
        TransferHandler handler = new TransferHandler(){
            private final DataFlavor flavor;
            {
                try {
                    this.flavor = new DataFlavor("application/x-java-jvm-local-objectref;class=" + dataType.getName());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public int getSourceActions(JComponent c) {
                return sourceActions;
            }

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return support.isDataFlavorSupported(this.flavor);
            }

            @Override
            public Icon getVisualRepresentation(Transferable t) {
                try {
                    return (Icon)dragImageCreator.apply(t.getTransferData(this.flavor));
                }
                catch (UnsupportedFlavorException | IOException e) {
                    return null;
                }
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                Object value = exporter.get();
                this.setDragImage(IconUtil.iconToImage((Icon)((Icon)dragImageCreator.apply(value)), (Component)c));
                return new ObjectTransferable(value, dataType);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                if (!support.isDrop()) {
                    return false;
                }
                try {
                    importer.accept(support.getTransferable().getTransferData(this.flavor));
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Importing failed", e);
                }
                return false;
            }
        };
        c.setTransferHandler(handler);
        ds.createDefaultDragGestureRecognizer(c, sourceActions, dge -> {
            if (!dragEnabled.get()) {
                return;
            }
            handler.exportAsDrag(c, dge.getTriggerEvent(), dge.getDragAction());
        });
        return new Pair((Object)c.getDropTarget(), (Object)dragEnabled);
    }
}

