/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.button;

import com.github.weisj.darklaf.ui.button.ButtonConstants;
import com.github.weisj.darklaf.ui.button.DarkButtonUI;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicButtonListener;

public class DarkButtonListener<T extends DarkButtonUI>
extends BasicButtonListener {
    protected final T ui;

    public DarkButtonListener(AbstractButton b, T ui) {
        super(b);
        this.ui = ui;
    }

    @Override
    public void focusGained(FocusEvent e) {
        super.focusGained(e);
        ((DarkButtonUI)this.ui).repaintNeighbours();
    }

    @Override
    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        ((DarkButtonUI)this.ui).repaintNeighbours();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        AbstractButton b = (AbstractButton)e.getSource();
        ButtonModel model = b.getModel();
        if (!SwingUtilities.isLeftMouseButton(e)) {
            model.setRollover(true);
        }
        if (model.isPressed()) {
            model.setArmed(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        AbstractButton b = (AbstractButton)e.getSource();
        ButtonModel model = b.getModel();
        model.setRollover(false);
        model.setArmed(false);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        AbstractButton b = (AbstractButton)e.getSource();
        ButtonModel model = b.getModel();
        if (b.contains(e.getPoint())) {
            model.setRollover(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        AbstractButton b = (AbstractButton)e.getSource();
        String key = e.getPropertyName();
        if (key.startsWith("JButton.")) {
            ((DarkButtonUI)this.ui).updateMargins(b);
            b.doLayout();
            b.repaint();
            if ("JButton.variant".equals(key)) {
                boolean newIsBorderless;
                boolean oldWasBorderless = "borderless".equals(e.getOldValue()) || "borderlessRectangular".equals(e.getOldValue());
                boolean bl = newIsBorderless = ButtonConstants.isBorderless(b) || ButtonConstants.isBorderlessRectangular(b);
                if (oldWasBorderless || newIsBorderless) {
                    b.setRequestFocusEnabled(!newIsBorderless);
                }
            }
        }
    }
}

