/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.cell;

import com.github.weisj.darklaf.ui.list.DarkListUI;
import com.github.weisj.darklaf.ui.table.renderer.IconWrapper;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.util.ColorUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;

public final class CellUtil {
    public static final String KEY_SELECTED_CELL_RENDERER = "JComponent.selectedCellRenderer";
    private static Color cellForeground;
    private static Color cellForegroundSelected;
    private static Color cellForegroundNoFocus;
    private static Color cellForegroundSelectedNoFocus;
    private static Color cellInactiveForeground;
    private static Color cellInactiveForegroundSelected;
    private static Color cellInactiveForegroundNoFocus;
    private static Color cellInactiveForegroundSelectedNoFocus;
    private static Color cellBackground;
    private static Color cellBackgroundAlternative;
    private static Color cellBackgroundSelected;
    private static Color cellBackgroundNoFocus;
    private static Color cellBackgroundNoFocusAlternative;
    private static Color cellBackgroundSelectedNoFocus;
    private static Color cellInactiveBackground;
    private static Color cellInactiveBackgroundAlternative;
    private static Color cellInactiveBackgroundSelected;
    private static Color cellInactiveBackgroundNoFocus;
    private static Color cellInactiveBackgroundNoFocusAlternative;
    private static Color cellInactiveBackgroundSelectedNoFocus;
    private static Color tableCellForeground;
    private static Color tableCellForegroundSelected;
    private static Color tableCellForegroundNoFocus;
    private static Color tableCellForegroundSelectedNoFocus;
    private static Color tableCellInactiveForeground;
    private static Color tableCellInactiveForegroundSelected;
    private static Color tableCellInactiveForegroundNoFocus;
    private static Color tableCellInactiveForegroundSelectedNoFocus;
    private static Color tableCellBackground;
    private static Color tableCellBackgroundAlternative;
    private static Color tableCellBackgroundSelected;
    private static Color tableCellBackgroundNoFocus;
    private static Color tableCellBackgroundNoFocusAlternative;
    private static Color tableCellBackgroundSelectedNoFocus;
    private static Color tableCellInactiveBackground;
    private static Color tableCellInactiveBackgroundAlternative;
    private static Color tableCellInactiveBackgroundSelected;
    private static Color tableCellInactiveBackgroundNoFocus;
    private static Color tableCellInactiveBackgroundNoFocusAlternative;
    private static Color tableCellInactiveBackgroundSelectedNoFocus;
    private static Color treeCellForeground;
    private static Color treeCellForegroundSelected;
    private static Color treeCellForegroundNoFocus;
    private static Color treeCellForegroundSelectedNoFocus;
    private static Color treeCellInactiveForeground;
    private static Color treeCellInactiveForegroundSelected;
    private static Color treeCellInactiveForegroundNoFocus;
    private static Color treeCellInactiveForegroundSelectedNoFocus;
    private static Color treeCellBackground;
    private static Color treeCellBackgroundAlternative;
    private static Color treeCellBackgroundSelected;
    private static Color treeCellBackgroundNoFocus;
    private static Color treeCellBackgroundNoFocusAlternative;
    private static Color treeCellBackgroundSelectedNoFocus;
    private static Color treeCellInactiveBackground;
    private static Color treeCellInactiveBackgroundAlternative;
    private static Color treeCellInactiveBackgroundSelected;
    private static Color treeCellInactiveBackgroundNoFocus;
    private static Color treeCellInactiveBackgroundNoFocusAlternative;
    private static Color treeCellInactiveBackgroundSelectedNoFocus;
    private static Color listCellForeground;
    private static Color listCellForegroundSelected;
    private static Color comboListCellForegroundSelected;
    private static Color listCellForegroundNoFocus;
    private static Color listCellForegroundSelectedNoFocus;
    private static Color listCellInactiveForeground;
    private static Color listCellInactiveForegroundSelected;
    private static Color listCellInactiveForegroundNoFocus;
    private static Color listCellInactiveForegroundSelectedNoFocus;
    private static Color listCellBackground;
    private static Color listCellBackgroundAlternative;
    private static Color listCellBackgroundSelected;
    private static Color comboListCellBackgroundSelected;
    private static Color listCellBackgroundNoFocus;
    private static Color listCellBackgroundNoFocusAlternative;
    private static Color listCellBackgroundSelectedNoFocus;
    private static Color listCellInactiveBackground;
    private static Color listCellInactiveBackgroundAlternative;
    private static Color listCellInactiveBackgroundSelected;
    private static Color listCellInactiveBackgroundNoFocus;
    private static Color listCellInactiveBackgroundNoFocusAlternative;
    private static Color listCellInactiveBackgroundSelectedNoFocus;

    public static void updateColors(UIDefaults defaults) {
        UIDefaults d = defaults != null ? defaults : UIManager.getDefaults();
        cellForeground = d.getColor("Cell.foreground");
        cellForegroundSelected = d.getColor("Cell.foregroundSelected");
        cellForegroundNoFocus = d.getColor("Cell.foregroundNoFocus");
        cellForegroundSelectedNoFocus = d.getColor("Cell.foregroundSelectedNoFocus");
        cellInactiveForeground = d.getColor("Cell.inactiveForeground");
        cellInactiveForegroundSelected = d.getColor("Cell.inactiveForegroundSelected");
        cellInactiveForegroundNoFocus = d.getColor("Cell.inactiveForegroundNoFocus");
        cellInactiveForegroundSelectedNoFocus = d.getColor("Cell.inactiveSelectedNoFocus");
        cellBackground = d.getColor("Cell.background");
        cellBackgroundAlternative = d.getColor("Cell.backgroundAlternative");
        cellBackgroundSelected = d.getColor("Cell.backgroundSelected");
        cellBackgroundNoFocus = d.getColor("Cell.backgroundNoFocus");
        cellBackgroundNoFocusAlternative = d.getColor("Cell.backgroundNoFocusAlternative");
        cellBackgroundSelectedNoFocus = d.getColor("Cell.backgroundSelectedNoFocus");
        cellInactiveBackground = d.getColor("Cell.inactiveBackground");
        cellInactiveBackgroundAlternative = d.getColor("Cell.inactiveBackgroundAlternative");
        cellInactiveBackgroundSelected = d.getColor("Cell.inactiveBackgroundSelected");
        cellInactiveBackgroundNoFocus = d.getColor("Cell.inactiveBackgroundNoFocus");
        cellInactiveBackgroundNoFocusAlternative = d.getColor("Cell.inactiveBackgroundNoFocusAlternative");
        cellInactiveBackgroundSelectedNoFocus = d.getColor("Cell.inactiveBackgroundSelectedNoFocus");
        tableCellForeground = d.getColor("Table.foreground");
        tableCellForegroundSelected = d.getColor("Table.foregroundSelected");
        tableCellForegroundNoFocus = d.getColor("Table.foregroundNoFocus");
        tableCellForegroundSelectedNoFocus = d.getColor("Table.foregroundSelectedNoFocus");
        tableCellInactiveForeground = d.getColor("Table.inactiveForeground");
        tableCellInactiveForegroundSelected = d.getColor("Table.inactiveForegroundSelected");
        tableCellInactiveForegroundNoFocus = d.getColor("Table.inactiveForegroundNoFocus");
        tableCellInactiveForegroundSelectedNoFocus = d.getColor("Table.inactiveSelectedNoFocus");
        tableCellBackground = d.getColor("Table.background");
        tableCellBackgroundAlternative = d.getColor("Table.backgroundAlternative");
        tableCellBackgroundSelected = d.getColor("Table.backgroundSelected");
        tableCellBackgroundNoFocus = d.getColor("Table.backgroundNoFocus");
        tableCellBackgroundNoFocusAlternative = d.getColor("Table.backgroundNoFocusAlternative");
        tableCellBackgroundSelectedNoFocus = d.getColor("Table.backgroundSelectedNoFocus");
        tableCellInactiveBackground = d.getColor("Table.inactiveBackground");
        tableCellInactiveBackgroundAlternative = d.getColor("Table.inactiveBackgroundAlternative");
        tableCellInactiveBackgroundSelected = d.getColor("Table.inactiveBackgroundSelected");
        tableCellInactiveBackgroundNoFocus = d.getColor("Table.inactiveBackgroundNoFocus");
        tableCellInactiveBackgroundNoFocusAlternative = d.getColor("Table.inactiveBackgroundNoFocusAlternative");
        tableCellInactiveBackgroundSelectedNoFocus = d.getColor("Table.inactiveBackgroundSelectedNoFocus");
        treeCellForeground = d.getColor("Tree.foreground");
        treeCellForegroundSelected = d.getColor("Tree.foregroundSelected");
        treeCellForegroundNoFocus = d.getColor("Tree.foregroundNoFocus");
        treeCellForegroundSelectedNoFocus = d.getColor("Tree.foregroundSelectedNoFocus");
        treeCellInactiveForeground = d.getColor("Tree.inactiveForeground");
        treeCellInactiveForegroundSelected = d.getColor("Tree.inactiveForegroundSelected");
        treeCellInactiveForegroundNoFocus = d.getColor("Tree.inactiveForegroundNoFocus");
        treeCellInactiveForegroundSelectedNoFocus = d.getColor("Tree.inactiveSelectedNoFocus");
        treeCellBackground = d.getColor("Tree.background");
        treeCellBackgroundAlternative = d.getColor("Tree.backgroundAlternative");
        treeCellBackgroundSelected = d.getColor("Tree.backgroundSelected");
        treeCellBackgroundNoFocus = d.getColor("Tree.backgroundNoFocus");
        treeCellBackgroundNoFocusAlternative = d.getColor("Tree.backgroundNoFocusAlternative");
        treeCellBackgroundSelectedNoFocus = d.getColor("Tree.backgroundSelectedNoFocus");
        treeCellInactiveBackground = d.getColor("Tree.inactiveBackground");
        treeCellInactiveBackgroundAlternative = d.getColor("Tree.inactiveBackgroundAlternative");
        treeCellInactiveBackgroundSelected = d.getColor("Tree.inactiveBackgroundSelected");
        treeCellInactiveBackgroundNoFocus = d.getColor("Tree.inactiveBackgroundNoFocus");
        treeCellInactiveBackgroundNoFocusAlternative = d.getColor("Tree.inactiveBackgroundNoFocusAlternative");
        treeCellInactiveBackgroundSelectedNoFocus = d.getColor("Tree.inactiveBackgroundSelectedNoFocus");
        listCellForeground = d.getColor("List.foreground");
        listCellForegroundSelected = d.getColor("List.foregroundSelected");
        comboListCellForegroundSelected = d.getColor("ComboBox.selectionForeground");
        listCellForegroundNoFocus = d.getColor("List.foregroundNoFocus");
        listCellForegroundSelectedNoFocus = d.getColor("List.foregroundSelectedNoFocus");
        listCellInactiveForeground = d.getColor("List.inactiveForeground");
        listCellInactiveForegroundSelected = d.getColor("List.inactiveForegroundSelected");
        listCellInactiveForegroundNoFocus = d.getColor("List.inactiveForegroundNoFocus");
        listCellInactiveForegroundSelectedNoFocus = d.getColor("List.inactiveSelectedNoFocus");
        listCellBackground = d.getColor("List.background");
        listCellBackgroundAlternative = d.getColor("List.backgroundAlternative");
        listCellBackgroundSelected = d.getColor("List.backgroundSelected");
        comboListCellBackgroundSelected = d.getColor("ComboBox.selectionBackground");
        listCellBackgroundNoFocus = d.getColor("List.backgroundNoFocus");
        listCellBackgroundNoFocusAlternative = d.getColor("List.backgroundNoFocusAlternative");
        listCellBackgroundSelectedNoFocus = d.getColor("List.backgroundSelectedNoFocus");
        listCellInactiveBackground = d.getColor("List.inactiveBackground");
        listCellInactiveBackgroundAlternative = d.getColor("List.inactiveBackgroundAlternative");
        listCellInactiveBackgroundSelected = d.getColor("List.inactiveBackgroundSelected");
        listCellInactiveBackgroundNoFocus = d.getColor("List.inactiveBackgroundNoFocus");
        listCellInactiveBackgroundNoFocusAlternative = d.getColor("List.inactiveBackgroundNoFocusAlternative");
        listCellInactiveBackgroundSelectedNoFocus = d.getColor("List.inactiveBackgroundSelectedNoFocus");
    }

    public static void setupTableForeground(Component comp, JTable parent, boolean selected, int row) {
        CellUtil.setupForeground(comp, parent, selected, tableCellForeground, tableCellForegroundSelected, tableCellForegroundNoFocus, tableCellForegroundSelectedNoFocus, tableCellInactiveForeground, tableCellInactiveForegroundSelected, tableCellInactiveForegroundNoFocus, tableCellInactiveForegroundSelectedNoFocus);
    }

    public static void setupTreeForeground(Component comp, JTree parent, boolean selected) {
        CellUtil.setupForeground(comp, parent, selected, treeCellForeground, treeCellForegroundSelected, treeCellForegroundNoFocus, treeCellForegroundSelectedNoFocus, treeCellInactiveForeground, treeCellInactiveForegroundSelected, treeCellInactiveForegroundNoFocus, treeCellInactiveForegroundSelectedNoFocus);
    }

    public static void setupListForeground(Component comp, JList<?> parent, boolean selected) {
        boolean comboList = PropertyUtil.getBooleanProperty(parent, (String)"JList..isComboList");
        CellUtil.setupForeground(comp, parent, selected, listCellForeground, comboList ? comboListCellForegroundSelected : listCellForegroundSelected, listCellForegroundNoFocus, listCellForegroundSelectedNoFocus, listCellInactiveForeground, listCellInactiveForegroundSelected, listCellInactiveForegroundNoFocus, listCellInactiveForegroundSelectedNoFocus);
    }

    public static void setupStandardForeground(Component comp, JComponent parent, boolean selected) {
        CellUtil.setupForeground(comp, parent, selected, cellForeground, cellForegroundSelected, cellForegroundNoFocus, cellForegroundSelectedNoFocus, cellInactiveForeground, cellInactiveForegroundSelected, cellInactiveForegroundNoFocus, cellInactiveForegroundSelectedNoFocus);
    }

    public static void setupForeground(Component comp, JComponent parent, boolean selected, Color fg, Color selFg, Color fgNoFocus, Color selFgNoFocus, Color inactiveFg, Color inactiveSelFg, Color inactiveFgNoFocus, Color inactiveSelFgNoFocus) {
        boolean enabled = comp.isEnabled() && parent.isEnabled();
        boolean focus = CellUtil.hasFocus(parent, comp);
        CellUtil.setupForeground(comp, parent, focus, selected, enabled, fg, selFg, fgNoFocus, selFgNoFocus, inactiveFg, inactiveSelFg, inactiveFgNoFocus, inactiveSelFgNoFocus);
    }

    public static void setupForeground(Component comp, JComponent parent, boolean focus, boolean selected, boolean enabled, Color fg, Color selFg, Color fgNoFocus, Color selFgNoFocus, Color inactiveFg, Color inactiveSelFg, Color inactiveFgNoFocus, Color inactiveSelFgNoFocus) {
        Color c = CellUtil.getColor(enabled, focus, selected, fg, selFg, fgNoFocus, selFgNoFocus, inactiveFg, inactiveSelFg, inactiveFgNoFocus, inactiveSelFgNoFocus);
        PropertyUtil.installForeground((Component)comp, (Color)c);
    }

    public static Color getTableBackground(Component comp, JTable parent, boolean selected, boolean focus, int row) {
        boolean alt = row % 2 == 1 && PropertyUtil.getBooleanProperty((JComponent)parent, (String)"JTable.alternateRowColor");
        return CellUtil.getColor(comp, focus, selected, alt ? tableCellBackgroundAlternative : tableCellBackground, tableCellBackgroundSelected, alt ? tableCellBackgroundNoFocusAlternative : tableCellBackgroundNoFocus, tableCellBackgroundSelectedNoFocus, alt ? tableCellInactiveBackgroundAlternative : tableCellInactiveBackground, tableCellInactiveBackgroundSelected, alt ? tableCellInactiveBackgroundNoFocusAlternative : tableCellInactiveBackgroundNoFocus, tableCellInactiveBackgroundSelectedNoFocus);
    }

    public static void setupTableBackground(Component comp, JTable parent, boolean selected, int row) {
        CellUtil.setupBackground(comp, CellUtil.getTableBackground(comp, parent, selected, CellUtil.hasFocus(parent, comp), row));
    }

    public static Color getTreeBackground(JTree tree, boolean selected, int row) {
        return CellUtil.getTreeBackground(tree, tree, selected, CellUtil.hasFocus(tree, tree), row);
    }

    public static Color getTreeBackground(Component comp, JTree parent, boolean selected, boolean focus, int row) {
        Color treeBg = parent.getBackground();
        boolean canOverwrite = ColorUtil.canOverwriteColor((Color)treeBg);
        boolean alt = canOverwrite && row % 2 == 1 && PropertyUtil.getBooleanProperty((JComponent)parent, (String)"JTree.alternateRowColor");
        Color defaultBg = canOverwrite ? treeCellBackground : treeBg;
        Color defaultBgNoFocus = canOverwrite ? treeCellBackgroundNoFocus : treeBg;
        Color defaultBgInactive = canOverwrite ? treeCellInactiveBackground : treeBg;
        Color defaultBgInactiveNoFocus = canOverwrite ? treeCellInactiveBackgroundNoFocus : treeBg;
        return CellUtil.getColor(comp.isEnabled(), focus, selected, alt ? treeCellBackgroundAlternative : defaultBg, treeCellBackgroundSelected, alt ? treeCellBackgroundNoFocusAlternative : defaultBgNoFocus, treeCellBackgroundSelectedNoFocus, alt ? treeCellInactiveBackgroundAlternative : defaultBgInactive, treeCellInactiveBackgroundSelected, alt ? treeCellInactiveBackgroundNoFocusAlternative : defaultBgInactiveNoFocus, treeCellInactiveBackgroundSelectedNoFocus);
    }

    public static void setupTreeBackground(Component comp, JTree parent, boolean selected, int row) {
        Color c;
        Color bg = CellUtil.getTreeBackground(comp, parent, selected, CellUtil.hasFocus(parent, comp), row);
        comp.setBackground(bg);
        if (comp instanceof DefaultTreeCellRenderer && ColorUtil.canOverwriteColor((Color)(c = comp.getBackground()))) {
            comp.setBackground(ColorUtil.stripUIResource((Color)bg, (boolean)true));
        }
    }

    public static Color getListBackground(Component comp, JList<?> parent, boolean selected, int index) {
        int layout = parent.getLayoutOrientation();
        int row = index;
        boolean altRow = true;
        if ((layout == 1 || layout == 2) && index >= 0 && index < parent.getModel().getSize()) {
            DarkListUI ui = DarkUIUtil.getUIOfType(parent.getUI(), DarkListUI.class);
            if (ui != null) {
                row = ui.convertModelToRow(index);
                if (row == -1 && index >= parent.getModel().getSize()) {
                    row = ui.convertModelToRow(index - ui.getRowCount(ui.getColumnCount() - 1));
                }
                if (row == -1) {
                    row = index;
                }
            } else {
                row = -1;
                altRow = false;
            }
        }
        return CellUtil.getListBackground(comp, parent, selected, altRow &= Math.abs(row) % 2 == 1);
    }

    public static Color getListBackground(Component comp, JList<?> parent, boolean selected, boolean altRow) {
        boolean alt = altRow && PropertyUtil.getBooleanProperty(parent, (String)"JList.alternateRowColor");
        boolean comboList = PropertyUtil.getBooleanProperty(parent, (String)"JList..isComboList");
        return CellUtil.getColor(comp, CellUtil.hasFocus(parent, comp), selected, alt ? listCellBackgroundAlternative : listCellBackground, comboList ? comboListCellBackgroundSelected : listCellBackgroundSelected, alt ? listCellBackgroundNoFocusAlternative : listCellBackgroundNoFocus, listCellBackgroundSelectedNoFocus, alt ? listCellInactiveBackgroundAlternative : listCellInactiveBackground, listCellInactiveBackgroundSelected, alt ? listCellInactiveBackgroundNoFocusAlternative : listCellInactiveBackgroundNoFocus, listCellInactiveBackgroundSelectedNoFocus);
    }

    public static void setupListBackground(Component comp, JList<?> parent, boolean selected, int index) {
        CellUtil.setupBackground(comp, CellUtil.getListBackground(comp, parent, selected, index));
    }

    public static void setupListBackground(Component comp, JList<?> parent, boolean selected, boolean altRow) {
        CellUtil.setupBackground(comp, CellUtil.getListBackground(comp, parent, selected, altRow));
    }

    public static void setupStandardBackground(Component comp, JComponent parent, boolean selected) {
        CellUtil.setupStandardBackground(comp, parent, selected, false);
    }

    public static void setupStandardBackground(Component comp, JComponent parent, boolean selected, boolean alt) {
        CellUtil.setupBackground(comp, CellUtil.getColor(comp, CellUtil.hasFocus(parent, comp), selected, alt ? cellBackgroundAlternative : cellBackground, cellBackgroundSelected, alt ? cellBackgroundNoFocusAlternative : cellBackgroundNoFocus, cellBackgroundSelectedNoFocus, alt ? cellInactiveBackgroundAlternative : cellInactiveBackground, cellInactiveBackgroundSelected, alt ? cellInactiveBackgroundNoFocusAlternative : cellInactiveBackgroundNoFocus, cellInactiveBackgroundSelectedNoFocus));
    }

    public static void setupBackground(Component comp, Color c) {
        PropertyUtil.installBackground((Component)comp, (Color)c);
        if (comp instanceof JComponent) {
            LookAndFeel.installProperty((JComponent)comp, "opaque", true);
        }
    }

    public static Color getColor(Component comp, boolean focus, boolean selected, Color bg, Color selBg, Color bgNoFocus, Color selBgNoFocus, Color inactiveBg, Color inactiveSelBg, Color inactiveBgNoFocus, Color inactiveSelBgNoFocus) {
        return CellUtil.getColor(comp.isEnabled(), focus, selected, bg, selBg, bgNoFocus, selBgNoFocus, inactiveBg, inactiveSelBg, inactiveBgNoFocus, inactiveSelBgNoFocus);
    }

    public static Color getColor(boolean enabled, boolean focus, boolean selected, Color color, Color selColor, Color colorNoFocus, Color selColorNoFocus, Color inactiveColor, Color inactiveSelColor, Color inactiveColorNoFocus, Color inactiveSelColorNoFocus) {
        Color c = enabled ? (selected ? (focus ? selColor : selColorNoFocus) : (focus ? color : colorNoFocus)) : (selected ? (focus ? inactiveSelColor : inactiveSelColorNoFocus) : (focus ? inactiveColor : inactiveColorNoFocus));
        return c;
    }

    private static boolean hasFocus(Component cellComponent, Component parentComponent) {
        return parentComponent.hasFocus() || DarkUIUtil.hasFocus(cellComponent) || DarkUIUtil.getParentOfType(JPopupMenu.class, cellComponent, 4) != null;
    }

    public static void setSelectedFlag(Component comp, boolean selected) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).putClientProperty(KEY_SELECTED_CELL_RENDERER, selected);
        }
    }

    public static void paintTableEditorBorder(Graphics g, Component c, JTable table, int width, int height) {
        int row = table.getEditingRow();
        int col = table.getEditingColumn();
        if (!table.getShowHorizontalLines()) {
            if (row > CellUtil.getMinRowIndex(table)) {
                g.fillRect(0, 0, width, 1);
            }
            g.fillRect(0, height - 1, width, 1);
        }
        boolean isWrapper = CellUtil.isInWrapper(c);
        ComponentOrientation orientation = table.getComponentOrientation();
        if (!table.getShowVerticalLines()) {
            if (isWrapper && orientation.isLeftToRight() || col > CellUtil.getMinColumnIndex(table)) {
                g.fillRect(0, 0, 1, height);
            }
            if (isWrapper && orientation.isLeftToRight() || col < CellUtil.getMaxColumnIndex(table)) {
                g.fillRect(width - 1, 0, 1, height);
            }
        } else if (CellUtil.isInWrapper(c)) {
            if (table.getComponentOrientation().isLeftToRight()) {
                g.fillRect(0, 0, 1, height);
            } else {
                g.fillRect(width - 1, 0, 1, height);
            }
        }
    }

    private static boolean isInWrapper(Component c) {
        return c.getParent() instanceof IconWrapper;
    }

    private static boolean isListEditor(Component c) {
        return PropertyUtil.getBooleanProperty((Component)c, (String)"JComponent.listCellEditor") && c.getParent() instanceof JList;
    }

    public static Insets adjustEditorInsets(Insets ins, Component c) {
        return CellUtil.adjustEditorInsets(ins, c, DarkUIUtil.getParentOfType(JTable.class, c, 2));
    }

    public static Insets adjustEditorInsets(Insets ins, Component c, JTable table) {
        ListCellRenderer renderer;
        if (CellUtil.isInWrapper(c)) {
            if (CellUtil.parentLTR(c)) {
                ins.left -= ((IconWrapper)c.getParent()).getIconCompGap();
            } else {
                ins.right -= ((IconWrapper)c.getParent()).getIconCompGap();
            }
        } else if (CellUtil.isListEditor(c) && (renderer = ((JList)c.getParent()).getCellRenderer()) instanceof JLabel) {
            if (CellUtil.parentLTR(c)) {
                ins.left -= ((JLabel)((Object)renderer)).getIconTextGap() - 1;
            } else {
                ins.right -= ((JLabel)((Object)renderer)).getIconTextGap() - 1;
            }
        }
        return CellUtil.adjustTableCellEditorInsets(ins, table);
    }

    public static Insets adjustTableCellEditorInsets(Insets ins, JTable table) {
        if (table != null && !table.getShowVerticalLines()) {
            int cMin = CellUtil.getMinColumnIndex(table);
            int column = table.getEditingColumn();
            if (column > cMin) {
                ++ins.left;
            }
        }
        return ins;
    }

    private static boolean parentLTR(Component c) {
        return c.getParent().getComponentOrientation().isLeftToRight();
    }

    public static int getMinColumnIndex(JTable table) {
        Rectangle rect = table.getVisibleRect();
        return table.columnAtPoint(rect.getLocation());
    }

    public static int getMaxColumnIndex(JTable table) {
        Rectangle rect = table.getVisibleRect();
        Point p = rect.getLocation();
        p.x += rect.width - 1;
        return table.columnAtPoint(p);
    }

    public static int getMinRowIndex(JTable table) {
        Rectangle rect = table.getVisibleRect();
        return table.rowAtPoint(rect.getLocation());
    }
}

