/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.combobox;

import com.github.weisj.darklaf.components.ArrowButton;
import com.github.weisj.darklaf.swingdsl.VisualPaddingListener;
import com.github.weisj.darklaf.ui.DividedWidgetPainter;
import com.github.weisj.darklaf.ui.combobox.ComboBoxConstants;
import com.github.weisj.darklaf.ui.combobox.ComboIcon;
import com.github.weisj.darklaf.ui.combobox.DarkComboBoxBorder;
import com.github.weisj.darklaf.ui.combobox.DarkComboBoxListener;
import com.github.weisj.darklaf.ui.combobox.DarkComboPopup;
import com.github.weisj.darklaf.ui.list.DarkDefaultListCellRenderer;
import com.github.weisj.darklaf.ui.text.DarkTextUI;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;

public class DarkComboBoxUI
extends BasicComboBoxUI
implements ComboBoxConstants {
    protected DarkComboBoxListener comboBoxListener;
    protected VisualPaddingListener visualPaddingListener;
    protected int arcSize;
    protected int borderSize;
    protected Color background;
    protected Color editBackground;
    protected Color inactiveBackground;
    protected Color foreground;
    protected Color inactiveForeground;
    protected Color arrowBackground;
    private Insets buttonPad;
    private Insets valueInsets;
    private Insets editorCellInsets;

    public static ComponentUI createUI(JComponent c) {
        return new DarkComboBoxUI();
    }

    protected Component getEditorComponent() {
        ComboBoxEditor editor = this.comboBox.getEditor();
        if (editor == null) {
            return null;
        }
        return editor.getEditorComponent();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.comboBox, "opaque", false);
        this.comboBox.putClientProperty("consumeEventOnClose", true);
        PropertyUtil.installBorder((JComponent)this.comboBox, (Border)this.createBorder());
        this.arcSize = UIManager.getInt("ComboBox.arc");
        this.borderSize = UIManager.getInt("ComboBox.borderThickness");
        this.background = UIManager.getColor("ComboBox.activeBackground");
        this.foreground = UIManager.getColor("ComboBox.foreground");
        this.editBackground = UIManager.getColor("ComboBox.editBackground");
        this.inactiveBackground = UIManager.getColor("ComboBox.inactiveBackground");
        this.inactiveForeground = UIManager.getColor("ComboBox.disabledForeground");
        this.arrowBackground = UIManager.getColor("ComboBox.arrowBackground");
        this.buttonPad = UIManager.getInsets("ComboBox.buttonInsets");
        this.valueInsets = UIManager.getInsets("ComboBox.valueInsets");
        this.editorCellInsets = UIManager.getInsets("ComboBox.cellEditorInsets");
        int maximumRowCount = UIManager.getInt("ComboBox.maximumRowCount");
        if (maximumRowCount > 0 && maximumRowCount != 8 && this.comboBox.getMaximumRowCount() == 8) {
            this.comboBox.setMaximumRowCount(maximumRowCount);
        }
        this.updateForeground(this.comboBox);
        this.updateBackground(this.comboBox);
    }

    protected Border createBorder() {
        return new DarkComboBoxBorder(this);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.comboBoxListener = this.createComboBoxListener();
        this.comboBox.addMouseListener(this.comboBoxListener);
        this.comboBox.addPropertyChangeListener(this.comboBoxListener);
        this.visualPaddingListener = new VisualPaddingListener();
        this.comboBox.addPropertyChangeListener(this.visualPaddingListener);
    }

    protected DarkComboBoxListener createComboBoxListener() {
        return new DarkComboBoxListener(this, this.comboBox);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removeMouseListener(this.comboBoxListener);
        this.comboBox.removePropertyChangeListener(this.comboBoxListener);
        this.comboBoxListener = null;
        this.comboBox.removePropertyChangeListener(this.visualPaddingListener);
        this.visualPaddingListener = null;
    }

    public JComboBox<?> getComboBox() {
        return this.comboBox;
    }

    public AbstractButton getArrowButton() {
        return this.arrowButton;
    }

    public boolean getHasFocus() {
        return this.hasFocus;
    }

    protected Insets getEditorInsets(JComponent c) {
        if (ComboBoxConstants.isTreeOrTableCellEditor(c)) {
            return this.editorCellInsets;
        }
        return this.valueInsets;
    }

    @Override
    protected ComboPopup createPopup() {
        return new DarkComboPopup(this.comboBox);
    }

    @Override
    protected ListCellRenderer<Object> createRenderer() {
        return new DarkDefaultListCellRenderer();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        ComboBoxEditor comboBoxEditor = super.createEditor();
        Component comp = comboBoxEditor.getEditorComponent();
        comp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                this.process(e);
            }

            private void process(KeyEvent e) {
                int code = e.getKeyCode();
                if ((code == 38 || code == 40) && e.getModifiersEx() == 0) {
                    DarkComboBoxUI.this.comboBox.dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.process(e);
            }
        });
        comp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DarkComboBoxUI.this.comboBox.revalidate();
                DarkComboBoxUI.this.comboBox.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                DarkComboBoxUI.this.comboBox.revalidate();
                DarkComboBoxUI.this.comboBox.repaint();
            }
        });
        return comboBoxEditor;
    }

    @Override
    protected JButton createArrowButton() {
        JButton button = ArrowButton.createUpDownArrow(this.comboBox, new ComboIcon(this.comboBox, UIManager.getIcon("ComboBox.arrowEditable.icon"), UIManager.getIcon("ComboBox.arrow.icon")), UIManager.getIcon("ComboBox.arrowInactive.icon"), 5, true, false, this.buttonPad);
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setCursor(Cursor.getPredefinedCursor(12));
        button.putClientProperty("consumeEventOnClose", true);
        return button;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (!this.comboBox.isEditable()) {
            Rectangle rect = this.rectangleForCurrentValue();
            Component currentValueRenderer = this.getRendererForCurrentValue();
            this.paintBackground(g, c, currentValueRenderer);
            this.paintCurrentValue(g, rect, this.hasFocus, currentValueRenderer);
        } else {
            this.paintBackground(g, c, this.getEditorComponent());
        }
    }

    private void paintBackground(Graphics g, JComponent c, Component currentValueRenderer) {
        Container parent = c.getParent();
        if (parent != null && parent.isOpaque() && !c.isEnabled()) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            return;
        }
        Color rendererBg = currentValueRenderer != null ? currentValueRenderer.getBackground() : null;
        Color bg = PropertyUtil.chooseColor((Color)rendererBg, (Color)this.getBackground(this.comboBox));
        Color splitBg = this.getArrowBackground(this.comboBox);
        Rectangle arrowRect = this.comboBox.isEditable() ? this.arrowButton.getBounds() : null;
        DividedWidgetPainter.paintBackground((Graphics2D)g, c, this.arcSize, arrowRect, bg, splitBg, ComboBoxConstants.getBorderType(c));
    }

    protected Color getBackground(JComponent c) {
        return c.getBackground();
    }

    protected void updateForeground(JComboBox<?> c) {
        Color color = this.foreground;
        if (!c.isEnabled()) {
            color = this.inactiveForeground;
        }
        if (c.isEditable()) {
            PropertyUtil.installForeground((Component)this.getEditorComponent(), (Color)color);
        }
        PropertyUtil.installForeground(c, (Color)color);
    }

    protected void updateBackground(JComboBox<?> c) {
        Color color = this.background;
        if (!c.isEnabled()) {
            color = this.inactiveBackground;
        } else if (c.isEditable()) {
            color = this.editBackground;
        }
        if (c.isEditable()) {
            PropertyUtil.installBackground((Component)this.getEditorComponent(), (Color)color);
        }
        PropertyUtil.installBackground(c, (Color)color);
    }

    protected Color getArrowBackground(JComboBox<?> c) {
        if (!c.isEnabled()) {
            return this.inactiveBackground;
        }
        if (c.isEditable()) {
            return this.arrowBackground;
        }
        return this.background;
    }

    private Color getForeground(Component c) {
        return c.getForeground();
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension size = super.getMinimumSize(c);
        Dimension editorSize = DarkUIUtil.getMinimumSize((JComponent)this.getEditorComponent());
        Insets ins = this.getInsets();
        DarkUIUtil.addInsets(size, ins);
        DarkUIUtil.addInsets(editorSize, ins);
        DarkUIUtil.addInsets(editorSize, this.getEditorInsets(this.comboBox));
        Insets bPad = this.buttonPad;
        Dimension abSize = this.arrowButton.getPreferredSize();
        size.width += bPad.left + bPad.right;
        editorSize.width += abSize.width;
        int width = Math.max(editorSize.width, size.width);
        int height = Math.max(editorSize.height, Math.max(abSize.height, size.height));
        return new Dimension(width, height);
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        Component editorComp;
        boolean ltr;
        Dimension rendererSize;
        Rectangle rect = new Rectangle(this.comboBox.getSize());
        Insets i = this.getInsets();
        DarkUIUtil.applyInsets(rect, i);
        Insets pad = this.getEditorInsets(this.comboBox);
        DarkUIUtil.applyInsets(rect, pad);
        Dimension dimension = rendererSize = !this.comboBox.isEditable() ? this.getDisplaySize() : this.getEditorComponent().getPreferredSize();
        if (rendererSize.height > rect.height) {
            if (this.comboBox.isEditable()) {
                ++i.top;
                ++i.bottom;
            }
            int extraInsets = pad.top + pad.bottom;
            int newHeight = Math.min(rect.height + extraInsets, rendererSize.height);
            rect.y = (int)((float)rect.y - (float)(newHeight - rect.height) * ((float)pad.top / (float)extraInsets));
            rect.y = Math.max(rect.y, i.top);
            rect.height = newHeight;
            rect.height = Math.min(rect.height, this.comboBox.getHeight() - i.top - i.bottom);
        }
        int extra = (ltr = this.comboBox.getComponentOrientation().isLeftToRight()) ? pad.right : pad.left;
        rect.width += extra;
        if (!ltr) {
            rect.x -= extra;
        }
        if (this.arrowButton != null) {
            int bw = this.arrowButton.getWidth();
            rect.width -= bw;
            if (!ltr) {
                rect.x += bw;
            }
        }
        if (!ltr && this.comboBox.isEditable() && (editorComp = this.getEditorComponent()) instanceof JTextComponent) {
            int caretWidth = DarkTextUI.getCaretWidth((JTextComponent)editorComp);
            rect.width += caretWidth;
        }
        return rect;
    }

    protected Component getRendererForCurrentValue() {
        return this.comboBox.getRenderer().getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus, Component c) {
        boolean changeOpaque;
        PropertyUtil.installFont((Component)c, (Font)this.comboBox.getFont());
        c.setFont(this.comboBox.getFont());
        if (this.comboBox.isEnabled() && hasFocus) {
            PropertyUtil.installForeground((Component)c, (Color)this.listBox.getForeground());
            PropertyUtil.installBackground((Component)c, (Color)this.listBox.getBackground());
        } else {
            PropertyUtil.installForeground((Component)c, (Color)this.getForeground(this.comboBox));
            PropertyUtil.installBackground((Component)c, (Color)this.getBackground(this.comboBox));
        }
        if (c instanceof JComponent) {
            PropertyUtil.installBorder((JComponent)((JComponent)c), null);
        }
        boolean bl = changeOpaque = c instanceof JComponent && c.isOpaque() && (!this.comboBox.isEnabled() || ComboBoxConstants.isTreeOrTableCellEditor(this.comboBox));
        if (changeOpaque) {
            ((JComponent)c).setOpaque(false);
        }
        Rectangle r = new Rectangle(bounds);
        this.currentValuePane.paintComponent(g, c, this.comboBox, r.x, r.y, r.width, r.height, c instanceof JPanel);
        if (changeOpaque) {
            ((JComponent)c).setOpaque(true);
        }
    }

    public void checkFocus() {
        this.hasFocus = DarkUIUtil.hasFocus(this.comboBox);
        if (this.hasFocus) {
            return;
        }
        this.editor = this.getEditorComponent();
        if (this.editor != null) {
            this.hasFocus = DarkUIUtil.hasFocus(this.editor);
        }
    }

    public void resetPopup() {
        ((DarkComboPopup)this.popup).reset();
    }
}

