/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.menu;

import com.github.weisj.darklaf.compatibility.MenuItemLayoutHelper;
import com.github.weisj.darklaf.compatibility.SwingUtil;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.util.StringUtil;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public interface MenuItemUI {
    public MenuItemLayoutHelper getMenuItemLayoutHelper(Icon var1, Icon var2, int var3, JMenuItem var4, Rectangle var5);

    public String getPropertyPrefix();

    default public Color getForeground(JMenuItem item) {
        boolean armed;
        boolean enabled = item.isEnabled();
        boolean bl = armed = item.isArmed() || item instanceof JMenu && item.isSelected() || item.isRolloverEnabled() && item.getModel().isRollover();
        if (enabled) {
            return armed ? this.getSelectionForeground() : item.getForeground();
        }
        return this.getDisabledForeground();
    }

    public Color getDisabledForeground();

    public Color getSelectionForeground();

    public Color getAcceleratorSelectionForeground();

    public Color getAcceleratorForeground();

    default public Color getBackground(JMenuItem item) {
        boolean armed;
        boolean enabled = item.isEnabled();
        boolean bl = armed = item.isArmed() || item instanceof JMenu && item.isSelected();
        if (enabled) {
            return armed ? this.getSelectionBackground() : item.getBackground();
        }
        return this.getDisabledBackground();
    }

    public Color getSelectionBackground();

    public Color getDisabledBackground();

    public int getAcceleratorTextOffset();

    public boolean isUseEvenHeight();

    default public void paintMenuItemImpl(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        GraphicsContext context = new GraphicsContext(g);
        JMenuItem mi = (JMenuItem)c;
        g.setFont(mi.getFont());
        Rectangle viewRect = new Rectangle(0, 0, mi.getWidth(), mi.getHeight());
        DarkUIUtil.applyInsets(viewRect, mi.getInsets());
        MenuItemLayoutHelper lh = this.getMenuItemLayoutHelper(checkIcon, arrowIcon, defaultTextIconGap, mi, viewRect);
        MenuItemLayoutHelper.MILayoutResult lr = lh.layoutMenuItem();
        Color background = this.getBackground(mi);
        Color foreground = this.getForeground(mi);
        this.paintBackgroundImpl(g, mi, background);
        context.restore();
        this.paintCheckIcon(g, mi, lh, lr, foreground);
        context.restore();
        this.paintIcon(g, mi, lh, lr);
        g.setColor(foreground);
        this.paintText(g, mi, lh, lr);
        this.paintAccText(g, mi, lh, lr);
        this.paintArrowIcon(g, mi, lh, lr, foreground);
        context.restore();
    }

    default public void paintBackgroundImpl(Graphics g, JMenuItem menuItem, Color bgColor) {
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight() + 1;
        boolean armed = menuItem.isArmed() || menuItem instanceof JMenu && menuItem.isSelected() || menuItem.isRolloverEnabled() && menuItem.getModel().isRollover();
        boolean parentOpaque = menuItem.getParent().isOpaque();
        if (armed || menuItem.isOpaque() && parentOpaque) {
            g.setColor(bgColor);
            g.fillRect(0, 0, menuWidth, menuHeight);
        }
    }

    default public void paintCheckIcon(Graphics g, JMenuItem mi, MenuItemLayoutHelper lh, MenuItemLayoutHelper.MILayoutResult lr, Color foreground) {
        if (lh.getCheckIcon() != null) {
            ButtonModel model = mi.getModel();
            if (model.isArmed() || mi instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            }
            if (lh.useCheckAndArrow()) {
                lh.getCheckIcon().paintIcon(mi, g, lr.getCheckRect().x, lr.getCheckRect().y);
            }
        }
    }

    default public void paintIcon(Graphics g, JMenuItem mi, MenuItemLayoutHelper lh, MenuItemLayoutHelper.MILayoutResult lr) {
        if (lh.getIcon() != null) {
            Icon icon;
            ButtonModel model = mi.getModel();
            if (!model.isEnabled()) {
                icon = mi.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = mi.getPressedIcon();
                if (icon == null) {
                    icon = mi.getIcon();
                }
            } else {
                icon = mi.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(mi, g, lr.getIconRect().x, lr.getIconRect().y);
            }
        }
    }

    default public void paintText(Graphics g, JMenuItem mi, MenuItemLayoutHelper lh, MenuItemLayoutHelper.MILayoutResult lr) {
        GraphicsContext config = GraphicsUtil.setupAntialiasing((Graphics)g);
        if (!StringUtil.isBlank((String)lh.getText())) {
            if (lh.getHtmlView() != null) {
                lh.getHtmlView().paint(g, lr.getTextRect());
            } else {
                this.paintItemText(g, mi, lr.getTextRect(), lh.getText());
            }
        }
        config.restore();
    }

    default public void paintItemText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = SwingUtil.getFontMetrics((JComponent)menuItem, (Graphics)g);
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        if (!model.isEnabled() || !menuItem.isEnabled()) {
            g.setColor(this.getDisabledForeground());
        } else if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
            g.setColor(this.getSelectionForeground());
        }
        SwingUtil.drawStringUnderlineCharAt((JComponent)menuItem, (Graphics)g, (String)text, (int)mnemIndex, (int)textRect.x, (int)(textRect.y + fm.getAscent()));
    }

    default public void paintAccText(Graphics g, JMenuItem mi, MenuItemLayoutHelper lh, MenuItemLayoutHelper.MILayoutResult lr) {
        GraphicsContext config = GraphicsUtil.setupAntialiasing((Graphics)g);
        MenuItemUI.rightAlignAccText(lh, lr);
        if (!StringUtil.isBlank((String)lh.getAccText())) {
            g.setFont(lh.getAccFontMetrics().getFont());
            g.setColor(this.getAcceleratorForeground(mi));
            SwingUtil.drawString((JComponent)mi, (Graphics)g, (String)lh.getAccText(), (int)lr.getAccRect().x, (int)(lr.getAccRect().y + lh.getAccFontMetrics().getAscent()));
        }
        config.restore();
    }

    default public Color getAcceleratorForeground(AbstractButton b) {
        ButtonModel model = b.getModel();
        if (!model.isEnabled() || !b.isEnabled()) {
            return this.getDisabledForeground();
        }
        if (model.isArmed() || b instanceof JMenu && model.isSelected()) {
            return this.getAcceleratorSelectionForeground();
        }
        return this.getAcceleratorForeground();
    }

    public static void rightAlignAccText(MenuItemLayoutHelper lh, MenuItemLayoutHelper.MILayoutResult lr) {
        Rectangle accRect = lr.getAccRect();
        ButtonModel model = lh.getMenuItem().getModel();
        if (model.isEnabled()) {
            accRect.x = lh.getViewRect().x + lh.getViewRect().width - lh.getMenuItem().getIconTextGap() - lr.getAccRect().width;
        }
    }

    default public void paintArrowIcon(Graphics g, JMenuItem mi, MenuItemLayoutHelper lh, MenuItemLayoutHelper.MILayoutResult lr, Color foreground) {
        if (lh.getArrowIcon() != null) {
            ButtonModel model = mi.getModel();
            if (model.isArmed() || mi instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            }
            if (lh.useCheckAndArrow()) {
                lh.getArrowIcon().paintIcon(mi, g, lr.getArrowRect().x, lr.getArrowRect().y);
            }
        }
    }

    default public Dimension getPreferredMenuItemSizeImpl(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        JMenuItem mi = (JMenuItem)c;
        MenuItemLayoutHelper lh = this.getMenuItemLayoutHelper(checkIcon, arrowIcon, defaultTextIconGap, mi, MenuItemLayoutHelper.createMaxRect());
        Dimension result = new Dimension();
        result.width = lh.getLeadingGap();
        MenuItemLayoutHelper.addMaxWidth((MenuItemLayoutHelper.MIRectSize)lh.getCheckSize(), (int)lh.getAfterCheckIconGap(), (Dimension)result);
        if (!lh.isTopLevelMenu() && lh.getMinTextOffset() > 0) {
            result.width = Math.max(lh.getMinTextOffset(), result.width);
        }
        int acceleratorTextOffset = this.getAcceleratorTextOffset();
        MenuItemLayoutHelper.addMaxWidth((MenuItemLayoutHelper.MIRectSize)lh.getLabelSize(), (int)0, (Dimension)result);
        MenuItemLayoutHelper.addMaxWidth((MenuItemLayoutHelper.MIRectSize)lh.getAccSize(), (int)acceleratorTextOffset, (Dimension)result);
        MenuItemLayoutHelper.addMaxWidth((MenuItemLayoutHelper.MIRectSize)lh.getArrowSize(), (int)lh.getGap(), (Dimension)result);
        if (lh.isTopLevelMenu()) {
            result.width += lh.getLeadingGap();
        }
        result.height = Integer.MIN_VALUE;
        result.height = Math.max(result.height, lh.getCheckSize().getHeight());
        result.height = Math.max(result.height, lh.getLabelSize().getHeight());
        result.height = Math.max(result.height, lh.getAccSize().getHeight());
        result.height = Math.max(result.height, lh.getArrowSize().getHeight());
        Insets insets = mi.getInsets();
        if (insets != null) {
            result.width += insets.left + insets.right;
            result.height += insets.top + insets.bottom;
        }
        if (result.height % 2 == 0 && this.isUseEvenHeight()) {
            ++result.height;
        }
        return result;
    }
}

