/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.rootpane;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.nativelaf.DecorationsHandler;
import com.github.weisj.darklaf.platform.decorations.AbstractNativeDecorationsRootPaneUI;
import com.github.weisj.darklaf.platform.decorations.NativeDecorationsManager;
import com.github.weisj.darklaf.util.PropertyUtil;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;

public class DarkRootPaneUI
extends AbstractNativeDecorationsRootPaneUI {
    private static final String[] borderKeys = new String[]{"RootPane.border", "RootPane.frameBorder"};

    public DarkRootPaneUI() {
        super((NativeDecorationsManager)DecorationsHandler.getSharedInstance());
    }

    public static ComponentUI createUI(JComponent comp) {
        return new DarkRootPaneUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.installBorder((JRootPane)c);
    }

    protected void installDefaults(JRootPane c) {
        super.installDefaults(c);
        PropertyUtil.installBooleanProperty((JComponent)c, (String)"JRootPane.unifiedMenuBar", (String)"TitlePane.unifiedMenuBar");
        PropertyUtil.installBooleanProperty((JComponent)c, (String)"JRootPane.coloredTitleBar", (String)"macos.coloredTitleBar");
        LookAndFeel.installColors(c, "RootPane.background", "RootPane.foreground");
    }

    protected void installBorder(JRootPane root) {
        if (root == null) {
            return;
        }
        LookAndFeel.installBorder(root, borderKeys[Math.max(Math.min(1, this.windowDecorationsStyle), 0)]);
    }

    private static void uninstallBorder(JRootPane root) {
        LookAndFeel.uninstallBorder(root);
    }

    protected void onDecorationsUninstall(JRootPane rootPane) {
        DarkRootPaneUI.uninstallBorder(rootPane);
    }

    protected void onDecorationsInstall(JRootPane rootPane) {
        this.installBorder(rootPane);
    }

    protected boolean shouldRemoveDecorations() {
        return !LafManager.isInstalled() || !LafManager.isDecorationsEnabled();
    }
}

