/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.splitpane;

import com.github.weisj.darklaf.properties.icons.EmptyIcon;
import com.github.weisj.darklaf.ui.splitpane.DarkSplitPaneDividerPainter;
import com.github.weisj.darklaf.ui.splitpane.DarkSplitPaneUI;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

public class DarkSplitPaneDivider
extends BasicSplitPaneDivider {
    protected final Icon leftOneTouch;
    protected final Icon rightOneTouch;
    protected final Icon topOneTouch;
    protected final Icon bottomOneTouch;
    private final DarkSplitPaneDividerPainter dividerPainter;

    public DarkSplitPaneDivider(DarkSplitPaneUI ui) {
        super(ui);
        this.dividerPainter = this.createPainter(ui);
        this.leftOneTouch = UIManager.getIcon("SplitPaneDivider.leftOneTouch.icon");
        this.rightOneTouch = UIManager.getIcon("SplitPaneDivider.rightOneTouch.icon");
        this.topOneTouch = UIManager.getIcon("SplitPaneDivider.topOneTouch.icon");
        this.bottomOneTouch = UIManager.getIcon("SplitPaneDivider.bottomOneTouch.icon");
    }

    protected DarkSplitPaneDividerPainter createPainter(DarkSplitPaneUI ui) {
        return new DarkSplitPaneDividerPainter(ui);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.dividerPainter.paint(this, g, 0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        return new OneTouchLeftButton();
    }

    @Override
    protected JButton createRightOneTouchButton() {
        return new OneTouchRightButton();
    }

    protected Icon getLeftOneTouchIcon() {
        return this.leftOneTouch;
    }

    protected Icon getRightOneTouchIcon() {
        return this.rightOneTouch;
    }

    protected Icon getTopOneTouchIcon() {
        return this.topOneTouch;
    }

    protected Icon getBottomOneTouchIcon() {
        return this.bottomOneTouch;
    }

    protected class OneTouchLeftButton
    extends OneTouchButton {
        protected OneTouchLeftButton() {
        }

        @Override
        public Icon getIcon() {
            if (DarkSplitPaneDivider.this.splitPane != null) {
                return DarkSplitPaneDivider.this.splitPane.getOrientation() == 1 ? DarkSplitPaneDivider.this.getLeftOneTouchIcon() : DarkSplitPaneDivider.this.getTopOneTouchIcon();
            }
            return EmptyIcon.create((int)0);
        }
    }

    protected class OneTouchRightButton
    extends OneTouchButton {
        protected OneTouchRightButton() {
        }

        @Override
        public Icon getIcon() {
            if (DarkSplitPaneDivider.this.splitPane != null) {
                return DarkSplitPaneDivider.this.splitPane.getOrientation() == 1 ? DarkSplitPaneDivider.this.getRightOneTouchIcon() : DarkSplitPaneDivider.this.getBottomOneTouchIcon();
            }
            return EmptyIcon.create((int)0);
        }
    }

    protected static class OneTouchButton
    extends JButton
    implements UIResource {
        protected OneTouchButton() {
            this.setMinimumSize(new Dimension(6, 6));
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setContentAreaFilled(false);
            this.setRequestFocusEnabled(false);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public Icon getPressedIcon() {
            return this.getIcon();
        }

        @Override
        public Icon getDisabledIcon() {
            return this.getIcon();
        }
    }
}

