/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabbedpane;

import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUI;
import com.github.weisj.darklaf.ui.tabbedpane.TabbedPaneLayout;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class DarkTabbedPaneLayout
extends TabbedPaneLayout {
    private final DarkTabbedPaneUI tabbedPaneUI;

    public DarkTabbedPaneLayout(DarkTabbedPaneUI tabbedPaneUI) {
        super(tabbedPaneUI);
        this.tabbedPaneUI = tabbedPaneUI;
    }

    @Override
    protected void centerTabs(int tabPlacement, int tabCount, int returnAt) {
        block4: {
            if (this.tabbedPaneUI.runCount != 1 || !PropertyUtil.getBooleanProperty((JComponent)this.tabbedPaneUI.tabPane, (String)"JTabbedPane.centerTabs")) break block4;
            if (this.tabbedPaneUI.isHorizontalTabPlacement()) {
                int shift = (returnAt - (this.tabbedPaneUI.rects[tabCount - 1].x + this.tabbedPaneUI.rects[tabCount - 1].width)) / 2;
                for (int i = 0; i < tabCount; ++i) {
                    this.tabbedPaneUI.rects[i].x += shift;
                }
            } else {
                int shift = (returnAt - (this.tabbedPaneUI.rects[tabCount - 1].y + this.tabbedPaneUI.rects[tabCount - 1].height)) / 2;
                for (int i = 0; i < tabCount; ++i) {
                    this.tabbedPaneUI.rects[i].y += shift;
                }
            }
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        int tabPlacement = this.tabbedPaneUI.tabPane.getTabPlacement();
        Insets insets = this.tabbedPaneUI.tabPane.getInsets();
        Insets tabAreaInsets = this.tabbedPaneUI.getTabAreaInsets(tabPlacement);
        int selectedIndex = this.tabbedPaneUI.tabPane.getSelectedIndex();
        Component visibleComponent = this.tabbedPaneUI.getVisibleComponent();
        this.calculateLayoutInfo();
        Component selectedComponent = null;
        if (selectedIndex < 0) {
            if (visibleComponent != null) {
                this.tabbedPaneUI.setVisibleComponent(null);
            }
        } else {
            selectedComponent = this.tabbedPaneUI.tabPane.getComponentAt(selectedIndex);
        }
        Insets contentInsets = this.tabbedPaneUI.getContentBorderInsets(tabPlacement);
        boolean shouldChangeFocus = false;
        if (selectedComponent != null) {
            Component owner;
            if (selectedComponent != visibleComponent && visibleComponent != null && (owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && SwingUtilities.isDescendingFrom(owner, visibleComponent)) {
                shouldChangeFocus = true;
            }
            this.tabbedPaneUI.setVisibleComponent(selectedComponent);
        }
        Rectangle bounds = this.tabbedPaneUI.tabPane.getBounds();
        int numChildren = this.tabbedPaneUI.tabPane.getComponentCount();
        if (numChildren > 0) {
            int ch;
            int cw;
            int cy;
            int cx;
            int th;
            int ty;
            int tx;
            int tw;
            switch (tabPlacement) {
                case 2: {
                    tw = this.tabbedPaneUI.calculateTabAreaWidth(tabPlacement, this.tabbedPaneUI.runCount, this.tabbedPaneUI.maxTabWidth);
                    tx = insets.left + tabAreaInsets.left;
                    ty = insets.top + tabAreaInsets.top;
                    th = bounds.height - insets.top - tabAreaInsets.top - insets.bottom - tabAreaInsets.bottom;
                    cx = insets.left + tw + contentInsets.left + tabAreaInsets.left + tabAreaInsets.right;
                    cy = insets.top + contentInsets.top;
                    cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right - tw - tabAreaInsets.left - tabAreaInsets.right;
                    ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                    break;
                }
                case 4: {
                    tw = this.tabbedPaneUI.calculateTabAreaWidth(tabPlacement, this.tabbedPaneUI.runCount, this.tabbedPaneUI.maxTabWidth);
                    tx = bounds.width - insets.left - tw - tabAreaInsets.right - tabAreaInsets.left;
                    ty = insets.top + tabAreaInsets.top;
                    th = bounds.height - insets.top - tabAreaInsets.top - insets.bottom - tabAreaInsets.bottom;
                    cx = insets.left + contentInsets.left;
                    cy = insets.top + contentInsets.top;
                    cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right - tw - tabAreaInsets.left - tabAreaInsets.right;
                    ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                    break;
                }
                case 3: {
                    th = this.tabbedPaneUI.calculateTabAreaHeight(tabPlacement, this.tabbedPaneUI.runCount, this.tabbedPaneUI.maxTabHeight);
                    ty = bounds.height - insets.bottom - th;
                    tx = insets.left + tabAreaInsets.left;
                    tw = bounds.width - insets.left - insets.right - tabAreaInsets.left - tabAreaInsets.right;
                    cx = insets.left + contentInsets.left;
                    cy = insets.top + contentInsets.top;
                    cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                    ch = bounds.height - th - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                    break;
                }
                default: {
                    ty = insets.top + tabAreaInsets.top;
                    tx = insets.left + tabAreaInsets.left;
                    tw = bounds.width - insets.left - insets.right - tabAreaInsets.left - tabAreaInsets.right;
                    th = this.tabbedPaneUI.calculateTabAreaHeight(tabPlacement, this.tabbedPaneUI.runCount, this.tabbedPaneUI.maxTabHeight);
                    cx = insets.left + contentInsets.left;
                    cy = insets.top + th + contentInsets.top + tabAreaInsets.top + tabAreaInsets.bottom;
                    cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                    ch = bounds.height - th - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom - tabAreaInsets.top - tabAreaInsets.bottom;
                }
            }
            this.tabbedPaneUI.tabAreaBounds.setRect(tx, ty, tw, th);
            for (int i = 0; i < numChildren; ++i) {
                Component child = this.tabbedPaneUI.tabPane.getComponent(i);
                if (child == this.tabbedPaneUI.tabContainer) {
                    child.setBounds(tx, ty, tw, th);
                    continue;
                }
                int tabHeight = this.tabbedPaneUI.maxTabHeight + tabAreaInsets.top + tabAreaInsets.bottom;
                int tabWidth = this.tabbedPaneUI.maxTabWidth + tabAreaInsets.left + tabAreaInsets.right;
                int compHeight = ch;
                int compY = cy;
                if (this.tabbedPaneUI.northComp != null) {
                    int nh = this.tabbedPaneUI.northComp.getPreferredSize().height;
                    compY -= nh;
                    compHeight += nh;
                }
                if (this.tabbedPaneUI.southComp != null) {
                    compHeight += this.tabbedPaneUI.southComp.getPreferredSize().height;
                }
                if (child == this.tabbedPaneUI.leadingComp && this.tabbedPaneUI.leadingComp != null) {
                    this.tabbedPaneUI.layoutLeadingComponent(child, tabWidth, tabHeight, insets, tx, ty, tabPlacement);
                    continue;
                }
                if (child == this.tabbedPaneUI.trailingComp && this.tabbedPaneUI.trailingComp != null) {
                    this.tabbedPaneUI.layoutTrailingComponent(child, tabWidth, tabHeight, insets, tx, ty, tw, th, tabPlacement);
                    continue;
                }
                if (child == this.tabbedPaneUI.northComp && this.tabbedPaneUI.northComp != null) {
                    this.tabbedPaneUI.northComp.setBounds(cx, cy - this.tabbedPaneUI.northComp.getPreferredSize().height, cw, this.tabbedPaneUI.northComp.getPreferredSize().height);
                    continue;
                }
                if (child == this.tabbedPaneUI.southComp && this.tabbedPaneUI.southComp != null) {
                    this.tabbedPaneUI.southComp.setBounds(cx, cy + ch, cw, this.tabbedPaneUI.southComp.getPreferredSize().height);
                    continue;
                }
                if (child == this.tabbedPaneUI.eastComp && this.tabbedPaneUI.eastComp != null) {
                    this.tabbedPaneUI.eastComp.setBounds(cx + cw, compY, this.tabbedPaneUI.eastComp.getPreferredSize().width, compHeight);
                    continue;
                }
                if (child == this.tabbedPaneUI.westComp && this.tabbedPaneUI.westComp != null) {
                    this.tabbedPaneUI.westComp.setBounds(cx - this.tabbedPaneUI.westComp.getPreferredSize().width, compY, this.tabbedPaneUI.westComp.getPreferredSize().width, compHeight);
                    continue;
                }
                child.setBounds(cx, cy, cw, ch);
            }
        }
        this.layoutTabComponents();
        if (shouldChangeFocus && !this.tabbedPaneUI.requestFocusForVisibleComponent()) {
            this.tabbedPaneUI.tabPane.requestFocusInWindow();
        }
    }

    @Override
    protected void layoutTabComponents() {
        this.tabbedPaneUI.layoutTabComponents();
    }
}

