/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabbedpane;

import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUI;
import com.github.weisj.darklaf.ui.tabbedpane.TabButtonContainer;
import com.github.weisj.darklaf.ui.tabbedpane.TabbedPaneScrollLayout;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class DarkTabbedPaneScrollLayout
extends TabbedPaneScrollLayout {
    private final DarkTabbedPaneUI tabbedPaneUI;

    public DarkTabbedPaneScrollLayout(DarkTabbedPaneUI tabbedPaneUI) {
        super(tabbedPaneUI);
        this.tabbedPaneUI = tabbedPaneUI;
    }

    @Override
    public void layoutContainer(Container parent) {
        int tabPlacement = this.tabbedPaneUI.tabPane.getTabPlacement();
        Insets insets = this.tabbedPaneUI.tabPane.getInsets();
        Insets tabAreaInsets = this.tabbedPaneUI.getTabAreaInsets(tabPlacement);
        int selectedIndex = this.tabbedPaneUI.tabPane.getSelectedIndex();
        Component visibleComponent = this.tabbedPaneUI.getVisibleComponent();
        this.calculateLayoutInfo();
        Component selectedComponent = null;
        if (selectedIndex < 0) {
            if (visibleComponent != null) {
                this.tabbedPaneUI.setVisibleComponent(null);
            }
        } else {
            selectedComponent = this.tabbedPaneUI.tabPane.getComponentAt(selectedIndex);
        }
        if (this.tabbedPaneUI.tabPane.getTabCount() == 0) {
            this.tabbedPaneUI.scrollableTabSupport.hideMoreTabsButton();
            return;
        }
        boolean shouldChangeFocus = false;
        if (selectedComponent != null) {
            Component owner;
            if (selectedComponent != visibleComponent && visibleComponent != null && (owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && SwingUtilities.isDescendingFrom(owner, visibleComponent)) {
                shouldChangeFocus = true;
            }
            this.tabbedPaneUI.setVisibleComponent(selectedComponent);
        }
        Insets contentInsets = this.tabbedPaneUI.getContentBorderInsets(tabPlacement);
        Rectangle bounds = this.tabbedPaneUI.tabPane.getBounds();
        int numChildren = this.tabbedPaneUI.tabPane.getComponentCount();
        if (numChildren > 0) {
            int ch;
            int cw;
            int cy;
            int cx;
            int ty;
            int tx;
            int th;
            int tw;
            switch (tabPlacement) {
                case 2: {
                    tw = this.tabbedPaneUI.calculateTabAreaWidth(tabPlacement, this.tabbedPaneUI.runCount, this.tabbedPaneUI.maxTabWidth);
                    th = bounds.height - insets.top - insets.bottom - tabAreaInsets.top - tabAreaInsets.bottom;
                    tx = insets.left + tabAreaInsets.left;
                    ty = insets.top + tabAreaInsets.top;
                    cx = insets.left + tw + contentInsets.left + tabAreaInsets.left + tabAreaInsets.right;
                    cy = insets.top + contentInsets.top;
                    cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right - tabAreaInsets.left - tabAreaInsets.right;
                    ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                    tw -= tabAreaInsets.left + tabAreaInsets.right;
                    break;
                }
                case 4: {
                    tw = this.tabbedPaneUI.calculateTabAreaWidth(tabPlacement, this.tabbedPaneUI.runCount, this.tabbedPaneUI.maxTabWidth);
                    th = bounds.height - insets.top - insets.bottom - tabAreaInsets.top - tabAreaInsets.bottom;
                    tx = bounds.width - insets.right - tw + tabAreaInsets.left;
                    ty = insets.top + tabAreaInsets.top;
                    cx = insets.left + contentInsets.left;
                    cy = insets.top + contentInsets.top;
                    cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                    ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                    tw -= tabAreaInsets.left + tabAreaInsets.right;
                    break;
                }
                case 3: {
                    tw = bounds.width - insets.left - insets.right - tabAreaInsets.left - tabAreaInsets.right;
                    th = this.tabbedPaneUI.calculateTabAreaHeight(tabPlacement, this.tabbedPaneUI.runCount, this.tabbedPaneUI.maxTabHeight);
                    tx = insets.left + tabAreaInsets.left;
                    ty = bounds.height - insets.bottom - th + tabAreaInsets.top;
                    cx = insets.left + contentInsets.left;
                    cy = insets.top + contentInsets.top;
                    cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                    ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                    th -= tabAreaInsets.top + tabAreaInsets.bottom;
                    break;
                }
                default: {
                    tw = bounds.width - insets.left - insets.right - tabAreaInsets.left - tabAreaInsets.right;
                    th = this.tabbedPaneUI.calculateTabAreaHeight(tabPlacement, this.tabbedPaneUI.runCount, this.tabbedPaneUI.maxTabHeight);
                    tx = insets.left + tabAreaInsets.left;
                    ty = insets.top + tabAreaInsets.top;
                    cx = insets.left + contentInsets.left;
                    cy = insets.top + th + contentInsets.top;
                    cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                    ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                    th -= tabAreaInsets.top + tabAreaInsets.bottom;
                }
            }
            TabButtonContainer moreTabs = this.tabbedPaneUI.scrollableTabSupport.moreTabsButton;
            TabButtonContainer newTab = this.tabbedPaneUI.scrollableTabSupport.newTabButton;
            for (int i = 0; i < numChildren; ++i) {
                Component child = this.tabbedPaneUI.tabPane.getComponent(i);
                if (this.tabbedPaneUI.tabScroller != null && child == this.tabbedPaneUI.tabScroller.viewport) {
                    int vw = tw;
                    int vh = th;
                    Dimension butSize = moreTabs.isVisible() ? ((JComponent)moreTabs).getPreferredSize() : new Dimension(0, 0);
                    boolean showNewTabButton = newTab.isVisible() && newTab.getParent() == this.tabbedPaneUI.tabPane;
                    Dimension butSize2 = showNewTabButton ? ((JComponent)newTab).getPreferredSize() : new Dimension(0, 0);
                    boolean leftToRight = this.tabbedPaneUI.tabPane.getComponentOrientation().isLeftToRight();
                    if (tabPlacement == 2 || tabPlacement == 4) {
                        vh = th - butSize.height - butSize2.height;
                        ((Component)moreTabs).setBounds(tx, ty + vh + butSize2.height, this.tabbedPaneUI.maxTabWidth, butSize.height);
                        if (showNewTabButton) {
                            ((Component)newTab).setBounds(tx, ty + vh, this.tabbedPaneUI.maxTabWidth, butSize2.height);
                        }
                    } else if (leftToRight) {
                        vw = tw - butSize.width - butSize2.width;
                        ((Component)moreTabs).setBounds(tx + vw + butSize2.width, ty, butSize.width, this.tabbedPaneUI.maxTabHeight);
                        if (showNewTabButton) {
                            ((Component)newTab).setBounds(tx + vw, ty, butSize2.width, this.tabbedPaneUI.maxTabHeight);
                        }
                    } else {
                        vw = tw - butSize.width - butSize2.width;
                        ((Component)moreTabs).setBounds(tx, ty, butSize.width, this.tabbedPaneUI.maxTabHeight);
                        if (showNewTabButton) {
                            ((Component)newTab).setBounds(tx + butSize.width, ty, butSize2.width, this.tabbedPaneUI.maxTabHeight);
                        }
                        tx += butSize.width + butSize2.width;
                    }
                    child.setBounds(tx, ty, vw, vh);
                    continue;
                }
                int tabHeight = this.tabbedPaneUI.maxTabHeight + tabAreaInsets.top + tabAreaInsets.bottom;
                int tabWidth = this.tabbedPaneUI.maxTabWidth + tabAreaInsets.left + tabAreaInsets.right;
                int compHeight = ch;
                int compY = cy;
                if (this.tabbedPaneUI.northComp != null) {
                    int nh = this.tabbedPaneUI.northComp.getPreferredSize().height;
                    compY -= nh;
                    compHeight += nh;
                }
                if (this.tabbedPaneUI.southComp != null) {
                    compHeight += this.tabbedPaneUI.southComp.getPreferredSize().height;
                }
                if (child == this.tabbedPaneUI.leadingComp && this.tabbedPaneUI.leadingComp != null) {
                    this.tabbedPaneUI.layoutLeadingComponent(child, tabWidth, tabHeight, insets, tx, ty, tabPlacement);
                    continue;
                }
                if (child == this.tabbedPaneUI.trailingComp && this.tabbedPaneUI.trailingComp != null) {
                    this.tabbedPaneUI.layoutTrailingComponent(child, tabWidth, tabHeight, insets, tx, ty, tw, th, tabPlacement);
                    continue;
                }
                if (child == this.tabbedPaneUI.northComp && this.tabbedPaneUI.northComp != null) {
                    this.tabbedPaneUI.northComp.setBounds(cx, cy - this.tabbedPaneUI.northComp.getPreferredSize().height, cw, this.tabbedPaneUI.northComp.getPreferredSize().height);
                    continue;
                }
                if (child == this.tabbedPaneUI.southComp && this.tabbedPaneUI.southComp != null) {
                    this.tabbedPaneUI.southComp.setBounds(cx, cy + ch, cw, this.tabbedPaneUI.southComp.getPreferredSize().height);
                    continue;
                }
                if (child == this.tabbedPaneUI.eastComp && this.tabbedPaneUI.eastComp != null) {
                    this.tabbedPaneUI.eastComp.setBounds(cx + cw, compY, this.tabbedPaneUI.eastComp.getPreferredSize().width, compHeight);
                    continue;
                }
                if (child == this.tabbedPaneUI.westComp && this.tabbedPaneUI.westComp != null) {
                    this.tabbedPaneUI.westComp.setBounds(cx - this.tabbedPaneUI.westComp.getPreferredSize().width, compY, this.tabbedPaneUI.westComp.getPreferredSize().width, compHeight);
                    continue;
                }
                if (child == moreTabs || child == newTab || child == null) continue;
                child.setBounds(cx, cy, cw, ch);
            }
            this.layoutTabComponents();
            if (shouldChangeFocus && !this.tabbedPaneUI.requestFocusForVisibleComponent()) {
                this.tabbedPaneUI.tabPane.requestFocusInWindow();
            }
        }
    }

    @Override
    protected void layoutTabComponents() {
        this.tabbedPaneUI.layoutTabComponents();
    }

    @Override
    protected Dimension calculateSize(boolean minimum) {
        int tabPlacement = this.tabbedPaneUI.tabPane.getTabPlacement();
        Insets insets = this.tabbedPaneUI.tabPane.getInsets();
        Insets contentInsets = this.tabbedPaneUI.getContentBorderInsets(tabPlacement);
        Insets tabAreaInsets = this.tabbedPaneUI.getTabAreaInsets(tabPlacement);
        int height = 0;
        int width = 0;
        int cWidth = 0;
        int cHeight = 0;
        for (int i = 0; i < this.tabbedPaneUI.tabPane.getTabCount(); ++i) {
            Dimension size;
            Component component = this.tabbedPaneUI.tabPane.getComponentAt(i);
            if (component == null) continue;
            Dimension dimension = size = minimum ? component.getMinimumSize() : component.getPreferredSize();
            if (size == null) continue;
            cHeight = Math.max(size.height, cHeight);
            cWidth = Math.max(size.width, cWidth);
        }
        width += cWidth;
        height += cHeight;
        if (this.tabbedPaneUI.tabPane.getTabCount() > 0) {
            int tabExtent;
            if (!this.tabbedPaneUI.isHorizontalTabPlacement()) {
                int tabHeight = this.tabbedPaneUI.calculateTabHeight(tabPlacement, this.tabbedPaneUI.tabPane.getSelectedIndex(), this.tabbedPaneUI.getFontMetrics().getHeight());
                if (this.tabbedPaneUI.scrollableTabSupport.moreTabsButton.isVisible()) {
                    tabHeight += this.tabbedPaneUI.scrollableTabSupport.moreTabsButton.getPreferredSize().height;
                }
                height = Math.max(height, tabHeight);
                tabExtent = this.preferredTabAreaWidth(tabPlacement, height - tabAreaInsets.top - tabAreaInsets.bottom);
                width += tabExtent;
            } else {
                int tabWidth = this.tabbedPaneUI.calculateTabWidth(tabPlacement, this.tabbedPaneUI.tabPane.getSelectedIndex(), this.tabbedPaneUI.getFontMetrics());
                if (this.tabbedPaneUI.scrollableTabSupport.moreTabsButton.isVisible()) {
                    tabWidth += this.tabbedPaneUI.scrollableTabSupport.moreTabsButton.getPreferredSize().width;
                }
                width = Math.max(width, tabWidth);
                tabExtent = this.preferredTabAreaHeight(tabPlacement, width - tabAreaInsets.left - tabAreaInsets.right);
                height += tabExtent;
            }
        }
        return new Dimension(width + insets.left + insets.right + contentInsets.left + contentInsets.right, height + insets.bottom + insets.top + contentInsets.top + contentInsets.bottom);
    }

    @Override
    protected void calculateTabRects(int tabPlacement, int tabCount) {
        Rectangle selectedBounds;
        if (this.tabbedPaneUI.scrollShiftX != 0 || this.tabbedPaneUI.scrollShiftY != 0) {
            return;
        }
        FontMetrics metrics = this.tabbedPaneUI.getFontMetrics();
        Dimension size = this.tabbedPaneUI.tabPane.getSize();
        Insets insets = this.tabbedPaneUI.tabPane.getInsets();
        Insets tabAreaInsets = this.tabbedPaneUI.getTabAreaInsets(tabPlacement);
        boolean verticalTabRuns = !this.tabbedPaneUI.isHorizontalTabPlacement();
        boolean leftToRight = this.tabbedPaneUI.tabPane.getComponentOrientation().isLeftToRight();
        if (!this.tabbedPaneUI.isHorizontalTabPlacement()) {
            this.tabbedPaneUI.maxTabWidth = this.tabbedPaneUI.calculateMaxTabWidth(tabPlacement);
        } else {
            this.tabbedPaneUI.maxTabHeight = this.tabbedPaneUI.calculateMaxTabHeight(tabPlacement);
        }
        this.tabbedPaneUI.runCount = 0;
        this.tabbedPaneUI.selectedRun = -1;
        if (tabCount == 0) {
            return;
        }
        this.tabbedPaneUI.selectedRun = 0;
        this.tabbedPaneUI.runCount = 1;
        int tabAreaWidth = Math.max(this.tabbedPaneUI.calculateTabAreaWidth(tabPlacement, 0, 0), this.tabbedPaneUI.maxTabWidth);
        int tabAreaHeight = Math.max(this.tabbedPaneUI.calculateTabAreaHeight(tabPlacement, 0, 0), this.tabbedPaneUI.maxTabHeight);
        Rectangle tabBounds = new Rectangle(0, 0, tabAreaWidth, tabAreaHeight);
        for (int i = 0; i < tabCount; ++i) {
            this.calculateRect(i, tabBounds, metrics, verticalTabRuns, tabPlacement);
        }
        TabButtonContainer tabsButton = this.tabbedPaneUI.scrollableTabSupport.moreTabsButton;
        Rectangle rectangle = selectedBounds = this.tabbedPaneUI.tabPane.getSelectedIndex() > 0 ? new Rectangle(this.tabbedPaneUI.rects[this.tabbedPaneUI.tabPane.getSelectedIndex()]) : new Rectangle(0, 0, 0, 0);
        if (!verticalTabRuns) {
            int rightMargin = size.width - (insets.right + tabAreaInsets.right + insets.left + tabAreaInsets.left);
            Point p = this.getMargins(tabPlacement);
            int leftMargin = p.x;
            int returnAt = p.y;
            this.tabbedPaneUI.currentShiftXTmp = this.tabbedPaneUI.currentShiftX;
            this.shiftTabsX(0, leftMargin, returnAt, tabCount, false);
            if (this.tabbedPaneUI.minVisible != this.tabbedPaneUI.maxVisible || this.tabbedPaneUI.minVisible != this.tabbedPaneUI.tabPane.getSelectedIndex()) {
                selectedBounds.x += this.tabbedPaneUI.currentShiftXTmp;
                this.shiftBoundsToVisibleX(selectedBounds, leftMargin, returnAt, tabCount);
            }
            this.restoreHiddenTabsX(leftMargin, returnAt, tabCount);
            if (this.tabbedPaneUI.minVisible == 0 && this.tabbedPaneUI.maxVisible == tabCount - 1 && PropertyUtil.getBooleanProperty((JComponent)this.tabbedPaneUI.tabPane, (String)"JTabbedPane.centerTabs")) {
                this.adjustForCenterX(leftMargin, returnAt, tabCount);
            }
            if (tabsButton.isVisible() && this.tabbedPaneUI.tabPane.getSelectedIndex() < this.tabbedPaneUI.maxVisible) {
                int margin = returnAt + ((JComponent)tabsButton).getPreferredSize().width;
                this.shiftTabsX(0, leftMargin, margin, tabCount, false);
                if (this.tabbedPaneUI.minVisible > 0 || this.tabbedPaneUI.maxVisible < tabCount - 1) {
                    this.shiftTabsX(0, leftMargin, returnAt, tabCount, false);
                }
            }
            this.adjustForDropX(leftMargin, returnAt, tabCount);
            this.layoutMoreTabsButton(tabCount);
            this.commitShiftX(this.tabbedPaneUI.currentShiftXTmp, tabCount);
            this.tabbedPaneUI.currentShiftX = this.tabbedPaneUI.currentShiftXTmp;
            if (!leftToRight) {
                TabButtonContainer newTabButton;
                if (tabsButton.isVisible()) {
                    rightMargin -= tabsButton.getWidth();
                }
                if ((newTabButton = this.tabbedPaneUI.scrollableTabSupport.newTabButton).isVisible() && newTabButton.getParent() == this.tabbedPaneUI.tabPane) {
                    rightMargin -= newTabButton.getWidth();
                }
                for (int i = 0; i < tabCount; ++i) {
                    this.tabbedPaneUI.rects[i].x = rightMargin - this.tabbedPaneUI.rects[i].x - this.tabbedPaneUI.rects[i].width;
                }
            }
            if (this.tabbedPaneUI.scrollableTabSupport.newTabButton.isVisible()) {
                this.layoutNewTabButton(true, leftToRight, leftMargin, rightMargin, tabCount);
            }
        } else {
            int bottomMargin = size.height - (insets.bottom + tabAreaInsets.bottom + insets.top + tabAreaInsets.top);
            Point p = this.getMargins(tabPlacement);
            int topMargin = p.x;
            int returnAt = p.y;
            this.tabbedPaneUI.currentShiftYTmp = this.tabbedPaneUI.currentShiftY;
            this.shiftTabsY(0, topMargin, returnAt, tabCount, false);
            if (this.tabbedPaneUI.minVisible != this.tabbedPaneUI.maxVisible || this.tabbedPaneUI.minVisible != this.tabbedPaneUI.tabPane.getSelectedIndex()) {
                selectedBounds.y += this.tabbedPaneUI.currentShiftYTmp;
                this.shiftBoundsToVisibleY(selectedBounds, topMargin, returnAt, tabCount);
            }
            this.restoreHiddenTabsY(topMargin, returnAt, tabCount);
            if (this.tabbedPaneUI.minVisible == 0 && this.tabbedPaneUI.maxVisible == tabCount - 1 && PropertyUtil.getBooleanProperty((JComponent)this.tabbedPaneUI.tabPane, (String)"JTabbedPane.centerTabs")) {
                this.adjustForCenterY(topMargin, returnAt, tabCount);
            }
            if (tabsButton.isVisible() && this.tabbedPaneUI.tabPane.getSelectedIndex() < this.tabbedPaneUI.maxVisible) {
                this.shiftTabsY(0, topMargin, bottomMargin, tabCount, false);
                if (this.tabbedPaneUI.minVisible > 0 || this.tabbedPaneUI.maxVisible < tabCount - 1) {
                    this.shiftTabsY(0, topMargin, returnAt, tabCount, false);
                }
            }
            this.adjustForDropY(topMargin, returnAt, tabCount);
            this.layoutMoreTabsButton(tabCount);
            this.commitShiftY(this.tabbedPaneUI.currentShiftYTmp, tabCount);
            this.tabbedPaneUI.currentShiftY = this.tabbedPaneUI.currentShiftYTmp;
            if (this.tabbedPaneUI.scrollableTabSupport.newTabButton.isVisible()) {
                this.layoutNewTabButton(false, leftToRight, topMargin, bottomMargin, tabCount);
            }
        }
        this.tabbedPaneUI.tabScroller.tabPanel.setPreferredSize(tabBounds.getSize());
    }

    @Override
    protected void centerTabs(int tabPlacement, int tabCount, int returnAt) {
    }

    protected void adjustForCenterX(int leftMargin, int returnAt, int tabCount) {
        int shift = (returnAt - (this.tabbedPaneUI.rects[tabCount - 1].x + this.tabbedPaneUI.rects[tabCount - 1].width)) / 2;
        this.shiftTabsX(shift, 0, returnAt, tabCount - 1, true);
    }

    protected void adjustForCenterY(int topMargin, int returnAt, int tabCount) {
        int shift = (returnAt - (this.tabbedPaneUI.rects[tabCount - 1].y + this.tabbedPaneUI.rects[tabCount - 1].height)) / 2;
        this.shiftTabsY(shift, 0, returnAt, tabCount - 1, true);
    }

    @Override
    protected int preferredTabAreaWidth(int tabPlacement, int height) {
        return this.tabbedPaneUI.calculateMaxTabWidth(tabPlacement);
    }

    @Override
    protected int preferredTabAreaHeight(int tabPlacement, int width) {
        return this.tabbedPaneUI.calculateMaxTabHeight(tabPlacement);
    }

    protected Point getMargins(int tabPlacement) {
        Dimension size = this.tabbedPaneUI.tabPane.getSize();
        Insets insets = this.tabbedPaneUI.tabPane.getInsets();
        Insets tabAreaInsets = this.tabbedPaneUI.getTabAreaInsets(tabPlacement);
        TabButtonContainer tabsButton = this.tabbedPaneUI.scrollableTabSupport.moreTabsButton;
        TabButtonContainer newTabsButton = this.tabbedPaneUI.scrollableTabSupport.newTabButton;
        if (this.tabbedPaneUI.isHorizontalTabPlacement()) {
            int leftMargin = 0;
            int returnAt = size.width - (insets.right + tabAreaInsets.right + insets.left + tabAreaInsets.left);
            if (tabsButton.isVisible()) {
                returnAt -= ((JComponent)tabsButton).getPreferredSize().width;
            }
            if (newTabsButton.isVisible() && newTabsButton.getParent() == this.tabbedPaneUI.tabPane) {
                returnAt -= ((JComponent)newTabsButton).getPreferredSize().width;
            }
            return new Point(leftMargin, returnAt);
        }
        int topMargin = 0;
        int returnAt = size.height - (insets.bottom + tabAreaInsets.bottom + insets.top + tabAreaInsets.top);
        if (tabsButton.isVisible()) {
            returnAt -= ((JComponent)tabsButton).getPreferredSize().height;
        }
        if (newTabsButton.isVisible() && newTabsButton.getParent() == this.tabbedPaneUI.tabPane) {
            returnAt -= ((JComponent)newTabsButton).getPreferredSize().height;
        }
        return new Point(topMargin, returnAt);
    }

    protected void adjustForDropX(int minX, int maxX, int tabCount) {
        if (this.tabbedPaneUI.dropSourceIndex >= 0 && this.tabbedPaneUI.dropSourceIndex < this.tabbedPaneUI.tabPane.getTabCount()) {
            int shift = this.tabbedPaneUI.rects[this.tabbedPaneUI.dropSourceIndex].width;
            this.tabbedPaneUI.rects[this.tabbedPaneUI.dropSourceIndex].setSize(0, 0);
            this.commitShiftX(this.tabbedPaneUI.dropSourceIndex + 1, tabCount - 1, -1 * shift, tabCount);
        }
        if (this.tabbedPaneUI.sourceEqualsTarget && this.tabbedPaneUI.dropTargetIndex >= 0 && this.tabbedPaneUI.dropTargetIndex < this.tabbedPaneUI.tabPane.getTabCount()) {
            this.commitShiftX(this.tabbedPaneUI.dropTargetIndex, tabCount - 1, this.tabbedPaneUI.dropRect.width, tabCount);
        }
        this.shiftTabsX(0, minX, maxX, tabCount, false);
    }

    protected void layoutNewTabButton(boolean horizontal, boolean leftToRight, int minVal, int maxVal, int tabCount) {
        TabButtonContainer button = this.tabbedPaneUI.scrollableTabSupport.newTabButton;
        Dimension buttonBounds = ((JComponent)button).getPreferredSize();
        if (horizontal) {
            if (leftToRight) {
                if (this.tabbedPaneUI.rects[tabCount - 1].x + this.tabbedPaneUI.rects[tabCount - 1].width + buttonBounds.width > maxVal) {
                    if (button.getParent() != this.tabbedPaneUI.tabPane) {
                        this.tabbedPaneUI.tabPane.add(button);
                    }
                } else if (button.getParent() != this.tabbedPaneUI.scrollableTabSupport.tabPanel) {
                    this.tabbedPaneUI.scrollableTabSupport.tabPanel.add(button);
                }
            } else {
                int x = this.tabbedPaneUI.rects[tabCount - 1].x;
                if (x - buttonBounds.width < minVal) {
                    if (button.getParent() != this.tabbedPaneUI.tabPane) {
                        this.tabbedPaneUI.tabPane.add(button);
                    }
                } else if (button.getParent() != this.tabbedPaneUI.scrollableTabSupport.tabPanel) {
                    this.tabbedPaneUI.scrollableTabSupport.tabPanel.add(button);
                }
            }
        } else if (this.tabbedPaneUI.rects[tabCount - 1].y + this.tabbedPaneUI.rects[tabCount - 1].height + buttonBounds.height > maxVal) {
            if (button.getParent() != this.tabbedPaneUI.tabPane) {
                this.tabbedPaneUI.tabPane.add(button);
            }
        } else if (button.getParent() != this.tabbedPaneUI.scrollableTabSupport.tabPanel) {
            this.tabbedPaneUI.scrollableTabSupport.tabPanel.add(button);
        }
    }

    protected void commitShiftX(int shift, int tabCount) {
        this.commitShiftX(0, tabCount - 1, shift, tabCount);
    }

    protected void commitShiftX(int low, int high, int shift, int tabCount) {
        for (int i = Math.max(low, 0); i <= Math.min(high, tabCount - 1); ++i) {
            this.tabbedPaneUI.rects[i].x += shift;
        }
    }

    protected void commitShiftY(int shift, int tabCount) {
        this.commitShiftY(0, tabCount - 1, shift, tabCount);
    }

    protected void commitShiftY(int low, int high, int shift, int tabCount) {
        for (int i = Math.max(low, 0); i <= Math.min(high, tabCount - 1); ++i) {
            this.tabbedPaneUI.rects[i].y += shift;
        }
    }

    protected void shiftBoundsToVisibleX(Rectangle selectedBounds, int leftMargin, int rightMargin, int tabCount) {
        if (selectedBounds.x + selectedBounds.width > rightMargin) {
            this.shiftTabsX(rightMargin - selectedBounds.x - selectedBounds.width, leftMargin, rightMargin, tabCount, true);
        } else if (selectedBounds.x < leftMargin) {
            this.shiftTabsX(-selectedBounds.x + leftMargin, leftMargin, rightMargin, tabCount, true);
        }
    }

    protected void shiftBoundsToVisibleY(Rectangle selectedBounds, int topMargin, int bottomMargin, int tabCount) {
        if (selectedBounds.y + selectedBounds.height > bottomMargin) {
            this.shiftTabsY(bottomMargin - selectedBounds.y - selectedBounds.height, topMargin, bottomMargin, tabCount, true);
        } else if (selectedBounds.y < topMargin) {
            this.shiftTabsY(-selectedBounds.y + topMargin, topMargin, bottomMargin, tabCount, true);
        }
    }

    protected void calculateRect(int i, Rectangle tabBounds, FontMetrics metrics, boolean verticalTabRuns, int tabPlacement) {
        Rectangle rect = this.tabbedPaneUI.rects[i];
        if (!verticalTabRuns) {
            if (i > 0) {
                rect.x = this.tabbedPaneUI.rects[i - 1].x + this.tabbedPaneUI.rects[i - 1].width;
            } else {
                this.tabbedPaneUI.tabRuns[0] = 0;
                this.tabbedPaneUI.maxTabWidth = 0;
                rect.x = tabBounds.x;
            }
            rect.width = this.tabbedPaneUI.calculateTabWidth(tabPlacement, i, metrics);
            tabBounds.width = rect.x + rect.width;
            this.tabbedPaneUI.maxTabWidth = Math.max(this.tabbedPaneUI.maxTabWidth, rect.width);
            rect.height = tabBounds.height;
            rect.y = tabBounds.y + tabBounds.height - rect.height;
        } else {
            if (i > 0) {
                rect.y = this.tabbedPaneUI.rects[i - 1].y + this.tabbedPaneUI.rects[i - 1].height;
            } else {
                this.tabbedPaneUI.tabRuns[0] = 0;
                this.tabbedPaneUI.maxTabHeight = 0;
                rect.y = tabBounds.y;
            }
            rect.height = this.tabbedPaneUI.calculateTabHeight(tabPlacement, i, metrics.getHeight());
            tabBounds.height = rect.y + rect.height;
            this.tabbedPaneUI.maxTabHeight = Math.max(this.tabbedPaneUI.maxTabHeight, rect.height);
            rect.width = tabBounds.width;
            rect.x = tabBounds.x + tabBounds.width - rect.width;
        }
    }

    protected void restoreHiddenTabsX(int minX, int maxX, int tabCount) {
        if (this.tabbedPaneUI.maxVisible < 0 || this.tabbedPaneUI.maxVisible >= tabCount) {
            return;
        }
        int space = Math.max(maxX - this.tabbedPaneUI.rects[this.tabbedPaneUI.maxVisible].x - this.tabbedPaneUI.rects[this.tabbedPaneUI.maxVisible].width - this.tabbedPaneUI.currentShiftXTmp, 0);
        int shift = Math.min(minX - this.tabbedPaneUI.rects[0].x - this.tabbedPaneUI.currentShiftXTmp, space);
        this.shiftTabsX(shift, minX, maxX, tabCount, true);
    }

    protected void restoreHiddenTabsY(int minY, int maxY, int tabCount) {
        if (this.tabbedPaneUI.maxVisible < 0 || this.tabbedPaneUI.maxVisible >= tabCount) {
            return;
        }
        int space = Math.max(maxY - this.tabbedPaneUI.rects[this.tabbedPaneUI.maxVisible].y - this.tabbedPaneUI.rects[this.tabbedPaneUI.maxVisible].height - this.tabbedPaneUI.currentShiftYTmp, 0);
        int shift = Math.min(minY - this.tabbedPaneUI.rects[0].y - this.tabbedPaneUI.currentShiftYTmp, space);
        this.shiftTabsY(shift, minY, maxY, tabCount, true);
    }

    protected void adjustForDropY(int minY, int maxY, int tabCount) {
        if (this.tabbedPaneUI.dropSourceIndex >= 0 && this.tabbedPaneUI.dropSourceIndex < this.tabbedPaneUI.tabPane.getTabCount()) {
            int shift = this.tabbedPaneUI.rects[this.tabbedPaneUI.dropSourceIndex].height;
            this.tabbedPaneUI.rects[this.tabbedPaneUI.dropSourceIndex].setSize(0, 0);
            this.commitShiftY(this.tabbedPaneUI.dropSourceIndex + 1, tabCount - 1, -1 * shift, tabCount);
        }
        if (this.tabbedPaneUI.sourceEqualsTarget && this.tabbedPaneUI.dropTargetIndex >= 0 && this.tabbedPaneUI.dropTargetIndex < this.tabbedPaneUI.tabPane.getTabCount()) {
            this.commitShiftY(this.tabbedPaneUI.dropTargetIndex, tabCount - 1, this.tabbedPaneUI.dropRect.height, tabCount);
        }
        this.shiftTabsY(0, minY, maxY, tabCount, false);
    }

    public void updateVisibleRange(int tapPlacement) {
        Point p = this.getMargins(tapPlacement);
        if (this.tabbedPaneUI.isHorizontalTabPlacement()) {
            this.shiftTabsX(0, p.x, p.y, this.tabbedPaneUI.tabPane.getTabCount(), false);
        } else {
            this.shiftTabsY(0, p.x, p.y, this.tabbedPaneUI.tabPane.getTabCount(), false);
        }
    }

    protected void layoutMoreTabsButton(int tabCount) {
        TabButtonContainer button = this.tabbedPaneUI.scrollableTabSupport.moreTabsButton;
        if (this.tabbedPaneUI.minVisible > 0 || this.tabbedPaneUI.maxVisible < tabCount - 1) {
            if (this.tabbedPaneUI.scrollableTabSupport.moreTabsButton.isVisible()) {
                if (this.tabbedPaneUI.minVisible != this.tabbedPaneUI.minVisibleOld || this.tabbedPaneUI.maxVisible != this.tabbedPaneUI.maxVisibleOld || this.tabbedPaneUI.oldTabCount != tabCount) {
                    this.tabbedPaneUI.scrollableTabSupport.showMoreTabsButton();
                }
            } else {
                this.tabbedPaneUI.scrollableTabSupport.showMoreTabsButton();
            }
            this.tabbedPaneUI.minVisibleOld = this.tabbedPaneUI.minVisible;
            this.tabbedPaneUI.maxVisibleOld = this.tabbedPaneUI.maxVisible;
            this.tabbedPaneUI.oldTabCount = tabCount;
        } else if (button.isVisible()) {
            this.tabbedPaneUI.scrollableTabSupport.hideMoreTabsButton();
        }
    }

    protected void shiftTabsX(int shift, int minX, int returnAt, int tabCount, boolean updateShift) {
        this.shiftTabs(shift, minX, returnAt, tabCount, updateShift, true);
    }

    protected void shiftTabsY(int shift, int minY, int returnAt, int tabCount, boolean updateShift) {
        this.shiftTabs(shift, minY, returnAt, tabCount, updateShift, false);
    }

    protected void shiftTabs(int shift, int minVal, int returnAt, int tabCount, boolean updateShift, boolean isX) {
        int i2;
        Function<Integer, Boolean> isVisible;
        int min = -1;
        int max = -1;
        int minStart = this.tabbedPaneUI.minVisible < 0 || this.tabbedPaneUI.minVisible >= tabCount ? 0 : this.tabbedPaneUI.minVisible;
        int maxStart = this.tabbedPaneUI.maxVisible < 0 || this.tabbedPaneUI.maxVisible >= tabCount ? tabCount - 1 : this.tabbedPaneUI.maxVisible;
        int currShift = isX ? this.tabbedPaneUI.currentShiftXTmp + shift : this.tabbedPaneUI.currentShiftYTmp + shift;
        Function<Integer, Boolean> function = isVisible = isX ? i -> this.isVisibleX((int)i, currShift, minVal, returnAt) : i -> this.isVisibleY((int)i, currShift, minVal, returnAt);
        if (isVisible.apply(minStart).booleanValue()) {
            min = minStart;
            i2 = minStart - 1;
            while (i2 >= 0 && isVisible.apply(i2).booleanValue()) {
                min = i2--;
            }
        } else {
            for (i2 = minStart + 1; i2 < tabCount; ++i2) {
                if (!isVisible.apply(i2).booleanValue()) continue;
                min = i2;
                break;
            }
        }
        if (min == -1) {
            min = tabCount;
        }
        if (isVisible.apply(maxStart).booleanValue()) {
            max = maxStart;
            i2 = maxStart + 1;
            while (i2 < tabCount && isVisible.apply(i2).booleanValue()) {
                max = i2++;
            }
        } else {
            for (i2 = maxStart - 1; i2 >= 0; --i2) {
                if (!isVisible.apply(i2).booleanValue()) continue;
                max = i2;
                break;
            }
        }
        this.tabbedPaneUI.minVisible = min;
        this.tabbedPaneUI.maxVisible = max;
        if (updateShift) {
            if (isX) {
                this.tabbedPaneUI.currentShiftXTmp += shift;
            } else {
                this.tabbedPaneUI.currentShiftYTmp += shift;
            }
        }
    }

    protected boolean isVisibleX(int i, int shift, int minX, int maxX) {
        int begin = this.tabbedPaneUI.rects[i].x + shift;
        int end = begin + this.tabbedPaneUI.rects[i].width;
        return begin < maxX && end >= minX;
    }

    protected boolean isVisibleY(int i, int shift, int minX, int maxX) {
        int begin = this.tabbedPaneUI.rects[i].y + shift;
        int end = begin + this.tabbedPaneUI.rects[i].height;
        return begin < maxX && end >= minX;
    }
}

