/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabframe;

import com.github.weisj.darklaf.components.JXPopupMenu;
import com.github.weisj.darklaf.components.tabframe.TabFrameTab;
import com.github.weisj.darklaf.properties.icons.EmptyIcon;
import com.github.weisj.darklaf.util.Alignment;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class DarkTabFrameComponentPopupMenu
extends JXPopupMenu
implements PropertyChangeListener,
UIResource {
    private final TabFrameTab tab;
    private final JMenuItem[] actions;
    private int disabled = -1;

    public DarkTabFrameComponentPopupMenu(TabFrameTab tab) {
        Alignment a;
        this.tab = tab;
        Locale l = tab.getComponent().getLocale();
        JMenu moveToMenu = new JMenu(UIManager.getString((Object)"popup.moveTo", l));
        Alignment[] aligns = Alignment.values();
        this.actions = new JMenuItem[aligns.length];
        for (a = Alignment.NORTH_WEST; a != Alignment.NORTH; a = a.anticlockwise()) {
            this.createAndAdd(a, moveToMenu, l);
        }
        this.createAndAdd(a, moveToMenu, l);
        this.add(moveToMenu);
        if (tab.getOrientation() != null) {
            this.disabled = tab.getOrientation().ordinal();
            this.actions[tab.getOrientation().ordinal()].setEnabled(false);
        }
        tab.getComponent().addPropertyChangeListener(this);
    }

    protected void createAndAdd(Alignment a, JMenu menu, Locale l) {
        JMenuItem menuItem;
        this.actions[a.ordinal()] = menuItem = this.createMenuItem(a, l);
        menu.add(menuItem);
    }

    protected JMenuItem createMenuItem(Alignment a, Locale l) {
        JMenuItem menuItem = new JMenuItem();
        menuItem.addActionListener(e -> this.moveTo(a));
        menuItem.setText(this.getDescription(a, l));
        menuItem.setIcon(this.createIcon(a, true));
        menuItem.setDisabledIcon(this.createIcon(a, false));
        return menuItem;
    }

    protected void moveTo(Alignment a) {
        if (this.disabled >= 0) {
            this.actions[this.disabled].setEnabled(true);
        }
        this.disabled = a.ordinal();
        this.actions[a.ordinal()].setEnabled(false);
        this.tab.getTabFrame().moveTab(this.tab, a);
    }

    protected String getDescription(Alignment a, Locale l) {
        switch (a) {
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: 
            case NORTH_EAST: 
            case NORTH_WEST: 
            case SOUTH_EAST: 
            case SOUTH_WEST: {
                return UIManager.getString((Object)("popup.moveTo." + a.name().toLowerCase()), l);
            }
        }
        return "";
    }

    protected Icon createIcon(Alignment a, boolean enabled) {
        String suffix = enabled ? "" : "Disabled";
        switch (a) {
            case NORTH: {
                return UIManager.getIcon("TabFrame.moveToTopLeft" + suffix + ".icon");
            }
            case SOUTH: {
                return UIManager.getIcon("TabFrame.moveToBottomRight" + suffix + ".icon");
            }
            case EAST: {
                return UIManager.getIcon("TabFrame.moveToRightTop" + suffix + ".icon");
            }
            case WEST: {
                return UIManager.getIcon("TabFrame.moveToLeftBottom" + suffix + ".icon");
            }
            case NORTH_EAST: {
                return UIManager.getIcon("TabFrame.moveToTopRight" + suffix + ".icon");
            }
            case NORTH_WEST: {
                return UIManager.getIcon("TabFrame.moveToLeftTop" + suffix + ".icon");
            }
            case SOUTH_EAST: {
                return UIManager.getIcon("TabFrame.moveToRightBottom" + suffix + ".icon");
            }
            case SOUTH_WEST: {
                return UIManager.getIcon("TabFrame.moveToBottomLeft" + suffix + ".icon");
            }
        }
        return EmptyIcon.create((int)0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("orientation".equals(evt.getPropertyName())) {
            Object a = evt.getNewValue();
            if (a instanceof Alignment) {
                if (this.disabled >= 0) {
                    this.actions[this.disabled].setEnabled(true);
                }
                this.disabled = ((Alignment)a).ordinal();
                this.actions[this.disabled].setEnabled(false);
            }
        } else if ("componentPopupMenu".equals(evt.getPropertyName()) && evt.getNewValue() != this) {
            this.tab.getComponent().removePropertyChangeListener(this);
        }
    }
}

