/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabframe;

import com.github.weisj.darklaf.components.border.MutableLineBorder;
import com.github.weisj.darklaf.components.tabframe.JTabFrame;
import com.github.weisj.darklaf.components.tabframe.PopupContainer;
import com.github.weisj.darklaf.components.tabframe.TabFramePopup;
import com.github.weisj.darklaf.components.tabframe.TabFrameTab;
import com.github.weisj.darklaf.components.tabframe.TabFrameUI;
import com.github.weisj.darklaf.components.uiresource.JPanelUIResource;
import com.github.weisj.darklaf.ui.tabframe.TabFrameLayout;
import com.github.weisj.darklaf.ui.tabframe.TabFrameTransferHandler;
import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.Pair;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.pbjar.jxlayer.plaf.ext.transform.DefaultTransformModel;
import org.pbjar.jxlayer.plaf.ext.transform.TransformUtils;

public class DarkTabFrameUI
extends TabFrameUI
implements AWTEventListener {
    protected static final TabFrameTransferHandler TRANSFER_HANDLER = new TabFrameTransferHandler.UIResource();
    private final Rectangle calcRect = new Rectangle();
    private JLayer<JComponent> rotatePaneLeft;
    private JLayer<JComponent> rotatePaneRight;
    private JTabFrame tabFrame;
    private JComponent dropComponentTop;
    private JComponent dropComponentBottom;
    private JComponent dropComponentRight;
    private JComponent dropComponentLeft;
    private MutableLineBorder topBorder;
    private MutableLineBorder bottomBorder;
    private MutableLineBorder leftBorder;
    private MutableLineBorder rightBorder;
    private Color lineColor;
    private TabFrameLayout layout;
    private int tabHeight;
    private Color dragBorderColor;
    private final Dimension dropSize = new Dimension();
    private Alignment sourceAlign;
    private int sourceIndex;
    private Alignment destAlign;
    private int destIndex;

    public static ComponentUI createUI(JComponent c) {
        return new DarkTabFrameUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.tabFrame = (JTabFrame)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installDnD();
    }

    protected void installDefaults() {
        this.layout = this.createLayout();
        this.tabFrame.setLayout(this.layout);
        this.lineColor = UIManager.getColor("TabFrame.line");
        this.tabHeight = UIManager.getInt("TabFrame.tabHeight");
        this.topBorder = new MutableLineBorder(0, 0, 1, 0, this.lineColor);
        this.bottomBorder = new MutableLineBorder(1, 0, 0, 0, this.lineColor);
        this.rightBorder = new MutableLineBorder(0, 0, 1, 0, this.lineColor);
        this.leftBorder = new MutableLineBorder(0, 0, 1, 0, this.lineColor);
        this.dropComponentTop = new JPanelUIResource();
        this.dropComponentBottom = new JPanelUIResource();
        this.dropComponentLeft = new JPanelUIResource();
        this.dropComponentRight = new JPanelUIResource();
        this.dragBorderColor = UIManager.getColor("TabFrame.dragBorderColor");
        Color dropColor = UIManager.getColor("TabFrame.dropBackground");
        this.dropComponentTop.setBackground(dropColor);
        this.dropComponentBottom.setBackground(dropColor);
        this.dropComponentLeft.setBackground(dropColor);
        this.dropComponentRight.setBackground(dropColor);
        this.tabFrame.getTopTabContainer().setBorder(this.topBorder);
        this.tabFrame.getBottomTabContainer().setBorder(this.bottomBorder);
        this.tabFrame.getRightTabContainer().setBorder(this.rightBorder);
        this.tabFrame.getLeftTabContainer().setBorder(this.leftBorder);
    }

    private void installComponents() {
        DefaultTransformModel rightTransformModel = new DefaultTransformModel();
        rightTransformModel.setQuadrantRotation(1);
        rightTransformModel.setScaleToPreferredSize(true);
        this.rotatePaneRight = TransformUtils.createTransformJLayer(this.tabFrame.getRightTabContainer(), rightTransformModel);
        DefaultTransformModel leftTransformModel = new DefaultTransformModel();
        leftTransformModel.setQuadrantRotation(3);
        leftTransformModel.setScaleToPreferredSize(true);
        this.rotatePaneLeft = TransformUtils.createTransformJLayer(this.tabFrame.getLeftTabContainer(), leftTransformModel);
        this.tabFrame.add(this.tabFrame.getTopTabContainer());
        this.tabFrame.add(this.tabFrame.getBottomTabContainer());
        this.tabFrame.add(this.rotatePaneLeft);
        this.tabFrame.add(this.rotatePaneRight);
        this.tabFrame.getTopTabContainer().add(this.dropComponentTop);
        this.tabFrame.getBottomTabContainer().add(this.dropComponentBottom);
        this.tabFrame.getLeftTabContainer().add(this.dropComponentLeft);
        this.tabFrame.getRightTabContainer().add(this.dropComponentRight);
    }

    protected void installListeners() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
    }

    protected void installDnD() {
        this.tabFrame.setTransferHandler(TRANSFER_HANDLER);
        try {
            DropTarget dropTarget = this.tabFrame.getDropTarget();
            if (dropTarget != null) {
                dropTarget.addDropTargetListener(TRANSFER_HANDLER);
                dropTarget.setActive(this.tabFrame.isDndEnabled());
            }
        }
        catch (TooManyListenersException e) {
            throw new IllegalStateException("Can't install DnD support. A valid drop target is already registered", e);
        }
    }

    protected TabFrameLayout createLayout() {
        return new TabFrameLayout(this.tabFrame, this);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.tabFrame.remove(this.tabFrame.getTopTabContainer());
        this.tabFrame.remove(this.tabFrame.getBottomTabContainer());
        this.tabFrame.remove(this.rotatePaneLeft);
        this.tabFrame.remove(this.rotatePaneRight);
        this.layout = null;
        this.lineColor = null;
        this.topBorder = null;
        this.bottomBorder = null;
        this.leftBorder = null;
        this.rightBorder = null;
        this.rotatePaneLeft = null;
        this.rotatePaneRight = null;
        this.uninstallListeners();
        if (this.tabFrame.getTransferHandler() instanceof TabFrameTransferHandler.UIResource) {
            this.tabFrame.setTransferHandler(null);
            if (this.tabFrame.getDropTarget() != null) {
                this.tabFrame.getDropTarget().removeDropTargetListener(TRANSFER_HANDLER);
                this.tabFrame.getDropTarget().setActive(false);
            }
        }
    }

    protected void uninstallListeners() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    @Override
    public int getTabSize(JTabFrame tabFrame) {
        return this.tabHeight;
    }

    @Override
    public void clearTargetIndicator() {
        this.destIndex = -10;
        this.destAlign = null;
        this.dropSize.setSize(0, 0);
        this.tabFrame.doLayout();
    }

    @Override
    public void clearSourceIndicator() {
        this.sourceIndex = -10;
        this.sourceAlign = null;
        this.tabFrame.doLayout();
    }

    @Override
    public Color getDragBorderColor() {
        return this.dragBorderColor;
    }

    @Override
    public void setSourceIndicator(Alignment a, int tabIndex) {
        this.sourceAlign = a;
        this.sourceIndex = tabIndex;
        this.destIndex = tabIndex;
        this.destAlign = a;
        this.tabFrame.doLayout();
    }

    @Override
    public void setTargetIndicator(Alignment a, int tabIndex) {
        this.destAlign = a;
        this.destIndex = tabIndex;
        this.tabFrame.doLayout();
    }

    @Override
    public JTabFrame.TabFramePosition getTabIndexAt(JTabFrame tabFrame, Point p) {
        return (JTabFrame.TabFramePosition)this.getTabIndexAtImpl(tabFrame, p).getFirst();
    }

    @Override
    public int getTabWidth(JTabFrame tabFrame, Alignment a, int index) {
        return this.layout.getTabWidth(tabFrame.getTabComponentAt(a, index).getComponent());
    }

    public JComponent getTopContainer() {
        return this.tabFrame.getTopTabContainer();
    }

    public JComponent getBottomContainer() {
        return this.tabFrame.getBottomTabContainer();
    }

    public JComponent getLeftContainer() {
        return this.rotatePaneLeft;
    }

    public JComponent getRightContainer() {
        return this.rotatePaneRight;
    }

    @Override
    public int getTabHeight(JTabFrame tabFrame, Alignment a, int index) {
        return tabFrame.getTabSize();
    }

    @Override
    public Rectangle getTabContainerBounds(JTabFrame tabFrame, Alignment a) {
        switch (a) {
            case NORTH: 
            case NORTH_EAST: {
                Rectangle rect = this.getTopContainer().getBounds();
                rect.x = 0;
                rect.width = tabFrame.getWidth();
                return rect;
            }
            case EAST: 
            case SOUTH_EAST: {
                return this.getRightContainer().getBounds();
            }
            case SOUTH: 
            case SOUTH_WEST: {
                Rectangle rect2 = this.getTopContainer().getBounds();
                rect2.x = 0;
                rect2.width = tabFrame.getWidth();
                return rect2;
            }
            case WEST: 
            case NORTH_WEST: {
                return this.getLeftContainer().getBounds();
            }
        }
        return tabFrame.getContentPane().getComponent().getBounds();
    }

    protected Pair<JTabFrame.TabFramePosition, Point> getTabIndexAtImpl(JTabFrame tabFrame, Point p) {
        int tmp;
        JComponent tabComp = null;
        Alignment a = null;
        Point pos = null;
        if (!this.layout.isDraggedOver(Alignment.NORTH)) {
            this.getTopContainer().getBounds(this.calcRect);
            if (p.y >= this.calcRect.y && p.y <= this.calcRect.y + this.calcRect.height) {
                tabComp = this.getTopContainer();
                a = Alignment.NORTH;
                pos = SwingUtilities.convertPoint(tabFrame, p, tabComp);
                if (pos.x > ((Component)tabComp).getWidth() / 2) {
                    a = Alignment.NORTH_EAST;
                }
            }
        }
        if (tabComp == null && !this.layout.isDraggedOver(Alignment.SOUTH)) {
            this.getBottomContainer().getBounds(this.calcRect);
            if (p.y >= this.calcRect.y && p.y <= this.calcRect.y + this.calcRect.height) {
                tabComp = this.getBottomContainer();
                a = Alignment.SOUTH;
                pos = SwingUtilities.convertPoint(tabFrame, p, tabComp);
                if (pos.x <= ((Component)tabComp).getWidth() / 2) {
                    a = Alignment.SOUTH_WEST;
                }
            }
        }
        if (tabComp == null && !this.layout.isDraggedOver(Alignment.WEST)) {
            this.getLeftContainer().getBounds(this.calcRect);
            if (p.x >= this.calcRect.x && p.x <= this.calcRect.x + this.calcRect.width) {
                tabComp = this.getLeftContainer();
                a = Alignment.WEST;
                pos = SwingUtilities.convertPoint(tabFrame, p, tabComp);
                if (pos.y < ((Component)tabComp).getHeight() / 2) {
                    a = Alignment.NORTH_WEST;
                }
                tmp = pos.x;
                pos.x = ((Component)tabComp).getHeight() - pos.y;
                pos.y = tmp;
            }
        }
        if (tabComp == null && !this.layout.isDraggedOver(Alignment.EAST)) {
            this.getRightContainer().getBounds(this.calcRect);
            if (p.x >= this.calcRect.x && p.x <= this.calcRect.x + this.calcRect.width) {
                tabComp = this.getRightContainer();
                a = Alignment.EAST;
                pos = SwingUtilities.convertPoint(tabFrame, p, tabComp);
                if (pos.y > ((Component)tabComp).getHeight() / 2) {
                    a = Alignment.SOUTH_EAST;
                }
                tmp = pos.x;
                pos.x = pos.y;
                pos.y = tmp;
            }
        }
        if (tabComp == null) {
            JTabFrame.TabFramePosition tab = this.maybeRestoreTabContainer(tabFrame, p);
            if (tab.getAlignment() != null) {
                return new Pair((Object)tab, pos);
            }
        } else {
            this.layout.setDraggedOver(false);
        }
        if (tabComp == null) {
            return new Pair((Object)new JTabFrame.TabFramePosition(null, -1), pos);
        }
        List<TabFrameTab> tabs = tabFrame.tabsForAlignment(a);
        for (TabFrameTab tab : tabs) {
            Rectangle rect = this.getTabRect(tab, a, tabComp, true);
            if (!rect.contains(pos)) continue;
            return new Pair((Object)new JTabFrame.TabFramePosition(a, tab.getIndex()), (Object)pos);
        }
        return new Pair((Object)new JTabFrame.TabFramePosition(a, -1), (Object)pos);
    }

    @Override
    public JTabFrame.TabFramePosition getNearestTabIndexAt(JTabFrame tabFrame, Point pos) {
        return (JTabFrame.TabFramePosition)this.getNearestTabIndexAtImpl(tabFrame, pos).getFirst();
    }

    @Override
    public JTabFrame.TabFramePosition getDropPosition(JTabFrame tabFrame, Point p) {
        Pair<JTabFrame.TabFramePosition, Point> res = this.getNearestTabIndexAtImpl(tabFrame, p);
        JTabFrame.TabFramePosition tab = (JTabFrame.TabFramePosition)res.getFirst();
        if (tab.getAlignment() != null) {
            Alignment a = tab.getAlignment();
            int index = tab.getIndex();
            if (index >= 0) {
                Rectangle rect = this.getTabRect(tabFrame.getTabComponentAt(a, index), a, tabFrame.getTabContainer(a), false);
                Point pos = (Point)res.getSecond();
                if (this.isForward(a)) {
                    if (pos.x <= rect.x + rect.width / 2 && pos.x >= rect.x) {
                        tab.setIndex(tab.getIndex() - 1);
                    }
                } else if (pos.x >= rect.x + rect.width / 2) {
                    tab.setIndex(tab.getIndex() - 1);
                }
            }
        }
        return tab;
    }

    protected JTabFrame.TabFramePosition maybeRestoreTabContainer(JTabFrame tabFrame, Point p) {
        int size;
        Alignment a = null;
        int threshold = size = tabFrame.getTabSize();
        int index = -10;
        if (tabFrame.getTopTabCount() == 0) {
            if (this.layout.isDraggedOver(Alignment.NORTH)) {
                threshold *= 2;
            }
            if (p.y < threshold) {
                Alignment alignment = a = p.x >= tabFrame.getWidth() / 2 ? Alignment.NORTH_EAST : Alignment.NORTH;
            }
            if (p.y < size) {
                index = -1;
            }
        }
        if (a == null && tabFrame.getBottomTabCount() == 0) {
            if (this.layout.isDraggedOver(Alignment.SOUTH)) {
                threshold *= 2;
            }
            if (p.y > tabFrame.getHeight() - threshold) {
                Alignment alignment = a = p.x >= tabFrame.getWidth() / 2 ? Alignment.SOUTH : Alignment.SOUTH_WEST;
            }
            if (p.y > tabFrame.getHeight() - size) {
                index = -1;
            }
        }
        if (a == null && tabFrame.getLeftTabCount() == 0) {
            if (this.layout.isDraggedOver(Alignment.WEST)) {
                threshold *= 2;
            }
            if (p.x < threshold) {
                Alignment alignment = a = p.y >= tabFrame.getHeight() / 2 ? Alignment.WEST : Alignment.NORTH_WEST;
            }
            if (p.x < size) {
                index = -1;
            }
        }
        if (a == null && tabFrame.getRightTabCount() == 0) {
            if (this.layout.isDraggedOver(Alignment.EAST)) {
                threshold *= 2;
            }
            if (p.x > tabFrame.getWidth() - threshold) {
                Alignment alignment = a = p.y >= tabFrame.getHeight() / 2 ? Alignment.SOUTH_EAST : Alignment.EAST;
            }
            if (p.x > tabFrame.getWidth() - size) {
                index = -1;
            }
        }
        this.layout.setDraggedOver(false);
        if (a != null) {
            this.layout.setDraggedOver(a, true);
        }
        return new JTabFrame.TabFramePosition(a, index);
    }

    @Override
    public void setDropSize(int width, int height) {
        this.dropSize.setSize(width, height);
    }

    protected Rectangle getTabRect(TabFrameTab tab, Alignment a, Component tabComp, boolean includeDropRect) {
        tab.getComponent().getBounds(this.calcRect);
        SwingUtilities.convertRectangle(tab.getComponent(), this.calcRect, tabComp);
        if (includeDropRect && a == this.destAlign && tab.getIndex() == this.destIndex && this.destIndex >= 0) {
            if (this.isForward(a)) {
                this.calcRect.width += this.dropSize.width;
            } else {
                this.calcRect.x -= this.dropSize.width;
                this.calcRect.width += this.dropSize.width;
            }
        }
        return this.calcRect;
    }

    protected boolean isForward(Alignment a) {
        switch (a) {
            case NORTH: 
            case EAST: 
            case SOUTH_WEST: 
            case WEST: {
                return true;
            }
        }
        return false;
    }

    protected Pair<JTabFrame.TabFramePosition, Point> getNearestTabIndexAtImpl(JTabFrame tabFrame, Point pos) {
        Pair<JTabFrame.TabFramePosition, Point> res = this.getTabIndexAtImpl(tabFrame, pos);
        JTabFrame.TabFramePosition tab = (JTabFrame.TabFramePosition)res.getFirst();
        if (tab.getAlignment() != null && tab.getIndex() == -1) {
            Point p = (Point)res.getSecond();
            Alignment a = tab.getAlignment();
            if (tabFrame.getTabCountAt(a) == 0) {
                tab.setIndex(-1);
                return res;
            }
            int w = a == this.destAlign && this.destIndex == -1 ? this.dropSize.width : 0;
            Component comp = this.getTabContainer(a);
            switch (a) {
                case NORTH: 
                case SOUTH_WEST: {
                    if (p.x <= this.getLeftContainer().getWidth() + w) break;
                    tab.setIndex(tabFrame.getTabCountAt(a) - 1);
                    break;
                }
                case NORTH_EAST: 
                case SOUTH: {
                    if (p.x >= comp.getWidth() - this.getRightContainer().getWidth() - w) break;
                    tab.setIndex(tabFrame.getTabCountAt(a) - 1);
                    break;
                }
                case EAST: 
                case WEST: {
                    if (p.x <= w) break;
                    tab.setIndex(tabFrame.getTabCountAt(a) - 1);
                    break;
                }
                case SOUTH_EAST: 
                case NORTH_WEST: {
                    if (p.x >= comp.getHeight() - w) break;
                    tab.setIndex(tabFrame.getTabCountAt(a) - 1);
                    break;
                }
                case CENTER: {
                    throw new IllegalStateException();
                }
            }
        }
        return res;
    }

    protected Component getTabContainer(Alignment a) {
        switch (a) {
            case NORTH: 
            case NORTH_EAST: {
                return this.getTopContainer();
            }
            case EAST: 
            case SOUTH_EAST: {
                return this.getRightContainer();
            }
            case SOUTH: 
            case SOUTH_WEST: {
                return this.getBottomContainer();
            }
            case WEST: 
            case NORTH_WEST: {
                return this.getLeftContainer();
            }
        }
        return null;
    }

    public Alignment getSourceAlign() {
        return this.sourceAlign;
    }

    public int getSourceIndex() {
        return this.sourceIndex;
    }

    public Alignment getDestAlign() {
        return this.destAlign;
    }

    public int getDestIndex() {
        return this.destIndex;
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        MouseEvent e;
        Component comp;
        if (event.getID() == 501 && ((comp = (e = (MouseEvent)event).getComponent().getComponentAt(e.getPoint())) instanceof TabFramePopup || comp instanceof PopupContainer || comp instanceof JTabFrame)) {
            comp.requestFocusInWindow();
        }
    }

    public Dimension getDropSize() {
        return this.dropSize;
    }

    public JComponent getDropComponent(Alignment a) {
        switch (a) {
            default: {
                return this.getDropComponentTop();
            }
            case EAST: 
            case SOUTH_EAST: {
                return this.getDropComponentRight();
            }
            case SOUTH: 
            case SOUTH_WEST: {
                return this.getDropComponentBottom();
            }
            case WEST: 
            case NORTH_WEST: 
        }
        return this.getDropComponentLeft();
    }

    public JComponent getDropComponentTop() {
        return this.dropComponentTop;
    }

    public JComponent getDropComponentRight() {
        return this.dropComponentRight;
    }

    public JComponent getDropComponentBottom() {
        return this.dropComponentBottom;
    }

    public JComponent getDropComponentLeft() {
        return this.dropComponentLeft;
    }
}

