/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tree;

import com.github.weisj.darklaf.components.tristate.TristateState;
import com.github.weisj.darklaf.delegate.TreeCellRendererDelegate;
import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.ui.cell.ComponentBasedTreeCellRenderer;
import com.github.weisj.darklaf.ui.cell.DarkBooleanCellRenderer;
import com.github.weisj.darklaf.ui.cell.DarkCellRendererTristateButton;
import com.github.weisj.darklaf.ui.tree.TreeRendererComponent;
import com.github.weisj.darklaf.ui.tree.TreeRendererSupport;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class DarkTreeCellRendererDelegate
extends TreeCellRendererDelegate
implements TreeRendererSupport {
    private final DarkBooleanCellRenderer booleanRenderer = new DarkBooleanCellRenderer(false);
    private final ComponentBasedTreeCellRenderer tristateRenderer = new DarkCellRendererTristateButton(false);
    private final TreeRendererComponent rendererComponent = new TreeRendererComponent();

    public DarkTreeCellRendererDelegate(TreeCellRenderer renderer) {
        super(renderer);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component renderer;
        boolean isFocused = DarkUIUtil.hasFocus(tree);
        Object unwrapped = DarkTreeCellRendererDelegate.unwrapValue(value);
        if (unwrapped instanceof Boolean && DarkTreeCellRendererDelegate.isBooleanRenderingEnabled(tree)) {
            Component comp = this.getBooleanRenderer().getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, isFocused);
            renderer = this.prepareRendererComponent(tree, comp);
        } else if (unwrapped instanceof TristateState) {
            Component comp = this.getTristateRenderer().getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, isFocused);
            renderer = this.prepareRendererComponent(tree, comp);
        } else {
            TreeCellRenderer delegate = this.getDelegate();
            if (delegate instanceof DefaultTreeCellRenderer) {
                this.patchIcon(tree, (DefaultTreeCellRenderer)delegate, leaf, expanded);
            }
            renderer = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, isFocused);
        }
        CellUtil.setupTreeForeground(renderer, tree, selected);
        CellUtil.setupTreeBackground(renderer, tree, selected, row);
        return renderer;
    }

    protected void patchIcon(JTree tree, DefaultTreeCellRenderer renderer, boolean leaf, boolean expanded) {
        Icon icon = leaf ? renderer.getLeafIcon() : (expanded ? renderer.getOpenIcon() : renderer.getClosedIcon());
        renderer.setIcon(icon);
        LookAndFeel laf = UIManager.getLookAndFeel();
        Icon disabledIcon = laf.getDisabledIcon(tree, icon);
        if (disabledIcon != null) {
            icon = disabledIcon;
        }
        renderer.setDisabledIcon(icon);
    }

    protected Component prepareRendererComponent(JTree tree, Component comp) {
        this.rendererComponent.setComponentOrientation(tree.getComponentOrientation());
        comp.setComponentOrientation(tree.getComponentOrientation());
        comp.setFont(tree.getFont());
        this.rendererComponent.setRenderer(this);
        this.rendererComponent.setRenderComponent(comp);
        return this.rendererComponent;
    }

    public static Object unwrapValue(Object value) {
        Object val = value;
        if (val instanceof DefaultMutableTreeNode) {
            val = ((DefaultMutableTreeNode)val).getUserObject();
        }
        return val;
    }

    protected static boolean isBooleanRenderingEnabled(JTree tree) {
        return PropertyUtil.getBooleanProperty((JComponent)tree, (String)"JTree.renderBooleanAsCheckBox");
    }

    protected DarkBooleanCellRenderer getBooleanRenderer() {
        return this.booleanRenderer;
    }

    protected ComponentBasedTreeCellRenderer getTristateRenderer() {
        return this.tristateRenderer;
    }

    @Override
    public Icon getIcon() {
        return this.getDelegate() instanceof JLabel ? ((JLabel)((Object)this.getDelegate())).getIcon() : null;
    }

    @Override
    public int getIconTextGap() {
        return this.getDelegate() instanceof JLabel ? ((JLabel)((Object)this.getDelegate())).getIconTextGap() : 0;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getDelegate() instanceof JComponent ? ((JComponent)((Object)this.getDelegate())).getPreferredSize() : null;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getDelegate() instanceof JComponent ? ((JComponent)((Object)this.getDelegate())).getMinimumSize() : null;
    }
}

