/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties.color;

import com.github.weisj.darklaf.properties.color.DarkColorModel;
import com.github.weisj.darklaf.properties.color.DarkColorModelHSL;
import com.github.weisj.darklaf.util.LazyValue;
import java.awt.Color;

public class DarkColorModelCMYK
extends DarkColorModel {
    private static final int[] cmyk = new int[4];
    private static final int[] rgb = new int[3];
    private static final LazyValue<DarkColorModelCMYK> instance = new LazyValue(DarkColorModelCMYK::new);

    public static DarkColorModelCMYK getInstance() {
        return (DarkColorModelCMYK)instance.get();
    }

    public DarkColorModelCMYK() {
        super("cmyk", "Cyan", "Magenta", "Yellow", "Black");
    }

    @Override
    public int getMinimum(int index) {
        return 0;
    }

    @Override
    public int getMaximum(int index) {
        return 100;
    }

    @Override
    public String toString() {
        return "CMYK";
    }

    @Override
    public String[] getLabelDescriptorsBefore() {
        return new String[]{"C", "M", "Y", "K"};
    }

    @Override
    public String[] getLabelDescriptorsAfter() {
        return new String[]{"%", "%", "%", "%"};
    }

    @Override
    public int[] getValuesFromColor(Color color) {
        return DarkColorModelCMYK.RGBtoCMYK(color.getRed(), color.getGreen(), color.getBlue());
    }

    private static int[] RGBtoCMYK(int r, int g, int b) {
        double max = DarkColorModelHSL.max((double)r / 255.0, (double)g / 255.0, (double)b / 255.0);
        if (max > 0.0) {
            DarkColorModelCMYK.cmyk[0] = (int)Math.round((1.0 - (double)r / 255.0 / max) * 100.0);
            DarkColorModelCMYK.cmyk[1] = (int)Math.round((1.0 - (double)g / 255.0 / max) * 100.0);
            DarkColorModelCMYK.cmyk[2] = (int)Math.round((1.0 - (double)b / 255.0 / max) * 100.0);
        } else {
            DarkColorModelCMYK.cmyk[0] = 0;
            DarkColorModelCMYK.cmyk[1] = 0;
            DarkColorModelCMYK.cmyk[2] = 0;
        }
        DarkColorModelCMYK.cmyk[3] = (int)Math.round((1.0 - max) * 100.0);
        return cmyk;
    }

    @Override
    public Color getColorFromValues(int[] values) {
        int[] rgb = DarkColorModelCMYK.CMYKtoRGB((double)values[0] / 100.0, (double)values[1] / 100.0, (double)values[2] / 100.0, (double)values[3] / 100.0);
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    private static int[] CMYKtoRGB(double c, double m, double y, double k) {
        DarkColorModelCMYK.rgb[0] = (int)Math.round(255.0 * (1.0 - c) * (1.0 - k));
        DarkColorModelCMYK.rgb[1] = (int)Math.round(255.0 * (1.0 - m) * (1.0 - k));
        DarkColorModelCMYK.rgb[2] = (int)Math.round(255.0 * (1.0 - y) * (1.0 - k));
        return rgb;
    }
}

