/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties.icons;

import com.github.weisj.darklaf.properties.icons.AwareIconStyle;
import com.github.weisj.darklaf.properties.icons.IconLoader;
import com.github.weisj.darklaf.properties.icons.UIAwareIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.plaf.UIResource;

public class DarkUIAwareIcon
implements UIAwareIcon,
UIResource,
IconLoader.CacheableIcon,
Serializable {
    private final DarkUIAwareIcon dual;
    protected final String darkKey;
    protected final String lightKey;
    protected final int w;
    protected final int h;
    protected final Class<?> parentClass;
    protected transient boolean loaded;
    protected transient Icon icon;
    private AwareIconStyle currentStyle;
    private IconLoader.IconKey cacheKey;

    public DarkUIAwareIcon(String darkKey, String lightKey, int w, int h, Class<?> parentClass) {
        this.darkKey = darkKey;
        this.lightKey = lightKey;
        this.w = w;
        this.h = h;
        this.parentClass = parentClass;
        this.dual = new DarkUIAwareIcon(this);
    }

    private DarkUIAwareIcon(DarkUIAwareIcon dual) {
        this.darkKey = dual.lightKey;
        this.lightKey = dual.darkKey;
        this.dual = dual;
        this.w = dual.w;
        this.h = dual.h;
        this.parentClass = dual.parentClass;
    }

    public void paintIcon(Component c, Graphics g2, int x, int y, double scale) {
        this.ensureLoaded();
        Graphics2D g = (Graphics2D)g2.create();
        g.translate(x, y);
        g.scale(scale, scale);
        this.icon.paintIcon(c, g, 0, 0);
        g2.dispose();
    }

    protected void ensureLoaded() {
        if (!this.isLoaded()) {
            this.updateStyle();
            this.loadIcon();
        }
    }

    protected void updateStyle() {
        this.currentStyle = IconLoader.getAwareStyle();
    }

    protected boolean isLoaded() {
        return this.loaded && this.currentStyle == IconLoader.getAwareStyle();
    }

    public boolean isDark() {
        return this.currentStyle == AwareIconStyle.DARK;
    }

    protected void loadIcon() {
        this.icon = this.isDark() ? IconLoader.get(this.parentClass).getIcon(this.darkKey, this.w, this.h) : IconLoader.get(this.parentClass).getIcon(this.lightKey, this.w, this.h);
        this.loaded = true;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.ensureLoaded();
        this.icon.paintIcon(c, g, x, y);
    }

    @Override
    public int getIconWidth() {
        this.ensureLoaded();
        return this.icon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        this.ensureLoaded();
        return this.icon.getIconHeight();
    }

    @Override
    public DarkUIAwareIcon getDual() {
        return this.dual;
    }

    public void setCacheKey(IconLoader.IconKey key) {
        this.cacheKey = key;
    }

    IconLoader.IconKey getCacheKey() {
        return this.cacheKey;
    }
}

