/*
 * Decompiled with CFR 0.152.
 */
package org.hid4java;

import java.util.List;
import org.hid4java.HidDevice;
import org.hid4java.HidDeviceManager;
import org.hid4java.HidException;
import org.hid4java.HidServicesListener;
import org.hid4java.HidServicesSpecification;
import org.hid4java.event.HidServicesListenerList;
import org.hid4java.jna.HidApi;

public class HidServices {
    private final HidServicesListenerList listeners = new HidServicesListenerList();
    private final HidDeviceManager hidDeviceManager;

    public HidServices() throws HidException {
        this(new HidServicesSpecification());
    }

    public HidServices(HidServicesSpecification hidServicesSpecification) {
        this.hidDeviceManager = new HidDeviceManager(this.listeners, hidServicesSpecification);
        this.hidDeviceManager.start();
        if (hidServicesSpecification.isAutoShutdown()) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    HidServices.this.shutdown();
                }
            });
        }
    }

    public void shutdown() {
        this.stop();
        try {
            HidApi.exit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void stop() {
        this.hidDeviceManager.stop();
    }

    public void start() {
        this.hidDeviceManager.start();
    }

    public void addHidServicesListener(HidServicesListener listener) {
        this.listeners.add(listener);
    }

    public void removeUsbServicesListener(HidServicesListener listener) {
        this.listeners.remove(listener);
    }

    public void scan() {
        this.hidDeviceManager.scan();
    }

    public List<HidDevice> getAttachedHidDevices() {
        return this.hidDeviceManager.getAttachedHidDevices();
    }

    public HidDevice getHidDevice(int vendorId, int productId, String serialNumber) {
        List<HidDevice> devices = this.hidDeviceManager.getAttachedHidDevices();
        for (HidDevice device : devices) {
            if (!device.isVidPidSerial(vendorId, productId, serialNumber)) continue;
            device.open();
            return device;
        }
        return null;
    }
}

