/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.core;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.core.BidibMessageProcessor;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.message.BidibRequestFactory;
import org.bidib.jbidibc.core.message.BidibRequestFactoryMessageMapInitializer;
import org.bidib.jbidibc.core.node.AccessoryNode;
import org.bidib.jbidibc.core.node.BidibNode;
import org.bidib.jbidibc.core.node.BoosterNode;
import org.bidib.jbidibc.core.node.CommandStationNode;
import org.bidib.jbidibc.core.node.InterfaceNode;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.core.node.RootNode;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.MessageReceiver;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.base.AbstractBaseBidib;
import org.bidib.jbidibc.messages.base.ConnectionStatusListener;
import org.bidib.jbidibc.messages.base.DataTransferStatusListener;
import org.bidib.jbidibc.messages.base.RawMessageListener;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBidib<MR extends MessageReceiver>
implements BidibInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBidib.class);
    private static final Logger MSG_RX_LOGGER = LoggerFactory.getLogger((String)"RX");
    private int responseTimeout = 400;
    private int firmwarePacketTimeout = 400;
    private MR messageReceiver;
    private NodeRegistry nodeRegistry;
    private org.bidib.jbidibc.messages.message.BidibRequestFactory requestFactory;
    private ConnectionListener connectionListener;
    private Set<TransferListener> transferListeners = new HashSet<TransferListener>();
    private RawMessageListener rawMessageListener;
    private Set<RawMessageListener> rawMessageListeners = new HashSet<RawMessageListener>();
    protected final ScheduledExecutorService serviceWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("bidibServiceWorkers-thread-%d").build());
    private final AtomicBoolean cleanupAfterCloseCalled = new AtomicBoolean();

    protected AbstractBidib() {
    }

    protected boolean isNetBidib() {
        return false;
    }

    public void initialize(Context context) {
        LOGGER.info("Initialize AbstractBidib, create a NodeRegistry. Current context: {}", (Object)context);
        this.nodeRegistry = new NodeRegistry(this.isNetBidib());
        LOGGER.info("Created nodeRegistry: {}", (Object)this.nodeRegistry);
        this.nodeRegistry.setBidib(this);
        this.requestFactory = this.createRequestFactory();
        this.nodeRegistry.setRequestFactory(this.requestFactory);
        this.requestFactory.initialize();
        if (!this.requestFactory.isMessageTypesLoaded()) {
            BidibRequestFactoryMessageMapInitializer.loadMessageTypeMap(this.requestFactory);
        }
        this.rawMessageListener = new RawMessageListener(){

            public void notifySend(byte[] data) {
                AbstractBidib.this.fireNotifySendRawMessage(data);
            }

            public void notifyReceived(byte[] data) {
                AbstractBidib.this.fireNotifyReceivedRawMessage(data);
            }
        };
        this.messageReceiver = this.createMessageReceiver(this.nodeRegistry, this.rawMessageListener, context);
    }

    protected org.bidib.jbidibc.messages.message.BidibRequestFactory createRequestFactory() {
        return new BidibRequestFactory();
    }

    protected org.bidib.jbidibc.messages.message.BidibRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public MR getMessageReceiver() {
        return this.messageReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupAfterClose(MessageReceiver messageReceiver) {
        LOGGER.info("Cleanup after close. Clear the transfer listeners and cleanup message receiver. Current cleanupAfterCloseCalled: {}", (Object)this.cleanupAfterCloseCalled);
        AtomicBoolean atomicBoolean = this.cleanupAfterCloseCalled;
        synchronized (atomicBoolean) {
            if (this.cleanupAfterCloseCalled.get()) {
                LOGGER.info("Skip more cleanup calls.");
                return;
            }
            this.cleanupAfterCloseCalled.set(true);
        }
        this.releaseRootNode();
        this.transferListeners.clear();
        if (messageReceiver != null) {
            LOGGER.info("Cleanup the message receiver: {}", (Object)messageReceiver);
            try {
                messageReceiver.cleanup();
            }
            catch (Exception ex) {
                LOGGER.warn("Cleanup the message receiver failed.", (Throwable)ex);
            }
        }
        if (!this.serviceWorker.isShutdown()) {
            LOGGER.info("Shutdown the service worker.");
            try {
                this.serviceWorker.shutdown();
                this.serviceWorker.awaitTermination(2000L, TimeUnit.MILLISECONDS);
                LOGGER.info("Shutdown the service worker passed.");
            }
            catch (Exception ex) {
                LOGGER.warn("Shutdown the service worker failed.", (Throwable)ex);
            }
        } else {
            LOGGER.info("The service worker is shutdown already.");
        }
        if (this.nodeRegistry != null) {
            this.nodeRegistry.shutdown();
        }
    }

    protected abstract MR createMessageReceiver(NodeRegistry var1, RawMessageListener var2, Context var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRawMessageListener(RawMessageListener rawMessageListener) {
        Set<RawMessageListener> set = this.rawMessageListeners;
        synchronized (set) {
            this.rawMessageListeners.add(rawMessageListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRawMessageListener(RawMessageListener rawMessageListener) {
        Set<RawMessageListener> set = this.rawMessageListeners;
        synchronized (set) {
            this.rawMessageListeners.remove(rawMessageListener);
        }
    }

    public void registerListeners(Set<NodeListener> nodeListeners, Set<MessageListener> messageListeners, Set<TransferListener> transferListeners) {
        if (this.getMessageReceiver() instanceof BidibMessageProcessor) {
            BidibMessageProcessor bidibMessageProcessor = (BidibMessageProcessor)this.getMessageReceiver();
            if (CollectionUtils.isNotEmpty(nodeListeners)) {
                for (NodeListener nodeListener : nodeListeners) {
                    bidibMessageProcessor.addNodeListener(nodeListener);
                }
            }
            if (CollectionUtils.isNotEmpty(messageListeners)) {
                for (MessageListener messageListener : messageListeners) {
                    bidibMessageProcessor.addMessageListener(messageListener);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(transferListeners)) {
            LOGGER.info("Add the transfer listeners to the root node.");
            this.transferListeners.addAll(transferListeners);
        } else {
            LOGGER.warn("No transfer listeners available!");
        }
    }

    protected void initializeConnector(final AbstractBaseBidib<MR> connector) {
        final Logger loggerConnector = LoggerFactory.getLogger(connector.getClass());
        org.bidib.jbidibc.messages.logger.Logger connectorLogger = new org.bidib.jbidibc.messages.logger.Logger(){

            public void debug(String format, Object ... arguments) {
                loggerConnector.debug(format, arguments);
            }

            public void info(String format, Object ... arguments) {
                loggerConnector.info(format, arguments);
            }

            public void warn(String format, Object ... arguments) {
                loggerConnector.warn(format, arguments);
            }

            public void error(String format, Object ... arguments) {
                loggerConnector.error(format, arguments);
            }
        };
        connector.setLogger(connectorLogger);
        final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"RAW");
        org.bidib.jbidibc.messages.logger.Logger rawLogger = new org.bidib.jbidibc.messages.logger.Logger(){

            public void debug(String format, Object ... arguments) {
                MSG_RAW_LOGGER.debug(format, arguments);
            }

            public void info(String format, Object ... arguments) {
                MSG_RAW_LOGGER.info(format, arguments);
            }

            public void warn(String format, Object ... arguments) {
                MSG_RAW_LOGGER.warn(format, arguments);
            }

            public void error(String format, Object ... arguments) {
                MSG_RAW_LOGGER.error(format, arguments);
            }
        };
        connector.setLoggerRAW(rawLogger);
        connector.setDataTransferStatusListener(new DataTransferStatusListener(){

            public void notifySendStarted() {
                AbstractBidib.this.fireSendStarted();
            }

            public void notifySendStopped() {
                AbstractBidib.this.fireSendStopped();
            }

            public void notifyReceiveStarted() {
                AbstractBidib.this.fireReceiveStarted();
            }

            public void notifyReceiveStopped() {
                AbstractBidib.this.fireReceiveStopped();
            }
        });
        connector.setConnectionStatusListener(new ConnectionStatusListener(){

            public void notifyOpened() {
                LOGGER.info("The port was opened. Contact the interface.");
                try {
                    AbstractBidib.this.contactInterface();
                }
                catch (RuntimeException ex) {
                    LOGGER.warn("Contact interface failed. Abort signal opened.", (Throwable)ex);
                    throw ex;
                }
                AbstractBidib.this.fireConnectionOpened(connector.getConnectedPortName().orElse(null));
            }

            public void notifyClosed() {
                AbstractBidib.this.fireConnectionClosed(connector.getConnectedPortName().orElse(null));
            }
        });
        connector.setRawMessageListener(this.rawMessageListener);
        connector.initialize();
    }

    @Override
    public BidibMessageProcessor getBidibMessageProcessor() {
        if (this.getMessageReceiver() instanceof BidibMessageProcessor) {
            BidibMessageProcessor bidibMessageProcessor = (BidibMessageProcessor)this.getMessageReceiver();
            return bidibMessageProcessor;
        }
        return null;
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public void setConnectionListener(ConnectionListener connectionListener) {
        LOGGER.info("Set the connection listener: {}", (Object)connectionListener);
        this.connectionListener = connectionListener;
    }

    protected NodeRegistry getNodeRegistry() {
        return this.nodeRegistry;
    }

    @Override
    public void close() {
        this.terminateAllNodes();
    }

    protected abstract int contactInterface();

    @Override
    public AccessoryNode getAccessoryNode(Node node) {
        return this.nodeRegistry.getAccessoryNode(node.getAddr());
    }

    @Override
    public BoosterNode getBoosterNode(Node node) {
        return this.nodeRegistry.getBoosterNode(node);
    }

    @Override
    public CommandStationNode getCommandStationNode(Node node) {
        return this.nodeRegistry.getCommandStationNode(node);
    }

    @Override
    public BidibNode getNode(Node node) {
        return this.nodeRegistry.getNode(node);
    }

    @Override
    public InterfaceNode getInterfaceNode(Node node) {
        return this.nodeRegistry.getInterfaceNode(node);
    }

    @Override
    public boolean isValidCoreNode(Node node) {
        return this.nodeRegistry.findNode(node.getAddr()) != null;
    }

    @Override
    public BidibNode findNode(byte[] nodeAddress) {
        return this.nodeRegistry.findNode(nodeAddress);
    }

    @Override
    public RootNode getRootNode() {
        return this.nodeRegistry.getRootNode();
    }

    @Override
    public void releaseRootNode() {
        LOGGER.info("Release the root node.");
        this.stopLocalPingWorker();
        if (this.getNodeRegistry() != null) {
            this.getNodeRegistry().reset(false);
        }
    }

    private void stopLocalPingWorker() {
        try {
            RootNode rootNode = this.getRootNode();
            if (rootNode != null) {
                LOGGER.info("Stop the local ping worker on the rootNode.");
                rootNode.stopLocalPingWorker();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Stop the local ping worker failed.", (Throwable)ex);
        }
    }

    @Override
    public void releaseSubNodesOfRootNode() {
        LOGGER.info("Release the subNodes of the root node.");
        this.stopLocalPingWorker();
        if (this.getNodeRegistry() != null) {
            this.getNodeRegistry().reset(true);
        }
    }

    @Override
    public void setIgnoreWaitTimeout(boolean ignoreWaitTimeout) {
        if (this.nodeRegistry != null) {
            LOGGER.info("Set ignoreWaitTimeout flag: {}", (Object)ignoreWaitTimeout);
            this.nodeRegistry.setIgnoreWaitTimeout(ignoreWaitTimeout);
        } else {
            LOGGER.warn("The node factory is not available, set the ignoreWaitTimeout is discarded.");
        }
    }

    @Override
    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    @Override
    public void setResponseTimeout(int responseTimeout) {
        LOGGER.info("Set the response timeout: {}", (Object)responseTimeout);
        this.responseTimeout = responseTimeout;
    }

    @Override
    public void setFirmwarePacketTimeout(int firmwarePacketTimeout) {
        LOGGER.info("Set the firmware packet timeout: {}", (Object)firmwarePacketTimeout);
        this.firmwarePacketTimeout = firmwarePacketTimeout;
    }

    @Override
    public int getFirmwarePacketTimeout() {
        return this.firmwarePacketTimeout;
    }

    @Override
    public void attach(Long uniqueId) {
        LOGGER.info("Attach the node, uniqueId: {}", (Object)uniqueId);
        try {
            RootNode rootNode = this.getRootNode();
            if (rootNode != null) {
                LOGGER.info("Get the magic from the rootNode.");
                rootNode.getMagic(null);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Get the magic from the rootNode failed.", (Throwable)ex);
        }
    }

    @Override
    public void detach(Long uniqueId) {
        LOGGER.info("Detach the node, uniqueId: {}", (Object)uniqueId);
        try {
            RootNode rootNode = this.getRootNode();
            if (rootNode != null) {
                LOGGER.info("Logoff from root node, uniqueId: {}", (Object)uniqueId);
                this.getRootNode().localLogonRejected(uniqueId);
                LOGGER.info("Reset the nodeRegistry but keep the root node.");
                this.getNodeRegistry().reset(true);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Logoff from the rootNode failed.", (Throwable)ex);
        }
    }

    protected void fireSendStarted() {
        for (TransferListener l : this.transferListeners) {
            l.sendStarted();
        }
    }

    protected void fireSendStopped() {
        for (TransferListener l : this.transferListeners) {
            l.sendStopped();
        }
    }

    protected void fireReceiveStarted() {
        for (TransferListener l : this.transferListeners) {
            l.receiveStarted();
        }
    }

    protected void fireReceiveStopped() {
        for (TransferListener l : this.transferListeners) {
            l.receiveStopped();
        }
    }

    protected void fireCtsChanged(boolean cts, boolean manualEvent) {
        LOGGER.info("Signal the changed CTS value: {}, manualEvent: {}", (Object)cts, (Object)manualEvent);
        MSG_RX_LOGGER.info("<< CTS changed, ready: {}", (Object)cts);
        for (TransferListener l : this.transferListeners) {
            l.ctsChanged(cts, manualEvent);
        }
        if (this.connectionListener != null) {
            boolean stall = !cts;
            this.serviceWorker.submit(() -> this.connectionListener.stall(stall));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireNotifyReceivedRawMessage(byte[] data) {
        Set<RawMessageListener> set = this.rawMessageListeners;
        synchronized (set) {
            for (RawMessageListener l : this.rawMessageListeners) {
                l.notifyReceived(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireNotifySendRawMessage(byte[] data) {
        Set<RawMessageListener> set = this.rawMessageListeners;
        synchronized (set) {
            for (RawMessageListener l : this.rawMessageListeners) {
                l.notifySend(data);
            }
        }
    }

    protected void fireConnectionOpened(String port) {
        LOGGER.info("Signal the connection was opened, port: {}", (Object)port);
        if (this.connectionListener != null) {
            this.serviceWorker.submit(() -> this.connectionListener.opened(port));
        } else {
            LOGGER.warn("No connectionListener available to signal connection was opened, port: {}", (Object)port);
        }
    }

    protected void fireConnectionClosed(String port) {
        LOGGER.info("Signal the connection was closed, port: {}", (Object)port);
        if (!this.hasMoreRetryAvailable()) {
            if (this.connectionListener != null) {
                this.serviceWorker.submit(() -> this.connectionListener.closed(port));
            } else {
                LOGGER.warn("No connectionListener available to signal connection was closed, port: {}", (Object)port);
            }
        } else {
            LOGGER.info("Do not signal the connection was closed because more retry is available.");
        }
    }

    protected boolean hasMoreRetryAvailable() {
        return false;
    }

    @Override
    public void signalUserAction(String actionKey, Context context) {
    }

    protected void terminateAllNodes() {
        LOGGER.info("Terminate all nodes.");
        try {
            NodeRegistry nodeRegistry = this.getNodeRegistry();
            if (nodeRegistry != null) {
                nodeRegistry.terminateAllNodes();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Terminate all nodes failed.", (Throwable)ex);
        }
    }
}

