/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.core;

import java.io.ByteArrayOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bidib.jbidibc.core.AbstractRawMessageReceiver;
import org.bidib.jbidibc.core.BidibDistributedMessageListener;
import org.bidib.jbidibc.core.BidibMessageProcessor;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.MessageParser;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.PlainMessageParser;
import org.bidib.jbidibc.core.node.AccessoryNode;
import org.bidib.jbidibc.core.node.BidibNode;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.messages.AccessoryState;
import org.bidib.jbidibc.messages.AccessoryStateOptions;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.DccAInfoIndexedString;
import org.bidib.jbidibc.messages.DccAInfoShortGui;
import org.bidib.jbidibc.messages.DccAInfoShortInfo;
import org.bidib.jbidibc.messages.DccATidData;
import org.bidib.jbidibc.messages.DecoderIdAddressData;
import org.bidib.jbidibc.messages.DecoderUniqueIdData;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.FirmwareUpdateStat;
import org.bidib.jbidibc.messages.LcConfig;
import org.bidib.jbidibc.messages.LcConfigX;
import org.bidib.jbidibc.messages.LcMacroParaValue;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.RcPlusDecoderAnswerData;
import org.bidib.jbidibc.messages.RcPlusFeedbackBindData;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.StringData;
import org.bidib.jbidibc.messages.TidData;
import org.bidib.jbidibc.messages.VendorData;
import org.bidib.jbidibc.messages.enums.BoosterControl;
import org.bidib.jbidibc.messages.enums.BoosterState;
import org.bidib.jbidibc.messages.enums.CommandStationProgState;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.enums.DccAdvAcknowledge;
import org.bidib.jbidibc.messages.enums.DccAdvOpCodesAck;
import org.bidib.jbidibc.messages.enums.IdentifyState;
import org.bidib.jbidibc.messages.enums.LcMacroState;
import org.bidib.jbidibc.messages.enums.M4OpCodesAck;
import org.bidib.jbidibc.messages.enums.OccupationState;
import org.bidib.jbidibc.messages.enums.RcPlusAcknowledge;
import org.bidib.jbidibc.messages.enums.RcPlusDecoderType;
import org.bidib.jbidibc.messages.enums.RcPlusPhase;
import org.bidib.jbidibc.messages.exception.NodeAlreadyRegisteredException;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.logger.Logger;
import org.bidib.jbidibc.messages.message.AccessoryNotifyResponse;
import org.bidib.jbidibc.messages.message.AccessoryParaResponse;
import org.bidib.jbidibc.messages.message.AccessoryStateResponse;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BoostDiagnosticResponse;
import org.bidib.jbidibc.messages.message.BoostStatResponse;
import org.bidib.jbidibc.messages.message.CommandStationAccessoryAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationAccessoryManualResponse;
import org.bidib.jbidibc.messages.message.CommandStationDccAdvAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationDriveAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationDriveManualResponse;
import org.bidib.jbidibc.messages.message.CommandStationDriveStateResponse;
import org.bidib.jbidibc.messages.message.CommandStationM4AcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationPomAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationProgStateResponse;
import org.bidib.jbidibc.messages.message.CommandStationRcPlusAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationStateResponse;
import org.bidib.jbidibc.messages.message.FeatureCountResponse;
import org.bidib.jbidibc.messages.message.FeatureNotAvailableResponse;
import org.bidib.jbidibc.messages.message.FeatureResponse;
import org.bidib.jbidibc.messages.message.FeedbackAccessoryResponse;
import org.bidib.jbidibc.messages.message.FeedbackAddressResponse;
import org.bidib.jbidibc.messages.message.FeedbackConfidenceResponse;
import org.bidib.jbidibc.messages.message.FeedbackCvResponse;
import org.bidib.jbidibc.messages.message.FeedbackDccAResponse;
import org.bidib.jbidibc.messages.message.FeedbackDynStateResponse;
import org.bidib.jbidibc.messages.message.FeedbackExtResponse;
import org.bidib.jbidibc.messages.message.FeedbackFreeResponse;
import org.bidib.jbidibc.messages.message.FeedbackMultipleResponse;
import org.bidib.jbidibc.messages.message.FeedbackOccupiedResponse;
import org.bidib.jbidibc.messages.message.FeedbackPositionResponse;
import org.bidib.jbidibc.messages.message.FeedbackRcPlusResponse;
import org.bidib.jbidibc.messages.message.FeedbackSpeedResponse;
import org.bidib.jbidibc.messages.message.FeedbackXPomResponse;
import org.bidib.jbidibc.messages.message.FwUpdateStatResponse;
import org.bidib.jbidibc.messages.message.LcConfigResponse;
import org.bidib.jbidibc.messages.message.LcConfigXResponse;
import org.bidib.jbidibc.messages.message.LcKeyResponse;
import org.bidib.jbidibc.messages.message.LcMacroParaResponse;
import org.bidib.jbidibc.messages.message.LcMacroResponse;
import org.bidib.jbidibc.messages.message.LcMacroStateResponse;
import org.bidib.jbidibc.messages.message.LcNotAvailableResponse;
import org.bidib.jbidibc.messages.message.LcStatResponse;
import org.bidib.jbidibc.messages.message.LcWaitResponse;
import org.bidib.jbidibc.messages.message.LocalBidibUpResponse;
import org.bidib.jbidibc.messages.message.LocalLogoffMessage;
import org.bidib.jbidibc.messages.message.LocalLogonAckMessage;
import org.bidib.jbidibc.messages.message.NodeLostResponse;
import org.bidib.jbidibc.messages.message.NodeNewResponse;
import org.bidib.jbidibc.messages.message.NodeTabCountResponse;
import org.bidib.jbidibc.messages.message.NodeTabResponse;
import org.bidib.jbidibc.messages.message.ResponseFactory;
import org.bidib.jbidibc.messages.message.StallResponse;
import org.bidib.jbidibc.messages.message.StringResponse;
import org.bidib.jbidibc.messages.message.SysErrorResponse;
import org.bidib.jbidibc.messages.message.SysIdentifyStateResponse;
import org.bidib.jbidibc.messages.message.SysMagicResponse;
import org.bidib.jbidibc.messages.message.SysPVersionResponse;
import org.bidib.jbidibc.messages.message.SysPongResponse;
import org.bidib.jbidibc.messages.message.SysSwVersionResponse;
import org.bidib.jbidibc.messages.message.SysUniqueIdResponse;
import org.bidib.jbidibc.messages.message.VendorAckResponse;
import org.bidib.jbidibc.messages.message.VendorResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.CollectionUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageReceiver
extends AbstractRawMessageReceiver
implements BidibMessageProcessor {
    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(AbstractMessageReceiver.class);
    protected static final org.slf4j.Logger MSG_RX_LOGGER = LoggerFactory.getLogger((String)"RX");
    protected static final org.slf4j.Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"RAW");
    private static final org.slf4j.Logger LOGGER_NODE = LoggerFactory.getLogger(Node.class);
    private final Logger nodeLogger;
    private final Set<MessageListener> messageListeners = new LinkedHashSet<MessageListener>();
    private final Collection<NodeListener> nodeListeners = Collections.synchronizedList(new LinkedList());
    private NodeRegistry nodeRegistry;
    private final ResponseFactory responseFactory;
    private MessageParser messageParser;
    private BidibDistributedMessageListener bidibDistributedMessageListener;

    public AbstractMessageReceiver(NodeRegistry nodeRegistry, ResponseFactory responseFactory, boolean checkCRC) {
        super(checkCRC);
        this.nodeRegistry = nodeRegistry;
        this.nodeRegistry.setMessageReceiver(this);
        this.responseFactory = responseFactory;
        this.nodeLogger = new Logger(){

            public void debug(String format, Object ... arguments) {
                LOGGER_NODE.debug(format, arguments);
            }

            public void info(String format, Object ... arguments) {
                LOGGER_NODE.info(format, arguments);
            }

            public void warn(String format, Object ... arguments) {
                LOGGER_NODE.warn(format, arguments);
            }

            public void error(String format, Object ... arguments) {
                LOGGER_NODE.error(format, arguments);
            }
        };
    }

    @Override
    public void init(Context context) {
        this.messageParser = this.createMessageParser();
        super.init(context);
        BidibDistributedMessageListener bidibDistributedMessageListener = (BidibDistributedMessageListener)context.get(BidibDistributedMessageListener.class.getSimpleName(), BidibDistributedMessageListener.class, null);
        if (bidibDistributedMessageListener != null) {
            LOGGER.info("The bidibDistributedMessageListener is provided in the context and is injected: {}", (Object)bidibDistributedMessageListener);
            this.setBidibDistributedMessageListener(bidibDistributedMessageListener);
        }
    }

    @Override
    public void cleanup() {
        LOGGER.info("Cleanup is called, bidibDistributedMessageListener: {}", (Object)this.bidibDistributedMessageListener);
        super.cleanup();
        if (this.bidibDistributedMessageListener != null) {
            try {
                this.bidibDistributedMessageListener.shutdown();
                LOGGER.info("Release the bidibDistributedMessageListener: {}", (Object)this.bidibDistributedMessageListener);
                this.bidibDistributedMessageListener = null;
            }
            catch (Exception ex) {
                LOGGER.warn("Shutdown the message listener failed.", (Throwable)ex);
            }
        }
    }

    protected MessageParser getMessageParser() {
        return this.messageParser;
    }

    protected void setBidibDistributedMessageListener(BidibDistributedMessageListener bidibDistributedMessageListener) {
        LOGGER.info("Set the bidibDistributedMessageListener instance: {}", (Object)bidibDistributedMessageListener);
        this.bidibDistributedMessageListener = bidibDistributedMessageListener;
    }

    @Override
    public void enable() {
        LOGGER.info("Enable is called.");
        MSG_RAW_LOGGER.info("++++ Enable the message receiver.");
        try {
            this.messageParser.reset();
        }
        catch (Exception ex) {
            LOGGER.warn("Reset buffered received data failed.", (Throwable)ex);
        }
        super.enable();
    }

    protected ResponseFactory getResponseFactory() {
        return this.responseFactory;
    }

    @Override
    public String getErrorInformation() {
        return null;
    }

    protected MessageParser createMessageParser() {
        LOGGER.info("Create the plain message parser.");
        PlainMessageParser messageParser = new PlainMessageParser();
        return messageParser;
    }

    @Override
    public void receive(ByteArrayOutputStream data) {
        if (!this.isEnabled()) {
            LOGGER.info("The receiver is not running. Skip processing of messages.");
            try {
                byte[] rawdata = data.toByteArray();
                LOGGER.info("Receiver is stopped, number of bytes read: {}, buffer: {}", (Object)rawdata.length, (Object)ByteUtils.bytesToHex((byte[])rawdata));
            }
            catch (Exception ex) {
                LOGGER.warn("Read data from input stream to buffer failed.", (Throwable)ex);
            }
            return;
        }
        MSG_RAW_LOGGER.info("<<<< start parse input: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)data));
        try {
            byte[] rawdata = data.toByteArray();
            this.parseInput(rawdata, rawdata.length);
        }
        catch (Exception e) {
            LOGGER.warn("Exception detected in message receiver!", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            MSG_RAW_LOGGER.info("<<<< finished parse input");
        }
    }

    protected void parseInput(byte[] receivedData, int len) throws ProtocolException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Parse input, len: {}, data: {}", (Object)len, (Object)ByteUtils.bytesToHex((byte[])receivedData));
        }
        this.messageParser.parseInput(this, receivedData, len);
    }

    @Override
    protected void processMessage(byte[] messageArray) throws ProtocolException {
        BidibMessageInterface message = null;
        try {
            message = this.responseFactory.create(messageArray);
            if (MSG_RX_LOGGER.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder("<< ");
                sb.append(message);
                sb.append(" : ");
                sb.append(ByteUtils.bytesToHex((byte[])messageArray));
                MSG_RX_LOGGER.info(sb.toString());
            }
            this.processMessage(message);
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Process received messages failed: {}", (Object)ByteUtils.bytesToHex((byte[])messageArray), (Object)ex);
            StringBuilder sb = new StringBuilder("<< received invalid: ");
            sb.append(message);
            sb.append(" : ");
            sb.append(ByteUtils.bytesToHex((byte[])messageArray));
            MSG_RX_LOGGER.warn(sb.toString());
            if (message != null) {
                this.publishInternalError(message.getAddr(), message.getNum(), "processMessage", sb.toString());
            }
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.warn("Process received messages failed: {}", (Object)ByteUtils.bytesToHex((byte[])messageArray), (Object)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processMessage(BidibMessageInterface message) throws ProtocolException {
        BidibNode bidibNode = null;
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Process message for addr: {}", (Object)NodeUtils.formatAddress((byte[])message.getAddr()));
            }
            bidibNode = this.nodeRegistry.findNode(message.getAddr());
            LOGGER.trace("Evaluate message.");
            this.evaluateMessage(bidibNode, message);
            LOGGER.trace("Evaluate message has finished.");
            if (message == null) return;
        }
        catch (ProtocolException ex) {
            try {
                LOGGER.warn("Process received messages failed: {}", (Object)message, (Object)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                if (message == null) throw throwable;
                if (bidibNode != null && (bidibNode.getNodeMagic() != null || message instanceof SysMagicResponse) && !message.isLocalMessage()) {
                    int numExpected = bidibNode.getNextReceiveMsgNum(message);
                    int numReceived = message.getNum();
                    LOGGER.trace("Compare the message numbers, expected: {}, received: {}", (Object)numExpected, (Object)numReceived);
                    if (numReceived == numExpected) throw throwable;
                    LOGGER.warn("Received unexpected message number for message: {}, expected: {}, node: {}", new Object[]{message, numExpected, bidibNode});
                    StringBuilder sb = new StringBuilder("<< Received unexpected message number: ");
                    sb.append(numReceived).append(", expected: ").append(numExpected);
                    sb.append(". Adjust the receive sequence number");
                    sb.append(". Message: ");
                    sb.append(message);
                    sb.append(" : ");
                    sb.append(ByteUtils.bytesToHex((byte[])message.getContent()));
                    MSG_RX_LOGGER.warn(sb.toString());
                    this.publishInternalError(message.getAddr(), message.getNum(), "ignoreWrongMessageNumber", sb.toString());
                    LOGGER.info("Unexpected receive message number is ignored due to preferences. The next expected number is adjusted to the received number: {}", (Object)numReceived);
                    bidibNode.adjustReceiveMsgNum(numReceived);
                    throw throwable;
                } else {
                    if (message.isLocalMessage()) throw throwable;
                    int numReceived = message.getNum();
                    LOGGER.warn("Ignore compare message number because the magic is not set on the node. Current received message number: {}, message: {}", (Object)numReceived, (Object)message);
                }
                throw throwable;
            }
        }
        if (bidibNode != null && (bidibNode.getNodeMagic() != null || message instanceof SysMagicResponse) && !message.isLocalMessage()) {
            int numExpected = bidibNode.getNextReceiveMsgNum(message);
            int numReceived = message.getNum();
            LOGGER.trace("Compare the message numbers, expected: {}, received: {}", (Object)numExpected, (Object)numReceived);
            if (numReceived == numExpected) return;
            LOGGER.warn("Received unexpected message number for message: {}, expected: {}, node: {}", new Object[]{message, numExpected, bidibNode});
            StringBuilder sb = new StringBuilder("<< Received unexpected message number: ");
            sb.append(numReceived).append(", expected: ").append(numExpected);
            sb.append(". Adjust the receive sequence number");
            sb.append(". Message: ");
            sb.append(message);
            sb.append(" : ");
            sb.append(ByteUtils.bytesToHex((byte[])message.getContent()));
            MSG_RX_LOGGER.warn(sb.toString());
            this.publishInternalError(message.getAddr(), message.getNum(), "ignoreWrongMessageNumber", sb.toString());
            LOGGER.info("Unexpected receive message number is ignored due to preferences. The next expected number is adjusted to the received number: {}", (Object)numReceived);
            bidibNode.adjustReceiveMsgNum(numReceived);
            return;
        } else {
            if (message.isLocalMessage()) return;
            int numReceived = message.getNum();
            LOGGER.warn("Ignore compare message number because the magic is not set on the node. Current received message number: {}, message: {}", (Object)numReceived, (Object)message);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluateMessage(BidibNode bidibNode, BidibMessageInterface message) throws ProtocolException {
        int type = ByteUtils.getInt((byte)message.getType());
        block3 : switch (type) {
            case 178: {
                BoostDiagnosticResponse diag = (BoostDiagnosticResponse)message;
                this.fireBoosterDiagnostic(message.getAddr(), message.getNum(), diag.getCurrent(), diag.getVoltage(), diag.getTemperature());
                break;
            }
            case 176: {
                this.fireBoosterState(message.getAddr(), message.getNum(), ((BoostStatResponse)message).getState(), ((BoostStatResponse)message).getControl());
                break;
            }
            case 163: {
                this.fireAddress(message.getAddr(), message.getNum(), ((FeedbackAddressResponse)message).getDetectorNumber(), ((FeedbackAddressResponse)message).getAddresses());
                break;
            }
            case 169: {
                this.fireConfidence(message.getAddr(), message.getNum(), ((FeedbackConfidenceResponse)message).getInvalid(), ((FeedbackConfidenceResponse)message).getFreeze(), ((FeedbackConfidenceResponse)message).getNoSignal());
                break;
            }
            case 161: {
                if (bidibNode != null && bidibNode.isSecureAckEnabled()) {
                    bidibNode.acknowledgeFree(((FeedbackFreeResponse)message).getDetectorNumber());
                    this.nodeRegistry.triggerPendingAcknowledge(bidibNode);
                }
                this.fireFree(message.getAddr(), message.getNum(), ((FeedbackFreeResponse)message).getDetectorNumber(), ((FeedbackFreeResponse)message).getTimestamp());
                break;
            }
            case 162: {
                int baseAddress = ((FeedbackMultipleResponse)message).getBaseAddress();
                int detectorCount = ((FeedbackMultipleResponse)message).getSize();
                byte[] detectorData = ((FeedbackMultipleResponse)message).getDetectorData();
                LOGGER.trace("Received FeedbackMultipleResponse, baseAddress: {}, detectorCount: {}, detectorData: {}", new Object[]{baseAddress, detectorCount, detectorData});
                if (bidibNode != null && bidibNode.isSecureAckEnabled()) {
                    bidibNode.acknowledgeMultiple(baseAddress, detectorCount, detectorData);
                    this.nodeRegistry.triggerPendingAcknowledge(bidibNode);
                }
                this.fireOccupancyMultiple(message.getAddr(), message.getNum(), baseAddress, detectorCount, detectorData);
                break;
            }
            case 160: {
                FeedbackOccupiedResponse feedbackOccupiedResponse = (FeedbackOccupiedResponse)message;
                if (bidibNode != null && bidibNode.isSecureAckEnabled()) {
                    bidibNode.acknowledgeOccupied(feedbackOccupiedResponse.getDetectorNumber());
                    this.nodeRegistry.triggerPendingAcknowledge(bidibNode);
                }
                this.fireOccupied(message.getAddr(), message.getNum(), feedbackOccupiedResponse.getDetectorNumber(), feedbackOccupiedResponse.getTimestamp());
                break;
            }
            case 172: {
                FeedbackPositionResponse feedbackPositionResponse = (FeedbackPositionResponse)message;
                if (bidibNode != null && bidibNode.isSecureAckEnabled()) {
                    bidibNode.acknowledgePosition(feedbackPositionResponse);
                    this.nodeRegistry.triggerPendingAcknowledge(bidibNode);
                }
                this.firePosition(feedbackPositionResponse.getAddr(), message.getNum(), feedbackPositionResponse.getDecoderAddress(), feedbackPositionResponse.getLocationType(), feedbackPositionResponse.getLocationAddress(), feedbackPositionResponse.getExtendedData());
                break;
            }
            case 166: {
                this.fireSpeed(message.getAddr(), message.getNum(), ((FeedbackSpeedResponse)message).getAddress(), ((FeedbackSpeedResponse)message).getSpeed());
                break;
            }
            case 170: {
                LOGGER.trace("Received MSG_BM_DYN_STATE: {}", (Object)message);
                this.fireDynState(message.getAddr(), message.getNum(), (FeedbackDynStateResponse)message);
                break;
            }
            case 185: {
                AccessoryParaResponse accessoryParaResponse = (AccessoryParaResponse)message;
                this.fireAccessoryPara(message.getAddr(), message.getNum(), accessoryParaResponse.getAccessoryNumber(), accessoryParaResponse.getParameter(), accessoryParaResponse.getValue());
                break;
            }
            case 184: {
                AccessoryStateResponse accessoryStateResponse = (AccessoryStateResponse)message;
                this.fireAccessoryState(message.getAddr(), message.getNum(), accessoryStateResponse.getAccessoryState(), accessoryStateResponse.getAccessoryStateOptions());
                break;
            }
            case 186: {
                AccessoryNotifyResponse accessoryNotifyResponse;
                AccessoryNode accessoryNode = this.nodeRegistry.getAccessoryNode(message.getAddr());
                if (accessoryNode != null) {
                    accessoryNotifyResponse = (AccessoryNotifyResponse)message;
                    if (accessoryNotifyResponse.getAccessoryState().getWait() == 0) {
                        accessoryNode.acknowledgeAccessoryNotify(accessoryNotifyResponse.getAccessoryState());
                        this.nodeRegistry.triggerPendingAcknowledge(bidibNode);
                    }
                } else {
                    LOGGER.warn("No accessory node available for node with address: {}", (Object)ByteUtils.bytesToHex((byte[])message.getAddr()));
                }
                accessoryNotifyResponse = (AccessoryNotifyResponse)message;
                this.fireAccessoryState(message.getAddr(), message.getNum(), accessoryNotifyResponse.getAccessoryState(), accessoryNotifyResponse.getAccessoryStateOptions());
                break;
            }
            case 201: {
                LcMacroResponse macroResponse = (LcMacroResponse)message;
                this.fireLcMacro(message.getAddr(), message.getNum(), macroResponse.getData());
                break;
            }
            case 202: {
                LcMacroParaResponse macroParaResponse = (LcMacroParaResponse)message;
                this.fireLcMacroPara(message.getAddr(), message.getNum(), macroParaResponse.getMacroNumber(), macroParaResponse.getParameterIndex(), macroParaResponse.getLcMacroParaValue());
                break;
            }
            case 200: {
                LcMacroStateResponse macroState = (LcMacroStateResponse)message;
                this.fireLcMacroState(message.getAddr(), message.getNum(), macroState.getMacroState());
                break;
            }
            case 195: {
                LcKeyResponse lcKeyResponse = (LcKeyResponse)message;
                this.fireKey(lcKeyResponse);
                break;
            }
            case 192: {
                LOGGER.trace("Received LcStatResponse: {}", (Object)message);
                LcStatResponse lcStatResponse = (LcStatResponse)message;
                this.fireLcStat(lcStatResponse);
                break;
            }
            case 196: {
                LOGGER.trace("Received LcWaitResponse: {}", (Object)message);
                LcWaitResponse lcWaitResponse = (LcWaitResponse)message;
                this.fireLcWait(lcWaitResponse);
                break;
            }
            case 194: {
                LOGGER.trace("Received LcConfigResponse: {}", (Object)message);
                LcConfigResponse lcConfigResponse = (LcConfigResponse)message;
                this.fireLcConfig(lcConfigResponse);
                break;
            }
            case 198: {
                LOGGER.trace("Received LcConfigXResponse: {}", (Object)message);
                LcConfigXResponse lcConfigXResponse = (LcConfigXResponse)message;
                this.fireLcConfigX(lcConfigXResponse);
                break;
            }
            case 193: {
                LOGGER.trace("Received LcNotAvailableResponse: {}", (Object)message);
                LcNotAvailableResponse lcNotAvailableResponse = (LcNotAvailableResponse)message;
                try {
                    if (bidibNode != null) {
                        this.fireLcNa(lcNotAvailableResponse);
                        break;
                    }
                    this.messageReceived(bidibNode, message);
                }
                catch (Exception ex) {
                    LOGGER.warn("Signal MSG_LC_NA failed.", (Throwable)ex);
                }
                break;
            }
            case 240: {
                break;
            }
            case 142: {
                LOGGER.warn("The node has sent the MSG_STALL: {}", (Object)bidibNode);
                this.fireStall((StallResponse)message);
                break;
            }
            case 141: {
                NodeNewResponse nodeNewResponse = (NodeNewResponse)message;
                Node node = nodeNewResponse.getNode(this.nodeLogger, message.getAddr());
                LOGGER.info("Send node changed acknowledge for nodetab version: {}", (Object)node.getVersion());
                boolean fireNodeNew = false;
                try {
                    if (bidibNode != null && bidibNode.isEnabled()) {
                        BidibNode newNode = this.nodeRegistry.createNode(node);
                        LOGGER.info("The node factory has registered the new node: {}", (Object)newNode);
                        fireNodeNew = true;
                    } else {
                        LOGGER.warn("The current node is not enabled. Skip signal the new node to the application: {}", (Object)node);
                    }
                }
                catch (NodeAlreadyRegisteredException ex) {
                    LOGGER.warn("The new node is already registered in the nodes list. Signal new node to application is skipped.", (Throwable)ex);
                }
                finally {
                    if (bidibNode != null) {
                        bidibNode.acknowledgeNodeChanged(node.getVersion());
                        this.nodeRegistry.triggerPendingAcknowledge(bidibNode);
                    } else {
                        LOGGER.warn("new node was not registered in node factory, addr: {}", (Object)message.getAddr());
                    }
                }
                if (!fireNodeNew) break;
                LOGGER.info("Signal new node in system to the application.");
                this.fireNodeNew(message.getAddr(), message.getNum(), node);
                break;
            }
            case 140: {
                NodeLostResponse nodeLostResponse = (NodeLostResponse)message;
                Node lostNode = nodeLostResponse.getNode(this.nodeLogger, message.getAddr());
                this.fireNodeLost(message.getAddr(), message.getNum(), lostNode);
                if (bidibNode != null) {
                    LOGGER.info("Acknowledge node lost on node: {}", (Object)bidibNode);
                    bidibNode.acknowledgeNodeChanged(nodeLostResponse.getNodeTabVersion());
                    this.nodeRegistry.triggerPendingAcknowledge(bidibNode);
                    break;
                }
                LOGGER.warn("Lost node was not registered in node factory, addr: {}", (Object)message.getAddr());
                break;
            }
            case 134: {
                SysErrorResponse errorResponse = (SysErrorResponse)message;
                switch (errorResponse.getErrorCode()) {
                    case 18: {
                        LOGGER.warn("A node attempted to register with an already registered ID: {}", (Object)errorResponse.getAddr());
                        this.fireError(message.getAddr(), message.getNum(), errorResponse.getErrorCode(), errorResponse.getReasonData());
                        break block3;
                    }
                }
                this.fireError(message.getAddr(), message.getNum(), errorResponse.getErrorCode(), errorResponse.getReasonData());
                break;
            }
            case 135: {
                this.fireSysIdentify(message.getAddr(), message.getNum(), ((SysIdentifyStateResponse)message).getState());
                break;
            }
            case 129: {
                this.fireSysMagic(message.getAddr(), message.getNum(), ((SysMagicResponse)message).getMagic());
                break;
            }
            case 133: {
                this.fireSysSoftwareVersion(message.getAddr(), message.getNum(), ((SysSwVersionResponse)message).getVersion());
                break;
            }
            case 131: {
                this.fireSysProtocolVersion(message.getAddr(), message.getNum(), ((SysPVersionResponse)message).getVersion());
                break;
            }
            case 130: {
                this.fireSysPong(message.getAddr(), message.getNum(), ((SysPongResponse)message).getMarker());
                break;
            }
            case 132: {
                this.fireSysUniqueId(message.getAddr(), message.getNum(), ((SysUniqueIdResponse)message).getUniqueId(), ((SysUniqueIdResponse)message).getConfigFingerPrint());
                break;
            }
            case 149: {
                StringResponse stringResponse = (StringResponse)message;
                this.fireNodeString(message.getAddr(), message.getNum(), stringResponse.getStringData());
                break;
            }
            case 167: {
                LOGGER.warn("MSG_BM_CURRENT is currently not processed by application: {}", (Object)message);
                break;
            }
            case 164: {
                this.fireBmAccessory(message.getAddr(), message.getNum(), ((FeedbackAccessoryResponse)message).getDetectorNumber(), ((FeedbackAccessoryResponse)message).getAddress());
                break;
            }
            case 165: {
                this.fireBmCv((FeedbackCvResponse)message);
                break;
            }
            case 168: {
                this.fireBmXPom((FeedbackXPomResponse)message);
                break;
            }
            case 171: {
                FeedbackExtResponse feedbackExtResponse = (FeedbackExtResponse)message;
                this.fireBmExt(feedbackExtResponse);
                break;
            }
            case 239: {
                CommandStationProgStateResponse commandStationProgStateResponse = (CommandStationProgStateResponse)message;
                this.fireCsProgState(message.getAddr(), message.getNum(), commandStationProgStateResponse.getState(), commandStationProgStateResponse.getRemainingTime(), commandStationProgStateResponse.getCvNumber(), commandStationProgStateResponse.getCvData());
                break;
            }
            case 225: {
                CommandStationStateResponse commandStationStateResponse = (CommandStationStateResponse)message;
                this.fireCsState(message.getAddr(), message.getNum(), commandStationStateResponse.getState());
                break;
            }
            case 228: {
                CommandStationPomAcknowledgeResponse commandStationPomAcknowledgeResponse = (CommandStationPomAcknowledgeResponse)message;
                this.fireCsPomAcknowledge(commandStationPomAcknowledgeResponse);
                break;
            }
            case 226: {
                CommandStationDriveAcknowledgeResponse commandStationDriveAcknowledgeResponse = (CommandStationDriveAcknowledgeResponse)message;
                this.fireCsDriveAcknowledge(commandStationDriveAcknowledgeResponse);
                break;
            }
            case 229: {
                CommandStationDriveManualResponse commandStationDriveManualResponse = (CommandStationDriveManualResponse)message;
                this.fireCsDriveManual(commandStationDriveManualResponse);
                break;
            }
            case 234: {
                CommandStationDriveStateResponse commandStationDriveStateResponse = (CommandStationDriveStateResponse)message;
                this.fireCsDriveState(commandStationDriveStateResponse);
                break;
            }
            case 227: {
                CommandStationAccessoryAcknowledgeResponse commandStationAccessoryAcknowledgeResponse = (CommandStationAccessoryAcknowledgeResponse)message;
                this.fireCsAccessoryAck(commandStationAccessoryAcknowledgeResponse);
                break;
            }
            case 231: {
                CommandStationAccessoryManualResponse commandStationAccessoryManualResponse = (CommandStationAccessoryManualResponse)message;
                this.fireCsAccessoryManual(commandStationAccessoryManualResponse);
                break;
            }
            case 232: {
                CommandStationRcPlusAcknowledgeResponse commandStationRcPlusAcknowledgeResponse = (CommandStationRcPlusAcknowledgeResponse)message;
                this.fireCsRcPlusAcknowledge(commandStationRcPlusAcknowledgeResponse);
                break;
            }
            case 233: {
                CommandStationM4AcknowledgeResponse commandStationM4AcknowledgeResponse = (CommandStationM4AcknowledgeResponse)message;
                this.fireCsM4Acknowledge(commandStationM4AcknowledgeResponse);
                break;
            }
            case 235: {
                CommandStationDccAdvAcknowledgeResponse commandStationDccAdvAcknowledgeResponse = (CommandStationDccAdvAcknowledgeResponse)message;
                this.fireCsDccAdvAcknowledge(commandStationDccAdvAcknowledgeResponse);
                break;
            }
            case 113: {
                if (bidibNode != null) {
                    bidibNode.acknowledgeLocalPing();
                    this.nodeRegistry.triggerPendingAcknowledge(bidibNode);
                }
                this.fireLocalPing(message.getAddr(), message.getNum());
                break;
            }
            case 241: {
                this.fireLocalPong(message.getAddr(), message.getNum());
                break;
            }
            case 252: {
                LocalBidibUpResponse localBidibUpResponse = (LocalBidibUpResponse)message;
                this.fireLocalBidibUp(message.getAddr(), message.getNum(), localBidibUpResponse.getData());
                break;
            }
            case 143: {
                FwUpdateStatResponse firmwareUpdateStat = (FwUpdateStatResponse)message;
                this.fireFirmwareUpdateStat(firmwareUpdateStat.getAddr(), message.getNum(), firmwareUpdateStat.getUpdateStat());
                break;
            }
            case 148: {
                VendorAckResponse vendorAck = (VendorAckResponse)message;
                this.fireVendorAck(vendorAck.getAddr(), message.getNum(), vendorAck.getReturnCode());
                break;
            }
            case 147: {
                VendorResponse vendor = (VendorResponse)message;
                this.fireVendor(vendor.getAddr(), message.getNum(), vendor.getVendorData());
                break;
            }
            case 112: {
                LocalLogonAckMessage localLogonAckMessage = (LocalLogonAckMessage)message;
                LOGGER.info("Received LocalLogonAck: {}", (Object)localLogonAckMessage);
                break;
            }
            case 242: {
                LocalLogoffMessage localLogoffResponse = (LocalLogoffMessage)message;
                if (NodeUtils.isAddressEqual((byte[])message.getAddr(), (byte[])NodeUtils.ROOT_ADDRESS)) {
                    this.nodeRegistry.getRootNode().signalLocalLogoff(localLogoffResponse.getSenderUniqueId());
                }
                this.fireLocalLogoff(localLogoffResponse);
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 208: 
            case 209: 
            case 210: {
                this.distributedMessageReceived(bidibNode, message);
                break;
            }
            case 136: {
                this.fireNodeTabCount((NodeTabCountResponse)message);
                break;
            }
            case 137: {
                this.fireNodeTab((NodeTabResponse)message);
                break;
            }
            case 146: {
                this.fireFeatureCount((FeatureCountResponse)message);
                break;
            }
            case 144: {
                this.fireFeature((FeatureResponse)message);
                break;
            }
            case 145: {
                this.fireFeatureNotAvailable((FeatureNotAvailableResponse)message);
                break;
            }
            default: {
                this.messageReceived(bidibNode, message);
            }
        }
    }

    protected void messageReceived(BidibNode bidibNode, BidibMessageInterface message) {
        LOGGER.warn("Received message that was not delivered to node: {}, message: {}", (Object)bidibNode, (Object)message);
    }

    protected void distributedMessageReceived(BidibNode bidibNode, BidibMessageInterface message) {
        LOGGER.info("Offer received message to distributed message listener: {}, message: {}", (Object)bidibNode, (Object)message);
        if (this.bidibDistributedMessageListener != null) {
            try {
                this.bidibDistributedMessageListener.handleDistributedMessage(bidibNode, message);
            }
            catch (Exception ex) {
                LOGGER.error("Offer received message to node failed. Message was: " + message, (Throwable)ex);
            }
        } else {
            LOGGER.warn("Ignore the distributed control messages for now: {}", (Object)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessageListener(MessageListener messageListener) {
        LOGGER.debug("Add new message listener: {}", (Object)messageListener);
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            boolean added = this.messageListeners.add(messageListener);
            if (!added) {
                LOGGER.warn("The messageListener was not added!!! provided messageListener: {}", (Object)messageListener);
                this.publishInternalError(new byte[]{0}, 0, "message-listener-not-added", "The messageListener was not added!!! provided messageListener: " + messageListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNodeListener(NodeListener nodeListener) {
        Collection<NodeListener> collection = this.nodeListeners;
        synchronized (collection) {
            this.nodeListeners.add(nodeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNodeListener(NodeListener nodeListener) {
        Collection<NodeListener> collection = this.nodeListeners;
        synchronized (collection) {
            this.nodeListeners.remove(nodeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessageListener(MessageListener messageListener) {
        LOGGER.debug("Remove message listener: {}", (Object)messageListener);
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            boolean removed = this.messageListeners.remove(messageListener);
            if (!removed) {
                LOGGER.warn("The messageListener was not removed!!! provided messageListener: {}", (Object)messageListener);
                this.publishInternalError(new byte[]{0}, 0, "message-listener-not-removed", "The messageListener was not removed!!! provided messageListener: " + messageListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMessageListeners() {
        LOGGER.info("Clear the message listeners.");
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            this.messageListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearNodeListeners() {
        Collection<NodeListener> collection = this.nodeListeners;
        synchronized (collection) {
            this.nodeListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAddress(byte[] address, int messageNum, int detectorNumber, List<AddressData> addresses) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.address(address, messageNum, detectorNumber, addresses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBmAccessory(byte[] address, int messageNum, int detectorNumber, int accessoryAddress) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.feedbackAccessory(address, messageNum, detectorNumber, accessoryAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBmCv(FeedbackCvResponse feedbackCvResponse) {
        List safeListeners;
        byte[] address = feedbackCvResponse.getAddr();
        int cvNumber = feedbackCvResponse.getCvNumber();
        int dat = feedbackCvResponse.getDat();
        PomAddressData decoderAddress = feedbackCvResponse.getAddress();
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.feedbackCv(address, feedbackCvResponse.getNum(), decoderAddress, cvNumber, dat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBmXPom(FeedbackXPomResponse response) {
        List safeListeners;
        byte[] address = response.getAddr();
        int cvNumber = response.getCvNumberX();
        int[] cvValue = response.getCvXValue();
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        if (response.isDiDAddress()) {
            DecoderIdAddressData did = response.getDID();
            for (MessageListener l : safeListeners) {
                l.feedbackXPom(address, response.getNum(), did, cvNumber, cvValue);
            }
        } else {
            AddressData decoderAddress = response.getDecoderAddress();
            for (MessageListener l : safeListeners) {
                l.feedbackXPom(address, response.getNum(), decoderAddress, cvNumber, cvValue);
            }
        }
    }

    private void fireBmExt(FeedbackExtResponse feedbackExtResponse) {
        LOGGER.info("fireBmExt: {}", (Object)feedbackExtResponse);
        if (feedbackExtResponse instanceof FeedbackDccAResponse) {
            this.fireBmDccA((FeedbackDccAResponse)feedbackExtResponse);
        } else {
            this.fireBmRcPlus((FeedbackRcPlusResponse)feedbackExtResponse);
        }
    }

    private void fireBmDccA(FeedbackDccAResponse feedbackDccAResponse) {
        LOGGER.info("fireBmDccA: {} : {}", (Object)feedbackDccAResponse, (Object)ByteUtils.bytesToHex((byte[])feedbackDccAResponse.getContent()));
        try {
            switch (feedbackDccAResponse.getOpCode()) {
                case BIDIB_DCCA_LOGON_COLLISION: {
                    LOGGER.info("Prepare message for BIDIB_DCCA_LOGON_COLLISION.");
                    this.publishDccALogonCollision(feedbackDccAResponse.getAddr(), feedbackDccAResponse.getNum(), feedbackDccAResponse.getDetectorNumber());
                    break;
                }
                case BIDIB_DCCA_LOGON_NEW_DID: {
                    LOGGER.info("Prepare message for BIDIB_DCCA_LOGON_NEW_DID.");
                    DecoderIdAddressData decoderIdAddressData = feedbackDccAResponse.getDecoderIdAddressData();
                    this.publishDccALogonNewDid(feedbackDccAResponse.getAddr(), feedbackDccAResponse.getNum(), feedbackDccAResponse.getDetectorNumber(), decoderIdAddressData);
                    break;
                }
                case BIDIB_DCCA_LOGON_ASSIGN_ACK: {
                    LOGGER.info("Prepare message for BIDIB_DCCA_LOGON_ASSIGN_ACK.");
                    this.publishDccALogonAssignAck(feedbackDccAResponse.getAddr(), feedbackDccAResponse.getNum(), feedbackDccAResponse.getDetectorNumber(), feedbackDccAResponse.getDecoderIdAddressData(), feedbackDccAResponse.getAssignHash());
                    break;
                }
                case BIDIB_DCCA_INFO_SHORTINFO: {
                    LOGGER.info("Prepare message for BIDIB_DCCA_INFO_SHORTINFO.");
                    DecoderIdAddressData decoderIdAddressData = feedbackDccAResponse.getDecoderIdAddressData();
                    this.publishDccAInfoShortInfo(feedbackDccAResponse.getAddr(), feedbackDccAResponse.getNum(), feedbackDccAResponse.getDetectorNumber(), decoderIdAddressData, feedbackDccAResponse.getShortInfo());
                    break;
                }
                case BIDIB_DCCA_INFO_SHORTGUI: {
                    LOGGER.info("Prepare message for BIDIB_DCCA_INFO_SHORTGUI.");
                    DecoderIdAddressData decoderIdAddressData = feedbackDccAResponse.getDecoderIdAddressData();
                    this.publishDccAInfoShortGui(feedbackDccAResponse.getAddr(), feedbackDccAResponse.getNum(), feedbackDccAResponse.getDetectorNumber(), decoderIdAddressData, feedbackDccAResponse.getShortGui());
                    break;
                }
                case BIDIB_DCCA_INFO_FIRMWAREID: {
                    LOGGER.info("Prepare message for BIDIB_DCCA_INFO_FIRMWAREID.");
                    DecoderIdAddressData decoderIdAddressData = feedbackDccAResponse.getDecoderIdAddressData();
                    this.publishDccAInfoFirmwareId(feedbackDccAResponse.getAddr(), feedbackDccAResponse.getNum(), feedbackDccAResponse.getDetectorNumber(), decoderIdAddressData, feedbackDccAResponse.getFirmwareId());
                    break;
                }
                case BIDIB_DCCA_INFO_PRODUCTNAME: {
                    LOGGER.info("Prepare message for BIDIB_DCCA_INFO_PRODUCTNAME.");
                    DecoderIdAddressData decoderIdAddressData = feedbackDccAResponse.getDecoderIdAddressData();
                    this.publishDccAInfoProductName(feedbackDccAResponse.getAddr(), feedbackDccAResponse.getNum(), feedbackDccAResponse.getDetectorNumber(), decoderIdAddressData, feedbackDccAResponse.getProductName());
                    break;
                }
                case BIDIB_DCCA_INFO_SHORTNAME: {
                    LOGGER.info("Prepare message for BIDIB_DCCA_INFO_SHORTNAME.");
                    DecoderIdAddressData decoderIdAddressData = feedbackDccAResponse.getDecoderIdAddressData();
                    this.publishDccAInfoShortName(feedbackDccAResponse.getAddr(), feedbackDccAResponse.getNum(), feedbackDccAResponse.getDetectorNumber(), decoderIdAddressData, feedbackDccAResponse.getShortName());
                    break;
                }
                case BIDIB_DCCA_INFO_FULLNAME: {
                    LOGGER.info("Prepare message for BIDIB_DCCA_INFO_FULLNAME.");
                    DecoderIdAddressData decoderIdAddressData = feedbackDccAResponse.getDecoderIdAddressData();
                    this.publishDccAInfoFullName(feedbackDccAResponse.getAddr(), feedbackDccAResponse.getNum(), feedbackDccAResponse.getDetectorNumber(), decoderIdAddressData, feedbackDccAResponse.getFullName());
                    break;
                }
                case BIDIB_DCCA_INFO_FUNCMAP: {
                    LOGGER.info("Prepare message for BIDIB_DCCA_INFO_FUNCMAP.");
                    break;
                }
                case BIDIB_DCCA_INFO_RAILCOM: {
                    LOGGER.info("Prepare message for BIDIB_DCCA_INFO_RAILCOM.");
                    break;
                }
                case BIDIB_DCCA_INFO_PICTURE: {
                    LOGGER.info("Prepare message for BIDIB_DCCA_INFO_PICTURE.");
                    break;
                }
                case BIDIB_DCCA_INFO_CV_P0: 
                case BIDIB_DCCA_INFO_CV_P1: {
                    LOGGER.info("Prepare message for BIDIB_DCCA_INFO_CV.");
                    break;
                }
                default: {
                    LOGGER.warn("Unhandled feedback DCCA response code detected: {}", (Object)feedbackDccAResponse.getOpCode());
                    break;
                }
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Process the FeedbackDccAResponse failed.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishDccALogonCollision(byte[] address, int messageNum, int detectorNum) {
        List safeListeners;
        LOGGER.info("Publish DccALogonNewDid, detectorNum: {}", (Object)detectorNum);
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.feedbackDccALogonCollision(address, messageNum, detectorNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishDccALogonNewDid(byte[] address, int messageNum, int detectorNum, DecoderIdAddressData decoderIdAddressData) {
        List safeListeners;
        LOGGER.info("Publish DccALogonNewDid, detectorNum: {}, decoderIdAddressData: {}", (Object)detectorNum, (Object)decoderIdAddressData);
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.feedbackDccALogonNewDid(address, messageNum, detectorNum, decoderIdAddressData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishDccALogonAssignAck(byte[] address, int messageNum, int detectorNum, DecoderIdAddressData decoderIdAddressData, Long assignHash) {
        List safeListeners;
        LOGGER.info("Publish DccALogonAssignAck, detectorNum: {}", (Object)detectorNum);
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.feedbackDccALogonAssignAck(address, messageNum, detectorNum, decoderIdAddressData, assignHash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishDccAInfoShortInfo(byte[] address, int messageNum, int detectorNum, DecoderIdAddressData decoderIdAddressData, DccAInfoShortInfo shortInfo) {
        List safeListeners;
        LOGGER.info("Publish DccAInfoShortName, detectorNum: {}, decoderIdAddressData: {}, shortInfo: {}", new Object[]{detectorNum, decoderIdAddressData, shortInfo});
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.feedbackDccAInfoShortInfo(address, messageNum, detectorNum, decoderIdAddressData, shortInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishDccAInfoShortName(byte[] address, int messageNum, int detectorNum, DecoderIdAddressData decoderIdAddressData, DccAInfoIndexedString shortName) {
        List safeListeners;
        LOGGER.info("Publish DccAInfoShortName, detectorNum: {}, decoderIdAddressData: {}, shortName: {}", new Object[]{detectorNum, decoderIdAddressData, shortName});
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.feedbackDccAInfoShortName(address, messageNum, detectorNum, decoderIdAddressData, shortName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishDccAInfoShortGui(byte[] address, int messageNum, int detectorNum, DecoderIdAddressData decoderIdAddressData, DccAInfoShortGui shortGui) {
        List safeListeners;
        LOGGER.info("Publish DccAInfoShortName, detectorNum: {}, decoderIdAddressData: {}, shortGui: {}", new Object[]{detectorNum, decoderIdAddressData, shortGui});
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.feedbackDccAInfoShortGui(address, messageNum, detectorNum, decoderIdAddressData, shortGui);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishDccAInfoFullName(byte[] address, int messageNum, int detectorNum, DecoderIdAddressData decoderIdAddressData, DccAInfoIndexedString fullName) {
        List safeListeners;
        LOGGER.info("Publish DccAInfoFullName, detectorNum: {}, decoderIdAddressData: {}, fullName: {}", new Object[]{detectorNum, decoderIdAddressData, fullName});
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.feedbackDccAInfoFullName(address, messageNum, detectorNum, decoderIdAddressData, fullName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishDccAInfoFirmwareId(byte[] address, int messageNum, int detectorNum, DecoderIdAddressData decoderIdAddressData, DccAInfoIndexedString firmwareId) {
        List safeListeners;
        LOGGER.info("Publish DccAInfoProductName, detectorNum: {}, decoderIdAddressData: {}, firmwareId: {}", new Object[]{detectorNum, decoderIdAddressData, firmwareId});
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.feedbackDccAInfoFirmwareId(address, messageNum, detectorNum, decoderIdAddressData, firmwareId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishDccAInfoProductName(byte[] address, int messageNum, int detectorNum, DecoderIdAddressData decoderIdAddressData, DccAInfoIndexedString productName) {
        List safeListeners;
        LOGGER.info("Publish DccAInfoProductName, detectorNum: {}, decoderIdAddressData: {}, productName: {}", new Object[]{detectorNum, decoderIdAddressData, productName});
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.feedbackDccAInfoProductName(address, messageNum, detectorNum, decoderIdAddressData, productName);
        }
    }

    private void fireBmRcPlus(FeedbackRcPlusResponse feedbackRcPlusResponse) {
        LOGGER.info("fireBmRcPlus: {}", (Object)feedbackRcPlusResponse);
        try {
            switch (feedbackRcPlusResponse.getOpCode()) {
                case RC_BIND_ACCEPTED_LOCO: {
                    LOGGER.info("Prepare message for RC_BIND_ACCEPTED_LOCO.");
                    RcPlusFeedbackBindData rcPlusBindAccepted = feedbackRcPlusResponse.getRcPlusFeedbackBind();
                    this.publishRcPlusBindAccepted(feedbackRcPlusResponse.getAddr(), feedbackRcPlusResponse.getNum(), feedbackRcPlusResponse.getDetectorNumber(), RcPlusDecoderType.LOCO, rcPlusBindAccepted);
                    break;
                }
                case RC_BIND_ACCEPTED_ACCESSORY: {
                    LOGGER.info("Prepare message for RC_BIND_ACCEPTED_ACCESSORY.");
                    RcPlusFeedbackBindData rcPlusBindAccepted = feedbackRcPlusResponse.getRcPlusFeedbackBind();
                    this.publishRcPlusBindAccepted(feedbackRcPlusResponse.getAddr(), feedbackRcPlusResponse.getNum(), feedbackRcPlusResponse.getDetectorNumber(), RcPlusDecoderType.ACCESSORY, rcPlusBindAccepted);
                    break;
                }
                case RC_PING_COLLISION_P0: {
                    LOGGER.info("Prepare message for RC_PING_COLLISION_P0.");
                    this.publishRcPlusPingCollision(feedbackRcPlusResponse.getAddr(), feedbackRcPlusResponse.getNum(), feedbackRcPlusResponse.getDetectorNumber(), RcPlusPhase.P0);
                    break;
                }
                case RC_PING_COLLISION_P1: {
                    LOGGER.info("Prepare message for RC_PING_COLLISION_P1.");
                    this.publishRcPlusPingCollision(feedbackRcPlusResponse.getAddr(), feedbackRcPlusResponse.getNum(), feedbackRcPlusResponse.getDetectorNumber(), RcPlusPhase.P1);
                    break;
                }
                case RC_FIND_COLLISION_P0: {
                    LOGGER.info("Prepare message for RC_FIND_COLLISION_P0.");
                    DecoderUniqueIdData uniqueId = feedbackRcPlusResponse.getRcPlusUniqueId();
                    this.publishRcPlusFindCollision(feedbackRcPlusResponse.getAddr(), feedbackRcPlusResponse.getNum(), feedbackRcPlusResponse.getDetectorNumber(), RcPlusPhase.P0, uniqueId);
                    break;
                }
                case RC_FIND_COLLISION_P1: {
                    LOGGER.info("Prepare message for RC_FIND_COLLISION_P1.");
                    DecoderUniqueIdData uniqueId = feedbackRcPlusResponse.getRcPlusUniqueId();
                    this.publishRcPlusFindCollision(feedbackRcPlusResponse.getAddr(), feedbackRcPlusResponse.getNum(), feedbackRcPlusResponse.getDetectorNumber(), RcPlusPhase.P1, uniqueId);
                    break;
                }
                case RC_PONG_OKAY_LOCO_P0: {
                    LOGGER.info("Prepare message for RC_PONG_OKAY_LOCO_P0.");
                    DecoderUniqueIdData uniqueId = feedbackRcPlusResponse.getRcPlusUniqueId();
                    this.publishRcPlusPongOkay(feedbackRcPlusResponse.getAddr(), feedbackRcPlusResponse.getNum(), feedbackRcPlusResponse.getDetectorNumber(), RcPlusPhase.P0, RcPlusDecoderType.LOCO, uniqueId);
                    break;
                }
                case RC_PONG_OKAY_LOCO_P1: {
                    LOGGER.info("Prepare message for RC_PONG_OKAY_LOCO_P1.");
                    DecoderUniqueIdData uniqueId = feedbackRcPlusResponse.getRcPlusUniqueId();
                    this.publishRcPlusPongOkay(feedbackRcPlusResponse.getAddr(), feedbackRcPlusResponse.getNum(), feedbackRcPlusResponse.getDetectorNumber(), RcPlusPhase.P1, RcPlusDecoderType.LOCO, uniqueId);
                    break;
                }
                case RC_PONG_NEW_LOCO_P0: {
                    LOGGER.info("Prepare message for RC_PONG_NEW_LOCO_P0.");
                    DecoderUniqueIdData uniqueId = feedbackRcPlusResponse.getRcPlusUniqueId();
                    this.publishRcPlusPongNew(feedbackRcPlusResponse.getAddr(), feedbackRcPlusResponse.getNum(), feedbackRcPlusResponse.getDetectorNumber(), RcPlusPhase.P0, RcPlusDecoderType.LOCO, uniqueId);
                    break;
                }
                case RC_PONG_NEW_LOCO_P1: {
                    LOGGER.info("Prepare message for RC_PONG_NEW_LOCO_P1.");
                    DecoderUniqueIdData uniqueId = feedbackRcPlusResponse.getRcPlusUniqueId();
                    this.publishRcPlusPongNew(feedbackRcPlusResponse.getAddr(), feedbackRcPlusResponse.getNum(), feedbackRcPlusResponse.getDetectorNumber(), RcPlusPhase.P1, RcPlusDecoderType.LOCO, uniqueId);
                    break;
                }
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Process the FeedbackDccAResponse failed.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishRcPlusBindAccepted(byte[] address, int messageNum, int detectorNum, RcPlusDecoderType decoderType, RcPlusFeedbackBindData rcPlusBindAccepted) {
        List safeListeners;
        LOGGER.info("Publish RcPlusBindAccepted, decoderType: {}, rcPlusBindAccepted: {}, detectorNum: {}", new Object[]{decoderType, rcPlusBindAccepted, detectorNum});
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.feedbackRcPlusBindAccepted(address, messageNum, detectorNum, decoderType, rcPlusBindAccepted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishRcPlusPingCollision(byte[] address, int messageNum, int detectorNum, RcPlusPhase phase) {
        List safeListeners;
        LOGGER.info("Publish RcPlusPingCollision, phase: {}, detectorNum: {}", (Object)phase, (Object)detectorNum);
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.feedbackRcPlusPingCollision(address, messageNum, detectorNum, phase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishRcPlusFindCollision(byte[] address, int messageNum, int detectorNum, RcPlusPhase phase, DecoderUniqueIdData uniqueId) {
        List safeListeners;
        LOGGER.info("Publish RcPlusFindCollision, phase: {}, uniqueId: {}, detectorNum: {}", new Object[]{phase, uniqueId, detectorNum});
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.feedbackRcPlusFindCollision(address, messageNum, detectorNum, phase, uniqueId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishRcPlusPongOkay(byte[] address, int messageNum, int detectorNum, RcPlusPhase phase, RcPlusDecoderType decoderType, DecoderUniqueIdData uniqueId) {
        List safeListeners;
        LOGGER.info("Publish RcPlusPongOkay, phase: {}, decoderType: {}, uniqueId: {}, detectorNum: {}", new Object[]{phase, decoderType, uniqueId, detectorNum});
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.feedbackRcPlusPongOkay(address, messageNum, detectorNum, phase, decoderType, uniqueId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishRcPlusPongNew(byte[] address, int messageNum, int detectorNum, RcPlusPhase phase, RcPlusDecoderType decoderType, DecoderUniqueIdData uniqueId) {
        List safeListeners;
        LOGGER.info("Publish RcPlusPongNew, phase: {}, decoderType: {}, uniqueId: {}, detectorNum: {}", new Object[]{phase, decoderType, uniqueId, detectorNum});
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.feedbackRcPlusPongNew(address, messageNum, detectorNum, phase, decoderType, uniqueId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCsProgState(byte[] address, int messageNum, CommandStationProgState commandStationProgState, int remainingTime, int cvNumber, int cvData) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.csProgState(address, messageNum, commandStationProgState, remainingTime, cvNumber, cvData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCsState(byte[] address, int messageNum, CommandStationState commandStationState) {
        List safeListeners;
        LOGGER.info("The state of the command station has changed: {}, address: {}", (Object)commandStationState, (Object)ByteUtils.bytesToHex((byte[])address));
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.csState(address, messageNum, commandStationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCsPomAcknowledge(CommandStationPomAcknowledgeResponse commandStationPomAcknowledgeResponse) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.csPomAcknowledge(commandStationPomAcknowledgeResponse.getAddr(), commandStationPomAcknowledgeResponse.getNum(), commandStationPomAcknowledgeResponse.getAddress(), commandStationPomAcknowledgeResponse.getAcknState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCsDriveAcknowledge(CommandStationDriveAcknowledgeResponse commandStationDriveAcknowledgeResponse) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.csDriveAcknowledge(commandStationDriveAcknowledgeResponse.getAddr(), commandStationDriveAcknowledgeResponse.getNum(), commandStationDriveAcknowledgeResponse.getDccAddress(), commandStationDriveAcknowledgeResponse.getState(), commandStationDriveAcknowledgeResponse.getAcknowledgedMessageNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCsDriveManual(CommandStationDriveManualResponse commandStationDriveManualResponse) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.csDriveManual(commandStationDriveManualResponse.getAddr(), commandStationDriveManualResponse.getNum(), commandStationDriveManualResponse.getDriveState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCsDriveState(CommandStationDriveStateResponse commandStationDriveStateResponse) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.csDriveState(commandStationDriveStateResponse.getAddr(), commandStationDriveStateResponse.getNum(), commandStationDriveStateResponse.getOpCode(), commandStationDriveStateResponse.getDriveState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCsAccessoryManual(CommandStationAccessoryManualResponse commandStationAccessoryManualResponse) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.csAccessoryManual(commandStationAccessoryManualResponse.getAddr(), commandStationAccessoryManualResponse.getNum(), commandStationAccessoryManualResponse.getDecoderAddress(), commandStationAccessoryManualResponse.getActivate(), commandStationAccessoryManualResponse.getAspect());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCsAccessoryAck(CommandStationAccessoryAcknowledgeResponse commandStationAccessoryAcknowledgeResponse) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.csAccessoryAcknowledge(commandStationAccessoryAcknowledgeResponse.getAddr(), commandStationAccessoryAcknowledgeResponse.getNum(), commandStationAccessoryAcknowledgeResponse.getAddress(), commandStationAccessoryAcknowledgeResponse.getAcknState());
        }
    }

    private void fireCsRcPlusAcknowledge(CommandStationRcPlusAcknowledgeResponse commandStationRcPlusAcknowledgeResponse) {
        LOGGER.info("fireCsRcPlusAcknowledge: {}", (Object)commandStationRcPlusAcknowledgeResponse);
        switch (commandStationRcPlusAcknowledgeResponse.getOpCode()) {
            case RC_TID: {
                TidData tidData = commandStationRcPlusAcknowledgeResponse.getTid();
                this.publishTidData(commandStationRcPlusAcknowledgeResponse.getAddr(), commandStationRcPlusAcknowledgeResponse.getNum(), tidData);
                break;
            }
            case RC_PING_ONCE_P0: {
                RcPlusAcknowledge acknState = commandStationRcPlusAcknowledgeResponse.getAcknState();
                this.publishPingAcknState(commandStationRcPlusAcknowledgeResponse.getAddr(), commandStationRcPlusAcknowledgeResponse.getNum(), RcPlusPhase.P0, acknState);
                break;
            }
            case RC_PING_ONCE_P1: {
                RcPlusAcknowledge acknState = commandStationRcPlusAcknowledgeResponse.getAcknState();
                this.publishPingAcknState(commandStationRcPlusAcknowledgeResponse.getAddr(), commandStationRcPlusAcknowledgeResponse.getNum(), RcPlusPhase.P1, acknState);
                break;
            }
            case RC_BIND: {
                RcPlusDecoderAnswerData decoderAnswer = commandStationRcPlusAcknowledgeResponse.getRcPlusDecoderAnswer();
                this.publishBindAnswer(commandStationRcPlusAcknowledgeResponse.getAddr(), commandStationRcPlusAcknowledgeResponse.getNum(), decoderAnswer);
                break;
            }
            case RC_FIND_P0: {
                RcPlusDecoderAnswerData decoderAnswer = commandStationRcPlusAcknowledgeResponse.getRcPlusDecoderAnswer();
                this.publishFindAnswer(commandStationRcPlusAcknowledgeResponse.getAddr(), commandStationRcPlusAcknowledgeResponse.getNum(), RcPlusPhase.P0, decoderAnswer);
                break;
            }
            case RC_FIND_P1: {
                RcPlusDecoderAnswerData decoderAnswer = commandStationRcPlusAcknowledgeResponse.getRcPlusDecoderAnswer();
                this.publishFindAnswer(commandStationRcPlusAcknowledgeResponse.getAddr(), commandStationRcPlusAcknowledgeResponse.getNum(), RcPlusPhase.P1, decoderAnswer);
                break;
            }
        }
    }

    private void fireCsM4Acknowledge(CommandStationM4AcknowledgeResponse commandStationM4AcknowledgeResponse) {
        LOGGER.info("fireCsM4Acknowledge: {}", (Object)commandStationM4AcknowledgeResponse);
        switch (commandStationM4AcknowledgeResponse.getOpCode()) {
            case M4_TID: {
                TidData tidData = commandStationM4AcknowledgeResponse.getTid();
                this.publishTidData(commandStationM4AcknowledgeResponse.getAddr(), commandStationM4AcknowledgeResponse.getNum(), tidData);
                break;
            }
            case M4_BEACON: {
                int beaconInterval = commandStationM4AcknowledgeResponse.getInterval(M4OpCodesAck.M4_BEACON);
                LOGGER.info("Received the beaconInterval: {}", (Object)beaconInterval);
                break;
            }
            case M4_SEARCH: {
                int searchInterval = commandStationM4AcknowledgeResponse.getInterval(M4OpCodesAck.M4_SEARCH);
                LOGGER.info("Received the searchInterval: {}", (Object)searchInterval);
                break;
            }
            case M4_NEW_LOCO: {
                LOGGER.info("Received M4_NEW_LOCO");
                Integer decoderId = commandStationM4AcknowledgeResponse.getDid(M4OpCodesAck.M4_NEW_LOCO);
                LOGGER.info("Received the decoderId: {}", (Object)decoderId);
                break;
            }
            default: {
                LOGGER.warn("Unhandled opCode: {}", (Object)commandStationM4AcknowledgeResponse.getOpCode());
            }
        }
    }

    private void fireCsDccAdvAcknowledge(CommandStationDccAdvAcknowledgeResponse acknowledge) {
        LOGGER.info("fireCsDccAdvAcknowledge: {}", (Object)acknowledge);
        switch (acknowledge.getOpCode()) {
            case BIDIB_DCCA_TID: {
                DccATidData tidData = acknowledge.getTid();
                this.publishDccAdvTidData(acknowledge.getAddr(), acknowledge.getNum(), acknowledge.getOpCode(), tidData);
                break;
            }
            case BIDIB_DCCA_LOGON_ENABLE_ALL: 
            case BIDIB_DCCA_LOGON_ENABLE_LOCO: 
            case BIDIB_DCCA_LOGON_ENABLE_ACC: 
            case BIDIB_DCCA_LOGON_ENABLE_NOW: {
                DccAdvAcknowledge ackn = acknowledge.getAcknState();
                this.publishDccAdvAckn(acknowledge.getAddr(), acknowledge.getNum(), acknowledge.getOpCode(), ackn);
                break;
            }
            case BIDIB_DCCA_LOGON_ASSIGN: {
                DccAdvAcknowledge assignAckn = acknowledge.getAcknState();
                this.publishDccAdvAckn(acknowledge.getAddr(), acknowledge.getNum(), acknowledge.getOpCode(), assignAckn);
                break;
            }
            default: {
                LOGGER.warn("Unprocessed OpCode for DCCA: {}", (Object)acknowledge.getOpCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishDccAdvTidData(byte[] address, int messageNum, DccAdvOpCodesAck opCode, DccATidData tidData) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.csDccAdvTid(address, messageNum, opCode, tidData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishDccAdvAckn(byte[] address, int messageNum, DccAdvOpCodesAck opCode, DccAdvAcknowledge ackn) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.csDccAdvAckn(address, messageNum, opCode, ackn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishTidData(byte[] address, int messageNum, TidData tidData) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.csRcPlusTid(address, messageNum, tidData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishPingAcknState(byte[] address, int messageNum, RcPlusPhase phase, RcPlusAcknowledge acknState) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.csRcPlusPingAcknState(address, messageNum, phase, acknState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishBindAnswer(byte[] address, int messageNum, RcPlusDecoderAnswerData decoderAnswer) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.csRcPlusBindAnswer(address, messageNum, decoderAnswer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishFindAnswer(byte[] address, int messageNum, RcPlusPhase phase, RcPlusDecoderAnswerData decoderAnswer) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.csRcPlusFindAnswer(address, messageNum, phase, decoderAnswer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBoosterDiagnostic(byte[] address, int messageNum, int current, int voltage, int temperature) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.boosterDiag(address, messageNum, current, voltage, temperature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBoosterState(byte[] address, int messageNum, BoosterState state, BoosterControl control) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.boosterState(address, messageNum, state, control);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConfidence(byte[] address, int messageNum, int valid, int freeze, int signal) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.confidence(address, messageNum, valid, freeze, signal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFree(byte[] address, int messageNum, int detectorNumber, Integer timestamp) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.occupation(address, messageNum, detectorNumber, OccupationState.FREE, timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOccupancyMultiple(byte[] address, int messageNum, int baseAddress, int detectorCount, byte[] detectorData) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.occupancyMultiple(address, messageNum, baseAddress, detectorCount, detectorData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOccupied(byte[] address, int messageNum, int detectorNumber, Integer timestamp) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.occupation(address, messageNum, detectorNumber, OccupationState.OCCUPIED, timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePosition(byte[] address, int messageNum, int decoderAddress, int locationType, int locationAddress, byte[] extendedData) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.position(address, messageNum, decoderAddress, locationType, locationAddress, extendedData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSpeed(byte[] address, int messageNum, AddressData addressData, int speed) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.speed(address, messageNum, addressData, speed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSysMagic(byte[] address, int messageNum, int magic) {
        List safeListeners;
        LOGGER.debug("SysMagic, addr: {}, magic: {}", (Object)address, (Object)magic);
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.sysMagic(address, messageNum, magic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSysSoftwareVersion(byte[] address, int messageNum, SoftwareVersion softwareVersion) {
        List safeListeners;
        LOGGER.debug("SysSoftwareVersion, addr: {}, softwareVersion: {}", (Object)address, (Object)softwareVersion);
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.sysSoftwareVersion(address, messageNum, softwareVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSysProtocolVersion(byte[] address, int messageNum, ProtocolVersion protocolVersion) {
        List safeListeners;
        LOGGER.debug("SysProtocolVersion, addr: {}, softwareVersion: {}", (Object)address, (Object)protocolVersion);
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.sysProtocolVersion(address, messageNum, protocolVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSysIdentify(byte[] address, int messageNum, IdentifyState identifyState) {
        List safeListeners;
        LOGGER.debug("Identify, addr: {}, identifyState: {}", (Object)address, (Object)identifyState);
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.identify(address, messageNum, identifyState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSysPong(byte[] address, int messageNum, int marker) {
        List safeListeners;
        LOGGER.debug("Pong, addr: {}, marker: {}", (Object)address, (Object)marker);
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.pong(address, messageNum, marker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSysUniqueId(byte[] address, int messageNum, byte[] uniqueId, Long configFingerPrint) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.sysUniqueId(address, messageNum, uniqueId, configFingerPrint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeString(byte[] address, int messageNum, StringData stringData) {
        List safeListeners;
        LOGGER.debug("Node string, addr: {}, stringData: {}", (Object)address, (Object)stringData);
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.nodeString(address, messageNum, stringData.getNamespace(), stringData.getIndex(), stringData.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeTabCount(NodeTabCountResponse nodeTabCountResponse) {
        List safeListeners;
        byte[] address = nodeTabCountResponse.getAddr();
        int nodeTabCount = nodeTabCountResponse.getCount();
        LOGGER.debug("NodeTabCount is signalled, addr: {}, nodeTabCount: {}", (Object)address, (Object)nodeTabCount);
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.nodeTabCount(address, nodeTabCountResponse.getNum(), nodeTabCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeTab(NodeTabResponse nodeTabResponse) {
        List safeListeners;
        byte[] address = nodeTabResponse.getAddr();
        int nodeTabVersion = nodeTabResponse.getNodeTabVersion();
        int localAddress = nodeTabResponse.getLocalAddr();
        byte[] uniqueId = nodeTabResponse.getUniqueId();
        LOGGER.debug("NodeTab is signalled, addr: {}, nodeTabVersion: {}, localAddress: {}", new Object[]{address, nodeTabVersion, localAddress});
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.nodeTab(address, nodeTabResponse.getNum(), localAddress, nodeTabVersion, uniqueId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFeatureCount(FeatureCountResponse featureCountResponse) {
        List safeListeners;
        byte[] address = featureCountResponse.getAddr();
        int featureCount = featureCountResponse.getCount();
        boolean streamingSupported = featureCountResponse.isStreamingSupported();
        LOGGER.debug("FeatureCount is signalled, addr: {}, featureCount: {}", (Object)address, (Object)featureCount);
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.featureCount(address, featureCountResponse.getNum(), featureCount, streamingSupported);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFeature(FeatureResponse featureResponse) {
        List safeListeners;
        byte[] address = featureResponse.getAddr();
        Feature feature = featureResponse.getFeature();
        LOGGER.debug("Feature is signalled, addr: {}, feature: {}", (Object)address, (Object)feature);
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.feature(address, featureResponse.getNum(), feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFeatureNotAvailable(FeatureNotAvailableResponse featureNotAvailableResponse) {
        List safeListeners;
        byte[] address = featureNotAvailableResponse.getAddr();
        int featureNumber = featureNotAvailableResponse.getFeatureNumber();
        LOGGER.debug("FeatureNotAvailable is signalled, addr: {}, feature: {}", (Object)address, (Object)featureNumber);
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.featureNotAvailable(address, featureNotAvailableResponse.getNum(), featureNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireKey(LcKeyResponse lcKeyResponse) {
        List safeListeners;
        byte[] address = lcKeyResponse.getAddr();
        BidibPort bidibPort = lcKeyResponse.getBidibPort();
        int portStatus = lcKeyResponse.getPortStatus();
        LOGGER.info("LcKey is signalled, bidibPort: {}, portStatus: {}", (Object)bidibPort, (Object)portStatus);
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.lcKey(address, lcKeyResponse.getNum(), bidibPort, portStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLcStat(LcStatResponse lcStatResponse) {
        List safeListeners;
        byte[] address = lcStatResponse.getAddr();
        BidibPort bidibPort = lcStatResponse.getBidibPort();
        int portStatus = lcStatResponse.getPortStatus();
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.lcStat(address, lcStatResponse.getNum(), bidibPort, portStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLcWait(LcWaitResponse lcWaitResponse) {
        List safeListeners;
        byte[] address = lcWaitResponse.getAddr();
        BidibPort bidibPort = lcWaitResponse.getBidibPort();
        int predRotationTime = lcWaitResponse.getPredictedRotationTime();
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.lcWait(address, lcWaitResponse.getNum(), bidibPort, predRotationTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLcNa(LcNotAvailableResponse lcNotAvailableResponse) {
        List safeListeners;
        byte[] address = lcNotAvailableResponse.getAddr();
        BidibPort bidibPort = lcNotAvailableResponse.getBidibPort();
        Integer errorCode = lcNotAvailableResponse.getErrorCode();
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.lcNa(address, lcNotAvailableResponse.getNum(), bidibPort, errorCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLcConfig(LcConfigResponse lcConfigResponse) {
        List safeListeners;
        byte[] address = lcConfigResponse.getAddr();
        LcConfig lcConfig = lcConfigResponse.getLcConfig();
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.lcConfig(address, lcConfigResponse.getNum(), lcConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLcConfigX(LcConfigXResponse lcConfigXResponse) {
        List safeListeners;
        byte[] address = lcConfigXResponse.getAddr();
        LcConfigX lcConfigX = lcConfigXResponse.getLcConfigX(this.nodeLogger);
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.lcConfigX(address, lcConfigXResponse.getNum(), lcConfigX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStall(StallResponse stallResponse) {
        List safeListeners;
        byte[] address = stallResponse.getAddr();
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.stall(address, stallResponse.getNum(), stallResponse.isStall());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeLost(byte[] address, int messageNum, Node node) {
        List safeListeners;
        Collection<NodeListener> collection = this.nodeListeners;
        synchronized (collection) {
            for (NodeListener nodeListener : this.nodeListeners) {
                nodeListener.nodeLost(node);
            }
        }
        Iterator iterator = this.messageListeners;
        synchronized (iterator) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener messageListener : safeListeners) {
            messageListener.nodeLost(address, messageNum, node);
        }
        if (this.nodeRegistry != null) {
            this.nodeRegistry.removeNode(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeNew(byte[] parentAddress, int messageNum, Node node) {
        List safeListeners;
        Collection<NodeListener> collection = this.nodeListeners;
        synchronized (collection) {
            for (NodeListener nodeListener : this.nodeListeners) {
                nodeListener.nodeNew(node);
            }
        }
        Iterator iterator = this.messageListeners;
        synchronized (iterator) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener messageListener : safeListeners) {
            messageListener.nodeNew(parentAddress, messageNum, node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishInternalError(byte[] address, int messageNum, String key, String message) {
        List safeListeners;
        LOGGER.error("Publish internal error, addr: {}, message: {}", (Object)address, (Object)message);
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.internalError(address, messageNum, key, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireError(byte[] address, int messageNum, int errorCode, byte[] reasonData) {
        List safeListeners;
        LOGGER.error("Error received from system, addr: {}, errorCode: {}, reasonData: {}", new Object[]{address, errorCode, ByteUtils.bytesToHex((byte[])reasonData)});
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.error(address, messageNum, errorCode, reasonData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAccessoryPara(byte[] address, int messageNum, int accessoryNumber, int parameterNumber, byte[] value) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.accessoryParameter(address, messageNum, accessoryNumber, parameterNumber, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAccessoryState(byte[] address, int messageNum, AccessoryState accessoryState, AccessoryStateOptions accessoryStateOptions) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            l.accessoryState(address, messageNum, accessoryState, accessoryStateOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLcMacro(byte[] address, int messageNum, byte[] macroData) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            try {
                l.lcMacro(address, messageNum, macroData);
            }
            catch (Exception ex) {
                LOGGER.warn("Process lcMacro failed, l: {}", (Object)l, (Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLcMacroPara(byte[] address, int messageNum, int macroNumber, int parameterIndex, LcMacroParaValue value) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            try {
                l.lcMacroParameter(address, messageNum, macroNumber, parameterIndex, value);
            }
            catch (Exception ex) {
                LOGGER.warn("Process lcMacroParameter failed, l: {}", (Object)l, (Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLcMacroState(byte[] address, int messageNum, LcMacroState macroState) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener l : safeListeners) {
            try {
                l.lcMacroState(address, messageNum, macroState);
            }
            catch (Exception ex) {
                LOGGER.warn("Process lcMacroState failed, l: {}", (Object)l, (Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDynState(byte[] address, int messageNum, FeedbackDynStateResponse feedbackDynStateResponse) {
        List safeListeners;
        int detectorNumber = feedbackDynStateResponse.getDetectorNumber();
        AddressData decoderAddress = feedbackDynStateResponse.getAddress();
        int dynNumber = feedbackDynStateResponse.getDynNumber();
        int dynValue = feedbackDynStateResponse.getDynValue();
        Integer timestamp = feedbackDynStateResponse.getTimestamp();
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.dynState(address, messageNum, detectorNumber, decoderAddress, dynNumber, dynValue, timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLocalPing(byte[] address, int messageNum) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.localPing(address, messageNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLocalPong(byte[] address, int messageNum) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.localPong(address, messageNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLocalBidibUp(byte[] address, int messageNum, byte[] wrappedMessage) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.localBidibUp(address, messageNum, wrappedMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFirmwareUpdateStat(byte[] address, int messageNum, FirmwareUpdateStat updateStat) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.firmwareUpdateStat(address, messageNum, updateStat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireVendorAck(byte[] address, int messageNum, int returnCode) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.vendorAck(address, messageNum, returnCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireVendor(byte[] address, int messageNum, VendorData vendorData) {
        List safeListeners;
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.vendor(address, messageNum, vendorData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLocalLogoff(LocalLogoffMessage localLogoffResponse) {
        List safeListeners;
        byte[] address = localLogoffResponse.getAddr();
        Long uniqueId = localLogoffResponse.getSenderUniqueId();
        Set<MessageListener> set = this.messageListeners;
        synchronized (set) {
            safeListeners = CollectionUtils.newArrayList(this.messageListeners);
        }
        for (MessageListener listener : safeListeners) {
            listener.localLogoff(address, localLogoffResponse.getNum(), uniqueId);
        }
    }

    public void removeOrphanNode(Node node) {
        LOGGER.info("Remove orphan node: {}", (Object)node);
        this.fireNodeLost(node.getAddr(), 0, node);
    }
}

