/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.core;

import java.io.ByteArrayOutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bidib.jbidibc.messages.MessageProcessor;
import org.bidib.jbidibc.messages.MessageReceiver;
import org.bidib.jbidibc.messages.base.RawMessageListener;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.utils.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRawMessageReceiver
implements MessageReceiver,
MessageProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRawMessageReceiver.class);
    private boolean checkCRC;
    private RawMessageListener rawMessageListener;
    private AtomicBoolean running = new AtomicBoolean();
    private final AtomicBoolean isFirstPacket = new AtomicBoolean(true);
    private final org.bidib.jbidibc.messages.logger.Logger splitMessageLogger;

    public AbstractRawMessageReceiver(boolean checkCRC) {
        this.checkCRC = checkCRC;
        this.splitMessageLogger = new org.bidib.jbidibc.messages.logger.Logger(){

            public void debug(String format, Object ... arguments) {
                LOGGER.debug(format, arguments);
            }

            public void info(String format, Object ... arguments) {
                LOGGER.info(format, arguments);
            }

            public void warn(String format, Object ... arguments) {
                LOGGER.warn(format, arguments);
            }

            public void error(String format, Object ... arguments) {
                LOGGER.error(format, arguments);
            }
        };
    }

    protected org.bidib.jbidibc.messages.logger.Logger getSplitMessageLogger() {
        return this.splitMessageLogger;
    }

    public boolean isCheckCRC() {
        return this.checkCRC;
    }

    public void setCheckCRC(boolean checkCRC) {
        this.checkCRC = checkCRC;
    }

    protected AtomicBoolean getIsFirstPacket() {
        return this.isFirstPacket;
    }

    public void disable() {
        LOGGER.debug("disable is called.");
        this.running.set(false);
    }

    public void enable() {
        LOGGER.debug("enable is called.");
        this.running.set(true);
    }

    public boolean isEnabled() {
        return this.running.get();
    }

    public void setRawMessageListener(RawMessageListener rawMessageListener) {
        this.rawMessageListener = rawMessageListener;
    }

    public void init(Context context) {
        this.running.set(true);
    }

    public void cleanup() {
        this.running.set(false);
    }

    public abstract void receive(ByteArrayOutputStream var1);

    public void processMessages(ByteArrayOutputStream messageData) throws ProtocolException {
        if (messageData.size() < 1) {
            LOGGER.info("No data in provided buffer, skip process messages.");
            return;
        }
        if (this.rawMessageListener != null) {
            try {
                this.rawMessageListener.notifyReceived(messageData.toByteArray());
            }
            catch (Exception ex) {
                LOGGER.warn("Notify the rawMessageListener failed.", (Throwable)ex);
            }
        }
        MessageUtils.splitBidibMessages((org.bidib.jbidibc.messages.logger.Logger)this.splitMessageLogger, (ByteArrayOutputStream)messageData, (boolean)this.checkCRC, (AtomicBoolean)this.isFirstPacket, message -> this.processMessage(message));
    }

    protected abstract void processMessage(byte[] var1) throws ProtocolException;
}

