/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BidibFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BidibFactory.class);
    private static final String METHODNAME_CREATEINSTANCE = "createInstance";

    public static BidibInterface createBidib(String clazzName, Context context) {
        BidibInterface bidib = null;
        LOGGER.info("Try to create instance of class: {}", (Object)clazzName);
        try {
            Class<?> clazz = Class.forName(clazzName);
            Method method = clazz.getDeclaredMethod(METHODNAME_CREATEINSTANCE, Context.class);
            bidib = (BidibInterface)method.invoke(null, context);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof InvalidConfigurationException) {
                InvalidConfigurationException ice = (InvalidConfigurationException)cause;
                LOGGER.error("Create Bidib instance failed because the configuration is invalid.", (Throwable)ice);
                throw ice;
            }
            LOGGER.error("Create Bidib instance with createInstance failed: {}", (Object)clazzName, (Object)ex);
            throw new InvalidConfigurationException("Create Bidib instance failed: " + clazzName);
        }
        catch (Exception ex) {
            LOGGER.error("Create Bidib instance with createInstance failed: {}", (Object)clazzName, (Object)ex);
            throw new InvalidConfigurationException("Create Bidib instance failed: " + clazzName);
        }
        LOGGER.info("Return created instance of bidib: {}", (Object)bidib);
        return bidib;
    }
}

