/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.core;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.core.MessageParser;
import org.bidib.jbidibc.core.utils.CircularByteBuffer;
import org.bidib.jbidibc.messages.MessageProcessor;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainMessageParser
implements MessageParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlainMessageParser.class);
    protected static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"RAW");
    private final CircularByteBuffer messageBuffer = new CircularByteBuffer(2048);
    private final ByteArrayOutputStream receiveBuffer = new ByteArrayOutputStream(2048);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        CircularByteBuffer circularByteBuffer = this.messageBuffer;
        synchronized (circularByteBuffer) {
            MSG_RAW_LOGGER.info("Reset the receiveBuffer in PlainMessageParser.");
            this.messageBuffer.clear();
            this.receiveBuffer.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseInput(MessageProcessor messageProcessor, byte[] receivedData, int len) throws ProtocolException {
        if (receivedData != null) {
            MSG_RAW_LOGGER.info("<<<< len: {}, data: {}", (Object)len, (Object)ByteUtils.bytesToHex((byte[])receivedData, (int)len));
            CircularByteBuffer circularByteBuffer = this.messageBuffer;
            synchronized (circularByteBuffer) {
                this.messageBuffer.add(receivedData, 0, len);
                while (this.messageBuffer.hasBytes()) {
                    int msgLen = (this.messageBuffer.inspect() & 0xFF) + 1;
                    if (msgLen <= this.messageBuffer.getCurrentNumberOfBytes()) {
                        try {
                            this.receiveBuffer.reset();
                            this.messageBuffer.read(this.receiveBuffer, msgLen);
                            try {
                                messageProcessor.processMessages(this.receiveBuffer);
                            }
                            catch (ProtocolException ex) {
                                LOGGER.warn("Process messages failed.", (Throwable)ex);
                            }
                            continue;
                        }
                        catch (IllegalStateException ex) {
                            LOGGER.warn("The buffer does not contain the complete message: {}", (Object)ex.getMessage());
                            break;
                        }
                    }
                    LOGGER.info("The buffer does not contain the complete message.");
                    break;
                }
                if (this.messageBuffer.hasBytes() && LOGGER.isDebugEnabled()) {
                    this.dumpRemainingBuffer(this.messageBuffer.dumpContent());
                }
            }
        } else {
            LOGGER.error("No input available.");
        }
    }

    protected void dumpRemainingBuffer(byte[] bufferContent) {
        LOGGER.debug("Data remaining in output: {}", (Object)ByteUtils.bytesToHex((byte[])bufferContent));
    }
}

