/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.core.node;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.bidib.jbidibc.core.DefaultMessageListener;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.node.BidibNode;
import org.bidib.jbidibc.core.node.MacroNode;
import org.bidib.jbidibc.core.node.messagelistener.LcMacroConsumer;
import org.bidib.jbidibc.core.node.messagelistener.LcMacroParameterConsumer;
import org.bidib.jbidibc.core.node.messagelistener.LcMacroStateConsumer;
import org.bidib.jbidibc.messages.AccessoryState;
import org.bidib.jbidibc.messages.AccessoryStateOptions;
import org.bidib.jbidibc.messages.LcMacro;
import org.bidib.jbidibc.messages.LcMacroParaValue;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.accessory.AccessoryParameter;
import org.bidib.jbidibc.messages.enums.AccessoryParameterKeyEnum;
import org.bidib.jbidibc.messages.enums.LcMacroOperationCode;
import org.bidib.jbidibc.messages.enums.LcMacroState;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.exception.ProtocolInvalidParamException;
import org.bidib.jbidibc.messages.exception.ProtocolNoAnswerException;
import org.bidib.jbidibc.messages.message.AccessoryGetMessage;
import org.bidib.jbidibc.messages.message.AccessoryParaGetMessage;
import org.bidib.jbidibc.messages.message.AccessorySetMessage;
import org.bidib.jbidibc.messages.message.BidibCommand;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.LcMacroParaGetMessage;
import org.bidib.jbidibc.messages.message.LcMacroParaResponse;
import org.bidib.jbidibc.messages.message.LcMacroResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.CollectionUtils;
import org.bidib.jbidibc.messages.utils.MacroUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessoryNode
implements MacroNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessoryNode.class);
    private final BidibNode delegate;

    AccessoryNode(BidibNode delegate) {
        this.delegate = delegate;
    }

    public BidibNode getBidibNode() {
        return this.delegate;
    }

    private byte[] getAddr() {
        return this.getBidibNode().getAddr();
    }

    public byte[] getAccessoryParameter(int accessoryNumber, final int parameter) throws ProtocolException {
        final byte[] nodeAddr = this.getAddr();
        final CompletableFuture future = new CompletableFuture();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void accessoryParameter(byte[] address, int messageNum, int accessoryNumber, int responseParameter, byte[] value) {
                if (Arrays.equals(nodeAddr, address)) {
                    if (responseParameter == 255) {
                        LOGGER.info("The requested accessory param does not exist, accessoryNumber: {}, parameter: {}", (Object)accessoryNumber, (Object)parameter);
                        future.completeExceptionally((Throwable)new ProtocolInvalidParamException("The requested accessory param does not exist!", parameter));
                    }
                    future.complete(value);
                } else {
                    LOGGER.debug("Received accessoryParameter from another node.");
                }
            }
        };
        byte[] result = (byte[])this.sendAndWaitForResponse(messageListener, () -> this.delegate.getRequestFactory().createAccessoryParaGet(accessoryNumber, parameter), future);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessoryParameter> getAccessoryParameters(int accessoryNumber, AccessoryParameterKeyEnum ... params) throws ProtocolException {
        if (this.delegate.getProtocolVersion().isLowerThan(ProtocolVersion.VERSION_0_7)) {
            LOGGER.warn("Bulk requests for accessory parameters are not allowed for protocol < 0.7");
            return Collections.emptyList();
        }
        final LinkedList<AccessoryParaGetMessage> messages = new LinkedList<AccessoryParaGetMessage>();
        for (AccessoryParameterKeyEnum param : params) {
            messages.add(new AccessoryParaGetMessage(accessoryNumber, param));
        }
        LOGGER.info("Prepared bulk messages for accessory para get: {}", messages);
        int windowSize = 4;
        final byte[] nodeAddr = this.getAddr();
        int expectedCountResponses = messages.size();
        LOGGER.info("Create CountDownLatch with value: {}", (Object)expectedCountResponses);
        final CountDownLatch continueLock = new CountDownLatch(expectedCountResponses);
        final CountDownLatch[] continueLockPartial = new CountDownLatch[1];
        final LinkedList<AccessoryParameter> accessoryParams = new LinkedList<AccessoryParameter>();
        DefaultMessageListener messageListener = new DefaultMessageListener(){
            private int index = 0;

            @Override
            public void accessoryParameter(byte[] address, int messageNum, int accessoryNumber, int responseParameter, byte[] value) {
                if (Arrays.equals(nodeAddr, address)) {
                    AccessoryParameter accessoryParameter = AccessoryNode.this.evaluateAccessoryParaResponse(responseParameter, value, ((AccessoryParaGetMessage)messages.get(this.index)).getParaNumber());
                    accessoryParams.add(accessoryParameter);
                    ++this.index;
                    continueLock.countDown();
                    if (continueLockPartial[0] != null) {
                        continueLockPartial[0].countDown();
                    }
                } else {
                    LOGGER.debug("Received accessoryParameter from another node.");
                }
            }
        };
        try {
            this.delegate.getMessageReceiver().addMessageListener(messageListener);
            this.delegate.sendBulk(windowSize, messages, true, BidibNode.ProcessSendQueue.enabled, messageListener, continueLock, continueLockPartial);
            boolean success = continueLock.await(windowSize * (this.delegate.getResponseTimeout() / 2), TimeUnit.MILLISECONDS);
            if (success) {
                LOGGER.info("Wait for all accessoryParameter was successful for node: {}", (Object)this.delegate.node);
                if (CollectionUtils.hasElements(accessoryParams)) {
                    LinkedList<AccessoryParameter> linkedList = accessoryParams;
                    return linkedList;
                }
            } else {
                LOGGER.warn("Wait for all accessory parameters was not successful for node: {}", (Object)this.delegate.node);
            }
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait for response before continue was interrupted.");
        }
        finally {
            this.delegate.getMessageReceiver().removeMessageListener(messageListener);
        }
        if (this.delegate.ignoreWaitTimeout) {
            LOGGER.warn("No response received but ignoreWaitTimeout ist set! Current node: {}", (Object)this.delegate.node);
            return null;
        }
        throw this.createNoResponseAvailable("get all accessory parameters with bulk");
    }

    private AccessoryParameter evaluateAccessoryParaResponse(int responseParameter, byte[] value, int accessoryParaNumber) {
        AccessoryParameter accessoryParameter;
        block5: {
            accessoryParameter = null;
            if (responseParameter == 255) {
                LOGGER.info("The requested accessory param does not exist: {}", (Object)accessoryParaNumber);
                try {
                    if (this.delegate.getProtocolVersion().isHigherOrEqualThan(ProtocolVersion.VERSION_0_7) && value != null && value.length > 0) {
                        accessoryParameter = new AccessoryParameter(AccessoryParameterKeyEnum.valueOf((byte)value[0]), AccessoryParameter.Status.notexist);
                        break block5;
                    }
                    LOGGER.info("The parameter does not exist for paraNumber: {}", (Object)accessoryParaNumber);
                    accessoryParameter = new AccessoryParameter(AccessoryParameterKeyEnum.valueOf((int)accessoryParaNumber), AccessoryParameter.Status.notexist);
                }
                catch (ProtocolException ex) {
                    LOGGER.warn("Get protocol version of node failed.", (Throwable)ex);
                }
            } else {
                accessoryParameter = new AccessoryParameter(AccessoryParameterKeyEnum.valueOf((byte)ByteUtils.getLowByte((int)responseParameter)), value);
            }
        }
        return accessoryParameter;
    }

    public AccessoryParameter setAccessoryParameter(int accessoryNumber, final int parameterNumber, byte[] value) throws ProtocolException {
        final byte[] nodeAddr = this.getAddr();
        final CompletableFuture future = new CompletableFuture();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void accessoryParameter(byte[] address, int messageNum, int accessoryNumber, int responseParameter, byte[] value) {
                if (Arrays.equals(nodeAddr, address)) {
                    AccessoryParameter accessoryParameter = AccessoryNode.this.evaluateAccessoryParaResponse(responseParameter, value, parameterNumber);
                    future.complete(accessoryParameter);
                } else {
                    LOGGER.debug("Received accessoryParameter from another node.");
                }
            }
        };
        AccessoryParameter accessoryParameter = (AccessoryParameter)this.sendAndWaitForResponse(messageListener, () -> this.delegate.getRequestFactory().createAccessoryParaSet(accessoryNumber, parameterNumber, value), future);
        return accessoryParameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAccessoryState(int ... accessoryNumber) throws ProtocolException {
        final byte[] nodeAddr = this.getAddr();
        if (accessoryNumber.length > 1) {
            int windowSize = 4;
            LinkedList<AccessoryGetMessage> messages = new LinkedList<AccessoryGetMessage>();
            for (int i = 0; i < accessoryNumber.length; ++i) {
                messages.add(this.delegate.getRequestFactory().createAccessoryGet(accessoryNumber[i]));
            }
            int expectedCountResponses = messages.size();
            LOGGER.info("Create CountDownLatch with value: {}", (Object)expectedCountResponses);
            final CountDownLatch continueLock = new CountDownLatch(expectedCountResponses);
            final CountDownLatch[] continueLockPartial = new CountDownLatch[1];
            DefaultMessageListener messageListener = new DefaultMessageListener(){

                @Override
                public void accessoryState(byte[] address, int messageNum, AccessoryState accessoryState, AccessoryStateOptions accessoryStateOptions) {
                    if (Arrays.equals(nodeAddr, address)) {
                        LOGGER.info("Received accessoryState.");
                        continueLock.countDown();
                        if (continueLockPartial[0] != null) {
                            continueLockPartial[0].countDown();
                        }
                    } else {
                        LOGGER.debug("Received accessoryState from another node.");
                    }
                }
            };
            try {
                this.delegate.getMessageReceiver().addMessageListener(messageListener);
                LOGGER.info("Get the accessory states with bulk messages, windowSize: {}, accessoryNumber: {}", new Object[]{windowSize, accessoryNumber});
                this.delegate.sendBulk(windowSize, messages, true, BidibNode.ProcessSendQueue.enabled, messageListener, continueLock, continueLockPartial);
                boolean success = continueLock.await(windowSize * (this.delegate.getResponseTimeout() / 2), TimeUnit.MILLISECONDS);
                if (success) {
                    LOGGER.info("Wait for all accessory states was successful for node: {}", (Object)this.delegate.node);
                }
                LOGGER.warn("Wait for all accessory states was not successful for node: {}", (Object)this.delegate.node);
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Wait for response before continue was interrupted.");
            }
            finally {
                this.delegate.getMessageReceiver().removeMessageListener(messageListener);
            }
        } else {
            LOGGER.info("Get the accessory states with single message, accessoryNumber: {}", (Object)accessoryNumber[0]);
            final CountDownLatch continueLock = new CountDownLatch(1);
            DefaultMessageListener messageListener = new DefaultMessageListener(){

                @Override
                public void accessoryState(byte[] address, int messageNum, AccessoryState accessoryState, AccessoryStateOptions accessoryStateOptions) {
                    if (Arrays.equals(nodeAddr, address)) {
                        LOGGER.info("Received accessoryState.");
                        continueLock.countDown();
                    } else {
                        LOGGER.debug("Received accessoryState from another node.");
                    }
                }
            };
            try {
                this.delegate.getMessageReceiver().addMessageListener(messageListener);
                this.delegate.sendNoWait((BidibMessageInterface)this.delegate.getRequestFactory().createAccessoryGet(accessoryNumber[0]));
                boolean success = continueLock.await(this.delegate.getResponseTimeout(), TimeUnit.MILLISECONDS);
                if (success) {
                    LOGGER.info("Wait for accessory state was successful for node: {}", (Object)this.delegate.node);
                } else {
                    LOGGER.warn("Wait for accessory state was not successful for node: {}", (Object)this.delegate.node);
                }
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Wait for response before continue was interrupted.");
            }
            finally {
                this.delegate.getMessageReceiver().removeMessageListener(messageListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAccessoryStateAll(int totalAccessoryCount) throws ProtocolException {
        final byte[] nodeAddr = this.getAddr();
        final CountDownLatch continueLock = new CountDownLatch(totalAccessoryCount);
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void accessoryState(byte[] address, int messageNum, AccessoryState accessoryState, AccessoryStateOptions accessoryStateOptions) {
                if (Arrays.equals(nodeAddr, address)) {
                    LOGGER.info("Received accessoryState.");
                    continueLock.countDown();
                } else {
                    LOGGER.debug("Received accessoryState from another node.");
                }
            }
        };
        try {
            boolean success;
            this.delegate.getMessageReceiver().addMessageListener(messageListener);
            LOGGER.info("Get all accessory states.");
            this.delegate.sendNoWait((BidibMessageInterface)this.delegate.getRequestFactory().createAccessoryGetAll());
            long timeoutValue = totalAccessoryCount * (this.delegate.getResponseTimeout() / 2);
            if (timeoutValue > 4000L) {
                LOGGER.info("Limit the timeout value to 4000ms to get all accessory states.");
                timeoutValue = 4000L;
            }
            if (success = continueLock.await(timeoutValue, TimeUnit.MILLISECONDS)) {
                LOGGER.info("Wait for all accessory state was successful for node: {}", (Object)this.delegate.node);
            } else {
                LOGGER.warn("Wait for all accessory state was not successful for node: {}", (Object)this.delegate.node);
            }
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait for all accessory state answers was interrupted.");
        }
        finally {
            this.delegate.getMessageReceiver().removeMessageListener(messageListener);
        }
    }

    public void setAccessoryState(int accessoryNumber, int aspect) throws ProtocolException {
        this.delegate.sendNoWait((BidibMessageInterface)new AccessorySetMessage(accessoryNumber, aspect));
    }

    public void acknowledgeAccessoryNotify(AccessoryState accessoryState) throws ProtocolException {
        LOGGER.info("Accessory change notification was received: {}", (Object)accessoryState);
        int accessoryNumber = ByteUtils.getInt((byte)accessoryState.getAccessoryNumber());
        Integer aspect = accessoryState.getActiveAspect();
        LOGGER.info("Acknowledge the accessory state change for accessory number: {}, aspect: {}", (Object)accessoryNumber, (Object)aspect);
        boolean added = this.delegate.acknowledge((BidibCommand)new AccessoryGetMessage(accessoryNumber));
        if (!added) {
            LOGGER.warn("Add the AccessoryGetMessage to sendQueue failed.");
            throw new ProtocolException("Add the AccessoryGetMessage to sendQueue failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LcMacroParaValue getMacroParameter(int macroNumber, int parameter) throws ProtocolException {
        final byte[] nodeAddr = this.getAddr();
        final CompletableFuture future = new CompletableFuture();
        LcMacroParameterConsumer lcMacroParameterConsumer = new LcMacroParameterConsumer(){

            @Override
            public void lcMacroParameter(byte[] address, int macroNumber, int parameterIndex, LcMacroParaValue value) {
                if (Arrays.equals(nodeAddr, address)) {
                    LOGGER.info("Received lcMacroParameter, addr: {} value: {}", (Object)NodeUtils.formatAddress((byte[])address), (Object)value);
                    future.complete(value);
                } else {
                    LOGGER.debug("Received lcMacroParameter from another node.");
                }
            }

            public String toString() {
                return "AccessoryNode, addr: " + NodeUtils.formatAddress((byte[])nodeAddr);
            }
        };
        LOGGER.info("Get single macro parameter for node: {}", (Object)this.delegate.node);
        try {
            this.delegate.getConsumerSupportMessageListener().setLcMacroParameterConsumer(lcMacroParameterConsumer);
            LcMacroParaValue macroParaValue = (LcMacroParaValue)this.sendAndWaitForResponse(() -> this.delegate.getRequestFactory().createLcMacroParaGet(macroNumber, parameter), future);
            this.delegate.expectResponse(macroParaValue, null, false, LcMacroParaResponse.TYPE);
            if (macroParaValue != null) {
                LcMacroParaValue lcMacroParaValue = macroParaValue;
                return lcMacroParaValue;
            }
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait for all macro step answers was interrupted.");
        }
        finally {
            this.delegate.getConsumerSupportMessageListener().setLcMacroConsumer(null);
        }
        LOGGER.warn("No response received for LcMacroParaGetMessage, macroNumber: {}, parameter: {}", (Object)macroNumber, (Object)parameter);
        throw new ProtocolNoAnswerException(String.format("No response received for LcMacroParaGetMessage, macroNumber: %d, parameter: %d", macroNumber, parameter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LcMacroParaValue> getMacroParameters(int macroNumber, int ... parameters) throws ProtocolException {
        LinkedList<LcMacroParaGetMessage> messages = new LinkedList<LcMacroParaGetMessage>();
        for (int parameter : parameters) {
            messages.add(this.delegate.getRequestFactory().createLcMacroParaGet(macroNumber, parameter));
        }
        int bulkWindowSize = 4;
        final byte[] nodeAddr = this.getAddr();
        int totalMessages = messages.size();
        final CountDownLatch continueLock = new CountDownLatch(totalMessages);
        final CountDownLatch[] continueLockParameters = new CountDownLatch[1];
        final LinkedList<LcMacroParaValue> responses = new LinkedList<LcMacroParaValue>();
        LcMacroParameterConsumer lcMacroParameterConsumer = new LcMacroParameterConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void lcMacroParameter(byte[] address, int macroNumber, int parameterIndex, LcMacroParaValue value) {
                if (Arrays.equals(nodeAddr, address)) {
                    LOGGER.info("Received lcMacroParameter, addr: {} value: {}", (Object)NodeUtils.formatAddress((byte[])address), (Object)value);
                    Object object = responses;
                    synchronized (object) {
                        responses.add(value);
                    }
                    LOGGER.debug("Count down locks, addr: {}", (Object)NodeUtils.formatAddress((byte[])address));
                    object = continueLock;
                    synchronized (object) {
                        if (continueLockParameters[0] != null) {
                            continueLockParameters[0].countDown();
                        }
                    }
                    continueLock.countDown();
                    LOGGER.debug("After count down locks, addr: {}", (Object)NodeUtils.formatAddress((byte[])address));
                } else {
                    LOGGER.debug("Received lcMacroParameter from another node.");
                }
            }

            public String toString() {
                return "AccessoryNode, addr: " + NodeUtils.formatAddress((byte[])nodeAddr);
            }
        };
        try {
            this.delegate.getConsumerSupportMessageListener().setLcMacroParameterConsumer(lcMacroParameterConsumer);
            LOGGER.info("Get macro parameters for node: {}", (Object)this.delegate.node);
            this.delegate.sendBulk(bulkWindowSize, messages, true, BidibNode.ProcessSendQueue.enabled, null, continueLock, continueLockParameters);
            boolean success = continueLock.await(bulkWindowSize * (this.delegate.getResponseTimeout() / 2), TimeUnit.MILLISECONDS);
            if (success) {
                LOGGER.info("Wait for all macro parameters was successful for node: {}", (Object)this.delegate.node);
            } else {
                LOGGER.warn("Wait for all macro parameters was not successful for node: {}", (Object)this.delegate.node);
            }
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait for all macro parameter answers was interrupted.");
        }
        finally {
            this.delegate.getConsumerSupportMessageListener().setLcMacroParameterConsumer(null);
        }
        return responses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LcMacro getMacroStep(int macroNumber, int stepNumber) throws ProtocolException {
        byte[] macroData;
        block7: {
            LOGGER.info("Get the macro step, macroNumber: {}, stepNumber: {}", (Object)macroNumber, (Object)stepNumber);
            final byte[] nodeAddr = this.getAddr();
            final CountDownLatch continueLock = new CountDownLatch(1);
            final LinkedList responses = new LinkedList();
            LcMacroConsumer lcMacroConsumer = new LcMacroConsumer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void lcMacro(byte[] address, byte[] macroData) {
                    LOGGER.info("lcMacro, address: {}, nodeAddr: {}", (Object)NodeUtils.formatAddress((byte[])address), (Object)NodeUtils.formatAddress((byte[])nodeAddr));
                    if (Arrays.equals(nodeAddr, address)) {
                        LOGGER.debug("Received macroStep, addr: {}, macroData: {}", (Object)NodeUtils.formatAddress((byte[])address), (Object)macroData);
                        List list = responses;
                        synchronized (list) {
                            responses.add(macroData);
                        }
                        continueLock.countDown();
                    } else {
                        LOGGER.debug("Received macroStep from another node.");
                    }
                }

                public String toString() {
                    return "AccessoryNode, addr: " + NodeUtils.formatAddress((byte[])nodeAddr);
                }
            };
            macroData = null;
            try {
                LOGGER.info("Get macro steps for node: {}", (Object)this.delegate.node);
                this.delegate.getConsumerSupportMessageListener().setLcMacroConsumer(lcMacroConsumer);
                boolean successful = this.sendAndWaitForResponse(() -> this.delegate.getRequestFactory().createLcMacroGet(macroNumber, stepNumber), continueLock);
                if (successful) {
                    macroData = (byte[])responses.get(0);
                    this.delegate.expectResponse(macroData, null, false, LcMacroResponse.TYPE);
                    break block7;
                }
                LOGGER.warn("Wait for macro step failed for node: {}", (Object)this.delegate.node);
                throw new ProtocolNoAnswerException("Wait for macro step failed.");
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Wait for all macro step answers was interrupted.");
            }
            finally {
                this.delegate.getConsumerSupportMessageListener().setLcMacroConsumer(null);
            }
        }
        LcMacro result = null;
        if (macroData != null) {
            result = MacroUtils.getMacro(macroData);
            LOGGER.info("The returned macro step is: {}", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LcMacroState handleMacro(int macroNumber, LcMacroOperationCode macroOperationCode) throws ProtocolException {
        LcMacroState macroState;
        block7: {
            LOGGER.info("handle macro, macroNumber: {}, macroOperationCode: {}", (Object)macroNumber, (Object)macroOperationCode);
            int receiveTimeout = 400;
            if (LcMacroOperationCode.SAVE.equals((Object)macroOperationCode) || LcMacroOperationCode.RESTORE.equals((Object)macroOperationCode) || LcMacroOperationCode.DELETE.equals((Object)macroOperationCode)) {
                receiveTimeout = 800;
            }
            final byte[] nodeAddr = this.getAddr();
            final CountDownLatch continueLock = new CountDownLatch(1);
            final LinkedList responses = new LinkedList();
            LcMacroStateConsumer lcMacroStateConsumer = new LcMacroStateConsumer(){

                @Override
                public void lcMacroState(byte[] address, LcMacroState macroState) {
                    if (Arrays.equals(nodeAddr, address)) {
                        responses.add(macroState);
                        continueLock.countDown();
                    } else {
                        LOGGER.info("Received lcMacro from another node.");
                    }
                }

                public String toString() {
                    return "AccessoryNode, addr: " + NodeUtils.formatAddress((byte[])nodeAddr);
                }
            };
            macroState = null;
            try {
                this.delegate.getConsumerSupportMessageListener().setLcMacroStateConsumer(lcMacroStateConsumer);
                boolean successful = this.sendAndWaitForResponse(() -> this.delegate.getRequestFactory().createLcMacroHandle(macroNumber, macroOperationCode), (long)receiveTimeout, continueLock);
                if (successful) {
                    macroState = (LcMacroState)responses.get(0);
                    this.delegate.expectResponse(macroState, receiveTimeout, false, LcMacroResponse.TYPE);
                    break block7;
                }
                LOGGER.warn("Wait for macro state of LcMacroHandle failed for node: {}", (Object)this.delegate.node);
                throw new ProtocolNoAnswerException("Wait for macro state of LcMacroHandle failed.");
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Wait for all macro step answers was interrupted.");
            }
            finally {
                this.delegate.getConsumerSupportMessageListener().setLcMacroStateConsumer(null);
            }
        }
        return macroState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LcMacro setMacroStep(LcMacro macroStep) throws ProtocolException {
        byte[] macroData2;
        block7: {
            LOGGER.info("Set the macro step: {}", (Object)macroStep);
            byte[] nodeAddr = this.getAddr();
            CountDownLatch continueLock = new CountDownLatch(1);
            LinkedList responses = new LinkedList();
            LcMacroConsumer lcMacroConsumer = (address, macroData) -> {
                if (Arrays.equals(nodeAddr, address)) {
                    List list = responses;
                    synchronized (list) {
                        responses.add(macroData);
                    }
                    continueLock.countDown();
                }
            };
            macroData2 = null;
            try {
                LOGGER.info("Set macro step for node: {}", (Object)this.delegate.node);
                this.delegate.getConsumerSupportMessageListener().setLcMacroConsumer(lcMacroConsumer);
                boolean successful = this.sendAndWaitForResponse(() -> this.delegate.getRequestFactory().createLcMacroSet(macroStep), 400L, continueLock);
                if (successful) {
                    macroData2 = (byte[])responses.get(0);
                    this.delegate.expectResponse(macroData2, null, false, LcMacroResponse.TYPE);
                    break block7;
                }
                LOGGER.warn("Wait for macro step failed for node: {}", (Object)this.delegate.node);
                throw new ProtocolNoAnswerException("Wait for macro step failed.");
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Wait for all macro step answers was interrupted.");
            }
            finally {
                this.delegate.getConsumerSupportMessageListener().setLcMacroConsumer(null);
            }
        }
        LcMacro result = null;
        if (macroData2 != null) {
            result = MacroUtils.getMacro(macroData2);
            LOGGER.info("The returned macro step is: {}", (Object)result);
        }
        return result;
    }

    public void setMacroParameter(int macroNumber, int parameter, byte ... value) throws ProtocolException {
        LOGGER.debug("Set macro parameter, macroNumber: {}, parameter: {}, value: {}", new Object[]{macroNumber, parameter, value});
        final byte[] nodeAddr = this.getAddr();
        final CompletableFuture future = new CompletableFuture();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void lcMacroParameter(byte[] address, int messageNum, int macroNumber, int parameterIndex, LcMacroParaValue value) {
                if (Arrays.equals(nodeAddr, address)) {
                    LOGGER.info("Received lcMacroParameter.");
                    future.complete(value);
                } else {
                    LOGGER.info("Received lcMacroParameter from another node.");
                }
            }
        };
        LcMacroParaValue macroParaValue = (LcMacroParaValue)this.sendAndWaitForResponse(messageListener, () -> this.delegate.getRequestFactory().createLcMacroParaSet(macroNumber, parameter, value), future);
        this.delegate.expectResponse(macroParaValue, null, false, LcMacroParaResponse.TYPE);
    }

    private void addMessageListener(MessageListener messageListener) {
        this.getBidibNode().getMessageReceiver().addMessageListener(messageListener);
    }

    private void removeMessageListener(MessageListener messageListener) {
        this.getBidibNode().getMessageReceiver().removeMessageListener(messageListener);
    }

    private <T> T sendAndWaitForResponse(MessageListener messageListener, Supplier<BidibCommand> sendOperation, CompletableFuture<T> future) throws ProtocolException {
        return this.sendAndWaitForResponse(messageListener, sendOperation, this.getBidibNode().getResponseTimeout(), future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T sendAndWaitForResponse(MessageListener messageListener, Supplier<BidibCommand> sendOperation, long responseTimeout, CompletableFuture<T> future) throws ProtocolException {
        BidibCommand command = sendOperation.get();
        try {
            T response;
            this.addMessageListener(messageListener);
            this.getBidibNode().sendNoWait((BidibMessageInterface)command);
            LOGGER.debug("The message was sent, wait for response.");
            T t = response = future.get(responseTimeout, TimeUnit.MILLISECONDS);
            return t;
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof ProtocolInvalidParamException) {
                LOGGER.info("The requested param is invalid: {}", (Object)ex.getMessage());
            } else {
                LOGGER.warn("Wait for response failed: {}", (Object)command, (Object)ex);
            }
        }
        catch (InterruptedException | TimeoutException ex) {
            LOGGER.warn("Wait for response failed: {}", (Object)command, (Object)ex);
        }
        finally {
            this.removeMessageListener(messageListener);
        }
        return null;
    }

    private <T> T sendAndWaitForResponse(Supplier<BidibCommand> sendOperation, CompletableFuture<T> future) throws ProtocolException, InterruptedException {
        return this.sendAndWaitForResponse(sendOperation, (long)this.getBidibNode().getResponseTimeout(), future);
    }

    private <T> T sendAndWaitForResponse(Supplier<BidibCommand> sendOperation, long responseTimeout, CompletableFuture<T> future) throws ProtocolException, InterruptedException {
        BidibCommand command = sendOperation.get();
        try {
            this.getBidibNode().sendNoWait((BidibMessageInterface)command);
            LOGGER.debug("The message was sent, wait for response.");
            T response = future.get(responseTimeout, TimeUnit.MILLISECONDS);
            return response;
        }
        catch (ExecutionException | TimeoutException ex) {
            LOGGER.warn("Wait for response failed: {}", (Object)command, (Object)ex);
            return null;
        }
    }

    private boolean sendAndWaitForResponse(Supplier<BidibCommand> sendOperation, CountDownLatch latch) throws ProtocolException, InterruptedException {
        return this.sendAndWaitForResponse(sendOperation, (long)this.getBidibNode().getResponseTimeout(), latch);
    }

    private boolean sendAndWaitForResponse(Supplier<BidibCommand> sendOperation, long responseTimeout, CountDownLatch latch) throws ProtocolException, InterruptedException {
        BidibCommand command = sendOperation.get();
        try {
            this.getBidibNode().sendNoWait((BidibMessageInterface)command);
            LOGGER.debug("The message was sent, wait for response.");
            return latch.await(responseTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait for response failed: {}", (Object)command, (Object)ex);
            return false;
        }
    }

    private ProtocolException createNoResponseAvailable(String messageName) {
        ProtocolNoAnswerException ex = new ProtocolNoAnswerException("No response received from '" + messageName + "' message! Current node: " + this);
        return ex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("@").append(this.hashCode());
        sb.append(",addr=").append(Arrays.toString(this.delegate.getAddr()));
        sb.append(",uniqueId=").append(ByteUtils.formatHexUniqueId((Long)this.delegate.getCachedUniqueId()));
        sb.append(",magic=").append(ByteUtils.integerToHex((Integer)this.delegate.getNodeMagic()));
        return sb.toString();
    }
}

