/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.core.node;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.core.BidibMessageProcessor;
import org.bidib.jbidibc.core.DefaultMessageListener;
import org.bidib.jbidibc.core.InbandProtocolHandler;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.event.MessageTimeoutEvent;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.core.node.messagelistener.ConsumerSupportMessageListener;
import org.bidib.jbidibc.core.schema.BidibFactory;
import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.FeatureData;
import org.bidib.jbidibc.messages.FirmwareUpdateStat;
import org.bidib.jbidibc.messages.LastSendMessageTimestampProvider;
import org.bidib.jbidibc.messages.LcConfig;
import org.bidib.jbidibc.messages.LcConfigX;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.StallStatusProvider;
import org.bidib.jbidibc.messages.StringData;
import org.bidib.jbidibc.messages.VendorData;
import org.bidib.jbidibc.messages.VendorGetData;
import org.bidib.jbidibc.messages.enums.FirmwareUpdateOperation;
import org.bidib.jbidibc.messages.enums.IdentifyState;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.exception.ProtocolNoAnswerException;
import org.bidib.jbidibc.messages.logger.Logger;
import org.bidib.jbidibc.messages.message.BidibBulkCommand;
import org.bidib.jbidibc.messages.message.BidibCommand;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.BoostOffMessage;
import org.bidib.jbidibc.messages.message.BoostOnMessage;
import org.bidib.jbidibc.messages.message.FeatureGetAllMessage;
import org.bidib.jbidibc.messages.message.FeatureGetNextMessage;
import org.bidib.jbidibc.messages.message.FeedbackGetAddressRangeMessage;
import org.bidib.jbidibc.messages.message.FeedbackGetConfidenceMessage;
import org.bidib.jbidibc.messages.message.FeedbackGetRangeMessage;
import org.bidib.jbidibc.messages.message.FeedbackMirrorFreeMessage;
import org.bidib.jbidibc.messages.message.FeedbackMirrorMultipleMessage;
import org.bidib.jbidibc.messages.message.FeedbackMirrorOccupiedMessage;
import org.bidib.jbidibc.messages.message.FeedbackMirrorPositionMessage;
import org.bidib.jbidibc.messages.message.FeedbackPositionResponse;
import org.bidib.jbidibc.messages.message.LcConfigGetMessage;
import org.bidib.jbidibc.messages.message.LcConfigSetMessage;
import org.bidib.jbidibc.messages.message.LcConfigXGetAllMessage;
import org.bidib.jbidibc.messages.message.LcConfigXGetMessage;
import org.bidib.jbidibc.messages.message.LcConfigXSetMessage;
import org.bidib.jbidibc.messages.message.LcKeyMessage;
import org.bidib.jbidibc.messages.message.LcOutputMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryAllMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryMessage;
import org.bidib.jbidibc.messages.message.LocalPongResponse;
import org.bidib.jbidibc.messages.message.NodeChangedAckMessage;
import org.bidib.jbidibc.messages.message.NodeTabCountResponse;
import org.bidib.jbidibc.messages.message.NodeTabResponse;
import org.bidib.jbidibc.messages.message.StringResponse;
import org.bidib.jbidibc.messages.message.SysIdentifyMessage;
import org.bidib.jbidibc.messages.message.SysMagicResponse;
import org.bidib.jbidibc.messages.message.SysPVersionResponse;
import org.bidib.jbidibc.messages.message.SysPingMessage;
import org.bidib.jbidibc.messages.message.SysResetMessage;
import org.bidib.jbidibc.messages.message.SysSwVersionResponse;
import org.bidib.jbidibc.messages.message.VendorAckResponse;
import org.bidib.jbidibc.messages.message.VendorGetMessage;
import org.bidib.jbidibc.messages.message.VendorResponse;
import org.bidib.jbidibc.messages.message.VendorSetMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.CollectionUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bushe.swing.event.EventBus;
import org.slf4j.LoggerFactory;

public class BidibNode {
    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(BidibNode.class);
    private static final org.slf4j.Logger LOGGER_LCCONFIGX = LoggerFactory.getLogger(LcConfigX.class);
    public static final int BIDIB_MAGIC_UNKNOWN = -1;
    protected static final int BULK_WINDOW_SIZE = 4;
    private static final int MAX_MESSAGE_PAKET_LEN = 62;
    private static final org.slf4j.Logger MSG_TX_LOGGER = LoggerFactory.getLogger((String)"TX");
    private static final long BLOCK_IF_STALL_TIMEOUT = 300L;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    private static final byte MSG_LOCAL_PING_TYPE = ByteUtils.getLowByte((int)113);
    private final Logger messageLogger;
    protected Node node;
    private final byte[] addr;
    private int nextReceiveMsgNum = 0;
    private final Object nextReceiveMsgNumLock = new Object();
    private int nextSendMsgNum = -1;
    private final Object nextSendMsgNumLock = new Object();
    private final ByteArrayOutputStream output = new ByteArrayOutputStream();
    private final BidibMessageProcessor messageReceiver;
    private final StallStatusProvider stallStatusProvider;
    private BidibInterface bidib;
    private Integer nodeMagic;
    private Long uniqueId;
    protected boolean ignoreWaitTimeout;
    private boolean secureAckEnabled;
    private AtomicBoolean enabled = new AtomicBoolean(true);
    private int responseTimeout = 400;
    private int firmwarePacketTimeout = 400;
    private BidibRequestFactory requestFactory;
    private final Object sendLock = new Object();
    private volatile BlockingQueue<BidibCommand> acknowledgeSendQueue = new LinkedTransferQueue<BidibCommand>();
    private long lastSentMessageTimestamp;
    private final AtomicBoolean nodeValid = new AtomicBoolean(true);
    private ConsumerSupportMessageListener consumerSupportMessageListener;
    private final LastSendMessageTimestampProvider lastSendMessageTimestampProvider;
    private ReentrantLock processPendingSendQueueLock = new ReentrantLock();

    protected BidibNode(Node node, BidibMessageProcessor messageReceiver, StallStatusProvider stallStatusProvider, boolean ignoreWaitTimeout, LastSendMessageTimestampProvider lastSendMessageTimestampProvider) {
        if (node == null) {
            throw new IllegalArgumentException("The node must not be null!");
        }
        this.node = node;
        this.addr = (byte[])node.getAddr().clone();
        this.messageReceiver = messageReceiver;
        this.stallStatusProvider = stallStatusProvider;
        this.ignoreWaitTimeout = ignoreWaitTimeout;
        this.lastSendMessageTimestampProvider = lastSendMessageTimestampProvider;
        LOGGER.debug("Create new BidibNode with address: {}, ignoreWaitTimeout: {}", (Object)this.addr, (Object)ignoreWaitTimeout);
        this.messageLogger = new Logger(){

            public void debug(String format, Object ... arguments) {
                LOGGER_LCCONFIGX.debug(format, arguments);
            }

            public void info(String format, Object ... arguments) {
                LOGGER_LCCONFIGX.info(format, arguments);
            }

            public void warn(String format, Object ... arguments) {
                LOGGER_LCCONFIGX.warn(format, arguments);
            }

            public void error(String format, Object ... arguments) {
                LOGGER_LCCONFIGX.error(format, arguments);
            }
        };
    }

    protected LastSendMessageTimestampProvider getLastSendMessageTimestampProvider() {
        return this.lastSendMessageTimestampProvider;
    }

    public void setBidib(BidibInterface bidib) {
        this.bidib = bidib;
    }

    public void setRequestFactory(BidibRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    public BidibRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(int responseTimeout) {
        LOGGER.info("Set the response timeout: {}", (Object)responseTimeout);
        this.responseTimeout = responseTimeout;
    }

    public void setFirmwarePacketTimeout(int firmwarePacketTimeout) {
        this.firmwarePacketTimeout = firmwarePacketTimeout;
    }

    protected BidibMessageProcessor getMessageReceiver() {
        return this.messageReceiver;
    }

    protected synchronized ConsumerSupportMessageListener getConsumerSupportMessageListener() {
        if (this.consumerSupportMessageListener == null) {
            this.consumerSupportMessageListener = new ConsumerSupportMessageListener(this.addr);
            this.getMessageReceiver().addMessageListener(this.consumerSupportMessageListener);
        }
        return this.consumerSupportMessageListener;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("@").append(this.hashCode());
        sb.append(",addr=").append(Arrays.toString(this.addr));
        sb.append(",uniqueId=").append(ByteUtils.formatHexUniqueId((Long)this.uniqueId));
        sb.append(",magic=").append(ByteUtils.integerToHex((Integer)this.nodeMagic));
        return sb.toString();
    }

    public void terminate() {
        LOGGER.debug("Terminate the node.");
        this.nodeValid.set(false);
        this.resetNextSendMsgNum();
        if (this.consumerSupportMessageListener != null) {
            try {
                this.getMessageReceiver().removeMessageListener(this.consumerSupportMessageListener);
            }
            catch (Exception ex) {
                LOGGER.warn("Remove consumerSupportMessageListener failed.", (Throwable)ex);
            }
            this.consumerSupportMessageListener = null;
        }
    }

    public void blockIfStall(long timeout) {
        LOGGER.debug("blockIfStall, timeout: {}", (Object)timeout);
        if (this.node != null) {
            this.node.blockIfStall(timeout);
        } else {
            LOGGER.warn("No node to check for stall flag available.");
        }
    }

    public Integer getNodeMagic() {
        return this.nodeMagic;
    }

    public void setNodeMagic(Integer magic) {
        LOGGER.debug("Set magic of node: {}", (Object)magic);
        this.nodeMagic = magic;
    }

    public boolean isBootloaderNode() {
        if (this.node != null && this.node.getMagic() != null) {
            this.nodeMagic = this.node.getMagic();
            LOGGER.info("Get the magic from the core node: {}", (Object)this.nodeMagic);
        }
        if (this.nodeMagic != null) {
            return 45069 == this.nodeMagic;
        }
        LOGGER.warn("No magic available for current node. Assume this is a bootloader node!");
        return true;
    }

    public byte[] getAddr() {
        return this.addr;
    }

    protected ProtocolNoAnswerException createNoResponseAvailable(String messageName) {
        ProtocolNoAnswerException ex = new ProtocolNoAnswerException("No response received from '" + messageName + "' message! Current node: " + this);
        return ex;
    }

    private ProtocolException createNotSupportedByBootloaderNode(String messageName) {
        ProtocolException ex = new ProtocolException("The current node is a limited bootloader node and does not support the '" + messageName + "' message! Current node: " + this);
        return ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextReceiveMsgNum(BidibMessageInterface message) {
        Object object = this.nextReceiveMsgNumLock;
        synchronized (object) {
            ++this.nextReceiveMsgNum;
            if (this.nextReceiveMsgNum > 255) {
                this.nextReceiveMsgNum = 1;
            }
            if (message.getNum() == 0) {
                this.nextReceiveMsgNum = 0;
            }
        }
        return this.nextReceiveMsgNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustReceiveMsgNum(int newReceiveMsgNum) {
        LOGGER.warn("The receive message number is adjusted on request: {}, current node: {}", (Object)newReceiveMsgNum, (Object)this);
        Object object = this.nextReceiveMsgNumLock;
        synchronized (object) {
            this.nextReceiveMsgNum = newReceiveMsgNum;
            if (this.nextReceiveMsgNum > 255) {
                this.nextReceiveMsgNum = 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextSendMsgNum() {
        Object object = this.nextSendMsgNumLock;
        synchronized (object) {
            ++this.nextSendMsgNum;
            if (this.nextSendMsgNum > 255) {
                this.nextSendMsgNum = 1;
            }
        }
        return this.nextSendMsgNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int revertNextSendMsgNum() {
        Object object = this.nextSendMsgNumLock;
        synchronized (object) {
            --this.nextSendMsgNum;
            if (this.nextSendMsgNum < 1) {
                this.nextSendMsgNum = 255;
            }
        }
        return this.nextSendMsgNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetNextSendMsgNum() {
        Object object = this.nextSendMsgNumLock;
        synchronized (object) {
            LOGGER.warn("Reset the nextSendMsgNum. Current nextSendMsgNum: {}", (Object)this.nextSendMsgNum);
            this.nextSendMsgNum = -1;
        }
    }

    public boolean acknowledge(BidibCommand message) throws ProtocolException {
        LOGGER.debug("Add the acknowledge message to sendQueue, message: {}", (Object)message);
        boolean added = this.acknowledgeSendQueue.offer(message);
        if (!added) {
            LOGGER.warn("Add the acknowledge message to sendQueue failed: {}", (Object)message);
            throw new ProtocolException("Add the acknowledge message to sendQueue failed.");
        }
        return added;
    }

    public void acknowledgeNodeChanged(int versionNumber) throws ProtocolException {
        LOGGER.debug("Add the NodeChangedAckMessage to sendQueue, versionNumber: {}", (Object)versionNumber);
        boolean added = this.acknowledgeSendQueue.offer((BidibCommand)new NodeChangedAckMessage(versionNumber));
        if (!added) {
            LOGGER.warn("Add the NodeChangedAckMessage to sendQueue failed.");
            throw new ProtocolException("Add the NodeChangedAckMessage to sendQueue failed.");
        }
    }

    public void acknowledgeFree(int detectorNumber) throws ProtocolException {
        LOGGER.debug("Add the FeedbackMirrorFreeMessage to sendQueue, detectorNumber: {}", (Object)detectorNumber);
        boolean added = this.acknowledgeSendQueue.offer((BidibCommand)new FeedbackMirrorFreeMessage(detectorNumber));
        if (!added) {
            LOGGER.warn("Add the FeedbackMirrorFreeMessage to sendQueue failed.");
            throw new ProtocolException("Add the FeedbackMirrorFreeMessage to sendQueue failed.");
        }
    }

    public void acknowledgeMultiple(int baseAddress, int size, byte[] detectorData) throws ProtocolException {
        LOGGER.debug("Send FeedbackMirrorMultipleMessage to baseAddress: {}", (Object)baseAddress);
        boolean added = this.acknowledgeSendQueue.offer((BidibCommand)new FeedbackMirrorMultipleMessage(baseAddress, size, detectorData));
        if (!added) {
            LOGGER.warn("Add the FeedbackMirrorMultipleMessage to sendQueue failed.");
            throw new ProtocolException("Add the FeedbackMirrorMultipleMessage to sendQueue failed.");
        }
    }

    public void acknowledgeOccupied(int detectorNumber) throws ProtocolException {
        LOGGER.debug("Add the FeedbackMirrorOccupiedMessage to sendQueue, detectorNumber: {}", (Object)detectorNumber);
        boolean added = this.acknowledgeSendQueue.offer((BidibCommand)new FeedbackMirrorOccupiedMessage(detectorNumber));
        if (!added) {
            LOGGER.warn("Add the FeedbackMirrorOccupiedMessage to sendQueue failed.");
            throw new ProtocolException("Add the FeedbackMirrorOccupiedMessage to sendQueue failed.");
        }
    }

    public void acknowledgePosition(FeedbackPositionResponse feedbackPositionResponse) throws ProtocolException {
        int decoderAddress = feedbackPositionResponse.getDecoderAddress();
        int locationType = feedbackPositionResponse.getLocationType();
        int locationAddress = feedbackPositionResponse.getLocationAddress();
        LOGGER.debug("Add the FeedbackMirrorPostionMessage to sendQueue, decoderAddress: {}, locationAddress: {}", (Object)decoderAddress, (Object)locationAddress);
        boolean added = this.acknowledgeSendQueue.offer((BidibCommand)new FeedbackMirrorPositionMessage(decoderAddress, locationType, locationAddress, feedbackPositionResponse.getExtendedData()));
        if (!added) {
            LOGGER.warn("Add the FeedbackMirrorPositionMessage to sendQueue failed.");
            throw new ProtocolException("Add the FeedbackMirrorPositionMessage to sendQueue failed.");
        }
    }

    public void boosterOn(byte broadcast) throws ProtocolException {
        this.sendNoWait((BidibMessageInterface)new BoostOnMessage(broadcast));
    }

    public void boosterOff(byte broadcast) throws ProtocolException {
        this.sendNoWait((BidibMessageInterface)new BoostOffMessage(broadcast));
    }

    public void getAddressState(int begin, int end) throws ProtocolException {
        this.sendNoWait((BidibMessageInterface)new FeedbackGetAddressRangeMessage(begin, end));
    }

    public void getConfidence() throws ProtocolException {
        this.sendNoWait((BidibMessageInterface)new FeedbackGetConfidenceMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feature setFeature(int featureNumber, int value) throws ProtocolException {
        final CountDownLatch continueLock = new CountDownLatch(1);
        final ArrayList features = new ArrayList();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void feature(byte[] address, int messageNum, Feature feature) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received the Feature response, address: {}, feature: {}", (Object)NodeUtils.formatAddressLong((byte[])address), (Object)feature);
                }
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    features.add(feature);
                    continueLock.countDown();
                } else {
                    LOGGER.debug("Received Feature for another node.");
                }
            }

            @Override
            public void featureNotAvailable(byte[] address, int messageNum, int featureNumber) {
                LOGGER.info("Received the Feature not available response, address: {}, featureNumber: {}", (Object)NodeUtils.formatAddressLong((byte[])address), (Object)featureNumber);
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    continueLock.countDown();
                } else {
                    LOGGER.debug("Received Feature for another node.");
                }
            }
        };
        try {
            this.getMessageReceiver().addMessageListener(messageListener);
            this.sendNoWait((BidibMessageInterface)this.requestFactory.createFeatureSet(featureNumber, value));
            boolean success = continueLock.await(this.responseTimeout, TimeUnit.MILLISECONDS);
            if (success) {
                if (CollectionUtils.hasElements(features)) {
                    Feature result;
                    Feature feature = result = (Feature)features.get(0);
                    return feature;
                }
                throw new ProtocolException("The requested feature is not available, featureNumber: " + featureNumber);
            }
            LOGGER.warn("Wait for feature count was not successful.");
        }
        catch (InterruptedException e) {
            LOGGER.warn("Wait for response before continue was interrupted.");
        }
        finally {
            this.getMessageReceiver().removeMessageListener(messageListener);
        }
        if (this.ignoreWaitTimeout) {
            LOGGER.warn("No response received but ignoreWaitTimeout ist set! Current node: {}", (Object)this);
            return null;
        }
        throw this.createNoResponseAvailable("feature set");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feature getFeature(int featureNumber) throws ProtocolException {
        LOGGER.debug("Get feature with number: {}", (Object)featureNumber);
        if (this.isBootloaderNode()) {
            LOGGER.warn("The current node is a bootloader node and does not support feature requests.");
            throw this.createNotSupportedByBootloaderNode("MSG_FEATURE_GET");
        }
        final CountDownLatch continueLock = new CountDownLatch(1);
        final LinkedList features = new LinkedList();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void feature(byte[] address, int messageNum, Feature feature) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received the Feature response, address: {}, feature: {}", (Object)NodeUtils.formatAddressLong((byte[])address), (Object)feature);
                }
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    features.add(feature);
                    continueLock.countDown();
                } else {
                    LOGGER.debug("Received Feature for another node.");
                }
            }

            @Override
            public void featureNotAvailable(byte[] address, int messageNum, int featureNumber) {
                LOGGER.info("Received the Feature response, address: {}, featureNumber: {}", (Object)NodeUtils.formatAddressLong((byte[])address), (Object)featureNumber);
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    continueLock.countDown();
                } else {
                    LOGGER.debug("Received Feature for another node.");
                }
            }
        };
        try {
            this.getMessageReceiver().addMessageListener(messageListener);
            this.sendNoWait((BidibMessageInterface)this.requestFactory.createFeatureGet(featureNumber));
            boolean success = continueLock.await(this.responseTimeout, TimeUnit.MILLISECONDS);
            if (success) {
                if (CollectionUtils.hasElements(features)) {
                    Feature result;
                    Feature feature = result = (Feature)features.get(0);
                    return feature;
                }
                throw new ProtocolException("The requested feature is not available, featureNumber: " + featureNumber);
            }
            LOGGER.warn("Wait for feature count was not successful.");
        }
        catch (InterruptedException e) {
            LOGGER.warn("Wait for response before continue was interrupted.");
        }
        finally {
            this.getMessageReceiver().removeMessageListener(messageListener);
        }
        if (this.ignoreWaitTimeout) {
            LOGGER.warn("No response received but ignoreWaitTimeout ist set! Current node: {}", (Object)this);
            return null;
        }
        throw this.createNoResponseAvailable("get feature");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getFeatureCount() throws ProtocolException {
        if (this.isBootloaderNode()) {
            LOGGER.warn("The current node is a bootloader node and does not support feature requests.");
            throw this.createNotSupportedByBootloaderNode("MSG_FEATURE_GETALL");
        }
        final CountDownLatch continueLock = new CountDownLatch(1);
        final AtomicInteger featureCountValue = new AtomicInteger();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void featureCount(byte[] address, int messageNum, int featureCount, boolean streamingSupported) {
                LOGGER.info("Received the FeatureCount response, address: {}, featureCount: {}, streamingSupported: {}", new Object[]{NodeUtils.formatAddressLong((byte[])address), featureCount, streamingSupported});
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    featureCountValue.set(featureCount);
                    continueLock.countDown();
                } else {
                    LOGGER.debug("Received FeatureCount for another node.");
                }
            }
        };
        try {
            this.getMessageReceiver().addMessageListener(messageListener);
            this.sendNoWait((BidibMessageInterface)this.requestFactory.createFeatureGetAll());
            boolean success = continueLock.await(this.responseTimeout, TimeUnit.MILLISECONDS);
            if (success) {
                int featureCount = featureCountValue.get();
                LOGGER.debug("Current featureCount: {}", (Object)featureCount);
                Integer n = featureCount;
                return n;
            }
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait for response before continue was interrupted.");
        }
        finally {
            this.getMessageReceiver().removeMessageListener(messageListener);
        }
        if (this.ignoreWaitTimeout) {
            LOGGER.warn("No response received but ignoreWaitTimeout ist set! Current node: {}", (Object)this);
            return 0;
        }
        throw this.createNoResponseAvailable("get feature count");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FeatureData getFeaturesAll() throws ProtocolException {
        AtomicInteger featureCountValue;
        block12: {
            if (this.isBootloaderNode()) {
                LOGGER.warn("The current node is a bootloader node and does not support feature requests.");
                throw this.createNotSupportedByBootloaderNode("MSG_FEATURE_GETALL");
            }
            int startStreaming = 1;
            boolean useStreaming = this.node.getProtocolVersion().isHigherThan(ProtocolVersion.VERSION_0_6);
            FeatureGetAllMessage featureGetAllMessage = useStreaming ? this.requestFactory.createFeatureGetAll(startStreaming) : this.requestFactory.createFeatureGetAll();
            final LinkedList features = new LinkedList();
            final CountDownLatch continueLock = new CountDownLatch(1);
            featureCountValue = new AtomicInteger();
            final AtomicBoolean streamingSupportedValue = new AtomicBoolean();
            final CountDownLatch[] continueLockFeatures = new CountDownLatch[1];
            DefaultMessageListener messageListener = new DefaultMessageListener(){

                @Override
                public void featureCount(byte[] address, int messageNum, int featureCount, boolean streamingSupported) {
                    LOGGER.info("Received the FeatureCount response, address: {}, featureCount: {}, streamingSupported: {}", new Object[]{NodeUtils.formatAddressLong((byte[])address), featureCount, streamingSupported});
                    if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                        featureCountValue.set(featureCount);
                        streamingSupportedValue.set(streamingSupported);
                        continueLockFeatures[0] = new CountDownLatch(featureCount);
                        continueLock.countDown();
                    } else {
                        LOGGER.debug("Received FeatureCount for another node.");
                    }
                }

                @Override
                public void feature(byte[] address, int messageNum, Feature feature) {
                    LOGGER.info("Received the Feature response, address: {}, feature: {}", (Object)NodeUtils.formatAddressLong((byte[])address), (Object)feature);
                    if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                        features.add(feature);
                        continueLockFeatures[0].countDown();
                    } else {
                        LOGGER.debug("Received Feature for another node.");
                    }
                }
            };
            try {
                this.getMessageReceiver().addMessageListener(messageListener);
                this.sendNoWait((BidibMessageInterface)featureGetAllMessage);
                boolean success = continueLock.await(this.responseTimeout, TimeUnit.MILLISECONDS);
                if (success) {
                    if (!streamingSupportedValue.get()) {
                        LOGGER.info("Streaming is not supported by node. Current featureCount: {}", (Object)featureCountValue);
                        FeatureData featureData = new FeatureData(featureCountValue.get(), false, Collections.emptyList());
                        return featureData;
                    }
                    int featureCount = featureCountValue.get();
                    LOGGER.info("Streaming is supported by node. Current featureCount: {}", (Object)featureCount);
                    if (featureCount > 0) {
                        int expectedFeatureCount = featureCount;
                        long maxWaitDuration = featureCount * 400;
                        LOGGER.debug("Wait for features, maxWaitDuration: {}", (Object)maxWaitDuration);
                        boolean successAwaitFeatures = continueLockFeatures[0].await(maxWaitDuration, TimeUnit.MILLISECONDS);
                        if (successAwaitFeatures) {
                            LOGGER.debug("All messages of the sent window were received, expectedFeatureCount: {}", (Object)expectedFeatureCount);
                            FeatureData featureData = new FeatureData(featureCount, true, features);
                            return featureData;
                        }
                        LOGGER.warn("Wait for streamed features was not successful.");
                    }
                    break block12;
                }
                LOGGER.warn("Wait for feature count was not successful.");
            }
            catch (InterruptedException e) {
                LOGGER.warn("Wait for response before continue was interrupted.");
            }
            finally {
                this.getMessageReceiver().removeMessageListener(messageListener);
            }
        }
        if (!this.ignoreWaitTimeout) throw this.createNoResponseAvailable("get feature count");
        LOGGER.warn("No response received but ignoreWaitTimeout ist set! Current node: {}", (Object)this);
        return new FeatureData(featureCountValue.get(), false, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feature getNextFeature() throws ProtocolException {
        if (this.isBootloaderNode()) {
            LOGGER.warn("The current node is a bootloader node and does not support feature requests.");
            throw this.createNotSupportedByBootloaderNode("MSG_FEATURE_GETNEXT");
        }
        final CountDownLatch continueLock = new CountDownLatch(1);
        final Holder featureHolder = new Holder();
        final AtomicInteger featureNotAvailableNumber = new AtomicInteger();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void feature(byte[] address, int messageNum, Feature feature) {
                LOGGER.debug("Received the feature response, address: {}, featureCount: {}", (Object)NodeUtils.formatAddressLong((byte[])address), (Object)feature);
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    featureHolder.set(feature);
                    continueLock.countDown();
                } else {
                    LOGGER.debug("Received feature for another node.");
                }
            }

            @Override
            public void featureNotAvailable(byte[] address, int messageNum, int featureNumber) {
                LOGGER.info("Received the Feature not available response, address: {}, featureNumber: {}", (Object)NodeUtils.formatAddressLong((byte[])address), (Object)featureNumber);
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    featureNotAvailableNumber.set(featureNumber);
                    continueLock.countDown();
                } else {
                    LOGGER.debug("Received Feature for another node.");
                }
            }
        };
        try {
            this.getMessageReceiver().addMessageListener(messageListener);
            this.sendNoWait((BidibMessageInterface)this.requestFactory.createFeatureGetNext());
            boolean success = continueLock.await(this.responseTimeout, TimeUnit.MILLISECONDS);
            if (success) {
                Feature feature = (Feature)featureHolder.get();
                LOGGER.debug("Current feature: {}", (Object)feature);
                if (feature == null) {
                    LOGGER.info("No feature available with number: {}", (Object)featureNotAvailableNumber.get());
                    throw new ProtocolException("The requested feature is not available, featureNumber: " + featureNotAvailableNumber.get());
                }
                Feature feature2 = feature;
                return feature2;
            }
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait for response before continue was interrupted.");
        }
        finally {
            this.getMessageReceiver().removeMessageListener(messageListener);
        }
        if (this.ignoreWaitTimeout) {
            LOGGER.warn("No response received but ignoreWaitTimeout ist set! Current node: {}", (Object)this);
            return null;
        }
        throw this.createNoResponseAvailable("get next feature");
    }

    public List<Feature> getFeaturesBulk(int featureCount) throws ProtocolException {
        return this.getFeaturesBulk(featureCount, 5);
    }

    public List<Feature> getFeaturesBulk(int featureCount, int bulkWindowSize) throws ProtocolException {
        if (this.isBootloaderNode()) {
            LOGGER.warn("The current node is a bootloader node and does not support feature requests.");
            throw this.createNotSupportedByBootloaderNode("MSG_FEATURE_GETNEXT");
        }
        LinkedList<FeatureGetNextMessage> messages = new LinkedList<FeatureGetNextMessage>();
        for (int index = 0; index < featureCount; ++index) {
            messages.add(this.requestFactory.createFeatureGetNext());
        }
        if (ProductUtils.isMultiDecoder((long)this.getUniqueId())) {
            bulkWindowSize = 2;
        }
        final LinkedList<Feature> features = new LinkedList<Feature>();
        final CountDownLatch continueLock = new CountDownLatch(featureCount);
        final CountDownLatch[] continueLockFeatures = new CountDownLatch[1];
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void feature(byte[] address, int messageNum, Feature feature) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received the Feature response, address: {}, feature: {}", (Object)NodeUtils.formatAddressLong((byte[])address), (Object)feature);
                }
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    features.add(feature);
                    continueLock.countDown();
                    if (continueLockFeatures[0] != null) {
                        continueLockFeatures[0].countDown();
                    }
                } else {
                    LOGGER.debug("Received Feature for another node.");
                }
            }
        };
        try {
            this.getMessageReceiver().addMessageListener(messageListener);
            this.sendBulk(bulkWindowSize, messages, true, ProcessSendQueue.enabled, messageListener, continueLock, continueLockFeatures);
            LOGGER.debug("Wait for all features of node: {}", (Object)this.node);
            boolean success = continueLock.await(bulkWindowSize * (this.responseTimeout / 2), TimeUnit.MILLISECONDS);
            if (success) {
                LOGGER.info("Wait for all features was successful for node: {}", (Object)this.node);
                if (CollectionUtils.hasElements(features)) {
                    LinkedList<Feature> linkedList = features;
                    return linkedList;
                }
            } else {
                LOGGER.warn("Wait for all features was not successful for node: {}", (Object)this.node);
            }
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait for response before continue was interrupted.");
            Thread.currentThread().interrupt();
            throw new RuntimeException("Wait for all feature answers was interrupted.");
        }
        catch (RuntimeException ex) {
            LOGGER.warn("Wait for feature responses failed.", (Throwable)ex);
            throw ex;
        }
        finally {
            this.getMessageReceiver().removeMessageListener(messageListener);
        }
        if (this.ignoreWaitTimeout) {
            LOGGER.warn("No response received but ignoreWaitTimeout ist set! Current node: {}", (Object)this);
            return null;
        }
        throw this.createNoResponseAvailable("get next feature with bulk");
    }

    public void getFeedbackState(int begin, int end) throws ProtocolException {
        this.sendNoWait((BidibMessageInterface)new FeedbackGetRangeMessage(begin, end));
    }

    public int getMagic(Integer receiveTimeout) throws ProtocolException {
        LOGGER.debug("Get the magic, receiveTimeout: {}", (Object)receiveTimeout);
        final byte[] nodeAddr = this.getAddr();
        final CompletableFuture future = new CompletableFuture();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void sysMagic(byte[] address, int messageNum, int magic) {
                if (Arrays.equals(nodeAddr, address)) {
                    future.complete(magic);
                } else {
                    LOGGER.debug("Received sysMagic from another node.");
                }
            }
        };
        Integer magic = (Integer)this.sendAndWaitForResponse(messageListener, () -> this.requestFactory.createSysGetMagic(), future);
        this.expectResponse(magic, receiveTimeout, false, SysMagicResponse.TYPE);
        if (magic != null) {
            LOGGER.info("+++ Return the magic: {}", (Object)magic);
            this.setNodeMagic(magic);
            return magic;
        }
        LOGGER.warn("No MAGIC response received from node: {}", (Object)this);
        throw this.createNoResponseAvailable("get magic");
    }

    public Node getNextNode(final Logger nodeLogger) throws ProtocolException {
        final byte[] nodeAddr = this.getAddr();
        final CompletableFuture future = new CompletableFuture();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void nodeTab(byte[] address, int messageNum, int localAddress, int nodeTabVersion, byte[] uniqueId) {
                if (Arrays.equals(nodeAddr, address)) {
                    Node node = NodeTabResponse.getNode((Logger)nodeLogger, (byte[])address, (int)localAddress, (int)nodeTabVersion, (byte[])uniqueId);
                    future.complete(node);
                } else {
                    LOGGER.debug("Received nodeTab from another node.");
                }
            }
        };
        Node childNode = (Node)this.sendAndWaitForResponse(messageListener, () -> this.requestFactory.createNodeTabGetNext(), future);
        this.expectResponse(childNode, null, false, NodeTabResponse.TYPE);
        if (childNode != null) {
            LOGGER.debug("Fetched child node: {}", (Object)childNode);
            return childNode;
        }
        if (this.ignoreWaitTimeout) {
            LOGGER.warn("No response received but ignoreWaitTimeout ist set! Current node: {}", (Object)this);
            return null;
        }
        throw this.createNoResponseAvailable("get next node");
    }

    public Integer getNodeCount() throws ProtocolException {
        LOGGER.debug("Get all registered nodes from system.");
        final byte[] nodeAddr = this.getAddr();
        final CompletableFuture future = new CompletableFuture();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void nodeTabCount(byte[] address, int messageNum, int nodeTabCount) {
                if (Arrays.equals(nodeAddr, address)) {
                    future.complete(nodeTabCount);
                } else {
                    LOGGER.debug("Received nodeTabCount from another node.");
                }
            }
        };
        Integer nodeTabCount = (Integer)this.sendAndWaitForResponse(messageListener, () -> this.requestFactory.createNodeTabGetAll(), future);
        this.expectResponse(nodeTabCount, null, false, NodeTabCountResponse.TYPE);
        if (nodeTabCount != null) {
            LOGGER.info("Found total nodes: {}", (Object)nodeTabCount);
            return nodeTabCount;
        }
        if (this.ignoreWaitTimeout) {
            LOGGER.warn("No response received but ignoreWaitTimeout ist set! Current node: {}", (Object)this);
            return 0;
        }
        throw this.createNoResponseAvailable("get node count");
    }

    public ProtocolVersion getProtocolVersion() throws ProtocolException {
        if (this.node != null && this.node.getProtocolVersion() != null) {
            return this.node.getProtocolVersion();
        }
        final byte[] nodeAddr = this.getAddr();
        final CompletableFuture future = new CompletableFuture();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void sysProtocolVersion(byte[] address, int messageNum, ProtocolVersion protocolVersion) {
                if (Arrays.equals(nodeAddr, address)) {
                    future.complete(protocolVersion);
                } else {
                    LOGGER.debug("Received sysProtocolVersion from another node.");
                }
            }
        };
        ProtocolVersion protocolVersion = (ProtocolVersion)this.sendAndWaitForResponse(messageListener, () -> this.requestFactory.createSysGetPVersion(), future);
        this.expectResponse(protocolVersion, null, false, SysPVersionResponse.TYPE);
        if (protocolVersion != null) {
            LOGGER.debug("ProtocolVersion of current node: {}", (Object)protocolVersion);
            this.node.setProtocolVersion(protocolVersion);
            return protocolVersion;
        }
        if (this.ignoreWaitTimeout) {
            LOGGER.warn("No response with protocol version received but ignoreWaitTimeout ist set! Current node: {}", (Object)this);
            return null;
        }
        throw this.createNoResponseAvailable("get protocol version");
    }

    private <T> T sendAndWaitForResponse(MessageListener messageListener, Supplier<BidibCommand> sendOperation, CompletableFuture<T> future) throws ProtocolException {
        return this.sendAndWaitForResponse(messageListener, sendOperation, this.responseTimeout, future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T sendAndWaitForResponse(MessageListener messageListener, Supplier<BidibCommand> sendOperation, long responseTimeout, CompletableFuture<T> future) throws ProtocolException {
        try {
            T response;
            this.addMessageListener(messageListener);
            this.sendNoWait((BidibMessageInterface)sendOperation.get());
            LOGGER.debug("The message was sent, wait for response, responseTimeout: {}", (Object)responseTimeout);
            T t = response = future.get(responseTimeout, TimeUnit.MILLISECONDS);
            return t;
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            LOGGER.warn("Wait for response failed", (Throwable)ex);
        }
        finally {
            this.removeMessageListener(messageListener);
        }
        return null;
    }

    public SoftwareVersion getSwVersion() throws ProtocolException {
        if (this.node != null && this.node.getSoftwareVersion() != null) {
            return this.node.getSoftwareVersion();
        }
        final byte[] nodeAddr = this.getAddr();
        final CompletableFuture future = new CompletableFuture();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void sysSoftwareVersion(byte[] address, int messageNum, SoftwareVersion softwareVersion) {
                if (Arrays.equals(nodeAddr, address)) {
                    future.complete(softwareVersion);
                } else {
                    LOGGER.debug("Received sysSoftwareVersion from another node.");
                }
            }
        };
        SoftwareVersion softwareVersion = (SoftwareVersion)this.sendAndWaitForResponse(messageListener, () -> this.requestFactory.createSysGetSwVersion(), future);
        this.expectResponse(softwareVersion, null, false, SysSwVersionResponse.TYPE);
        if (softwareVersion != null) {
            LOGGER.debug("Set the softwareVersion of current node: {}, softwareVersion: {}", (Object)this.node, (Object)softwareVersion);
            this.node.setSoftwareVersion(softwareVersion);
            return softwareVersion;
        }
        if (this.ignoreWaitTimeout) {
            LOGGER.warn("No response with software version received but ignoreWaitTimeout ist set! Current node: {}", (Object)this);
            return null;
        }
        throw this.createNoResponseAvailable("get sw version");
    }

    public Long getUniqueId() throws ProtocolException {
        return this.getUniqueId(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getUniqueId(boolean ignoreCache) throws ProtocolException {
        if (ignoreCache || this.uniqueId == null) {
            final CountDownLatch continueLock = new CountDownLatch(1);
            final Holder uniqueIdValue = new Holder();
            DefaultMessageListener messageListener = new DefaultMessageListener(){

                @Override
                public void sysUniqueId(byte[] address, int messageNum, byte[] uniqueId, Long configFingerPrint) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Received the sysUniqueId response, address: {}, uniqueId: {}, configFingerPrint: {}", new Object[]{NodeUtils.formatAddressLong((byte[])address), uniqueId, configFingerPrint});
                    }
                    if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                        uniqueIdValue.set(uniqueId);
                        continueLock.countDown();
                    } else {
                        LOGGER.debug("Received sysUniqueId for another node.");
                    }
                }
            };
            try {
                this.getMessageReceiver().addMessageListener(messageListener);
                this.sendNoWait((BidibMessageInterface)this.requestFactory.createSysGetUniqueId());
                boolean success = continueLock.await(this.responseTimeout, TimeUnit.MILLISECONDS);
                if (success) {
                    byte[] encodedUniqueId = (byte[])uniqueIdValue.get();
                    this.uniqueId = NodeUtils.getUniqueId((byte[])encodedUniqueId);
                    if (this.uniqueId != null) {
                        LOGGER.info("Fetched uniqueId from node: {}", (Object)ByteUtils.getUniqueIdAsString((Long)this.uniqueId));
                    }
                    Long l = this.uniqueId;
                    return l;
                }
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Wait for response before continue was interrupted.");
            }
            finally {
                this.getMessageReceiver().removeMessageListener(messageListener);
            }
            throw this.createNoResponseAvailable("get unique id");
        }
        return this.uniqueId;
    }

    public void getKeyState(List<Integer> portIds) throws ProtocolException {
        int bulkWindowSize = 4;
        LOGGER.debug("Get key states with bulk read for windowSize: {}, portIds: {}", (Object)bulkWindowSize, portIds);
        LinkedList<LcKeyMessage> messages = new LinkedList<LcKeyMessage>();
        for (int portId : portIds) {
            messages.add(this.requestFactory.createLcKey(portId));
        }
        int portCount = messages.size();
        final CountDownLatch continueLock = new CountDownLatch(portCount);
        final CountDownLatch[] continueLockFeatures = new CountDownLatch[1];
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void lcKey(byte[] address, int messageNum, BidibPort bidibPort, int portStatus) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received the lcKey response, address: {}, feature: {}", (Object)NodeUtils.formatAddressLong((byte[])address), (Object)portStatus);
                }
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    continueLock.countDown();
                    if (continueLockFeatures[0] != null) {
                        continueLockFeatures[0].countDown();
                    }
                } else {
                    LOGGER.debug("Received lcKey for another node.");
                }
            }
        };
        try {
            this.getMessageReceiver().addMessageListener(messageListener);
            this.sendBulk(bulkWindowSize, messages, true, ProcessSendQueue.enabled, messageListener, continueLock, continueLockFeatures);
        }
        catch (RuntimeException ex) {
            LOGGER.warn("Wait for all key status answers was interrupted.", (Throwable)ex);
            throw ex;
        }
        finally {
            this.getMessageReceiver().removeMessageListener(messageListener);
        }
    }

    public void identify(IdentifyState state) throws ProtocolException {
        this.sendNoWait((BidibMessageInterface)new SysIdentifyMessage(state));
    }

    public boolean isUpdatable(Node node) throws ProtocolException {
        try {
            Feature feature = this.getFeature(254);
            if (feature != null) {
                node.setFeature(feature);
                return feature.getValue() == 1;
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Check if node is updatable caused protocol exception.", (Throwable)ex);
        }
        return false;
    }

    public int ping(byte[] marker) throws ProtocolException {
        return this.sendNoWait((BidibMessageInterface)new SysPingMessage(() -> marker));
    }

    public void reset() throws ProtocolException {
        this.sendNoWait((BidibMessageInterface)new SysResetMessage());
    }

    protected int sendNoWait(BidibMessageInterface message) throws ProtocolException {
        return this.send(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int send(BidibMessageInterface message) throws ProtocolException {
        Object object = this.sendLock;
        synchronized (object) {
            LOGGER.debug("Send message: {}", (Object)message);
            ArrayList<BidibMessageInterface> messagesToSend = new ArrayList<BidibMessageInterface>();
            messagesToSend.add(message);
            EncodedMessage encodedMessage = this.encodeMessage(message);
            this.prepareAndSendMessages(List.of(encodedMessage), messagesToSend);
            return encodedMessage.getLength();
        }
    }

    protected EncodedMessage encodeMessage(BidibMessageInterface message) {
        int num = 0;
        if (!message.isLocalMessage()) {
            num = this.getNextSendMsgNum();
        }
        message.setSendMsgNum(num);
        byte type = message.getType();
        byte[] data = message.getData();
        byte[] bytes = null;
        int index = 0;
        message.setAddr(this.addr);
        if (this.addr.length != 0 && this.addr[0] != 0) {
            bytes = new byte[1 + (this.addr.length + 1) + 2 + (data != null ? data.length : 0)];
            bytes[index++] = (byte)(bytes.length - 1);
            for (int addrIndex = 0; addrIndex < this.addr.length; ++addrIndex) {
                bytes[index++] = this.addr[addrIndex];
            }
        } else {
            LOGGER.trace("Current address is the root node.");
            bytes = new byte[1 + this.addr.length + 2 + (data != null ? data.length : 0)];
            bytes[index++] = (byte)(bytes.length - 1);
        }
        bytes[index++] = 0;
        bytes[index++] = (byte)(num & 0xFF);
        bytes[index++] = type;
        if (data != null) {
            for (int dataIndex = 0; dataIndex < data.length; ++dataIndex) {
                bytes[index++] = data[dataIndex];
            }
        }
        EncodedMessage encodedMessage = new EncodedMessage(bytes);
        return encodedMessage;
    }

    private void prepareAndSendMessages(List<EncodedMessage> encodedMessages, List<BidibMessageInterface> messages) throws ProtocolException {
        try {
            this.sendMessages(encodedMessages, messages);
        }
        catch (IOException ex) {
            LOGGER.warn("Send messages failed.", (Throwable)ex);
            throw new ProtocolException("Send messages failed: " + messages);
        }
    }

    private void sendMessages(List<EncodedMessage> encodedMessages, List<BidibMessageInterface> bidibMessages) throws IOException {
        this.stallStatusProvider.blockIfParentNodeStall(this.node, 300L);
        this.node.blockIfStall(300L);
        LOGGER.debug("Send messages after stall lock.");
        if (!this.node.isRegistered()) {
            LOGGER.warn("The node is no longer registered. Skip send message to node: {}", (Object)this.node);
            MSG_TX_LOGGER.warn("The node is no longer registered. Skip send message to node: {}", (Object)this.node);
            throw new IOException("The node is no longer registered.");
        }
        this.output.reset();
        for (EncodedMessage encodedMessage : encodedMessages) {
            byte[] message = encodedMessage.getMessage();
            this.output.write(message);
        }
        StringBuilder sb = new StringBuilder(">> ");
        sb.append(bidibMessages);
        sb.append(" : ");
        sb.append(ByteUtils.bytesToHex((ByteArrayOutputStream)this.output));
        MSG_TX_LOGGER.info(sb.toString());
        if (this.output.size() >= 62) {
            MSG_TX_LOGGER.warn("The MAX_MESSAGE_PAKET_LEN was reached or exceeded: {}", (Object)this.output.size());
            LOGGER.warn("The MAX_MESSAGE_PAKET_LEN was reached or exceeded: {}", (Object)this.output.size());
        }
        this.bidib.send(this.output.toByteArray());
        boolean hasLocalPingMessage = bidibMessages.stream().filter(msg -> msg.getType() == MSG_LOCAL_PING_TYPE).findFirst().isPresent();
        this.updateLastSendMessageTimestamp(hasLocalPingMessage);
        this.output.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPendingSendQueue() throws ProtocolException {
        LOGGER.debug("Process the pending acknowledge messages in the acknowledge send queue, addr: {}", (Object)NodeUtils.formatAddress((byte[])this.addr));
        int timeout = 5;
        try {
            Object object = this.sendLock;
            synchronized (object) {
                if (this.processPendingSendQueueLock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
                    try {
                        ArrayList<BidibCommand> commandsToSend = new ArrayList<BidibCommand>();
                        BidibCommand acknowledge = null;
                        int maxRemainingProcessing = 3;
                        while (true) {
                            if ((acknowledge = (BidibCommand)this.acknowledgeSendQueue.poll()) != null) {
                                commandsToSend.add(acknowledge);
                            }
                            if (acknowledge != null) continue;
                            if (commandsToSend.isEmpty()) {
                                LOGGER.debug("No acknowledge messages to send for current node: {}, maxRemainingProcessing: {}", (Object)this, (Object)maxRemainingProcessing);
                            }
                            LOGGER.debug("Send the acknowledge messages for current node: {}", (Object)this);
                            this.sendBulk(commandsToSend.size(), commandsToSend, false, ProcessSendQueue.disabled, null, null, null);
                            commandsToSend.clear();
                            if (--maxRemainingProcessing <= 0) break;
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Process the pending send queue failed.", (Throwable)ex);
                    }
                    finally {
                        this.processPendingSendQueueLock.unlock();
                    }
                } else {
                    LOGGER.info("Get lock for processPendingSendQueueLock failed: {}", (Object)this.processPendingSendQueueLock);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Get the lock to process pending send queue failed.", (Throwable)ex);
        }
        LOGGER.debug("Finished process the pending acknowledge messages in the acknowledge send queue.");
    }

    public FirmwareUpdateStat sendFirmwareUpdateOperation(FirmwareUpdateOperation operation, byte ... data) throws ProtocolException {
        CompletableFuture future;
        byte[] nodeAddr;
        DefaultMessageListener messageListener;
        FirmwareUpdateStat firmwareUpdateStat;
        Integer receiveTimeout = this.firmwarePacketTimeout;
        if (FirmwareUpdateOperation.EXIT == operation) {
            LOGGER.info("The operation is done. Give the node more time do do the work.");
            receiveTimeout = 4 * this.firmwarePacketTimeout;
        }
        if ((firmwareUpdateStat = (FirmwareUpdateStat)this.sendAndWaitForResponse(messageListener = new DefaultMessageListener(nodeAddr = this.getAddr(), future = new CompletableFuture()){
            final /* synthetic */ byte[] val$nodeAddr;
            final /* synthetic */ CompletableFuture val$future;
            {
                this.val$nodeAddr = byArray;
                this.val$future = completableFuture;
            }

            @Override
            public void firmwareUpdateStat(byte[] address, int messageNum, FirmwareUpdateStat updateStat) {
                if (Arrays.equals(this.val$nodeAddr, address)) {
                    this.val$future.complete(updateStat);
                } else {
                    LOGGER.info("Received firmwareUpdateStat from another node.");
                }
            }
        }, () -> this.requestFactory.createFwUpdateOp(operation, data), receiveTimeout.intValue(), future)) != null) {
            return firmwareUpdateStat;
        }
        throw this.createNoResponseAvailable("firmware update operation");
    }

    public void sysDisable() throws ProtocolException {
        this.enabled.set(false);
        this.sendNoWait((BidibMessageInterface)this.requestFactory.createSysDisable());
    }

    public void sysEnable() throws ProtocolException {
        this.enabled.set(true);
        this.sendNoWait((BidibMessageInterface)this.requestFactory.createSysEnable());
    }

    public void sysEnable(int classEnableL, int classEnableH) throws ProtocolException {
        this.enabled.set(true);
        this.sendNoWait((BidibMessageInterface)this.requestFactory.createSysEnable(classEnableL, classEnableH));
    }

    public boolean vendorDisable() throws ProtocolException {
        final byte[] nodeAddr = this.getAddr();
        final CompletableFuture future = new CompletableFuture();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void vendorAck(byte[] address, int messageNum, int returnCode) {
                if (Arrays.equals(nodeAddr, address)) {
                    future.complete(returnCode);
                } else {
                    LOGGER.trace("Received vendorAck from another node.");
                }
            }
        };
        Integer vendorAck = (Integer)this.sendAndWaitForResponse(messageListener, () -> this.requestFactory.createVendorDisable(), future);
        this.expectResponse(vendorAck, null, false, VendorAckResponse.TYPE);
        if (vendorAck != null) {
            return vendorAck == 0;
        }
        return false;
    }

    public boolean vendorEnable(long uniqueId) throws ProtocolException {
        final byte[] nodeAddr = this.getAddr();
        final CompletableFuture future = new CompletableFuture();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void vendorAck(byte[] address, int messageNum, int returnCode) {
                if (Arrays.equals(nodeAddr, address)) {
                    future.complete(returnCode);
                } else {
                    LOGGER.trace("Received vendorAck from another node.");
                }
            }
        };
        Integer vendorAck = (Integer)this.sendAndWaitForResponse(messageListener, () -> this.requestFactory.createVendorEnable(uniqueId), future);
        this.expectResponse(vendorAck, null, false, VendorAckResponse.TYPE);
        if (vendorAck != null) {
            return vendorAck == 1;
        }
        return false;
    }

    public VendorData vendorGet(String name, boolean skipTimeout) throws ProtocolException {
        LOGGER.debug("Get vendor message, name: {}", (Object)name);
        if (this.isBootloaderNode()) {
            LOGGER.warn("The current node is a bootloader node and does not support vendor data requests.");
            throw this.createNotSupportedByBootloaderNode("MSG_VENDOR_GET");
        }
        final byte[] nodeAddr = this.getAddr();
        final CompletableFuture future = new CompletableFuture();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void vendor(byte[] address, int messageNum, VendorData vendorData) {
                if (Arrays.equals(nodeAddr, address)) {
                    future.complete(vendorData);
                } else {
                    LOGGER.trace("Received vendor data from another node.");
                }
            }
        };
        VendorData vendorData = (VendorData)this.sendAndWaitForResponse(messageListener, () -> this.requestFactory.createVendorGet(name), future);
        this.expectResponse(vendorData, null, skipTimeout, VendorResponse.TYPE);
        return vendorData;
    }

    public List<VendorData> vendorGetBulk(List<VendorGetData> cvNumbers, final List<VendorData> vendorDataList, final InbandProtocolHandler<VendorData> handler) throws ProtocolException {
        LOGGER.debug("Get vendor message, cvNumbers: {}", cvNumbers);
        if (this.isBootloaderNode()) {
            LOGGER.warn("The current node is a bootloader node and does not support vendor data requests.");
            throw this.createNotSupportedByBootloaderNode("MSG_VENDOR_GET");
        }
        LinkedList<VendorGetMessage> messages = new LinkedList<VendorGetMessage>();
        for (VendorGetData vendorGetData : cvNumbers) {
            String name = vendorGetData.getName();
            LOGGER.debug("Add new CV name: {}", (Object)name);
            VendorGetMessage bidibCommand = this.requestFactory.createVendorGet(name);
            bidibCommand.setIgnoreTimeout(vendorGetData.isIgnoreTimeout());
            messages.add(bidibCommand);
        }
        final byte[] nodeAddr = this.getAddr();
        int numMessages = messages.size();
        final CountDownLatch continueLock = new CountDownLatch(numMessages);
        final CountDownLatch[] continueLockPartial = new CountDownLatch[1];
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void vendor(byte[] address, int messageNum, VendorData vendorData) {
                if (Arrays.equals(nodeAddr, address)) {
                    LOGGER.debug("Received vendor data: {}", (Object)vendorData);
                    List list = vendorDataList;
                    synchronized (list) {
                        vendorDataList.add(vendorData);
                    }
                    boolean waitForMoreMessages = false;
                    if (handler != null) {
                        waitForMoreMessages = handler.handleMessageData(vendorData);
                    }
                    if (!waitForMoreMessages) {
                        continueLock.countDown();
                        if (continueLockPartial[0] != null) {
                            continueLockPartial[0].countDown();
                        }
                    }
                } else {
                    LOGGER.trace("Received vendor data from another node.");
                }
            }
        };
        try {
            this.getMessageReceiver().addMessageListener(messageListener);
            this.sendBulk(4, messages, true, ProcessSendQueue.enabled, messageListener, continueLock, continueLockPartial);
        }
        catch (RuntimeException ex) {
            LOGGER.warn("Wait for all vendor get answers was interrupted.");
            throw ex;
        }
        finally {
            this.getMessageReceiver().removeMessageListener(messageListener);
        }
        return Collections.unmodifiableList(vendorDataList);
    }

    public VendorData vendorSet(String name, String value) throws ProtocolException {
        if (this.isBootloaderNode()) {
            LOGGER.warn("The current node is a bootloader node and does not support vendor data requests.");
            throw this.createNotSupportedByBootloaderNode("MSG_VENDOR_SET");
        }
        final byte[] nodeAddr = this.getAddr();
        final CompletableFuture future = new CompletableFuture();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void vendor(byte[] address, int messageNum, VendorData vendorData) {
                if (Arrays.equals(nodeAddr, address)) {
                    future.complete(vendorData);
                } else {
                    LOGGER.trace("Received vendor data from another node.");
                }
            }
        };
        VendorData vendorData = (VendorData)this.sendAndWaitForResponse(messageListener, () -> this.requestFactory.createVendorSet(name, value), future);
        this.expectResponse(vendorData, null, false, VendorResponse.TYPE);
        return vendorData;
    }

    public List<VendorData> vendorSetBulk(List<ConfigurationVariable> configVariables, final InbandProtocolHandler<VendorData> handler) throws ProtocolException {
        if (this.isBootloaderNode()) {
            LOGGER.warn("The current node is a bootloader node and does not support vendor data requests.");
            throw this.createNotSupportedByBootloaderNode("MSG_VENDOR_SET");
        }
        LinkedList<VendorSetMessage> messages = new LinkedList<VendorSetMessage>();
        for (ConfigurationVariable configVariable : configVariables) {
            LOGGER.debug("Add new CV: {}", (Object)configVariable);
            VendorSetMessage bidibCommand = this.requestFactory.createVendorSet(configVariable.getName(), configVariable.getValue());
            messages.add(bidibCommand);
        }
        final byte[] nodeAddr = this.getAddr();
        int numMessages = messages.size();
        final CountDownLatch continueLock = new CountDownLatch(numMessages);
        final CountDownLatch[] continueLockPartial = new CountDownLatch[1];
        final LinkedList<VendorData> vendorDataList = new LinkedList<VendorData>();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void vendor(byte[] address, int messageNum, VendorData vendorData) {
                if (Arrays.equals(nodeAddr, address)) {
                    LOGGER.debug("Received vendor data: {}", (Object)vendorData);
                    vendorDataList.add(vendorData);
                    boolean waitForMoreMessages = false;
                    if (handler != null) {
                        waitForMoreMessages = handler.handleMessageData(vendorData);
                    }
                    if (!waitForMoreMessages) {
                        continueLock.countDown();
                        if (continueLockPartial[0] != null) {
                            continueLockPartial[0].countDown();
                        }
                    }
                } else {
                    LOGGER.trace("Received vendor data from another node.");
                }
            }
        };
        try {
            this.getMessageReceiver().addMessageListener(messageListener);
            this.sendBulk(4, messages, true, ProcessSendQueue.enabled, messageListener, continueLock, continueLockPartial);
        }
        catch (RuntimeException ex) {
            LOGGER.warn("Wait for all vendor set answers was interrupted.");
            throw ex;
        }
        finally {
            this.getMessageReceiver().removeMessageListener(messageListener);
        }
        return vendorDataList;
    }

    public StringData getString(int namespace, int stringId) throws ProtocolException {
        LOGGER.info("Get the string, namespace: {}, stringId: {}", (Object)namespace, (Object)stringId);
        StringData result = this.doSendString(namespace, stringId, () -> this.requestFactory.createStringGet(namespace, stringId));
        LOGGER.info("Result from get the StringData: {}", (Object)result);
        return result;
    }

    private StringData doSendString(final int namespace, final int stringId, Supplier<BidibCommand> sendOperation) throws ProtocolException {
        final CompletableFuture future = new CompletableFuture();
        final byte[] nodeAddr = this.getAddr();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void nodeString(byte[] address, int messageNum, int namespaceAckn, int stringIdAckn, String value) {
                LOGGER.debug("+++ Node string was signalled, node address: {}, namespace: {}, namespaceAckn: {}, stringId: {}. stringIdAckn: {}, value: {}", new Object[]{address, namespace, namespaceAckn, stringId, stringIdAckn, value});
                if (Arrays.equals(nodeAddr, address) && namespace == namespaceAckn && stringId == stringIdAckn) {
                    StringData data = new StringData();
                    data.setNamespace(namespace);
                    data.setIndex(stringId);
                    data.setValue(value);
                    LOGGER.debug("Prepared StringData: {}", (Object)data);
                    future.complete(data);
                } else {
                    LOGGER.trace("Received string data from another node or another namespace: {} or stringId: {}", (Object)namespaceAckn, (Object)stringIdAckn);
                }
            }
        };
        StringData stringData = (StringData)this.sendAndWaitForResponse(messageListener, sendOperation, future);
        this.expectResponse(stringData, null, false, StringResponse.TYPE);
        return stringData;
    }

    public StringData setString(int namespace, int stringId, String value) throws ProtocolException {
        LOGGER.info("Set the string, namespace: {}, stringId: {}, value: {}", new Object[]{namespace, stringId, value});
        StringData result = this.doSendString(namespace, stringId, () -> this.requestFactory.createStringSet(namespace, stringId, value));
        LOGGER.info("Result from set the StringData: {}", (Object)result);
        return result;
    }

    public void setOutput(PortModelEnum portModel, LcOutputType outputType, int outputNumber, int state) throws ProtocolException {
        LOGGER.debug("Set the new output state, type: {}, outputNumber: {}, state: {}", new Object[]{outputType, outputNumber, state});
        LcOutputMessage command = this.requestFactory.createLcOutputMessage(portModel, outputType, outputNumber, state);
        this.sendNoWait((BidibMessageInterface)command);
    }

    public void queryPortState(PortModelEnum portModel, LcOutputType outputType, int outputNumber) throws ProtocolException {
        LOGGER.info("Query the output state, type: {}, outputNumber: {}", (Object)outputType, (Object)outputNumber);
        LcPortQueryMessage command = this.requestFactory.createLcPortQuery(portModel, outputType, outputNumber);
        this.sendNoWait((BidibMessageInterface)command);
    }

    public void queryPortStates(PortModelEnum portModel, LcOutputType outputType, List<Integer> portIds) throws ProtocolException {
        int windowSize = 4;
        boolean usePortQuery = this.node.getProtocolVersion().isHigherThan(ProtocolVersion.VERSION_0_6);
        LOGGER.debug("Get port states with bulk read for windowSize: {}, portIds: {}, usePortQuery: {}", new Object[]{windowSize, portIds, usePortQuery});
        LinkedList<Object> messages = new LinkedList<Object>();
        for (int portId : portIds) {
            if (!usePortQuery && LcOutputType.INPUTPORT == outputType) {
                messages.add(this.requestFactory.createLcKey(portId));
                continue;
            }
            messages.add(this.requestFactory.createLcPortQuery(portModel, outputType, portId));
        }
        int totalResponseCount = messages.size();
        final CountDownLatch continueLock = new CountDownLatch(totalResponseCount);
        final CountDownLatch[] continueLockPortStates = new CountDownLatch[1];
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void lcStat(byte[] address, int messageNum, BidibPort bidibPort, int portStatus) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received the lcStat response, address: {}, portStatus: {}", (Object)NodeUtils.formatAddressLong((byte[])address), (Object)portStatus);
                }
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    continueLock.countDown();
                    if (continueLockPortStates[0] != null) {
                        continueLockPortStates[0].countDown();
                    }
                } else {
                    LOGGER.debug("Received LcStat for another node.");
                }
            }

            @Override
            public void lcNa(byte[] address, int messageNum, BidibPort bidibPort, Integer errorCode) {
                LOGGER.info("Received the lcNa response, address: {}, errorCode: {}", (Object)NodeUtils.formatAddressLong((byte[])address), (Object)errorCode);
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    continueLock.countDown();
                    if (continueLockPortStates[0] != null) {
                        continueLockPortStates[0].countDown();
                    }
                } else {
                    LOGGER.debug("Received LcNa for another node.");
                }
            }
        };
        try {
            this.getMessageReceiver().addMessageListener(messageListener);
            this.sendBulk(windowSize, messages, true, ProcessSendQueue.enabled, messageListener, continueLock, continueLockPortStates);
            boolean successful = continueLock.await(this.responseTimeout, TimeUnit.MILLISECONDS);
            if (!successful) {
                LOGGER.warn("Wait for LC_CONFIGX failed on node: {} ({})", (Object)NodeUtils.formatAddress((byte[])this.node.getAddr()), (Object)ByteUtils.formatHexUniqueId((long)this.node.getUniqueId()));
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Wait for response before continue was interrupted.");
            Thread.currentThread().interrupt();
            throw new RuntimeException("Wait for all port status answers was interrupted.");
        }
        catch (RuntimeException ex) {
            LOGGER.warn("Wait for all port status answers was interrupted.");
            throw ex;
        }
        finally {
            this.getMessageReceiver().removeMessageListener(messageListener);
        }
    }

    public void queryPortStatesAll(PortModelEnum portModel, int portTypeMask, int rangeFrom, int rangeTo) throws ProtocolException {
        LOGGER.debug("Query the output state for all ports ,portTypeMask: {}, rangeFrom: {}, rangeTo: {}", new Object[]{portTypeMask, rangeFrom, rangeTo});
        LcPortQueryAllMessage command = this.requestFactory.createPortQueryAll(portTypeMask, rangeFrom, rangeTo);
        this.sendNoWait((BidibMessageInterface)command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(PortModelEnum portModel, LcConfig config) throws ProtocolException {
        LOGGER.debug("Send LcConfigSet to node, config: {}", (Object)config);
        final CountDownLatch continueLock = new CountDownLatch(1);
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void lcConfig(byte[] address, int messageNum, LcConfig lcConfig) {
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    continueLock.countDown();
                }
            }

            @Override
            public void lcNa(byte[] address, int messageNum, BidibPort bidibPort, Integer errorCode) {
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    continueLock.countDown();
                }
            }
        };
        try {
            this.getMessageReceiver().addMessageListener(messageListener);
            this.sendNoWait((BidibMessageInterface)new LcConfigSetMessage(portModel, config));
            boolean successful = continueLock.await(this.responseTimeout, TimeUnit.MILLISECONDS);
            if (!successful) {
                LOGGER.warn("Wait for LC_CONFIG failed on node: {} ({})", (Object)NodeUtils.formatAddress((byte[])this.node.getAddr()), (Object)ByteUtils.formatHexUniqueId((long)this.node.getUniqueId()));
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Wait for response before continue was interrupted.");
        }
        finally {
            this.getMessageReceiver().removeMessageListener(messageListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigX(PortModelEnum portModel, LcConfigX config) throws ProtocolException {
        LOGGER.debug("Send LcConfigXSet to node, config: {}, portModel: {}", (Object)config, (Object)portModel);
        LcConfigXSetMessage msg = new LcConfigXSetMessage(this.messageLogger, config, portModel);
        final CountDownLatch continueLock = new CountDownLatch(1);
        DefaultMessageListener msgListener = new DefaultMessageListener(){

            @Override
            public void lcConfigX(byte[] address, int messageNum, LcConfigX lcConfigX) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received the LcConfigX response, address: {}, lcConfigX: {}", (Object)ByteUtils.bytesToHex((byte[])address), (Object)lcConfigX);
                }
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    continueLock.countDown();
                } else {
                    LOGGER.trace("Received lcConfigX for another node.");
                }
            }

            @Override
            public void lcNa(byte[] address, int messageNum, BidibPort bidibPort, Integer errorCode) {
                LOGGER.info("Received the LcNa response, address: {}, port: {}", (Object)ByteUtils.bytesToHex((byte[])address), (Object)bidibPort);
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    continueLock.countDown();
                } else {
                    LOGGER.trace("Received lcNa for another node.");
                }
            }
        };
        try {
            this.getMessageReceiver().addMessageListener(msgListener);
            this.sendNoWait((BidibMessageInterface)msg);
            LOGGER.debug("Sent the new port parameters and wait for response before continue.");
            boolean successful = continueLock.await(1000L, TimeUnit.MILLISECONDS);
            LOGGER.debug("Wait for response before continue has finished. Wait for message was successful: {}", (Object)successful);
            if (!successful) {
                LOGGER.warn("Wait for LC_CONFIGX failed on node: {} ({})", (Object)NodeUtils.formatAddress((byte[])this.node.getAddr()), (Object)ByteUtils.formatHexUniqueId((long)this.node.getUniqueId()));
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Wait for response before continue was interrupted.");
        }
        finally {
            this.getMessageReceiver().removeMessageListener(msgListener);
        }
    }

    public void getConfigBulk(PortModelEnum portModel, LcOutputType outputType, int ... outputNumbers) throws ProtocolException {
        LinkedList<LcConfigGetMessage> messages = new LinkedList<LcConfigGetMessage>();
        for (int outputNumber : outputNumbers) {
            messages.add(this.requestFactory.createLcConfigGet(portModel, outputType, outputNumber));
        }
        int numMessages = messages.size();
        LOGGER.debug("Get configX with bulk. Prepare countDownLatch with value: {}", (Object)numMessages);
        final CountDownLatch continueLock = new CountDownLatch(numMessages);
        final CountDownLatch[] continueLockPartial = new CountDownLatch[1];
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void lcConfig(byte[] address, int messageNum, LcConfig lcConfig) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received the LcConfigX response, address: {}, lcConfig: {}", (Object)NodeUtils.formatAddressLong((byte[])address), (Object)lcConfig);
                }
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    continueLock.countDown();
                    if (continueLockPartial[0] != null) {
                        continueLockPartial[0].countDown();
                    }
                } else {
                    LOGGER.trace("Received lcConfigX for another node.");
                }
            }

            @Override
            public void lcNa(byte[] address, int messageNum, BidibPort bidibPort, Integer errorCode) {
                LOGGER.info("Received the LcNa response, address: {}, port: {}", (Object)NodeUtils.formatAddressLong((byte[])address), (Object)bidibPort);
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    continueLock.countDown();
                    if (continueLockPartial[0] != null) {
                        continueLockPartial[0].countDown();
                    }
                } else {
                    LOGGER.trace("Received lcNa for another node.");
                }
            }
        };
        try {
            this.getMessageReceiver().addMessageListener(messageListener);
            this.sendBulk(4, messages, true, ProcessSendQueue.enabled, messageListener, continueLock, continueLockPartial);
        }
        catch (RuntimeException ex) {
            LOGGER.warn("Wait for lcConfig answers was interrupted.");
            throw ex;
        }
        finally {
            this.getMessageReceiver().removeMessageListener(messageListener);
        }
    }

    public void getConfigXBulk(PortModelEnum portModel, LcOutputType outputType, int windowSize, int ... outputNumbers) throws ProtocolException {
        LOGGER.info("Get configX with bulk read for outputType: {}, windowSize: {}, outputNumbers: {}", new Object[]{outputType, windowSize, outputNumbers});
        LinkedList<LcConfigXGetMessage> messages = new LinkedList<LcConfigXGetMessage>();
        for (int outputNumber : outputNumbers) {
            messages.add(this.requestFactory.createLcConfigXGet(portModel, outputType, outputNumber));
        }
        int numMessages = messages.size();
        LOGGER.debug("Get configX with bulk. Prepare countDownLatch with value: {}", (Object)numMessages);
        final CountDownLatch continueLock = new CountDownLatch(numMessages);
        final CountDownLatch[] continueLockPartial = new CountDownLatch[1];
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void lcConfigX(byte[] address, int messageNum, LcConfigX lcConfigX) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received the LcConfigX response, own addr: {}, received address: {}, lcConfigX: {}", new Object[]{NodeUtils.formatAddressLong((byte[])BidibNode.this.getAddr()), NodeUtils.formatAddressLong((byte[])address), lcConfigX});
                }
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    if (!lcConfigX.isContinueDetected()) {
                        if (continueLockPartial[0] != null) {
                            continueLockPartial[0].countDown();
                        }
                        continueLock.countDown();
                    } else {
                        LOGGER.info("Continue detected in LcConfigX.");
                    }
                } else {
                    LOGGER.trace("Received lcConfigX for another node.");
                }
            }

            @Override
            public void lcNa(byte[] address, int messageNum, BidibPort bidibPort, Integer errorCode) {
                LOGGER.info("Received the LcNa response, address: {}, port: {}", (Object)NodeUtils.formatAddressLong((byte[])address), (Object)bidibPort);
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    if (continueLockPartial[0] != null) {
                        continueLockPartial[0].countDown();
                    }
                    continueLock.countDown();
                } else {
                    LOGGER.debug("Received lcNa for another node.");
                }
            }
        };
        try {
            this.getMessageReceiver().addMessageListener(messageListener);
            this.sendBulk(windowSize, messages, true, ProcessSendQueue.enabled, messageListener, continueLock, continueLockPartial);
        }
        catch (RuntimeException ex) {
            LOGGER.warn("Wait for lcConfigX answers was interrupted.");
            throw ex;
        }
        finally {
            this.getMessageReceiver().removeMessageListener(messageListener);
        }
    }

    public void getAllConfigX(PortModelEnum portModel, LcOutputType outputType, Integer rangeFrom, Integer rangeTo) throws ProtocolException {
        int totalPorts;
        int expectedCountResponses = totalPorts = rangeTo - rangeFrom;
        LinkedList<LcConfigXGetAllMessage> messages = new LinkedList<LcConfigXGetAllMessage>();
        LcConfigXGetAllMessage message = null;
        if (outputType == null) {
            LOGGER.info(">> Get all configX from the node: {}, totalPorts: {}", (Object)this, (Object)totalPorts);
            message = this.requestFactory.createLcConfigXGetAll();
        } else {
            LOGGER.info("Get all configX from the node: {}, outputType: {}, rangeFrom: {}, rangeTo: {}", new Object[]{this, outputType, rangeFrom, rangeTo});
            message = this.requestFactory.createLcConfigXGetAll(portModel, outputType, rangeFrom.intValue(), rangeTo.intValue());
        }
        LcConfigXGetAllMessage lcConfigXGetAllMessage = message;
        lcConfigXGetAllMessage.setExpectedCountResponses(expectedCountResponses);
        messages.add(message);
        LOGGER.debug("Create CountDownLatch with value: {}", (Object)expectedCountResponses);
        final CountDownLatch continueLock = new CountDownLatch(expectedCountResponses);
        final CountDownLatch[] continueLockPartial = new CountDownLatch[1];
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void lcConfigX(byte[] address, int messageNum, LcConfigX lcConfigX) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received the LcConfigX response, own addr: {}, received address: {}, lcConfigX: {}", new Object[]{NodeUtils.formatAddressLong((byte[])BidibNode.this.getAddr()), NodeUtils.formatAddressLong((byte[])address), lcConfigX});
                }
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    if (!lcConfigX.isContinueDetected()) {
                        CountDownLatch countDownLatch = continueLock;
                        synchronized (countDownLatch) {
                            if (continueLockPartial[0] != null) {
                                continueLockPartial[0].countDown();
                            }
                        }
                        continueLock.countDown();
                    } else {
                        LOGGER.info("Continue detected in LcConfigX.");
                    }
                } else {
                    LOGGER.trace("Received lcConfigX for another node.");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void lcNa(byte[] address, int messageNum, BidibPort bidibPort, Integer errorCode) {
                LOGGER.info("Received the LcNa response, address: {}, port: {}", (Object)NodeUtils.formatAddressLong((byte[])address), (Object)bidibPort);
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])BidibNode.this.getAddr())) {
                    CountDownLatch countDownLatch = continueLock;
                    synchronized (countDownLatch) {
                        if (continueLockPartial[0] != null) {
                            continueLockPartial[0].countDown();
                        }
                    }
                    continueLock.countDown();
                } else {
                    LOGGER.trace("Received lcNa for another node.");
                }
            }
        };
        try {
            this.getMessageReceiver().addMessageListener(messageListener);
            this.sendBulk(1, messages, true, ProcessSendQueue.enabled, messageListener, continueLock, continueLockPartial);
            boolean success = continueLock.await(expectedCountResponses * (this.getResponseTimeout() / 2), TimeUnit.MILLISECONDS);
            if (success) {
                LOGGER.debug("Wait for all lcConfigXs was successful for node: {}", (Object)this.node);
            } else {
                LOGGER.warn("Wait for all lcConfigXs was not successful for node: {}", (Object)this.node);
            }
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait for all lcConfigX answers was interrupted.");
            Thread.currentThread().interrupt();
            throw new RuntimeException("Wait for all lcConfigX answers was interrupted.");
        }
        catch (RuntimeException ex) {
            LOGGER.warn("Wait for all lcConfigX answers was interrupted.", (Throwable)ex);
            throw ex;
        }
        finally {
            this.getMessageReceiver().removeMessageListener(messageListener);
        }
        LOGGER.info("Get all LcConfigX has finished.");
    }

    public void sysClock(LocalDateTime time, int acceleration) throws ProtocolException {
        this.sendNoWait((BidibMessageInterface)this.requestFactory.createSysClock(time, acceleration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendBulk(int windowSize, List<? extends BidibCommand> messages, boolean waitForBulkAnswer, ProcessSendQueue processSendQueue, MessageListener messageListener, CountDownLatch continueLockTotal, CountDownLatch[] continueLockPartial) throws ProtocolException {
        Object object = this.sendLock;
        synchronized (object) {
            int numMessages = messages.size();
            LOGGER.debug(">> Send bulk messages total: {}, windowSize: {}, processSendQueue: {}", new Object[]{numMessages, windowSize, processSendQueue});
            if (numMessages == 0) {
                LOGGER.warn("No messages to send available.");
                return;
            }
            long maxWaitDuration = numMessages * 400;
            int fromIndex = 0;
            LinkedList<BidibCommand> messagesToWaitForResponse = new LinkedList<BidibCommand>();
            while (true) {
                if (fromIndex >= numMessages) {
                    LOGGER.debug("Send bulk messages has finished.");
                    return;
                }
                LOGGER.debug("Send bulk messages fromIndex: {}, numMessages: {}", (Object)fromIndex, (Object)numMessages);
                boolean internalWaitForBulkAnswer = waitForBulkAnswer;
                int toIndex = fromIndex;
                int maxTotalExpectedResponseLength = 48;
                int totalExpectedResponseLength = 0;
                LinkedList<BidibMessageInterface> messagesToSend = new LinkedList<BidibMessageInterface>();
                LinkedList<EncodedMessage> encodedMessages = new LinkedList<EncodedMessage>();
                int totalMessageLength = 0;
                boolean messageLimitExceeded = false;
                if (ProcessSendQueue.enabled == processSendQueue && !this.acknowledgeSendQueue.isEmpty()) {
                    totalMessageLength = this.drainSendQueue(totalMessageLength, encodedMessages, messagesToSend, new boolean[]{messageLimitExceeded});
                }
                int expectedResponseCount = 0;
                if (messageLimitExceeded) {
                    LOGGER.warn("The max message size limit is exceeded already. Do not add more messages.");
                    internalWaitForBulkAnswer = false;
                } else {
                    for (int index = fromIndex; index < numMessages; ++index) {
                        block26: {
                            BidibCommand command = messages.get(index);
                            if (totalExpectedResponseLength + command.getAnswerSize() <= maxTotalExpectedResponseLength) {
                                EncodedMessage encodedMessage = this.encodeMessage((BidibMessageInterface)command);
                                int messageLen = encodedMessage.getMessage().length;
                                if (totalMessageLength + messageLen < 48) {
                                    encodedMessages.add(encodedMessage);
                                    LOGGER.debug("Add command to send: {}, totalMessageLength: {}", (Object)command, (Object)(totalMessageLength += messageLen));
                                    messagesToSend.add((BidibMessageInterface)command);
                                    ++toIndex;
                                    ++expectedResponseCount;
                                    LOGGER.debug("Current totalExpectedResponseLength: {}", (Object)(totalExpectedResponseLength += command.getAnswerSize()));
                                    if (windowSize <= -1) continue;
                                    break block26;
                                } else {
                                    LOGGER.warn("Max message size exceeded while adding command: {}, node: {}, command: {}", new Object[]{totalMessageLength + messageLen, this.node, command});
                                    messageLimitExceeded = true;
                                    this.revertNextSendMsgNum();
                                    break;
                                }
                            }
                            LOGGER.debug("Max total response size exceeded.");
                            break;
                        }
                        if (toIndex - fromIndex < windowSize) continue;
                        LOGGER.debug("Window size exceeded, stop adding messages to send.");
                        break;
                    }
                }
                messagesToWaitForResponse.clear();
                for (BidibMessageInterface message : messagesToSend) {
                    if (!(message instanceof BidibCommand) || ((BidibCommand)message).getExpectedResponseTypes() == null) continue;
                    messagesToWaitForResponse.add((BidibCommand)message);
                }
                LOGGER.debug("Prepared messages to send: {}", messagesToSend);
                this.prepareAndSendMessages(encodedMessages, messagesToSend);
                fromIndex = toIndex;
                LOGGER.debug("Prepeared new fromIndex: {}, toIndex: {}", (Object)fromIndex, (Object)toIndex);
                if (!messagesToWaitForResponse.isEmpty()) {
                    LOGGER.debug("Wait for responses, expectedResponseCount: {}, messages: {}", (Object)expectedResponseCount, messagesToWaitForResponse);
                    CountDownLatch index = continueLockTotal;
                    synchronized (index) {
                        continueLockPartial[0] = new CountDownLatch(expectedResponseCount);
                    }
                    try {
                        long timeoutValue = 200L;
                        maxWaitDuration = continueLockPartial[0].getCount() * timeoutValue + timeoutValue;
                        LOGGER.debug("Wait for continueLockPartial, maxWaitDuration: {}ms", (Object)maxWaitDuration);
                        boolean success = continueLockPartial[0].await(maxWaitDuration, TimeUnit.MILLISECONDS);
                        LOGGER.debug("Wait for continueLockPartial succeeded: {}", (Object)success);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.warn("Wait for all bulk answers was interrupted.");
                        Thread.currentThread().interrupt();
                        throw new RuntimeException("Wait for all bulk answers was interrupted.");
                    }
                }
                if (internalWaitForBulkAnswer) {
                    boolean success;
                    BidibBulkCommand configXGetAllMessage;
                    LOGGER.info("Wait for bulk answers. Current continueLockTotal: {}", (Object)continueLockTotal.getCount());
                    int expectedBulkAnswerCount = numMessages;
                    boolean waitForMultipleResponses = false;
                    long timeoutValue = 200L;
                    if (messages.get(0) instanceof BidibBulkCommand && (configXGetAllMessage = (BidibBulkCommand)messages.get(0)).getExpectedCountResponses() > 0) {
                        expectedBulkAnswerCount = configXGetAllMessage.getExpectedCountResponses();
                        waitForMultipleResponses = true;
                        if (expectedBulkAnswerCount == 0) {
                            expectedBulkAnswerCount = numMessages;
                        }
                        maxWaitDuration = (long)expectedBulkAnswerCount * timeoutValue + timeoutValue;
                        LOGGER.info("Adjusted expectedBulkAnswerCount to new value: {}, maxWaitDuration: {}", (Object)expectedBulkAnswerCount, (Object)maxWaitDuration);
                    }
                    if (waitForMultipleResponses) {
                        try {
                            maxWaitDuration = continueLockTotal.getCount() * timeoutValue + timeoutValue;
                            LOGGER.debug("Wait for continueLockTotal, maxWaitDuration: {}ms", (Object)maxWaitDuration);
                            success = continueLockTotal.await(maxWaitDuration, TimeUnit.MILLISECONDS);
                            LOGGER.debug("Wait for continueLockTotal succeeded: {}", (Object)success);
                        }
                        catch (InterruptedException ex) {
                            LOGGER.warn("Wait for all bulk answers with multiple responses was interrupted.");
                            Thread.currentThread().interrupt();
                            throw new RuntimeException("Wait for all bulk answers with multiple responses was interrupted.");
                        }
                    }
                    continueLockPartial[0] = new CountDownLatch(expectedResponseCount);
                    try {
                        maxWaitDuration = continueLockPartial[0].getCount() * timeoutValue + timeoutValue;
                        LOGGER.debug("Wait for continueLockPartial, maxWaitDuration: {}ms", (Object)maxWaitDuration);
                        success = continueLockPartial[0].await(maxWaitDuration, TimeUnit.MILLISECONDS);
                        LOGGER.debug("Wait for continueLockPartial succeeded: {}", (Object)success);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.warn("Wait for all bulk answers with not multiple responses was interrupted.");
                        Thread.currentThread().interrupt();
                        throw new RuntimeException("Wait for all bulk answers with not multiple responses was interrupted.");
                    }
                }
                LOGGER.debug("No answer expected in send bulk.");
            }
        }
    }

    private int drainSendQueue(int totalMessageLength, List<EncodedMessage> encodedMessages, List<BidibMessageInterface> messagesToSend, boolean[] messageLimitExceeded) {
        LOGGER.debug("Insert send pending acknowledge message.");
        BidibCommand acknowledge = null;
        do {
            if ((acknowledge = (BidibCommand)this.acknowledgeSendQueue.peek()) == null) continue;
            EncodedMessage encodedMessage = this.encodeMessage((BidibMessageInterface)acknowledge);
            int messageLen = encodedMessage.getMessage().length;
            if (totalMessageLength + messageLen >= 48) {
                LOGGER.warn("Max message size exceeded while adding pending acknowledge: {}, node: {}", (Object)(totalMessageLength + messageLen), (Object)this.node);
                messageLimitExceeded[0] = true;
                this.revertNextSendMsgNum();
                break;
            }
            try {
                BidibCommand removed = (BidibCommand)this.acknowledgeSendQueue.remove();
                if (!acknowledge.equals(removed)) {
                    LOGGER.warn("The removed message does not match the peeked message: {}, removed: {}", (Object)acknowledge, (Object)removed);
                }
            }
            catch (NoSuchElementException ex) {
                LOGGER.error("Failed to remove the command from the send queue. Expected acknowledge: {}", (Object)acknowledge, (Object)ex);
            }
            encodedMessages.add(encodedMessage);
            totalMessageLength += messageLen;
            LOGGER.debug("Add acknowledge message to send: {}", (Object)acknowledge);
            messagesToSend.add((BidibMessageInterface)acknowledge);
        } while (acknowledge != null);
        return totalMessageLength;
    }

    protected void expectResponse(Object response, Integer receiveTimeout, boolean ignoreTimeout, Integer ... expectedResponseTypes) {
        if (response == null) {
            StringBuilder sb = new StringBuilder("No valid message received, timestamp: ");
            sb.append(FORMATTER.format(LocalDateTime.now()));
            sb.append(", provided receiveTimeout: ");
            sb.append(receiveTimeout != null ? receiveTimeout : this.responseTimeout).append(". Reset the send message number. Current node: ").append(this.node).append(", expectedResponseTypes: ");
            if (expectedResponseTypes != null) {
                boolean multi = false;
                for (Integer type : expectedResponseTypes) {
                    if (multi) {
                        sb.append(", ");
                    }
                    sb.append(type).append(" : 0x").append(ByteUtils.byteToHex((int)type)).append(" : ").append(BidibNode.findMessageType(type));
                    multi = true;
                }
            } else {
                sb.append("null");
            }
            String message = sb.toString();
            LOGGER.warn(message);
            if (!ignoreTimeout) {
                this.resetNextSendMsgNum();
                MessageTimeoutEvent messageTimeoutEvent = new MessageTimeoutEvent(this.node, message);
                LOGGER.info("Publish the messageTimeoutEvent: {}", (Object)messageTimeoutEvent);
                EventBus.publish((Object)messageTimeoutEvent);
            } else {
                LOGGER.info("Skip publish messageTimeoutEvent because the skipTimeout flag is set.");
            }
        }
    }

    protected static String findMessageType(int messageId) {
        return BidibFactory.getMessageTypes().stream().filter(mt -> mt.getId() == messageId).findFirst().map(mt -> mt.getName()).orElse("UNKNOWN");
    }

    public Long getCachedUniqueId() {
        if (this.node != null) {
            return this.node.getUniqueId();
        }
        return this.uniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        LOGGER.info("Set the uniqueId on the node: {}, previous stored uniqueId: {}", (Object)ByteUtils.formatHexUniqueId((Long)uniqueId), (Object)ByteUtils.formatHexUniqueId((Long)this.uniqueId));
        this.uniqueId = uniqueId;
    }

    public boolean isSecureAckEnabled() {
        return this.secureAckEnabled;
    }

    public void setSecureAckEnabled(boolean secureAckEnabled) {
        LOGGER.info("Set secureAckEnabled on node with uniqueId: {}, secureAckEnabled: {}", (Object)ByteUtils.formatHexUniqueId((Long)this.uniqueId), (Object)secureAckEnabled);
        this.secureAckEnabled = secureAckEnabled;
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void setEnabled(boolean enabled) {
        this.enabled.set(enabled);
    }

    private void addMessageListener(MessageListener messageListener) {
        this.getMessageReceiver().addMessageListener(messageListener);
    }

    private void removeMessageListener(MessageListener messageListener) {
        this.getMessageReceiver().removeMessageListener(messageListener);
    }

    private void updateLastSendMessageTimestamp(boolean hasLocalPingMessage) {
        this.setLastSentMessageTimestamp(System.currentTimeMillis());
        this.lastSendMessageTimestampProvider.updateLastSendMessageTimestamp(hasLocalPingMessage);
    }

    public long getLastSentMessageTimestamp() {
        return this.lastSentMessageTimestamp;
    }

    public void setLastSentMessageTimestamp(long lastSentMessageTimestamp) {
        this.lastSentMessageTimestamp = lastSentMessageTimestamp;
    }

    public void sendGatewayResponse(BidibMessageInterface gatewayResponse) throws ProtocolException {
        LOGGER.info("Send the gateway response: {}", (Object)gatewayResponse);
        this.sendNoWait(gatewayResponse);
    }

    public void acknowledgeLocalPing() throws ProtocolException {
        LOGGER.debug("Add the LocalPongMessage to sendQueue");
        boolean added = this.acknowledgeSendQueue.offer((BidibCommand)new LocalPongResponse());
        if (!added) {
            LOGGER.warn("Add the LocalPongResponse to sendQueue failed.");
            throw new ProtocolException("Add the LocalPongResponse to sendQueue failed.");
        }
    }

    private static class Holder<E> {
        private E value;

        private Holder() {
        }

        public void set(E value) {
            this.value = value;
        }

        public E get() {
            return this.value;
        }
    }

    protected static enum ProcessSendQueue {
        enabled,
        disabled;

    }

    public static class EncodedMessage {
        private byte[] message;

        public EncodedMessage(byte[] message) {
            this.message = message;
        }

        public byte[] getMessage() {
            return this.message;
        }

        public int getLength() {
            return this.message.length;
        }
    }
}

