/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.core.node;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.bidib.jbidibc.core.DefaultMessageListener;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.node.BidibNode;
import org.bidib.jbidibc.messages.BoosterStateData;
import org.bidib.jbidibc.messages.enums.BoosterControl;
import org.bidib.jbidibc.messages.enums.BoosterState;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BoostOffMessage;
import org.bidib.jbidibc.messages.message.BoostOnMessage;
import org.bidib.jbidibc.messages.message.BoostQueryMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoosterNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoosterNode.class);
    private BidibNode delegate;

    BoosterNode(BidibNode delegate) {
        this.delegate = delegate;
    }

    public void boosterOn(byte broadcast) throws ProtocolException {
        LOGGER.info("Switch booster on, broadcast: {}", (Object)broadcast);
        this.delegate.sendNoWait((BidibMessageInterface)new BoostOnMessage(broadcast));
    }

    public void boosterOff(byte broadcast) throws ProtocolException {
        LOGGER.info("Switch booster off, broadcast: {}", (Object)broadcast);
        this.delegate.sendNoWait((BidibMessageInterface)new BoostOffMessage(broadcast));
    }

    public void boosterQuery() throws ProtocolException {
        this.delegate.sendNoWait((BidibMessageInterface)new BoostQueryMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BoosterStateData queryState() throws ProtocolException {
        LOGGER.debug("Query the state of the booster.");
        BoosterStateData boosterState = new BoosterStateData(BoosterState.OFF, BoosterControl.NONE);
        final CompletableFuture future = new CompletableFuture();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void boosterState(byte[] address, int messageNum, BoosterState state, BoosterControl control) {
                LOGGER.info("Booster state was signalled: {}, control: {}", (Object)state, (Object)control);
                future.complete(new BoosterStateData(state, control));
            }
        };
        try {
            this.addMessageListener(messageListener);
            this.delegate.sendNoWait((BidibMessageInterface)new BoostQueryMessage());
            LOGGER.info("The boost query message was sent, wait for response.");
            boosterState = (BoosterStateData)future.get(2000L, TimeUnit.MILLISECONDS);
            LOGGER.info("Return the current booster state data: {}", (Object)boosterState);
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            LOGGER.warn("Wait for booster state failed.", (Throwable)ex);
        }
        finally {
            this.removeMessageListener(messageListener);
        }
        return boosterState;
    }

    private void addMessageListener(MessageListener messageListener) {
        this.delegate.getMessageReceiver().addMessageListener(messageListener);
    }

    private void removeMessageListener(MessageListener messageListener) {
        this.delegate.getMessageReceiver().removeMessageListener(messageListener);
    }
}

