/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.core.node;

import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.bidib.jbidibc.core.DefaultMessageListener;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.node.BidibNode;
import org.bidib.jbidibc.messages.DccATidData;
import org.bidib.jbidibc.messages.DecoderIdAddressData;
import org.bidib.jbidibc.messages.DecoderUniqueIdData;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.RcPlusBindData;
import org.bidib.jbidibc.messages.TidData;
import org.bidib.jbidibc.messages.enums.AccessoryAcknowledge;
import org.bidib.jbidibc.messages.enums.ActivateCoilEnum;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.CommandStationPom;
import org.bidib.jbidibc.messages.enums.CommandStationPt;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.enums.CsQueryTypeEnum;
import org.bidib.jbidibc.messages.enums.DccAdvLogonType;
import org.bidib.jbidibc.messages.enums.DccAdvOpCodes;
import org.bidib.jbidibc.messages.enums.DccAdvSelectInfoOpCode;
import org.bidib.jbidibc.messages.enums.DirectionEnum;
import org.bidib.jbidibc.messages.enums.DriveAcknowledge;
import org.bidib.jbidibc.messages.enums.M4OpCodes;
import org.bidib.jbidibc.messages.enums.PomAcknowledge;
import org.bidib.jbidibc.messages.enums.RcPlusOpCodes;
import org.bidib.jbidibc.messages.enums.RcPlusPhase;
import org.bidib.jbidibc.messages.enums.SpeedStepsEnum;
import org.bidib.jbidibc.messages.enums.TimeBaseUnitEnum;
import org.bidib.jbidibc.messages.enums.TimingControlEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.exception.ProtocolNoAnswerException;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.CommandStationAccessoryMessage;
import org.bidib.jbidibc.messages.message.CommandStationBinaryStateMessage;
import org.bidib.jbidibc.messages.message.CommandStationDccAdvMessage;
import org.bidib.jbidibc.messages.message.CommandStationDriveMessage;
import org.bidib.jbidibc.messages.message.CommandStationM4Message;
import org.bidib.jbidibc.messages.message.CommandStationPomMessage;
import org.bidib.jbidibc.messages.message.CommandStationProgMessage;
import org.bidib.jbidibc.messages.message.CommandStationQueryMessage;
import org.bidib.jbidibc.messages.message.CommandStationRcPlusMessage;
import org.bidib.jbidibc.messages.message.CommandStationSetStateMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandStationNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandStationNode.class);
    private static final Logger LOGGER_DRIVE_ACK = LoggerFactory.getLogger((String)"DRIVE_ACK");
    private BidibNode delegate;
    private boolean m4Enabled = false;
    private static final long DRIVE_ACK_TIMEOUT = 100L;

    CommandStationNode(BidibNode delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DriveAcknowledge setBinaryState(final int dccAddress, int stateNumber, boolean value) throws ProtocolException {
        LOGGER.info("Set binary state, dccAddress: {}, stateNumber: {}, value: {}", new Object[]{dccAddress, stateNumber, value});
        final CompletableFuture future = new CompletableFuture();
        final byte[] nodeAddr = this.delegate.getAddr();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void csDriveAcknowledge(byte[] address, int messageNum, int dccAddressAckn, DriveAcknowledge state, Integer acknowledgedMessageNumber) {
                LOGGER.debug("+++ Command station drive acknowledge was signalled: {}, dcc address: {}, node address: {}. acknowledgedMessageNumber: {}", new Object[]{state, dccAddressAckn, address, acknowledgedMessageNumber});
                if (Arrays.equals(nodeAddr, address) && dccAddress == dccAddressAckn) {
                    future.complete(new DriveAcknowledgeHolder(state, acknowledgedMessageNumber, System.currentTimeMillis()));
                } else {
                    LOGGER.info("Received command station state from another node or another dcc address: {}", (Object)dccAddressAckn);
                }
            }
        };
        DriveAcknowledge driveAck = null;
        try {
            this.addMessageListener(messageListener);
            long sendTimestamp = System.currentTimeMillis();
            this.delegate.sendNoWait((BidibMessageInterface)new CommandStationBinaryStateMessage(dccAddress, stateNumber, value));
            LOGGER.debug("+++ The command station drive message was sent, wait for response.");
            DriveAcknowledgeHolder driveAckHolder = (DriveAcknowledgeHolder)future.get(100L, TimeUnit.MILLISECONDS);
            driveAck = driveAckHolder.driveAcknowledge;
            long receiveTimestamp = driveAckHolder.receiveTimestamp;
            long ackDelay = receiveTimestamp - sendTimestamp;
            Integer acknowledgedMessageNumber = driveAckHolder.acknowledgedMessageNumber;
            LOGGER_DRIVE_ACK.info("DRIVE_ACK, DCC addr: {}, ack delay: {}, driveAck state: {}, ackMsgNum: {}", new Object[]{dccAddress, ackDelay, driveAck, acknowledgedMessageNumber});
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            LOGGER_DRIVE_ACK.warn("DRIVE_ACK: Wait for drive acknowledge failed, dccAddress: {}", (Object)dccAddress);
            LOGGER.warn("DRIVE_ACK: Wait for drive acknowledge failed, dccAddress: {}", (Object)dccAddress, (Object)ex);
        }
        finally {
            this.removeMessageListener(messageListener);
        }
        if (driveAck == null) {
            LOGGER.warn("No acknowledge received for MSG_CS_BIN_STATE, dcc address: {}, stateNumber: {}, value: {}", new Object[]{dccAddress, stateNumber, value});
            throw new ProtocolNoAnswerException("No acknowledge received for MSG_CS_BIN_STATE, dccAddress: " + dccAddress + ", stateNumber: " + stateNumber + ", value: " + value);
        }
        return driveAck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DriveAcknowledge setDrive(final int dccAddress, SpeedStepsEnum speedSteps, Integer speed, DirectionEnum direction, BitSet activeFunctions, BitSet functions) throws ProtocolException {
        LOGGER.debug("set drive, dcc address: {}, speed: {}", (Object)dccAddress, (Object)speed);
        final CompletableFuture future = new CompletableFuture();
        final byte[] nodeAddr = this.delegate.getAddr();
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void csDriveAcknowledge(byte[] address, int messageNum, int dccAddressAckn, DriveAcknowledge state, Integer acknowledgedMessageNumber) {
                LOGGER.debug("+++ Command station drive acknowledge was signalled: {}, dcc address: {}, node address: {}, acknowledgedMessageNumber: {}", new Object[]{state, dccAddressAckn, address, acknowledgedMessageNumber});
                if (Arrays.equals(nodeAddr, address) && dccAddress == dccAddressAckn) {
                    future.complete(new DriveAcknowledgeHolder(state, acknowledgedMessageNumber, System.currentTimeMillis()));
                } else {
                    LOGGER.info("Received command station state from another node or another dcc address: {}", (Object)dccAddressAckn);
                }
            }
        };
        DriveAcknowledge driveAck = null;
        try {
            this.addMessageListener(messageListener);
            long sendTimestamp = System.currentTimeMillis();
            this.setDriveNoWait(dccAddress, speedSteps, speed, direction, activeFunctions, functions);
            LOGGER.debug("+++ The command station drive message was sent, wait for response.");
            DriveAcknowledgeHolder driveAckHolder = (DriveAcknowledgeHolder)future.get(100L, TimeUnit.MILLISECONDS);
            driveAck = driveAckHolder.driveAcknowledge;
            long receiveTimestamp = driveAckHolder.receiveTimestamp;
            long ackDelay = receiveTimestamp - sendTimestamp;
            Integer acknowledgedMessageNumber = driveAckHolder.acknowledgedMessageNumber;
            LOGGER_DRIVE_ACK.info("DRIVE_ACK, DCC addr: {}, ack delay: {}, driveAck state: {}, ackMsgNum: {}", new Object[]{dccAddress, ackDelay, driveAck, acknowledgedMessageNumber});
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            LOGGER_DRIVE_ACK.warn("DRIVE_ACK: Wait for drive acknowledge failed, dccAddress: {}", (Object)dccAddress);
            LOGGER.warn("Wait for drive acknowledge failed, dccAddress: {}", (Object)dccAddress, (Object)ex);
        }
        finally {
            this.removeMessageListener(messageListener);
        }
        if (driveAck == null) {
            LOGGER.warn("No acknowledge received for MSG_CS_DRIVE, dcc address: {}, speed: {}", (Object)dccAddress, (Object)speed);
            throw new ProtocolNoAnswerException("No acknowledge received for MSG_CS_DRIVE, dccAddress: " + dccAddress);
        }
        return driveAck;
    }

    public void setDriveNoWait(int dccAddress, SpeedStepsEnum speedSteps, Integer speed, DirectionEnum direction, BitSet activeFunctions, BitSet functions) throws ProtocolException {
        LOGGER.debug("set drive, dccAddress: {}, speed: {}", (Object)dccAddress, (Object)speed);
        this.delegate.sendNoWait((BidibMessageInterface)new CommandStationDriveMessage(dccAddress, speedSteps, speed, direction, activeFunctions, functions));
    }

    public DriveAcknowledge clearLoco(int dccAddress, SpeedStepsEnum speedSteps) throws ProtocolException {
        LOGGER.info("Clear loco from command station, dccAddress: {}, speedSteps: {}", (Object)dccAddress, (Object)speedSteps);
        return this.setDrive(dccAddress, speedSteps, null, DirectionEnum.BACKWARD, null, null);
    }

    public void setStateNoWait(CommandStationState commandStationState) throws ProtocolException {
        byte[] nodeAddr = this.delegate.getAddr();
        LOGGER.info("set state, commandStationState: {}, nodeAddr: {}", (Object)commandStationState, (Object)ByteUtils.bytesToHex((byte[])nodeAddr));
        this.delegate.sendNoWait((BidibMessageInterface)new CommandStationSetStateMessage(commandStationState));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandStationState setState(CommandStationState commandStationState) throws ProtocolException {
        CommandStationState resultCommandStationState = CommandStationState.OFF;
        final CompletableFuture future = new CompletableFuture();
        final byte[] nodeAddr = this.delegate.getAddr();
        LOGGER.info("set state, commandStationState: {}, nodeAddr: {}", (Object)commandStationState, (Object)ByteUtils.bytesToHex((byte[])nodeAddr));
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void csState(byte[] address, int messageNum, CommandStationState state) {
                LOGGER.info("+++ Command station state was signalled: {}, address: {}", (Object)state, (Object)address);
                if (Arrays.equals(nodeAddr, address)) {
                    future.complete(state);
                } else {
                    LOGGER.info("Received command station state from another node.");
                }
            }
        };
        try {
            this.addMessageListener(messageListener);
            this.delegate.sendNoWait((BidibMessageInterface)new CommandStationSetStateMessage(commandStationState));
            LOGGER.info("+++ The command station set state message was sent, wait for response.");
            resultCommandStationState = (CommandStationState)future.get(2000L, TimeUnit.MILLISECONDS);
            LOGGER.info("+++ Return the current command station state: {}", (Object)resultCommandStationState);
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            LOGGER.warn("Wait for current command station state failed.", (Throwable)ex);
        }
        finally {
            this.removeMessageListener(messageListener);
        }
        return resultCommandStationState;
    }

    public CommandStationState queryState() throws ProtocolException {
        return this.queryState(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandStationState queryState(boolean waitForResult) throws ProtocolException {
        LOGGER.debug("Query the state of the commandStation, waitForResult: {}", (Object)waitForResult);
        CommandStationState commandStationState = CommandStationState.OFF;
        final CompletableFuture future = new CompletableFuture();
        final byte[] nodeAddr = this.delegate.getAddr();
        DefaultMessageListener messageListener = null;
        if (waitForResult) {
            messageListener = new DefaultMessageListener(){

                @Override
                public void csState(byte[] address, int messageNum, CommandStationState state) {
                    LOGGER.info("+++ Command station state was signalled: {}, address: {}", (Object)state, (Object)address);
                    if (Arrays.equals(nodeAddr, address)) {
                        future.complete(state);
                    } else {
                        LOGGER.info("Received command station state from another node.");
                    }
                }
            };
        }
        if (messageListener != null) {
            try {
                this.addMessageListener(messageListener);
                this.delegate.sendNoWait((BidibMessageInterface)new CommandStationSetStateMessage(CommandStationState.QUERY));
                LOGGER.info("+++ The command station state query message was sent, wait for response.");
                commandStationState = (CommandStationState)future.get(500L, TimeUnit.MILLISECONDS);
                LOGGER.info("+++ Return the current command station state: {}", (Object)commandStationState);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                LOGGER.warn("Wait for current command station state failed.", (Throwable)ex);
            }
            finally {
                this.removeMessageListener(messageListener);
            }
        } else {
            this.delegate.sendNoWait((BidibMessageInterface)new CommandStationSetStateMessage(CommandStationState.QUERY));
        }
        return commandStationState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessoryAcknowledge setAccessory(int address, AddressTypeEnum addressType, TimingControlEnum timingControl, ActivateCoilEnum activateCoil, int aspect, TimeBaseUnitEnum timeBaseUnit, int time) throws ProtocolException {
        LOGGER.debug("Set accessory, address: {}", (Object)address);
        final CompletableFuture future = new CompletableFuture();
        final int requestedDecoderAddress = address;
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void csAccessoryAcknowledge(byte[] address, int messageNum, int decoderAddress, AccessoryAcknowledge acknowledge) {
                LOGGER.info("+++ CS accessory ackn was signalled, decoderAddress: {}, acknowledge: {}", (Object)decoderAddress, (Object)acknowledge);
                if (requestedDecoderAddress != decoderAddress) {
                    LOGGER.info("Acknowledge from different decoder: {}, requested: {}", (Object)decoderAddress, (Object)requestedDecoderAddress);
                }
                future.complete(acknowledge);
            }
        };
        AccessoryAcknowledge accessoryAcknowledge = null;
        try {
            this.addMessageListener(messageListener);
            CommandStationAccessoryMessage message = this.delegate.getRequestFactory().createCommandStationAccessory(address, addressType, timingControl, activateCoil, aspect, timeBaseUnit, time);
            this.delegate.sendNoWait((BidibMessageInterface)message);
            LOGGER.info("+++ The command station accessory message was sent, wait for response.");
            accessoryAcknowledge = (AccessoryAcknowledge)future.get(2000L, TimeUnit.MILLISECONDS);
            LOGGER.info("+++ Return the current command station accessory ackn: {}", (Object)accessoryAcknowledge);
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            LOGGER.warn("Wait for current command station accessory ackn failed.", (Throwable)ex);
        }
        finally {
            this.removeMessageListener(messageListener);
        }
        return accessoryAcknowledge;
    }

    public PomAcknowledge readPom(PomAddressData locoAddress, CommandStationPom opCode, int cvNumber) throws ProtocolException {
        return this.readPom(true, locoAddress, opCode, cvNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PomAcknowledge readPom(boolean waitForResult, PomAddressData locoAddress, CommandStationPom opCode, int cvNumber) throws ProtocolException {
        byte[] data = new byte[]{0};
        PomAcknowledge pomAcknowledge = null;
        final CompletableFuture future = new CompletableFuture();
        final byte[] nodeAddr = this.delegate.getAddr();
        DefaultMessageListener messageListener = null;
        if (waitForResult) {
            messageListener = new DefaultMessageListener(){

                @Override
                public void csPomAcknowledge(byte[] address, int messageNum, PomAddressData addressData, PomAcknowledge state) {
                    LOGGER.info("+++ POM acknowledge was signalled: {}, addressData: {}", (Object)state, (Object)addressData);
                    if (Arrays.equals(nodeAddr, address)) {
                        future.complete(state);
                    } else {
                        LOGGER.info("Received pom acknowledge from another node.");
                    }
                }
            };
            try {
                this.addMessageListener(messageListener);
                this.delegate.sendNoWait((BidibMessageInterface)new CommandStationPomMessage(locoAddress, opCode, cvNumber, data));
                LOGGER.info("+++ The read pom message was sent, wait for response.");
                pomAcknowledge = (PomAcknowledge)future.get(2000L, TimeUnit.MILLISECONDS);
                LOGGER.info("+++ Return the current pomAcknowledge: {}", (Object)pomAcknowledge);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                LOGGER.warn("Wait for current pomAcknowledge failed.", (Throwable)ex);
            }
            finally {
                this.removeMessageListener(messageListener);
            }
        } else {
            this.delegate.sendNoWait((BidibMessageInterface)new CommandStationPomMessage(locoAddress, opCode, cvNumber, data));
        }
        LOGGER.debug("Return the pomAcknowledge: {}", pomAcknowledge);
        return pomAcknowledge;
    }

    public PomAcknowledge readPom(DecoderIdAddressData locoAddress, CommandStationPom opCode, int cvNumber) throws ProtocolException {
        return this.readPom(true, locoAddress, opCode, cvNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PomAcknowledge readPom(boolean waitForResult, DecoderIdAddressData locoAddress, CommandStationPom opCode, int cvNumber) throws ProtocolException {
        byte[] data = new byte[]{0};
        PomAcknowledge pomAcknowledge = null;
        final CompletableFuture future = new CompletableFuture();
        final byte[] nodeAddr = this.delegate.getAddr();
        DefaultMessageListener messageListener = null;
        if (waitForResult) {
            messageListener = new DefaultMessageListener(){

                @Override
                public void csPomAcknowledge(byte[] address, int messageNum, PomAddressData addressData, PomAcknowledge state) {
                    LOGGER.info("+++ POM acknowledge was signalled: {}, addressData: {}", (Object)state, (Object)addressData);
                    if (Arrays.equals(nodeAddr, address)) {
                        future.complete(state);
                    } else {
                        LOGGER.info("Received pom acknowledge from another node.");
                    }
                }
            };
            try {
                this.addMessageListener(messageListener);
                this.delegate.sendNoWait((BidibMessageInterface)new CommandStationPomMessage(locoAddress, opCode, cvNumber, data));
                LOGGER.info("+++ The read pom message was sent, wait for response.");
                pomAcknowledge = (PomAcknowledge)future.get(2000L, TimeUnit.MILLISECONDS);
                LOGGER.info("+++ Return the current pomAcknowledge: {}", (Object)pomAcknowledge);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                LOGGER.warn("Wait for current pomAcknowledge failed.", (Throwable)ex);
            }
            finally {
                this.removeMessageListener(messageListener);
            }
        } else {
            this.delegate.sendNoWait((BidibMessageInterface)new CommandStationPomMessage(locoAddress, opCode, cvNumber, data));
        }
        LOGGER.debug("Return the pomAcknowledge: {}", pomAcknowledge);
        return pomAcknowledge;
    }

    public PomAcknowledge writePom(PomAddressData locoAddress, CommandStationPom opCode, int cvNumber, int cvValue) throws ProtocolException {
        return this.writePom(true, locoAddress, opCode, cvNumber, cvValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PomAcknowledge writePom(boolean waitForResult, PomAddressData locoAddress, CommandStationPom opCode, int cvNumber, int cvValue) throws ProtocolException {
        byte[] data = new byte[]{ByteUtils.getLowByte((int)cvValue)};
        if (CommandStationPom.XWR_BYTE2.equals((Object)opCode)) {
            data = new byte[]{ByteUtils.getLowByte((int)cvValue), ByteUtils.getHighByte((int)cvValue)};
            cvNumber = 4;
            LOGGER.info("Prepared data for short form CV access write, cvNumber (instruction type): {}, 2 bytes: {}", (Object)cvNumber, (Object)ByteUtils.bytesToHex((byte[])data));
        }
        PomAcknowledge pomAcknowledge = null;
        final CompletableFuture future = new CompletableFuture();
        final byte[] nodeAddr = this.delegate.getAddr();
        DefaultMessageListener messageListener = null;
        if (waitForResult) {
            messageListener = new DefaultMessageListener(){

                @Override
                public void csPomAcknowledge(byte[] address, int messageNum, PomAddressData addressData, PomAcknowledge state) {
                    LOGGER.info("+++ POM acknowledge was signalled: {}, addressData: {}", (Object)state, (Object)addressData);
                    if (Arrays.equals(nodeAddr, address)) {
                        future.complete(state);
                    } else {
                        LOGGER.info("Received pom acknowledge from another node.");
                    }
                }
            };
            try {
                this.addMessageListener(messageListener);
                this.delegate.sendNoWait((BidibMessageInterface)new CommandStationPomMessage(locoAddress, opCode, cvNumber, data));
                LOGGER.info("+++ The write pom message was sent, wait for response.");
                pomAcknowledge = (PomAcknowledge)future.get(2000L, TimeUnit.MILLISECONDS);
                LOGGER.info("+++ Return the current pomAcknowledge: {}", (Object)pomAcknowledge);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                LOGGER.warn("Wait for current pomAcknowledge failed.", (Throwable)ex);
            }
            finally {
                this.removeMessageListener(messageListener);
            }
        } else {
            this.delegate.sendNoWait((BidibMessageInterface)new CommandStationPomMessage(locoAddress, opCode, cvNumber, data));
        }
        LOGGER.debug("Return the pomAcknowledge: {}", pomAcknowledge);
        return pomAcknowledge;
    }

    public void readPt(CommandStationPt opCode, int cvNumber) throws ProtocolException {
        LOGGER.info("Send PT read command, opCode: {}, cvNumber: {}", (Object)opCode, (Object)cvNumber);
        byte data = 0;
        this.delegate.sendNoWait((BidibMessageInterface)new CommandStationProgMessage(opCode, cvNumber, data));
    }

    public void writePt(CommandStationPt opCode, int cvNumber, int cvValue) throws ProtocolException {
        LOGGER.info("Send PT write command, opCode: {}, cvNumber: {}, cvValue: {}", new Object[]{opCode, cvNumber, cvValue});
        byte data = ByteUtils.getLowByte((int)cvValue);
        this.delegate.sendNoWait((BidibMessageInterface)new CommandStationProgMessage(opCode, cvNumber, data));
    }

    private void addMessageListener(MessageListener messageListener) {
        this.delegate.getMessageReceiver().addMessageListener(messageListener);
    }

    private void removeMessageListener(MessageListener messageListener) {
        this.delegate.getMessageReceiver().removeMessageListener(messageListener);
    }

    public void getRcPlusTid() throws ProtocolException {
        if (this.m4Enabled) {
            LOGGER.info("Send CommandStationM4Message(M4_GET_TID) to node");
            this.delegate.sendNoWait((BidibMessageInterface)new CommandStationM4Message(M4OpCodes.M4_GET_TID));
        } else {
            LOGGER.info("Send CommandStationRcPlusMessage(RC_GET_TID) to node");
            this.delegate.sendNoWait((BidibMessageInterface)new CommandStationRcPlusMessage(RcPlusOpCodes.RC_GET_TID));
        }
    }

    public void setRcPlusTid(TidData tid) throws ProtocolException {
        if (this.m4Enabled) {
            LOGGER.info("Send CommandStationM4Message(M4_SET_TID) to node, tid: {}", (Object)tid);
            this.delegate.sendNoWait((BidibMessageInterface)new CommandStationM4Message(M4OpCodes.M4_SET_TID, tid));
        } else {
            LOGGER.info("Send CommandStationRcPlusMessage(RC_SET_TID) to node, tid: {}", (Object)tid);
            this.delegate.sendNoWait((BidibMessageInterface)new CommandStationRcPlusMessage(RcPlusOpCodes.RC_SET_TID, tid));
        }
    }

    public void sendPingOnce(RcPlusPhase phase) throws ProtocolException {
        LOGGER.info("Send CommandStationRcPlusMessage(RC_PING_ONCE) to node, phase: {}", (Object)phase);
        this.delegate.sendNoWait((BidibMessageInterface)new CommandStationRcPlusMessage(phase == RcPlusPhase.P0 ? RcPlusOpCodes.RC_PING_ONCE_P0 : RcPlusOpCodes.RC_PING_ONCE_P1));
    }

    public void sendPing(int interval) throws ProtocolException {
        if (this.m4Enabled) {
            LOGGER.info("Send CommandStationM4Message(M4_SET_BEACON) to node, interval: {}", (Object)interval);
            this.delegate.sendNoWait((BidibMessageInterface)new CommandStationM4Message(M4OpCodes.M4_SET_BEACON, new byte[]{ByteUtils.getLowByte((int)interval)}));
        } else {
            LOGGER.info("Send CommandStationRcPlusMessage(RC_PING) to node, interval: {}", (Object)interval);
            this.delegate.sendNoWait((BidibMessageInterface)new CommandStationRcPlusMessage(RcPlusOpCodes.RC_PING, new byte[]{ByteUtils.getLowByte((int)interval)}));
        }
    }

    public void sendFind(RcPlusPhase phase, DecoderUniqueIdData decoder) throws ProtocolException {
        LOGGER.info("Send CommandStationRcPlusMessage(RC_FIND) to node, phase: {}, decoder: {}", (Object)phase, (Object)decoder);
        this.delegate.sendNoWait((BidibMessageInterface)new CommandStationRcPlusMessage(phase == RcPlusPhase.P0 ? RcPlusOpCodes.RC_FIND_P0 : RcPlusOpCodes.RC_FIND_P1, decoder));
    }

    public void sendBind(RcPlusBindData bindData) throws ProtocolException {
        LOGGER.info("Send CommandStationRcPlusMessage(RC_BIND) to node, bindData: {}", (Object)bindData);
        this.delegate.sendNoWait((BidibMessageInterface)new CommandStationRcPlusMessage(bindData));
    }

    public void queryValue(CsQueryTypeEnum csQueryValue, Integer address) throws ProtocolException {
        LOGGER.info("Send CommandStationQueryMessage to node, csQueryValue: {}, address: {}", (Object)csQueryValue, (Object)address);
        if (address != null) {
            this.delegate.sendNoWait((BidibMessageInterface)new CommandStationQueryMessage(csQueryValue, address.intValue()));
        } else {
            this.delegate.sendNoWait((BidibMessageInterface)new CommandStationQueryMessage(csQueryValue));
        }
    }

    public void getDccAdvTid() throws ProtocolException {
        LOGGER.info("Send CommandStationDccAdvMessage(BIDIB_DCCA_GET_TID) to node");
        this.delegate.sendNoWait((BidibMessageInterface)new CommandStationDccAdvMessage(DccAdvOpCodes.BIDIB_DCCA_GET_TID));
    }

    public void setDccAdvTid(DccATidData tid) throws ProtocolException {
        LOGGER.info("Send CommandStationDccAdvMessage(BIDIB_DCCA_SET_TID) to node, tid: {}", (Object)tid);
        this.delegate.sendNoWait((BidibMessageInterface)new CommandStationDccAdvMessage(DccAdvOpCodes.BIDIB_DCCA_SET_TID, tid));
    }

    public void sendDccAdvLogonEnable(DccAdvLogonType type, int repetitions, int interval) throws ProtocolException {
        LOGGER.info("Send logon enable to node, type: {}, repetitions: {}, interval: {}", new Object[]{type, repetitions, interval});
        DccAdvOpCodes opCode = null;
        switch (type) {
            case DCCA_LOCO: {
                opCode = DccAdvOpCodes.BIDIB_DCCA_LOGON_ENABLE_LOCO;
                break;
            }
            case DCCA_ACC: {
                opCode = DccAdvOpCodes.BIDIB_DCCA_LOGON_ENABLE_ACC;
                break;
            }
            case DCCA_NOW: {
                opCode = DccAdvOpCodes.BIDIB_DCCA_LOGON_ENABLE_NOW;
                break;
            }
            default: {
                opCode = DccAdvOpCodes.BIDIB_DCCA_LOGON_ENABLE_ALL;
            }
        }
        this.delegate.sendNoWait((BidibMessageInterface)new CommandStationDccAdvMessage(opCode, repetitions, interval));
    }

    public void sendDccAdvLogonAssign(DecoderUniqueIdData did, int address) throws ProtocolException {
        LOGGER.info("Send logon assign to node, did: {}, address: {}", (Object)did, (Object)address);
        this.delegate.sendNoWait((BidibMessageInterface)new CommandStationDccAdvMessage(DccAdvOpCodes.BIDIB_DCCA_LOGON_ASSIGN, did, address));
    }

    public void sendDccAdvSelectInfo(DccAdvOpCodes opCode, DecoderUniqueIdData did, DccAdvSelectInfoOpCode selectInfoOpCode, int getDataRepetitions) throws ProtocolException {
        LOGGER.info("Send get info to node, did: {}, opCode: {}, selectInfoOpCode: {}, getDataRepetitions: {}", new Object[]{did, opCode, selectInfoOpCode, getDataRepetitions});
        this.delegate.sendNoWait((BidibMessageInterface)new CommandStationDccAdvMessage(opCode, did, selectInfoOpCode));
        if (getDataRepetitions > 0) {
            this.delegate.sendNoWait((BidibMessageInterface)new CommandStationDccAdvMessage(DccAdvOpCodes.BIDIB_DCCA_GET_DATA, getDataRepetitions));
        }
    }

    public void sendDccAdvGetData(DccAdvOpCodes opCode, int repetitions) throws ProtocolException {
        LOGGER.info("Send get data to node, opCode: {}, repetitions: {}", (Object)opCode, (Object)repetitions);
        this.delegate.sendNoWait((BidibMessageInterface)new CommandStationDccAdvMessage(opCode, repetitions));
    }

    private static class DriveAcknowledgeHolder {
        final DriveAcknowledge driveAcknowledge;
        final Integer acknowledgedMessageNumber;
        final long receiveTimestamp;

        public DriveAcknowledgeHolder(DriveAcknowledge driveAcknowledge, Integer acknowledgedMessageNumber, long receiveTimestamp) {
            this.driveAcknowledge = driveAcknowledge;
            this.acknowledgedMessageNumber = acknowledgedMessageNumber;
            this.receiveTimestamp = receiveTimestamp;
        }
    }
}

