/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.core.node;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.bidib.jbidibc.core.node.ConfigVar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationVariable
implements Serializable,
Comparable<ConfigurationVariable>,
ConfigVar {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationVariable.class);
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_VALUE = "value";
    public static final String PROPERTY_DEFAULT_VALUE = "defaultValue";
    public static final String PROPERTY_INVALID = "invalid";
    private transient PropertyChangeSupport changeSupport;
    private String name;
    private String defaultValue;
    private String value;
    private boolean timeout;
    private boolean invalid;
    private boolean skipOnTimeout;
    private int minCvNumber;
    private int maxCvNumber;

    public ConfigurationVariable() {
    }

    public ConfigurationVariable(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public final synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = this.createPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public final synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    protected PropertyChangeSupport createPropertyChangeSupport(Object bean) {
        return new PropertyChangeSupport(bean);
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeSupport aChangeSupport = this.changeSupport;
        if (aChangeSupport == null) {
            return;
        }
        aChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        String oldValue = this.value;
        this.value = value;
        this.firePropertyChange(PROPERTY_VALUE, oldValue, value);
    }

    @Override
    public boolean setValueIfDifferent(String value) {
        if (Objects.equals(this.value, value)) {
            return false;
        }
        this.setValue(value);
        return true;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        String oldValue = this.defaultValue;
        this.defaultValue = defaultValue;
        this.firePropertyChange(PROPERTY_DEFAULT_VALUE, oldValue, defaultValue);
    }

    @Override
    public boolean isTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(boolean timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean isSkipOnTimeout() {
        return this.skipOnTimeout;
    }

    @Override
    public void setSkipOnTimeout(boolean skipOnTimeout) {
        this.skipOnTimeout = skipOnTimeout;
    }

    public void setInvalid(boolean invalid) {
        boolean oldValue = this.invalid;
        this.invalid = invalid;
        this.firePropertyChange(PROPERTY_INVALID, oldValue, invalid);
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    @Override
    public int getMinCvNumber() {
        return this.minCvNumber;
    }

    @Override
    public void setMinCvNumber(int minCvNumber) {
        LOGGER.debug("Set the minCvNumber: {}", (Object)minCvNumber);
        this.minCvNumber = minCvNumber;
    }

    @Override
    public int getMaxCvNumber() {
        return this.maxCvNumber;
    }

    @Override
    public void setMaxCvNumber(int maxCvNumber) {
        LOGGER.debug("Set the maxCvNumber: {}", (Object)maxCvNumber);
        this.maxCvNumber = maxCvNumber;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConfigurationVariable) {
            ConfigurationVariable other = (ConfigurationVariable)obj;
            return this.name.equals(other.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(ConfigurationVariable o) {
        return this.name.compareTo(o.getName());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static void sortCvVariables(List<ConfigurationVariable> cvList) {
        Collections.sort(cvList, (cv1, cv2) -> {
            Integer cvNum1 = null;
            try {
                cvNum1 = Integer.valueOf(cv1.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Integer cvNum2 = null;
            try {
                cvNum2 = Integer.valueOf(cv2.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cvNum1 != null && cvNum2 != null) {
                return Objects.compare(cvNum1, cvNum2, (cvLeft, cvRight) -> cvLeft - cvRight);
            }
            return cv1.getName().compareTo(cv2.getName());
        });
    }

    public static ConfigurationVariable from(int cvNumber, int cvValue) {
        return new ConfigurationVariable(Integer.toString(cvNumber), Integer.toString(cvValue));
    }

    public static ConfigurationVariable from(String cvNumber, int cvValue) {
        return new ConfigurationVariable(cvNumber, Integer.toString(cvValue));
    }
}

