/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.core.node;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.concurrent.atomic.AtomicLong;
import org.bidib.jbidibc.messages.LastSendMessageTimestampProvider;
import org.bidib.jbidibc.messages.logger.Logger;

public class DefaultLastSendMessageTimestampProvider
implements LastSendMessageTimestampProvider {
    private final boolean netBidibConnection;
    private final Logger logger;
    private AtomicLong lastSentMessageTimestamp = new AtomicLong();

    public DefaultLastSendMessageTimestampProvider(Logger logger, boolean netBidibConnection) {
        this.logger = logger;
        this.netBidibConnection = netBidibConnection;
    }

    public void updateLastSendMessageTimestamp(boolean hasLocalPingMessage) {
        if (!this.netBidibConnection || hasLocalPingMessage) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Update last sent message timestamp, current: {}, new: {}", new Object[]{LocalDateTime.ofInstant(Instant.ofEpochMilli(this.getLastSendMessageTimestamp()), ZoneId.systemDefault()), LocalDateTime.ofInstant(Instant.ofEpochMilli(System.currentTimeMillis()), ZoneId.systemDefault())});
            }
            this.lastSentMessageTimestamp.set(System.currentTimeMillis());
        }
    }

    public long getLastSendMessageTimestamp() {
        return this.lastSentMessageTimestamp.get();
    }
}

