/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.core.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.bidib.jbidibc.core.AbstractMessageReceiver;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.core.BidibMessageProcessor;
import org.bidib.jbidibc.core.node.AccessoryNode;
import org.bidib.jbidibc.core.node.BidibNode;
import org.bidib.jbidibc.core.node.BoosterNode;
import org.bidib.jbidibc.core.node.CommandStationNode;
import org.bidib.jbidibc.core.node.DefaultLastSendMessageTimestampProvider;
import org.bidib.jbidibc.core.node.InterfaceNode;
import org.bidib.jbidibc.core.node.RootNode;
import org.bidib.jbidibc.messages.LastSendMessageTimestampProvider;
import org.bidib.jbidibc.messages.MasterNode;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.StallStatusProvider;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeRegistry
implements StallStatusProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeRegistry.class);
    private static final Logger LOGGER_NODE = LoggerFactory.getLogger(Node.class);
    private static final int ROOT_ADDRESS = 0;
    private final Map<Integer, BidibNode> nodes = new HashMap<Integer, BidibNode>();
    private AbstractMessageReceiver messageReceiver;
    private BidibInterface bidib;
    private BidibRequestFactory requestFactory;
    private boolean ignoreWaitTimeout;
    private boolean ignoreMissingTransferListeners;
    private final LastSendMessageTimestampProvider lastSendMessageTimestampProvider;
    private final ScheduledExecutorService sendQueueWorkers;
    private final org.bidib.jbidibc.messages.logger.Logger nodeLogger = new org.bidib.jbidibc.messages.logger.Logger(){

        public void debug(String format, Object ... arguments) {
            LOGGER_NODE.debug(format, arguments);
        }

        public void info(String format, Object ... arguments) {
            LOGGER_NODE.info(format, arguments);
        }

        public void warn(String format, Object ... arguments) {
            LOGGER_NODE.warn(format, arguments);
        }

        public void error(String format, Object ... arguments) {
            LOGGER_NODE.error(format, arguments);
        }

        public boolean isDebugEnabled() {
            return LOGGER_NODE.isDebugEnabled();
        }
    };

    public NodeRegistry(boolean isNetBidib) {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("nodeRegistrySendQueueWorkers-thread-%d").build();
        this.sendQueueWorkers = Executors.newScheduledThreadPool(5, namedThreadFactory);
        this.lastSendMessageTimestampProvider = new DefaultLastSendMessageTimestampProvider(this.nodeLogger, isNetBidib);
    }

    public void shutdown() {
        LOGGER.info("Shutdown the sendQueueWorkers.");
        this.sendQueueWorkers.shutdownNow();
    }

    public BidibInterface getBidib() {
        return this.bidib;
    }

    public void setBidib(BidibInterface bidib) {
        this.bidib = bidib;
    }

    public BidibRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public void setRequestFactory(BidibRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    public void setIgnoreWaitTimeout(boolean ignoreWaitTimeout) {
        this.ignoreWaitTimeout = ignoreWaitTimeout;
    }

    public void setIgnoreMissingTransferListeners(boolean ignoreMissingTransferListeners) {
        this.ignoreMissingTransferListeners = ignoreMissingTransferListeners;
    }

    public void setMessageReceiver(AbstractMessageReceiver messageReceiver) {
        LOGGER.debug("Set the message receiver: {}", (Object)messageReceiver);
        this.messageReceiver = messageReceiver;
    }

    public AccessoryNode getAccessoryNode(byte[] address) {
        BidibNode bidibNode = this.findNode(address);
        if (bidibNode != null) {
            try {
                if (NodeUtils.hasAccessoryFunctions((long)bidibNode.getUniqueId())) {
                    AccessoryNode accessoryNode = new AccessoryNode(bidibNode);
                    LOGGER.debug("prepared accessory node: {}", (Object)accessoryNode);
                    return accessoryNode;
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Get accessory node failed.", (Throwable)ex);
            }
            LOGGER.warn("The requested node is not an AccessoryNode, node: {}, address: {}", (Object)bidibNode, (Object)NodeUtils.formatAddress((byte[])address));
        } else {
            LOGGER.warn("No node found in registry with address: {}", (Object)NodeUtils.formatAddress((byte[])address));
        }
        return null;
    }

    public BoosterNode getBoosterNode(Node node) {
        BidibNode bidibNode = this.getNode(node);
        if (bidibNode != null && NodeUtils.hasBoosterFunctions((long)node.getUniqueId())) {
            BoosterNode boosterNode = new BoosterNode(bidibNode);
            LOGGER.debug("prepared booster node: {}", (Object)boosterNode);
            return boosterNode;
        }
        LOGGER.debug("The requested node is not a BoosterNode.");
        throw new InvalidConfigurationException("The requested node is not a BoosterNode.");
    }

    public CommandStationNode getCommandStationNode(Node node) {
        BidibNode bidibNode = this.getNode(node);
        if (bidibNode != null && NodeUtils.hasCommandStationFunctions((long)node.getUniqueId())) {
            CommandStationNode commandStationNode = new CommandStationNode(bidibNode);
            LOGGER.debug("prepared command station node: {}", (Object)commandStationNode);
            return commandStationNode;
        }
        LOGGER.debug("The requested node is not a CommandStationNode.");
        throw new InvalidConfigurationException("The requested node is not a CommandStationNode.");
    }

    public CommandStationNode getCommandStationNode(byte[] address) {
        BidibNode bidibNode = this.findNode(address);
        if (bidibNode != null) {
            try {
                if (NodeUtils.hasCommandStationFunctions((long)bidibNode.getUniqueId())) {
                    CommandStationNode commandStationNode = new CommandStationNode(bidibNode);
                    LOGGER.debug("prepared command station node: {}", (Object)commandStationNode);
                    return commandStationNode;
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Get accessory node failed.", (Throwable)ex);
            }
            LOGGER.warn("The requested node is not an CommandStationNode, node: {}, address: {}", (Object)bidibNode, (Object)NodeUtils.formatAddress((byte[])address));
        } else {
            LOGGER.warn("No node found in registry with address: {}", (Object)NodeUtils.formatAddress((byte[])address));
        }
        return null;
    }

    public InterfaceNode getInterfaceNode(Node node) {
        BidibNode bidibNode = this.getNode(node);
        if (bidibNode != null && NodeUtils.hasSubNodesFunctions((long)node.getUniqueId())) {
            InterfaceNode interfaceNode = new InterfaceNode(bidibNode);
            LOGGER.debug("prepared interface node: {}", (Object)interfaceNode);
            return interfaceNode;
        }
        LOGGER.debug("The requested node is not a InterfaceNode.");
        throw new InvalidConfigurationException("The requested node is not a InterfaceNode.");
    }

    public BidibNode createNode(Node node) {
        LOGGER.info("Create the new bidibNode of node: {}", (Object)node);
        BidibNode bidibNode = null;
        bidibNode = this.findNode(node.getAddr());
        if (bidibNode != null) {
            LOGGER.warn("The new node is already registered in the system: {}", (Object)bidibNode);
            this.messageReceiver.removeOrphanNode(node);
            LOGGER.warn("Removed orphan node: {}", (Object)node);
        }
        bidibNode = this.getNode(node);
        LOGGER.info("createNode returns new bidibNode: {}", (Object)bidibNode);
        return bidibNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BidibNode findNode(byte[] address) {
        int nodeAddress = NodeUtils.convertAddress((byte[])address);
        LOGGER.debug("Fetch bidibNode from nodes, nodeAddress: {}", (Object)nodeAddress);
        BidibNode bidibNode = null;
        Map<Integer, BidibNode> map = this.nodes;
        synchronized (map) {
            bidibNode = this.nodes.get(nodeAddress);
            if (bidibNode == null) {
                LOGGER.warn("No registered node found with address: {}", (Object)NodeUtils.formatAddressLong((byte[])address));
            }
        }
        return bidibNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BidibNode getNode(Node node) {
        int nodeAddress = NodeUtils.convertAddress((byte[])node.getAddr());
        LOGGER.debug("Fetch bidibNode from nodes, address: {}", (Object)nodeAddress);
        BidibNode bidibNode = null;
        Map<Integer, BidibNode> map = this.nodes;
        synchronized (map) {
            bidibNode = this.nodes.get(nodeAddress);
            LOGGER.debug("Get the bidibNode from nodesSet with address: {}, bidibNode: {}", (Object)nodeAddress, (Object)bidibNode);
            if (bidibNode == null) {
                LOGGER.info("No registered bidibNode found with address: {}, node: {}", (Object)nodeAddress, (Object)node);
                int classId = ByteUtils.getClassIdFromUniqueId((long)node.getUniqueId());
                LOGGER.info("Create new bidibNode with classId: {}", (Object)classId);
                bidibNode = this.createBidibNode(node);
                LOGGER.info("Created new bidibNode: {}, address: {}", (Object)bidibNode, (Object)nodeAddress);
                this.nodes.put(nodeAddress, bidibNode);
            }
        }
        return bidibNode;
    }

    protected BidibNode createBidibNode(Node node) {
        node.setLogger(this.nodeLogger);
        BidibNode bidibNode = new BidibNode(node, this.messageReceiver, this, this.ignoreWaitTimeout, this.lastSendMessageTimestampProvider);
        bidibNode.setUniqueId(node.getUniqueId());
        bidibNode.setBidib(this.bidib);
        bidibNode.setRequestFactory(this.requestFactory);
        bidibNode.setResponseTimeout(this.bidib.getResponseTimeout());
        bidibNode.setFirmwarePacketTimeout(this.bidib.getFirmwarePacketTimeout());
        LOGGER.info("Created new bidibNode, firmwarePacketTimeout: {}", (Object)this.bidib.getFirmwarePacketTimeout());
        return bidibNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RootNode getRootNode() {
        RootNode rootNode = null;
        Map<Integer, BidibNode> map = this.nodes;
        synchronized (map) {
            rootNode = (RootNode)this.nodes.get(0);
            if (rootNode == null) {
                LOGGER.info("The root node is not available, create new root node.");
                MasterNode node = new MasterNode();
                node.setLogger(this.nodeLogger);
                node.setRegistered(true);
                rootNode = new RootNode(node, (BidibMessageProcessor)this.messageReceiver, (StallStatusProvider)this, this.ignoreWaitTimeout, this.lastSendMessageTimestampProvider);
                rootNode.setBidib(this.bidib);
                rootNode.setRequestFactory(this.requestFactory);
                rootNode.setResponseTimeout(this.bidib.getResponseTimeout());
                rootNode.setFirmwarePacketTimeout(this.bidib.getFirmwarePacketTimeout());
                this.nodes.put(0, rootNode);
            }
            LOGGER.debug("Root node: {}", (Object)rootNode);
        }
        return rootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(Node node) {
        LOGGER.info("Remove node from bidib nodes: {}", (Object)node);
        Map<Integer, BidibNode> map = this.nodes;
        synchronized (map) {
            LinkedList<Integer> nodesToRemove = new LinkedList<Integer>();
            int address = NodeUtils.convertAddress((byte[])node.getAddr());
            nodesToRemove.add(address);
            if (NodeUtils.hasSubNodesFunctions((long)node.getUniqueId())) {
                byte[] addr = node.getAddr();
                LOGGER.info("The removed node has subnode functions. We must remove all subnodes, too. Address of current node: {}", (Object)addr);
                if (addr != null && addr.length > 0) {
                    for (BidibNode currentNode : this.nodes.values()) {
                        LOGGER.debug("Check if we must remove the current node: {}", (Object)currentNode);
                        byte[] currentAddr = currentNode.getAddr();
                        if (currentAddr.length <= addr.length || currentAddr[addr.length - 1] != addr[addr.length - 1]) continue;
                        address = NodeUtils.convertAddress((byte[])currentAddr);
                        LOGGER.debug("Found a subnode to be removed: {}, address: {}", (Object)currentNode, (Object)address);
                        nodesToRemove.add(address);
                    }
                }
            }
            for (Integer addressKey : nodesToRemove) {
                BidibNode bidibNode = this.nodes.remove(addressKey);
                if (bidibNode != null) {
                    LOGGER.info("Removed bidib node that must be removed: {}", (Object)bidibNode);
                    try {
                        bidibNode.terminate();
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Terminate the bidibNode failed: {}", (Object)bidibNode, (Object)ex);
                    }
                    continue;
                }
                LOGGER.warn("Remove node from nodes map failed, address: {}", (Object)addressKey);
            }
        }
    }

    public void terminateAllNodes() {
        ArrayList<BidibNode> nodes = new ArrayList<BidibNode>(this.nodes.values());
        for (BidibNode bidibNode : nodes) {
            LOGGER.info("Terminate the bidibNode: {}", (Object)bidibNode);
            try {
                bidibNode.terminate();
            }
            catch (Exception ex) {
                LOGGER.warn("Terminate the bidibNode failed: {}", (Object)bidibNode, (Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(boolean keepRootNode) {
        LOGGER.info("Reset the node factory, keepRootNode: {}", (Object)keepRootNode);
        Map<Integer, BidibNode> map = this.nodes;
        synchronized (map) {
            LOGGER.debug("Remove all nodes but keep the root node.");
            RootNode rootNode = (RootNode)this.nodes.get(0);
            for (BidibNode bidibNode : this.nodes.values()) {
                if (Arrays.equals(bidibNode.getAddr(), rootNode.getAddr())) continue;
                LOGGER.info("Terminate the bidibNode: {}", (Object)bidibNode);
                try {
                    bidibNode.terminate();
                }
                catch (Exception ex) {
                    LOGGER.warn("Terminate the bidibNode failed: {}", (Object)bidibNode, (Object)ex);
                }
            }
            this.nodes.clear();
            if (rootNode != null) {
                rootNode.setNodeMagic(null);
                if (keepRootNode) {
                    LOGGER.info("Keep the root node: {}", (Object)rootNode);
                    this.nodes.put(0, rootNode);
                }
            }
        }
    }

    public void triggerPendingAcknowledge(BidibNode bidibNode) {
        LOGGER.debug("Trigger the pending acknowledge for bidibNode: {}", (Object)bidibNode);
        this.sendQueueWorkers.submit(() -> {
            try {
                LOGGER.debug("Process the pending send queue for bidibNode: {}", (Object)bidibNode);
                bidibNode.processPendingSendQueue();
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Process pending send queue failed for bidibNode: {}", (Object)bidibNode, (Object)ex);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockIfParentNodeStall(Node node, long timeout) {
        BidibNode bidibNode = null;
        byte[] addr = node.getAddr();
        byte[] address = null;
        if (addr.length > 1) {
            int i = addr.length - 1;
            address = ByteUtils.subArray((byte[])addr, (int)0, (int)i);
        }
        Map<Integer, BidibNode> map = this.nodes;
        synchronized (map) {
            bidibNode = address != null ? this.findNode(address) : this.nodes.get(0);
        }
        if (bidibNode != null) {
            LOGGER.trace(">> Block if parent node is stall: {}", (Object)bidibNode);
            bidibNode.blockIfStall(timeout);
            LOGGER.trace("<< Block if parent node is stall: {}", (Object)bidibNode);
        }
    }
}

