/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.core.node;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.BidibMessageProcessor;
import org.bidib.jbidibc.core.DefaultMessageListener;
import org.bidib.jbidibc.core.node.BidibNode;
import org.bidib.jbidibc.messages.FirmwareUpdateStat;
import org.bidib.jbidibc.messages.LastSendMessageTimestampProvider;
import org.bidib.jbidibc.messages.MasterNode;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.StallStatusProvider;
import org.bidib.jbidibc.messages.enums.BoosterState;
import org.bidib.jbidibc.messages.enums.FirmwareUpdateOperation;
import org.bidib.jbidibc.messages.exception.NoAnswerException;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.exception.ProtocolNoAnswerException;
import org.bidib.jbidibc.messages.message.BidibCommand;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.LocalBidibDownMessage;
import org.bidib.jbidibc.messages.message.LocalLogonRejectedMessage;
import org.bidib.jbidibc.messages.message.LocalPingMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootNode
extends BidibNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(RootNode.class);
    private AtomicBoolean initialReadNodesPassed = new AtomicBoolean();
    private long startTime;
    private int timeAccelerationFactor = 1;
    private AtomicBoolean localPingEnabled = new AtomicBoolean();
    private final ScheduledExecutorService localPingWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("localPingWorkers-thread-%d").build());
    private Future<?> localPingFuture;
    private final Object localPingLock = new Object();

    RootNode(MasterNode node, BidibMessageProcessor messageReceiver, StallStatusProvider stallStatusProvider, boolean ignoreWaitTimeout, LastSendMessageTimestampProvider lastSendMessageTimestampProvider) {
        super((Node)node, messageReceiver, stallStatusProvider, ignoreWaitTimeout, lastSendMessageTimestampProvider);
        this.setStartTime(new Date().getTime());
    }

    public void setNode(MasterNode node) {
        this.node = node;
    }

    public MasterNode getMasterNode() {
        return (MasterNode)this.node;
    }

    @Override
    public void setUniqueId(Long uniqueId) {
        LOGGER.info("Set the uniqueId on the node: {}", (Object)ByteUtils.formatHexUniqueId((Long)uniqueId));
        super.setUniqueId(uniqueId);
        ((MasterNode)this.node).setUniqueId(uniqueId.longValue());
    }

    @Override
    public void terminate() {
        LOGGER.debug("Terminate the root node.");
        try {
            this.localPingWorker.shutdownNow();
        }
        catch (Exception ex) {
            LOGGER.warn("Shutdown the localPingWorker in terminate failed.", (Throwable)ex);
        }
        super.terminate();
    }

    public void clock(LocalDateTime currentTime, int factor) throws ProtocolException {
        if (this.node.isDetached()) {
            LOGGER.info("The root node is detached. Do not send the clock message.");
        } else {
            LOGGER.info("Send the clock message.");
            this.sendNoWait((BidibMessageInterface)this.getRequestFactory().createSysClock(currentTime, factor));
        }
    }

    @Override
    public void reset() throws ProtocolException {
        super.reset();
    }

    public void clear() {
    }

    @Override
    public int getMagic(Integer receiveTimeout) throws ProtocolException {
        LOGGER.trace("Get magic from root node!");
        int magic = super.getMagic(receiveTimeout);
        LOGGER.info("Get magic from root node returns: {}", (Object)magic);
        if (-1 == magic) {
            LOGGER.warn("The interface did not respond the get magic request!");
            StringBuilder sb = new StringBuilder("The interface did not respond the get magic request!");
            String errorInfo = this.getMessageReceiver().getErrorInformation();
            if (StringUtils.isNotBlank((CharSequence)errorInfo)) {
                LOGGER.warn("Found received data that was not identifed as BiDiB messages: {}", (Object)errorInfo);
                sb.append("\r\n");
                sb.append(errorInfo);
            }
            NoAnswerException ex = new NoAnswerException("Establish communication with interface failed.");
            ex.setDescription(sb.toString());
            LOGGER.warn("Prepared exception to throw:", (Throwable)ex);
            throw ex;
        }
        return magic;
    }

    public void broadcastBoosterState(BoosterState boosterState) throws ProtocolException {
        LOGGER.info("Broadcast the booster state: {}", (Object)boosterState);
        BidibCommand bidibCommand = this.getRequestFactory().createBoosterSetState(boosterState, true);
        this.sendNoWait((BidibMessageInterface)bidibCommand);
    }

    public void setReadNodesPassed(boolean readNodesPassed) {
        this.initialReadNodesPassed.set(readNodesPassed);
    }

    public boolean getReadNodesPassed() {
        return this.initialReadNodesPassed.get();
    }

    public int getTimeAccelerationFactor() {
        return this.timeAccelerationFactor;
    }

    public void setTimeAccelerationFactor(int timeAccelerationFactor) {
        this.timeAccelerationFactor = timeAccelerationFactor;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localPing() throws ProtocolException {
        final CountDownLatch continueLock = new CountDownLatch(1);
        DefaultMessageListener messageListener = new DefaultMessageListener(){

            @Override
            public void localPong(byte[] address, int messageNum) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received the local pong response, address: {}", (Object)NodeUtils.formatAddressLong((byte[])address));
                }
                if (NodeUtils.isAddressEqual((byte[])address, (byte[])RootNode.this.getAddr())) {
                    continueLock.countDown();
                } else {
                    LOGGER.debug("Received local pong for another node.");
                }
            }
        };
        try {
            this.getMessageReceiver().addMessageListener(messageListener);
            LocalPingMessage bidibCommand = this.getRequestFactory().createLocalPing();
            this.sendNoWait((BidibMessageInterface)bidibCommand);
            boolean success = continueLock.await(this.getResponseTimeout(), TimeUnit.MILLISECONDS);
            if (success) {
                LOGGER.info("Received local pong.");
                return;
            }
            LOGGER.warn("Wait for local pong was not successful.");
        }
        catch (InterruptedException e) {
            LOGGER.warn("Wait for response before continue was interrupted.");
            Thread.currentThread().interrupt();
        }
        finally {
            this.getMessageReceiver().removeMessageListener(messageListener);
        }
        throw this.createNoResponseAvailable("local ping");
    }

    public void localLogonRejected(long uniqueId) throws ProtocolException {
        LOGGER.info("Stop the local ping worker on the rootNode before send logon rejected. Current uniqueId: {}", (Object)uniqueId);
        try {
            this.stopLocalPingWorker();
        }
        catch (Exception ex) {
            LOGGER.warn("Stop the local ping worker failed.", (Throwable)ex);
        }
        LocalLogonRejectedMessage bidibCommand = this.getRequestFactory().createLocalLogonRejected(uniqueId);
        this.sendNoWait((BidibMessageInterface)bidibCommand);
        this.resetNextSendMsgNum();
    }

    public void localBidibDown(byte[] wrappedMessage) throws ProtocolException {
        LocalBidibDownMessage bidibCommand = this.getRequestFactory().createLocalBidibDown(wrappedMessage);
        this.sendNoWait((BidibMessageInterface)bidibCommand);
    }

    @Override
    public FirmwareUpdateStat sendFirmwareUpdateOperation(FirmwareUpdateOperation operation, byte ... data) throws ProtocolException {
        switch (operation) {
            case ENTER: {
                LOGGER.info("Stop the local ping worker before enter the firmware update mode.");
                this.stopLocalPingWorker();
                break;
            }
        }
        return super.sendFirmwareUpdateOperation(operation, data);
    }

    public boolean isLocalPingEnabled() {
        return this.localPingEnabled.get();
    }

    public void setLocalPingEnabled(boolean localPingEnabled) {
        this.localPingEnabled.set(localPingEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLocalPingWorker(boolean netBidibConnection, Consumer<Boolean> localPingResultConsumer) {
        LOGGER.info("Start the local ping worker for bidibNode: {}", (Object)this);
        boolean isGbmBoostMaster = ProductUtils.isGBMBoostMaster((long)this.node.getUniqueId());
        if (isGbmBoostMaster) {
            LOGGER.info("The current master is a GBMboost. Check the firmware version.");
            if (this.node.getSoftwareVersion().isLowerThan(SoftwareVersion.build((int)2, (int)7, (int)1))) {
                LOGGER.warn("Don't start the local ping worker for old firmware version of GBMboost Master: {}", (Object)this.node.getSoftwareVersion());
                return;
            }
        } else if (ProductUtils.isZeus((long)this.node.getUniqueId())) {
            LOGGER.info("The current master is a Tams Zeus. No support for MSG_LOCAL_PING.");
            return;
        }
        Object object = this.localPingLock;
        synchronized (object) {
            if (this.localPingFuture != null) {
                LOGGER.warn("The local ping worker is assigned already.");
                return;
            }
            this.localPingFuture = this.localPingWorker.scheduleWithFixedDelay(() -> {
                block5: {
                    try {
                        LOGGER.debug("Trigger the local ping for bidib root node: {}", (Object)this);
                        if (System.currentTimeMillis() - this.getLastSendMessageTimestampProvider().getLastSendMessageTimestamp() > 4200L) {
                            try {
                                this.localPing();
                                localPingResultConsumer.accept(Boolean.TRUE);
                            }
                            catch (ProtocolNoAnswerException pnaEx) {
                                LOGGER.warn("Wait for local ping timed-out.");
                                localPingResultConsumer.accept(Boolean.FALSE);
                            }
                        }
                    }
                    catch (ProtocolException ex) {
                        LOGGER.warn("Send local ping failed for bidibNode: {}", (Object)this, (Object)ex);
                        if (this.node == null || this.node.isRegistered()) break block5;
                        LOGGER.warn("The node is no longer registered. Leave the loop.");
                        throw new IllegalStateException("The node is no longer registered.");
                    }
                }
            }, 1000L, 500L, TimeUnit.MILLISECONDS);
            LOGGER.info("Current localPingFuture: {}", this.localPingFuture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLocalPingWorker() {
        LOGGER.info("Stop the local ping worker, localPingFuture: {}", this.localPingFuture);
        Object object = this.localPingLock;
        synchronized (object) {
            if (this.localPingFuture != null) {
                try {
                    this.localPingFuture.cancel(true);
                }
                catch (Exception ex) {
                    LOGGER.warn("Cancel the local ping worker failed for bidibNode: {}", (Object)this, (Object)ex);
                }
                LOGGER.info("Free the localPingFuture.");
                this.localPingFuture = null;
            }
        }
    }

    public void signalLocalLogoff(Long uniqueId) {
        LOGGER.info("The node was logged off: {}", (Object)ByteUtils.formatHexUniqueId((Long)uniqueId));
        this.resetNextSendMsgNum();
    }

    public void setVersion(int version) {
        MasterNode masterNode = (MasterNode)this.node;
        LOGGER.info("Set the version on the masterNode: {}, version: {}, masterNode.identity: {}", new Object[]{masterNode, version, masterNode.getIdentity()});
        masterNode.setVersion(version);
    }

    public void localSync(int systemTime) throws ProtocolException {
        BidibCommand bidibCommand = this.getRequestFactory().createLocalSync(systemTime);
        this.sendNoWait((BidibMessageInterface)bidibCommand);
    }
}

