/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.core.schema;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.IndentingXMLEventWriter;
import org.bidib.jbidibc.core.schema.bidib2.BiDiB;
import org.bidib.jbidibc.core.schema.bidib2.FeatureCode;
import org.bidib.jbidibc.core.schema.bidib2.InputKey;
import org.bidib.jbidibc.core.schema.bidib2.LocalLink;
import org.bidib.jbidibc.core.schema.bidib2.MessageType;
import org.bidib.jbidibc.core.schema.bidib2.ObjectFactory;
import org.bidib.jbidibc.core.schema.bidib2.OutputBacklight;
import org.bidib.jbidibc.core.schema.bidib2.OutputLight;
import org.bidib.jbidibc.core.schema.bidib2.OutputMotor;
import org.bidib.jbidibc.core.schema.bidib2.OutputServo;
import org.bidib.jbidibc.core.schema.bidib2.OutputSound;
import org.bidib.jbidibc.core.schema.bidib2.OutputSwitch;
import org.bidib.jbidibc.core.schema.bidib2.OutputSwitchPair;
import org.bidib.jbidibc.core.schema.bidib2.Port;
import org.bidib.jbidibc.core.schema.exception.InvalidSchemaException;
import org.bidib.jbidibc.core.schema.validation.XsdValidationLoggingErrorHandler;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class BidibFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BidibFactory.class);
    private static final String JAXB_PACKAGE = "org.bidib.jbidibc.core.schema.bidib2";
    public static final String XSD_LOCATION = "/xsd/bidib2.xsd";
    public static final String JAXB_SCHEMA_LOCATION = "http://www.bidib.org/schema/bidib/2.0 xsd/bidib2.xsd";
    public static final String FILENAME_PROTOCOL_BIDIB = "/xml/protocol/Protocol2.bidib";
    private static JAXBContext jaxbContext;
    private static List<MessageType> messageTypes;
    private static List<LocalLink> localLinks;
    private static List<FeatureCode> featureCodes;

    public static synchronized List<MessageType> getMessageTypes() {
        if (messageTypes == null) {
            LOGGER.info("Load and cache the message types.");
            messageTypes = new BidibFactory().loadMessageTypes();
        }
        return messageTypes;
    }

    public static synchronized List<LocalLink> getLocalLinks() {
        if (localLinks == null) {
            LOGGER.info("Load and cache the local links.");
            localLinks = new BidibFactory().loadLocalLinks();
        }
        return localLinks;
    }

    public static synchronized List<FeatureCode> getFeatureCodes() {
        if (featureCodes == null) {
            LOGGER.info("Load and cache the feature codes.");
            featureCodes = new BidibFactory().loadFeatureCodes();
        }
        return featureCodes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<FeatureCode> loadFeatureCodes() {
        try (InputStream is = BidibFactory.class.getResourceAsStream(FILENAME_PROTOCOL_BIDIB);){
            if (is != null) {
                BiDiB bidib = BidibFactory.loadBiDiBFile(is);
                if (bidib == null) return Collections.emptyList();
                try {
                    List<FeatureCode> featureCodes = bidib.getProtocol().getFeatureCodes().getFeatureCode();
                    LOGGER.info("Loaded number of featureCodes: {}", (Object)featureCodes.size());
                    List<FeatureCode> list = featureCodes;
                    return list;
                }
                catch (Exception ex) {
                    LOGGER.warn("Get the feature codes failed.", (Throwable)ex);
                    return Collections.emptyList();
                }
            }
            LOGGER.warn("Load protocol file  failed.");
            return Collections.emptyList();
        }
        catch (IOException ex) {
            LOGGER.warn("Load feature codes from protocol file failed.", (Throwable)ex);
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<MessageType> loadMessageTypes() {
        try (InputStream is = BidibFactory.class.getResourceAsStream(FILENAME_PROTOCOL_BIDIB);){
            if (is != null) {
                BiDiB bidib = BidibFactory.loadBiDiBFile(is);
                if (bidib == null) return Collections.emptyList();
                try {
                    List<MessageType> messageTypes = bidib.getProtocol().getMessageTypes().getMessageType();
                    LOGGER.info("Loaded number of messageTypes: {}", (Object)messageTypes.size());
                    List<MessageType> list = messageTypes;
                    return list;
                }
                catch (Exception ex) {
                    LOGGER.warn("Get the message types failed.", (Throwable)ex);
                    return Collections.emptyList();
                }
            }
            LOGGER.warn("Load protocol file failed.");
            return Collections.emptyList();
        }
        catch (IOException ex) {
            LOGGER.warn("Load message types from protocol file failed.", (Throwable)ex);
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<LocalLink> loadLocalLinks() {
        try (InputStream is = BidibFactory.class.getResourceAsStream(FILENAME_PROTOCOL_BIDIB);){
            if (is != null) {
                BiDiB bidib = BidibFactory.loadBiDiBFile(is);
                if (bidib == null) return Collections.emptyList();
                try {
                    List<LocalLink> localLinks = bidib.getProtocol().getLocalLinks().getLocalLink();
                    LOGGER.info("Loaded number of localLinks: {}", (Object)localLinks.size());
                    List<LocalLink> list = localLinks;
                    return list;
                }
                catch (Exception ex) {
                    LOGGER.warn("Get the localLinks failed.", (Throwable)ex);
                    return Collections.emptyList();
                }
            }
            LOGGER.warn("Load protocol file failed.");
            return Collections.emptyList();
        }
        catch (IOException ex) {
            LOGGER.warn("Load localLinks from protocol file failed.", (Throwable)ex);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BiDiB loadBiDiBFile(File bidibFile) throws FileNotFoundException {
        BiDiB bidib = null;
        try (FileInputStream is = new FileInputStream(bidibFile);){
            bidib = BidibFactory.loadBiDiBFile(is);
        }
        catch (InvalidSchemaException ex) {
            LOGGER.warn("Load bidib file failed due to schema violation. Try to transform.", (Throwable)ex);
            StringBuilder transformed = new StringBuilder();
            OutputStream fos = null;
            try (FileInputStream isOrg = new FileInputStream(bidibFile);){
                BidibFactory.transform(isOrg, transformed);
                LOGGER.info("Save transformed bidib to file: {}", (Object)bidibFile.getAbsolutePath());
                fos = new FileOutputStream(bidibFile);
                IOUtils.write((CharSequence)transformed, (OutputStream)fos, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException | XMLStreamException e) {
                LOGGER.warn("Transform bidib file failed: {}", (Object)bidibFile.getAbsolutePath(), (Object)e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.flush();
                        ((FileOutputStream)fos).close();
                    }
                    catch (Exception e1) {
                        LOGGER.warn("Close output stream failed.", (Throwable)e1);
                    }
                }
            }
            LOGGER.info("Try to load the bidib file after transformation.");
            try (FileInputStream is2 = new FileInputStream(bidibFile);){
                bidib = BidibFactory.loadBiDiBFile(is2);
            }
            catch (IOException e1) {
                LOGGER.info("No bidib file after transformation found.", (Throwable)e1);
            }
        }
        catch (IOException ex) {
            LOGGER.info("No bidib file found.", (Throwable)ex);
        }
        return bidib;
    }

    public static BiDiB loadBiDiBFile(InputStream is) {
        BiDiB bidib = null;
        try {
            if (jaxbContext == null) {
                LOGGER.info("Create the jaxb context for JAXB_PACKAGE: {}", (Object)JAXB_PACKAGE);
                jaxbContext = JAXBContext.newInstance((String)JAXB_PACKAGE, (ClassLoader)BidibFactory.class.getClassLoader());
            }
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSource = new StreamSource(BidibFactory.class.getResourceAsStream(XSD_LOCATION));
            Schema schema = schemaFactory.newSchema(streamSource);
            unmarshaller.setSchema(schema);
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader xmlr = factory.createXMLStreamReader(is);
            try {
                JAXBElement jaxbElement = unmarshaller.unmarshal(xmlr, BiDiB.class);
                bidib = (BiDiB)jaxbElement.getValue();
            }
            catch (UnmarshalException ex) {
                LOGGER.warn("Load content from file failed.", (Throwable)ex);
                if (ex.getLinkedException() instanceof SAXException) {
                    BidibFactory.validate(is);
                    throw new InvalidSchemaException("Load BiDiB from file failed");
                }
            }
        }
        catch (JAXBException | XMLStreamException | SAXException ex) {
            LOGGER.warn("Load content from file failed.", ex);
        }
        return bidib;
    }

    private static List<String> validate(InputStream is) {
        List<String> errors = null;
        if (is instanceof FileInputStream) {
            FileInputStream fis = (FileInputStream)is;
            try {
                LOGGER.info("Try to set file position to 0.");
                fis.getChannel().position(0L);
            }
            catch (IOException e) {
                LOGGER.warn("Set file position to 0 failed.", (Throwable)e);
            }
        }
        StreamSource inputStreamSource = new StreamSource(is);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource streamSource = new StreamSource(BidibFactory.class.getResourceAsStream(XSD_LOCATION));
        XsdValidationLoggingErrorHandler errorHandler = new XsdValidationLoggingErrorHandler();
        try {
            Schema schema = schemaFactory.newSchema(streamSource);
            Validator validator = schema.newValidator();
            validator.setErrorHandler(errorHandler);
            validator.validate(inputStreamSource);
        }
        catch (IOException | SAXException ex) {
            LOGGER.warn("Validate failed.", (Throwable)ex);
        }
        errors = errorHandler.getErrors();
        LOGGER.info("Found errors: {}", errors);
        return errors;
    }

    public static void saveBiDiB(BiDiB bidib, String fileName, boolean gzip) {
        BidibFactory.saveBiDiB(bidib, new File(fileName), gzip);
    }

    public static void saveBiDiB(BiDiB bidib, File bidibFile, boolean gzip) {
        if (bidib != null && bidib.getExportTimestamp() == null) {
            try {
                LocalDateTime now = LocalDateTime.now();
                XMLGregorianCalendar xmlGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(now.toString());
                bidib.setExportTimestamp(xmlGregorianCalendar);
            }
            catch (Exception ex) {
                LOGGER.warn("Set the export timestamp failed.", (Throwable)ex);
            }
        }
        LOGGER.info("Save bidib content to file: {}", (Object)bidibFile.getPath());
        LOGGER.debug("Save bidib content, bidib: {}", (Object)bidib);
        OutputStream os = null;
        OutputStreamWriter osw = null;
        boolean passed = false;
        try {
            if (jaxbContext == null) {
                LOGGER.info("Create the jaxb context for JAXB_PACKAGE: {}", (Object)JAXB_PACKAGE);
                jaxbContext = JAXBContext.newInstance((String)JAXB_PACKAGE);
            }
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.schemaLocation", (Object)JAXB_SCHEMA_LOCATION);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSource = new StreamSource(BidibFactory.class.getResourceAsStream(XSD_LOCATION));
            Schema schema = schemaFactory.newSchema(streamSource);
            marshaller.setSchema(schema);
            os = new BufferedOutputStream(new FileOutputStream(bidibFile));
            if (gzip) {
                LOGGER.debug("Use gzip to compress bidib.");
                os = new GZIPOutputStream(os);
            }
            JAXBElement<BiDiB> jaxbElement = new ObjectFactory().createBiDiB(bidib);
            osw = new OutputStreamWriter(os, Charset.forName("UTF-8"));
            marshaller.marshal(jaxbElement, (Writer)osw);
            osw.flush();
            os.flush();
            LOGGER.info("Save bidib content to file passed: {}", (Object)bidibFile.getPath());
            passed = true;
        }
        catch (Exception ex) {
            LOGGER.warn("Save bidib failed.", (Throwable)ex);
            throw new RuntimeException("Save bidib failed.", ex);
        }
        finally {
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close outputStreamWriter failed.", (Throwable)ex);
                }
                osw = null;
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close outputStream failed.", (Throwable)ex);
                }
                os = null;
            }
            if (!passed) {
                LOGGER.warn("Delete the file because the export has failed.");
                FileUtils.deleteQuietly((File)bidibFile);
            }
        }
    }

    public static <PT extends Port> List<PT> getPortsOfType(List<Port> allPorts, final LcOutputType type) {
        LinkedList ports = new LinkedList();
        Collection selection = CollectionUtils.select(allPorts, (Predicate)new Predicate<Port>(){

            public boolean evaluate(Port port) {
                switch (type) {
                    case LIGHTPORT: {
                        if (!(port instanceof OutputLight)) break;
                        return true;
                    }
                    case BACKLIGHTPORT: {
                        if (!(port instanceof OutputBacklight)) break;
                        return true;
                    }
                    case SERVOPORT: {
                        if (!(port instanceof OutputServo)) break;
                        return true;
                    }
                    case SWITCHPORT: {
                        if (!(port instanceof OutputSwitch)) break;
                        return true;
                    }
                    case SWITCHPAIRPORT: {
                        if (!(port instanceof OutputSwitchPair)) break;
                        return true;
                    }
                    case SOUNDPORT: {
                        if (!(port instanceof OutputSound)) break;
                        return true;
                    }
                    case MOTORPORT: {
                        if (!(port instanceof OutputMotor)) break;
                        return true;
                    }
                    case INPUTPORT: {
                        if (!(port instanceof InputKey)) break;
                        return true;
                    }
                }
                return false;
            }
        });
        ports.addAll(selection);
        return ports;
    }

    public static String prepareNodeFilename(long uniqueId) {
        String nodeFileName = String.format("%014X.xml", uniqueId & 0xFFFFFFFFFFFFFFL);
        return nodeFileName;
    }

    public static void transform(InputStream source, StringBuilder target) throws XMLStreamException, IOException {
        XMLInputFactory inFactory = XMLInputFactory.newInstance();
        XMLEventReader eventReader = inFactory.createXMLEventReader(source);
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        StringBuilderWriter stringBuilderWriter = new StringBuilderWriter(target);
        IndentingXMLEventWriter writer = new IndentingXMLEventWriter(factory.createXMLEventWriter(new BufferedWriter((Writer)stringBuilderWriter)));
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.getEventType() == 1) {
                LOGGER.debug("Current element name: {}", (Object)event.asStartElement().getName().toString());
                if (event.asStartElement().getName().getLocalPart().equals("node")) {
                    StartElement node = eventFactory.createStartElement("", null, "node");
                    writer.add(node);
                    StartElement nodeElement = event.asStartElement();
                    QName uniqueIdName = new QName("uniqueId");
                    Iterator<Attribute> attributes = nodeElement.getAttributes();
                    while (attributes.hasNext()) {
                        Attribute attribute = attributes.next();
                        if (attribute.getName().equals(uniqueIdName)) {
                            LOGGER.info("Found uniqueId attribute: {}", (Object)attribute);
                            String value = attribute.getValue();
                            if (StringUtils.startsWithIgnoreCase((CharSequence)value, (CharSequence)"0x")) {
                                long uniqueId = Long.parseLong(value.substring(2), 16);
                                value = Long.toString(uniqueId);
                                Attribute newAttribute = eventFactory.createAttribute("uniqueId", value);
                                writer.add(newAttribute);
                                continue;
                            }
                            writer.add(attribute);
                            continue;
                        }
                        writer.add(attribute);
                    }
                    continue;
                }
                writer.add(event);
                continue;
            }
            writer.add(event);
        }
        writer.close();
    }
}

