/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.core.schema;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.io.FileUtils;
import org.bidib.jbidibc.core.schema.UserDevicesListFactory;
import org.bidib.jbidibc.core.schema.bidib.products.BiDiB;
import org.bidib.jbidibc.core.schema.bidib.products.ObjectFactory;
import org.bidib.jbidibc.core.schema.bidib.products.ProductType;
import org.bidib.jbidibc.core.schema.exception.InvalidSchemaException;
import org.bidib.jbidibc.core.schema.validation.XsdValidationLoggingErrorHandler;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class BidibProductsFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BidibProductsFactory.class);
    private static final String JAXB_PACKAGE = "org.bidib.jbidibc.core.schema.bidib.products";
    public static final String XSD_LOCATION = "/xsd/bidib2Products.xsd";
    public static final String XSD_LOCATION_BASE = "/xsd/bidib2Common.xsd";
    public static final String JAXB_SCHEMA_LOCATION = "http://www.bidib.org/schema/bidib xsd/bidib2Products.xsd";
    private static JAXBContext jaxbContext;

    public static synchronized List<ProductType> getProducts(int vendorId, String ... searchPaths) {
        LOGGER.info("Load the products for vendorId: {}", (Object)vendorId);
        return new BidibProductsFactory().loadProducts(vendorId, searchPaths);
    }

    public static synchronized ProductType getProduct(int vendorId, final int productId, String ... searchPaths) {
        LOGGER.info("Load the product with vendorId: {} and productId: {}", (Object)vendorId, (Object)productId);
        List<ProductType> products = new BidibProductsFactory().loadProducts(vendorId, searchPaths);
        if (CollectionUtils.isNotEmpty(products)) {
            ProductType product = (ProductType)IterableUtils.find(products, (Predicate)new Predicate<ProductType>(){

                public boolean evaluate(ProductType product) {
                    return product.getProductTypeId() == productId;
                }
            });
            return product;
        }
        return null;
    }

    private List<ProductType> loadProducts(int vendorId, String ... searchPaths) {
        List<ProductType> products = Collections.emptyList();
        BiDiB bidib = this.loadBidib(vendorId, searchPaths);
        if (bidib != null) {
            products = bidib.getProducts().getProduct();
        }
        return products;
    }

    public static ProductType getProduct(Node node, String ... searchPaths) {
        LOGGER.info("Load the Product info for node: {}", (Object)node);
        return new BidibProductsFactory().loadProductForNode(node, searchPaths);
    }

    public ProductType loadProductForNode(Node node, String ... searchPaths) {
        List<ProductType> products;
        long uniqueId = node.getUniqueId();
        int relevantPidBits = node.getRelevantPidBits();
        int pid = NodeUtils.getPid((long)uniqueId, (int)relevantPidBits);
        int vid = NodeUtils.getVendorId((long)uniqueId);
        LOGGER.info("Load the vendor cv definition for uniqueId: {}, pid: {}, vid: {}", new Object[]{ByteUtils.getUniqueIdAsString((long)uniqueId), pid, vid});
        ProductType product = null;
        BiDiB bidib = this.loadBidib(vid, searchPaths);
        if (bidib != null && (products = bidib.getProducts().getProduct()) != null) {
            short productTypeId = (short)pid;
            for (ProductType current : products) {
                if (current.getProductTypeId() != productTypeId) continue;
                product = current;
                break;
            }
        }
        LOGGER.trace("Loaded product: {}", product);
        return product;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BiDiB loadBiDiBFile(File productsFile) throws FileNotFoundException {
        BiDiB bidib;
        block14: {
            bidib = null;
            FileInputStream is = null;
            try {
                is = new FileInputStream(productsFile);
                bidib = this.loadBiDiBFile(is);
            }
            catch (InvalidSchemaException ex) {
                LOGGER.warn("Load bidib file failed due to schema violation. Try to transform.", (Throwable)ex);
                if (is == null) break block14;
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e1) {
                    LOGGER.warn("Close output stream failed.", (Throwable)e1);
                }
                is = null;
            }
            finally {
                if (is != null) {
                    LOGGER.info("Close input stream.");
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception e1) {
                        LOGGER.warn("Close output stream failed.", (Throwable)e1);
                    }
                    is = null;
                }
            }
        }
        return bidib;
    }

    private BiDiB loadBidib(long vid, String ... searchPaths) {
        BiDiB bidib = null;
        for (String searchPath : searchPaths) {
            StringBuilder filename = new StringBuilder("Products_");
            filename.append(vid).append(".bidib");
            LOGGER.info("Prepared filename to load products: {}", (Object)filename.toString());
            if (searchPath.startsWith("classpath:")) {
                int beginIndex = "classpath:".length();
                String lookup = searchPath.substring(beginIndex) + "/" + filename.toString();
                LOGGER.info("Lookup products file internally: {}", (Object)lookup);
                InputStream is = BidibProductsFactory.class.getResourceAsStream(lookup);
                if (is != null) {
                    bidib = this.loadBiDiBFile(is);
                    if (bidib == null) continue;
                    break;
                }
                LOGGER.warn("Internal lookup for products file failed.");
                continue;
            }
            File productsFile = new File(searchPath, filename.toString());
            if (productsFile.exists()) {
                LOGGER.info("Found product file: {}", (Object)productsFile.getAbsolutePath());
                try {
                    bidib = this.loadBiDiBFile(productsFile);
                }
                catch (FileNotFoundException ex) {
                    LOGGER.info("No Products file found.");
                }
                if (bidib == null) continue;
                break;
            }
            LOGGER.info("File does not exist: {}", (Object)productsFile.getAbsolutePath());
        }
        return bidib;
    }

    public BiDiB loadBiDiBFile(InputStream is) {
        BiDiB bidib = null;
        try {
            if (jaxbContext == null) {
                LOGGER.info("Create the jaxb context for JAXB_PACKAGE: {}", (Object)JAXB_PACKAGE);
                jaxbContext = JAXBContext.newInstance((String)JAXB_PACKAGE);
            }
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSource = new StreamSource(BidibProductsFactory.class.getResourceAsStream(XSD_LOCATION));
            StreamSource streamSourceBase = new StreamSource(UserDevicesListFactory.class.getResourceAsStream(XSD_LOCATION_BASE));
            Schema schema = schemaFactory.newSchema(new Source[]{streamSourceBase, streamSource});
            unmarshaller.setSchema(schema);
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader xmlr = factory.createXMLStreamReader(is);
            try {
                JAXBElement jaxbElement = unmarshaller.unmarshal(xmlr, BiDiB.class);
                bidib = (BiDiB)jaxbElement.getValue();
            }
            catch (UnmarshalException ex) {
                LOGGER.warn("Load content from file failed.", (Throwable)ex);
                if (ex.getLinkedException() instanceof SAXException) {
                    this.validate(is);
                    throw new InvalidSchemaException("Load BiDiB from file failed");
                }
            }
        }
        catch (JAXBException | XMLStreamException | SAXException ex) {
            LOGGER.warn("Load content from file failed.", ex);
        }
        return bidib;
    }

    private List<String> validate(InputStream is) {
        List<String> errors = null;
        if (is instanceof FileInputStream) {
            FileInputStream fis = (FileInputStream)is;
            try {
                LOGGER.info("Try to set file position to 0.");
                fis.getChannel().position(0L);
            }
            catch (IOException e) {
                LOGGER.warn("Set file position to 0 failed.", (Throwable)e);
            }
        }
        StreamSource inputStreamSource = new StreamSource(is);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource streamSource = new StreamSource(BidibProductsFactory.class.getResourceAsStream(XSD_LOCATION));
        StreamSource streamSourceBase = new StreamSource(UserDevicesListFactory.class.getResourceAsStream(XSD_LOCATION_BASE));
        XsdValidationLoggingErrorHandler errorHandler = new XsdValidationLoggingErrorHandler();
        try {
            Schema schema = schemaFactory.newSchema(new Source[]{streamSourceBase, streamSource});
            Validator validator = schema.newValidator();
            validator.setErrorHandler(errorHandler);
            validator.validate(inputStreamSource);
        }
        catch (IOException ex) {
            LOGGER.warn("Validate failed.", (Throwable)ex);
        }
        catch (SAXException ex) {
            LOGGER.warn("Validate failed.", (Throwable)ex);
        }
        errors = errorHandler.getErrors();
        LOGGER.info("Found errors: {}", errors);
        return errors;
    }

    public static void saveBiDiB(BiDiB bidib, String fileName, boolean gzip) {
        LOGGER.info("Save bidib content to file: {}, bidib: {}", (Object)fileName, (Object)bidib);
        OutputStream os = null;
        boolean passed = false;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)JAXB_PACKAGE);
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.schemaLocation", (Object)JAXB_SCHEMA_LOCATION);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSource = new StreamSource(BidibProductsFactory.class.getResourceAsStream(XSD_LOCATION));
            StreamSource streamSourceBase = new StreamSource(UserDevicesListFactory.class.getResourceAsStream(XSD_LOCATION_BASE));
            Schema schema = schemaFactory.newSchema(new Source[]{streamSourceBase, streamSource});
            marshaller.setSchema(schema);
            os = new BufferedOutputStream(new FileOutputStream(fileName));
            if (gzip) {
                LOGGER.debug("Use gzip to compress bidib.");
                os = new GZIPOutputStream(os);
            }
            JAXBElement<BiDiB> jaxbElement = new ObjectFactory().createBiDiB(bidib);
            marshaller.marshal(jaxbElement, (Writer)new OutputStreamWriter(os, StandardCharsets.UTF_8));
            os.flush();
            LOGGER.info("Save bidib content to file passed: {}", (Object)fileName);
            passed = true;
        }
        catch (Exception ex) {
            LOGGER.warn("Save bidib failed.", (Throwable)ex);
            throw new RuntimeException("Save bidib failed.", ex);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close outputstream failed.", (Throwable)ex);
                }
            }
            if (!passed) {
                LOGGER.warn("Delete the file because the export has failed.");
                FileUtils.deleteQuietly((File)new File(fileName));
            }
        }
    }
}

