/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.core.schema;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.FileUtils;
import org.bidib.jbidibc.core.schema.cvexchange.SaveCV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class CvExchangeFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CvExchangeFactory.class);
    private static final String JAXB_PACKAGE = "org.bidib.jbidibc.core.schema.cvexchange";
    public static final String XSD_LOCATION = "/xsd/cv-exchange.xsd";
    public static final String JAXB_SCHEMA_LOCATION = "http://www.bidib.org/jbidibc/schema/cvexchange xsd/cv-exchange.xsd";
    private static volatile XMLInputFactory xmlInputFactory;
    private static volatile JAXBContext jaxbContext;

    public static SaveCV loadCV(String filePath) throws FileNotFoundException {
        SaveCV saveCV = null;
        InputStream is = null;
        try {
            if (filePath.startsWith("/")) {
                is = CvExchangeFactory.class.getResourceAsStream(filePath);
            } else {
                File file = new File(filePath);
                is = new FileInputStream(file);
            }
            saveCV = new CvExchangeFactory().loadCV(is);
            LOGGER.trace("Loaded saveCV: {}", (Object)saveCV);
        }
        catch (FileNotFoundException ex) {
            LOGGER.warn("Load saved CV from file failed.", (Throwable)ex);
            throw ex;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close input stream failed.", (Throwable)ex);
                }
            }
        }
        return saveCV;
    }

    public SaveCV loadCV(InputStream is) {
        SaveCV saveCV = null;
        try {
            if (xmlInputFactory == null) {
                XMLInputFactory factory = XMLInputFactory.newInstance();
                factory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
                factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
                factory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
                factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                factory.setXMLResolver(new XMLResolver(){

                    @Override
                    public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                        throw new XMLStreamException("Reading external entities is disabled");
                    }
                });
                xmlInputFactory = factory;
            }
            if (jaxbContext == null) {
                jaxbContext = JAXBContext.newInstance((String)JAXB_PACKAGE);
            }
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSource = new StreamSource(CvExchangeFactory.class.getResourceAsStream(XSD_LOCATION));
            Schema schema = schemaFactory.newSchema(streamSource);
            unmarshaller.setSchema(schema);
            saveCV = (SaveCV)unmarshaller.unmarshal(xmlInputFactory.createXMLStreamReader(is));
        }
        catch (JAXBException | XMLStreamException | SAXException ex) {
            LOGGER.warn("Load SaveCV from file failed.", ex);
            throw new RuntimeException("Load SaveCV from file failed.");
        }
        return saveCV;
    }

    public static void saveCV(SaveCV saveCV, File file) {
        LOGGER.info("Save saveCV content, saveCV: {}, file: {}", (Object)saveCV, (Object)file);
        OutputStream os = null;
        boolean passed = false;
        try {
            if (jaxbContext == null) {
                jaxbContext = JAXBContext.newInstance((String)JAXB_PACKAGE);
            }
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.schemaLocation", (Object)JAXB_SCHEMA_LOCATION);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSource = new StreamSource(CvExchangeFactory.class.getResourceAsStream(XSD_LOCATION));
            Schema schema = schemaFactory.newSchema(new Source[]{streamSource});
            marshaller.setSchema(schema);
            os = new BufferedOutputStream(new FileOutputStream(file));
            marshaller.marshal((Object)saveCV, (Writer)new OutputStreamWriter(os, Charset.forName("UTF-8")));
            os.flush();
            LOGGER.info("Save saveCV content to file passed: {}", (Object)file);
            passed = true;
        }
        catch (Exception ex) {
            LOGGER.warn("Save saveCV failed.", (Throwable)ex);
            throw new RuntimeException("Save saveCV failed.", ex);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close outputstream failed.", (Throwable)ex);
                }
            }
            if (!passed) {
                LOGGER.warn("Delete the file because the copy has failed.");
                FileUtils.deleteQuietly((File)file);
            }
        }
    }
}

