/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.core.schema;

import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.bidib.jbidibc.core.schema.BidibFactory;
import org.bidib.jbidibc.core.schema.decodervendor.DecoderVendorType;
import org.bidib.jbidibc.core.schema.decodervendor.VendorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class DecoderVendorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecoderVendorFactory.class);
    private static final String JAXB_PACKAGE = "org.bidib.jbidibc.core.schema.decodervendor";
    public static final String XSD_LOCATION = "/xsd/decoderVendor.xsd";
    private static List<VendorType> decoderVendors;

    private DecoderVendorFactory() {
    }

    public static synchronized List<VendorType> getDecoderVendors() {
        if (decoderVendors == null) {
            LOGGER.info("Load and cache the decoder vendors.");
            decoderVendors = new DecoderVendorFactory().loadDecoderVendors();
        }
        return decoderVendors;
    }

    private List<VendorType> loadDecoderVendors() {
        String fileName = "/xml/protocol/DecoderIndex.bidib";
        InputStream is = BidibFactory.class.getResourceAsStream("/xml/protocol/DecoderIndex.bidib");
        if (is != null) {
            DecoderVendorType decoderVendor = this.loadDecoderVendorFile(is);
            if (decoderVendor != null) {
                try {
                    List<VendorType> vendors = decoderVendor.getVendor();
                    LOGGER.info("Loaded number of vendors: {}", (Object)vendors.size());
                    return vendors;
                }
                catch (Exception ex) {
                    LOGGER.warn("Get the vendors failed.", (Throwable)ex);
                }
            }
        } else {
            LOGGER.warn("Load DecoderIndex.bidib file failed.");
        }
        return null;
    }

    private DecoderVendorType loadDecoderVendorFile(InputStream is) {
        DecoderVendorType decoderVendor = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)JAXB_PACKAGE);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSource = new StreamSource(BidibFactory.class.getResourceAsStream(XSD_LOCATION));
            Schema schema = schemaFactory.newSchema(streamSource);
            unmarshaller.setSchema(schema);
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader xmlr = factory.createXMLStreamReader(is);
            JAXBElement jaxbElement = unmarshaller.unmarshal(xmlr, DecoderVendorType.class);
            decoderVendor = (DecoderVendorType)jaxbElement.getValue();
        }
        catch (JAXBException | XMLStreamException | SAXException ex) {
            LOGGER.warn("Load content from input stream failed failed.", ex);
        }
        return decoderVendor;
    }

    public static String getDecoderVendorName(List<VendorType> vendors, int vendorId) {
        for (VendorType vendor : vendors) {
            if (vendor.getId() != vendorId) continue;
            return vendor.getName();
        }
        return null;
    }
}

