/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.core.schema;

import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;

public class IndentingXMLEventWriter
implements XMLEventWriter {
    private static final Logger logger = Logger.getLogger(IndentingXMLEventWriter.class.getName());
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final Map<Integer, String> indentCache = new HashMap<Integer, String>();
    private final XMLEventFactory xmlEventFactory;
    private final Deque<Set<State>> scopeState = new LinkedList<Set<State>>();
    private final XMLEventWriter out;
    private int indentSize = 2;
    private int depth = 0;

    public IndentingXMLEventWriter(XMLEventWriter out) {
        this.out = out;
        this.xmlEventFactory = XMLEventFactory.newFactory();
        this.scopeState.add(EnumSet.noneOf(State.class));
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.out.getNamespaceContext();
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.out.setNamespaceContext(context);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.out.setDefaultNamespace(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.out.setPrefix(prefix, uri);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.out.getPrefix(uri);
    }

    @Override
    public void add(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            this.add(reader.nextEvent());
        }
    }

    @Override
    public void flush() throws XMLStreamException {
        this.out.flush();
    }

    @Override
    public void close() throws XMLStreamException {
        this.out.close();
    }

    public void setIndentSize(int indentSize) {
        this.indentSize = indentSize;
    }

    private static String repeat(char ch, int repeat) {
        if (repeat <= 0) {
            return "";
        }
        char[] buf = new char[repeat];
        for (int i = repeat - 1; i >= 0; --i) {
            buf[i] = ch;
        }
        return new String(buf);
    }

    @Override
    public void add(XMLEvent event) throws XMLStreamException {
        switch (event.getEventType()) {
            case 4: 
            case 6: 
            case 12: {
                this.out.add(event);
                this.afterData();
                return;
            }
            case 1: {
                this.beforeStartElement();
                this.out.add(event);
                this.afterStartElement();
                return;
            }
            case 2: {
                this.beforeEndElement();
                this.out.add(event);
                this.afterEndElement();
                return;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: {
                this.beforeMarkup();
                this.out.add(event);
                this.afterMarkup();
                return;
            }
            case 8: {
                this.out.add(event);
                break;
            }
            default: {
                this.out.add(event);
                this.afterEndDocument();
            }
        }
    }

    private void beforeMarkup() {
        Set<State> state = this.scopeState.getFirst();
        if (!(state.contains((Object)State.WROTE_DATA) || this.depth <= 0 && state.isEmpty())) {
            String indent = this.getIndent(this.depth, this.indentSize);
            Characters indentEvent = this.xmlEventFactory.createCharacters(indent);
            try {
                this.out.add(indentEvent);
            }
            catch (XMLStreamException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            this.afterMarkup();
        }
    }

    private void afterMarkup() {
        Set<State> state = this.scopeState.getFirst();
        state.add(State.WROTE_MARKUP);
    }

    private void afterData() {
        Set<State> state = this.scopeState.getFirst();
        state.add(State.WROTE_DATA);
    }

    private void beforeStartElement() {
        this.beforeMarkup();
    }

    private void afterStartElement() {
        this.afterMarkup();
        ++this.depth;
        this.scopeState.push(EnumSet.noneOf(State.class));
    }

    private void beforeEndElement() {
        Set<State> state = this.scopeState.getFirst();
        if (this.depth > 0 && state.contains((Object)State.WROTE_MARKUP) && !state.contains((Object)State.WROTE_DATA)) {
            String indent = this.getIndent(this.depth - 1, this.indentSize);
            Characters indentEvent = this.xmlEventFactory.createCharacters(indent);
            try {
                this.out.add(indentEvent);
            }
            catch (XMLStreamException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private void afterEndElement() {
        if (this.depth > 0) {
            --this.depth;
            this.scopeState.pop();
        }
    }

    private void afterEndDocument() {
        this.depth = 0;
        this.scopeState.clear();
        this.scopeState.push(EnumSet.noneOf(State.class));
    }

    private String getIndent(int depth, int size) {
        int length = depth * size;
        Object indent = this.indentCache.get(length);
        if (indent == null) {
            indent = LINE_SEPARATOR + IndentingXMLEventWriter.repeat(' ', length);
            this.indentCache.put(length, (String)indent);
        }
        return indent;
    }

    private static enum State {
        WROTE_MARKUP,
        WROTE_DATA;

    }
}

