/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.core.schema;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.bidib.jbidibc.core.schema.decoder.commontypes.DecoderTypeType;
import org.bidib.jbidibc.core.schema.decoder.commontypes.VersionType;
import org.bidib.jbidibc.core.schema.decoder.userdevices.UserDeviceType;
import org.bidib.jbidibc.core.schema.decoder.userdevices.UserDevicesList;
import org.bidib.jbidibc.core.schema.decoder.userdevices.UserDevicesType;
import org.bidib.jbidibc.core.schema.exception.InvalidContentException;
import org.bidib.jbidibc.core.schema.validation.XsdValidationLoggingErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class UserDevicesListFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserDevicesListFactory.class);
    private static final String JAXB_PACKAGE = "org.bidib.jbidibc.core.schema.decoder.userdevices";
    public static final String XSD_LOCATION_BASE = "/xsd/commonTypes.xsd";
    public static final String XSD_LOCATION = "/xsd/userDevices.xsd";

    private UserDevicesListFactory() {
    }

    public static UserDevicesList getUserDevicesList(File userDevicesFile) {
        return new UserDevicesListFactory().loadUserDevicesFile(userDevicesFile);
    }

    private UserDevicesList loadUserDevicesFile(File userDevicesFile) {
        UserDevicesList userDevicesList = null;
        try (FileInputStream is = new FileInputStream(userDevicesFile);){
            userDevicesList = this.loadUserDevicesList(is);
        }
        catch (IOException ex) {
            LOGGER.info("No UserDevicesList file found.");
        }
        return userDevicesList;
    }

    private UserDevicesList loadUserDevicesList(InputStream is) {
        UserDevicesList userDevicesList = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)JAXB_PACKAGE);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSource = new StreamSource(UserDevicesListFactory.class.getResourceAsStream(XSD_LOCATION));
            StreamSource streamSourceBase = new StreamSource(UserDevicesListFactory.class.getResourceAsStream(XSD_LOCATION_BASE));
            Schema schema = schemaFactory.newSchema(new Source[]{streamSourceBase, streamSource});
            unmarshaller.setSchema(schema);
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader xmlr = factory.createXMLStreamReader(is);
            JAXBElement jaxbElement = unmarshaller.unmarshal(xmlr, UserDevicesList.class);
            userDevicesList = (UserDevicesList)jaxbElement.getValue();
        }
        catch (JAXBException | XMLStreamException | SAXException ex) {
            LOGGER.warn("Load content from input stream failed failed.", ex);
            List<String> errors = this.validate(is);
            throw new InvalidContentException("Load userDevicesList failed.", errors);
        }
        return userDevicesList;
    }

    public static List<UserDeviceType> findUserDevices(DecoderTypeType deviceType, List<UserDeviceType> source) {
        List<UserDeviceType> filtered = source.stream().filter(device -> deviceType.equals((Object)device.getDeviceType())).collect(Collectors.toList());
        return filtered;
    }

    public static List<UserDeviceType> findUserDevices(List<UserDeviceType> source, DecoderTypeType ... deviceType) {
        ArrayList<DecoderTypeType> decoderTypes = new ArrayList<DecoderTypeType>();
        decoderTypes.addAll(Arrays.asList(deviceType));
        List<UserDeviceType> filtered = source.stream().filter(device -> decoderTypes.contains((Object)device.getDeviceType())).collect(Collectors.toList());
        return filtered;
    }

    public static void saveUserDevicesList(UserDevicesList userDevicesList, File file) {
        LOGGER.info("Save user devices list to file: {}", (Object)file.getPath());
        OutputStream os = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)JAXB_PACKAGE);
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)StandardCharsets.UTF_8.name());
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSource = new StreamSource(UserDevicesListFactory.class.getResourceAsStream(XSD_LOCATION));
            StreamSource streamSourceBase = new StreamSource(UserDevicesListFactory.class.getResourceAsStream(XSD_LOCATION_BASE));
            Schema schema = schemaFactory.newSchema(new Source[]{streamSourceBase, streamSource});
            marshaller.setSchema(schema);
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            marshaller.marshal((Object)userDevicesList, (Writer)new OutputStreamWriter((OutputStream)bas, StandardCharsets.UTF_8));
            os = new BufferedOutputStream(new FileOutputStream(file));
            os.write(bas.toByteArray());
            os.flush();
            LOGGER.info("Save userDevicesList content to file passed: {}", (Object)file.getPath());
        }
        catch (Exception ex) {
            LOGGER.warn("Save userDevicesList failed.", (Throwable)ex);
            throw new RuntimeException("Save userDevicesList failed.", ex);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close outputstream failed.", (Throwable)ex);
                }
            }
        }
    }

    private List<String> validate(InputStream is) {
        List<String> errors = null;
        if (is instanceof FileInputStream) {
            FileInputStream fis = (FileInputStream)is;
            try {
                LOGGER.info("Try to set file position to 0.");
                fis.getChannel().position(0L);
            }
            catch (IOException e) {
                LOGGER.warn("Set file position to 0 failed.", (Throwable)e);
            }
        }
        StreamSource inputStreamSource = new StreamSource(is);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource streamSource = new StreamSource(UserDevicesListFactory.class.getResourceAsStream(XSD_LOCATION));
        XsdValidationLoggingErrorHandler errorHandler = new XsdValidationLoggingErrorHandler();
        try {
            Schema schema = schemaFactory.newSchema(streamSource);
            Validator validator = schema.newValidator();
            validator.setErrorHandler(errorHandler);
            validator.validate(inputStreamSource);
        }
        catch (IOException ex) {
            LOGGER.warn("Validate failed.", (Throwable)ex);
        }
        catch (SAXException ex) {
            LOGGER.warn("Validate failed.", (Throwable)ex);
        }
        errors = errorHandler.getErrors();
        LOGGER.info("Found errors: {}", errors);
        return errors;
    }

    public static UserDevicesList prepareEmptyList(Date created) {
        XMLGregorianCalendar createdDate = null;
        try {
            LocalDateTime now = LocalDateTime.now();
            createdDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(now.toString());
        }
        catch (DatatypeConfigurationException ex) {
            LOGGER.warn("Create the XML gregorian calendar failed.", (Throwable)ex);
        }
        UserDevicesList userDevicesList = new UserDevicesList();
        userDevicesList.withVersion(new VersionType().withAuthor("Wizard").withCreatedBy("Wizard").withLastUpdate("2018-03-08T07:35:49").withCreated(createdDate).withCreatorLink("http://bidib.org"));
        userDevicesList.withUserDevices(new UserDevicesType());
        return userDevicesList;
    }
}

