/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.core.schema.bidiblabels;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.io.FileUtils;
import org.bidib.jbidibc.core.schema.bidibbase.PortType;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.ObjectFactory;
import org.bidib.jbidibc.core.schema.bidiblabels.PortLabel;
import org.bidib.jbidibc.core.schema.exception.InvalidContentException;
import org.bidib.jbidibc.core.schema.validation.XsdValidationLoggingErrorHandler;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.exception.UnexpectedCharacterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LabelFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LabelFactory.class);
    public static final String XSD_LOCATION = "/xsd/bidib2Labels.xsd";
    public static final String XSD_LOCATION_BASE = "/xsd/bidib2Base.xsd";
    public static final String JAXB_SCHEMA_LOCATION = "http://www.bidib.org/schema/nodeLabels/1.0 xsd/bidib2Labels.xsd";
    private static JAXBContext jaxbContext;

    public static void initJaxbContext() {
        if (jaxbContext == null) {
            LOGGER.info("Create the jaxb context for JAXB_PACKAGE: {}", (Object)NodeLabels.class.getPackage());
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{NodeLabels.class});
            }
            catch (JAXBException ex) {
                LOGGER.warn("Init the JAXB context failed for JAXB_PACKAGE: {}", (Object)NodeLabels.class.getPackage(), (Object)ex);
            }
            LOGGER.info("Finished create the jaxb context for JAXB_PACKAGE: {}", (Object)NodeLabels.class.getPackage());
        }
    }

    public static String prepareNodeFilename(long uniqueId) {
        String nodeFileName = String.format("Node_%014X.xml", uniqueId);
        return nodeFileName;
    }

    public static String prepareLookupNodeFilename(long uniqueId) {
        String uniqueIdPart = String.format("%014X.xml", uniqueId);
        String nodeFileName = String.format("Node_??%s", uniqueIdPart.substring(2));
        return nodeFileName;
    }

    public synchronized void saveNodeLabel(NodeLabels nodeLabels, File file, boolean gzip) {
        LOGGER.debug("Save nodeLabels to file: {}, nodeLabels: {}", (Object)file, (Object)nodeLabels);
        OutputStream os = null;
        boolean passed = false;
        try {
            if (jaxbContext == null) {
                LOGGER.info("Create the jaxb context for JAXB_PACKAGE: {}", (Object)NodeLabels.class.getPackage());
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{NodeLabels.class});
            }
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.schemaLocation", (Object)JAXB_SCHEMA_LOCATION);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSource = new StreamSource(LabelFactory.class.getResourceAsStream(XSD_LOCATION));
            StreamSource streamSourceBase = new StreamSource(LabelFactory.class.getResourceAsStream(XSD_LOCATION_BASE));
            Schema schema = schemaFactory.newSchema(new Source[]{streamSourceBase, streamSource});
            marshaller.setSchema(schema);
            os = new BufferedOutputStream(new FileOutputStream(file));
            if (gzip) {
                LOGGER.debug("Use gzip to compress accessories.");
                os = new GZIPOutputStream(os);
            }
            JAXBElement<NodeLabels> jaxbElement = new ObjectFactory().createNodeLabels(nodeLabels);
            marshaller.marshal(jaxbElement, (Writer)new OutputStreamWriter(os, StandardCharsets.UTF_8));
            os.flush();
            LOGGER.info("Save nodeLabels to file passed: {}", (Object)file.getPath());
            passed = true;
        }
        catch (Exception ex) {
            LOGGER.warn("Save nodeLabels failed, file: {}", (Object)file, (Object)ex);
            InvalidConfigurationException icex = new InvalidConfigurationException("Save nodeLabels failed.", (Throwable)ex);
            icex.setReason(file.getAbsolutePath());
            throw icex;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close outputstream failed.", (Throwable)ex);
                }
            }
            if (!passed) {
                LOGGER.warn("Delete the file because the export has failed.");
                FileUtils.deleteQuietly((File)file);
            }
        }
    }

    public synchronized NodeLabels loadLabels(InputStream is) {
        NodeLabels nodeLabels = null;
        try {
            if (jaxbContext == null) {
                LOGGER.info("Create the jaxb context for JAXB_PACKAGE: {}", (Object)NodeLabels.class.getPackage());
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{NodeLabels.class});
            }
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSource = new StreamSource(LabelFactory.class.getResourceAsStream(XSD_LOCATION));
            StreamSource streamSourceBase = new StreamSource(LabelFactory.class.getResourceAsStream(XSD_LOCATION_BASE));
            Schema schema = schemaFactory.newSchema(new Source[]{streamSourceBase, streamSource});
            unmarshaller.setSchema(schema);
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader xmlr = factory.createXMLStreamReader(is);
            try {
                JAXBElement jaxbElement = unmarshaller.unmarshal(xmlr, NodeLabels.class);
                nodeLabels = (NodeLabels)jaxbElement.getValue();
            }
            catch (UnmarshalException ex) {
                LOGGER.warn("Load content from file failed due to an unmarshal exception.", (Throwable)ex);
                if (ex.getLinkedException() instanceof SAXParseException) {
                    throw (SAXParseException)ex.getLinkedException();
                }
                if (ex.getLinkedException() instanceof SAXException) {
                    List<String> errors = this.validate(is);
                    throw new InvalidContentException("Load NodeLabels from file failed.", errors);
                }
                if (ex.getCause() instanceof XMLStreamException) {
                    XMLStreamException wex = (XMLStreamException)ex.getCause();
                    LOGGER.warn("The inner exception signals an unexpected character.", (Throwable)wex);
                    throw new UnexpectedCharacterException(wex.getMessage());
                }
            }
        }
        catch (SAXParseException ex) {
            LOGGER.warn("Load content from file failed.", (Throwable)ex);
            XsdValidationLoggingErrorHandler errorHandler = new XsdValidationLoggingErrorHandler();
            try {
                errorHandler.error(ex);
            }
            catch (SAXException e) {
                LOGGER.warn("Add error failed.", (Throwable)e);
            }
            List<String> errors = errorHandler.getErrors();
            throw new InvalidContentException("Load content from labels file failed.", errors);
        }
        catch (JAXBException | XMLStreamException | SAXException ex) {
            LOGGER.warn("Load content from file failed.", ex);
            List<String> errors = this.validate(is);
            throw new InvalidContentException("Load content from labels file failed.", errors);
        }
        return nodeLabels;
    }

    private List<String> validate(InputStream is) {
        List<String> errors = null;
        if (is instanceof FileInputStream) {
            FileInputStream fis = (FileInputStream)is;
            try {
                LOGGER.info("Try to set file position to 0.");
                fis.getChannel().position(0L);
            }
            catch (IOException e) {
                LOGGER.warn("Set file position to 0 failed.", (Throwable)e);
            }
        }
        StreamSource inputStreamSource = new StreamSource(is);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource streamSource = new StreamSource(LabelFactory.class.getResourceAsStream(XSD_LOCATION));
        XsdValidationLoggingErrorHandler errorHandler = new XsdValidationLoggingErrorHandler();
        try {
            Schema schema = schemaFactory.newSchema(streamSource);
            Validator validator = schema.newValidator();
            validator.setErrorHandler(errorHandler);
            validator.validate(inputStreamSource);
        }
        catch (IOException ex) {
            LOGGER.warn("Validate failed.", (Throwable)ex);
        }
        catch (SAXParseException ex) {
            LOGGER.warn("Validate failed.", (Throwable)ex);
            if (ex.getMessage() != null && CollectionUtils.isEmpty(errorHandler.getErrors())) {
                try {
                    errorHandler.error(ex);
                }
                catch (SAXException e) {
                    LOGGER.warn("Add error failed.", (Throwable)e);
                }
            }
        }
        catch (SAXException ex) {
            LOGGER.warn("Validate failed.", (Throwable)ex);
        }
        errors = errorHandler.getErrors();
        LOGGER.info("Found errors: {}", errors);
        return errors;
    }

    public static List<PortLabel> getPortsOfType(List<PortLabel> allPorts, final PortType type) {
        List selection = ListUtils.select(allPorts, (Predicate)new Predicate<PortLabel>(){

            public boolean evaluate(PortLabel portLabel) {
                return portLabel.type == type;
            }
        });
        return selection;
    }
}

