/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages;

import org.bidib.jbidibc.messages.utils.AccessoryStateUtils;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class AccessoryState {
    private final byte accessoryNumber;
    private final Integer activeAspect;
    private final byte total;
    private final byte execute;
    private final byte wait;

    public AccessoryState(byte accessoryNumber, byte aspect, byte total, byte execute, byte wait) {
        this.accessoryNumber = accessoryNumber;
        this.activeAspect = ByteUtils.getInteger(aspect);
        this.total = total;
        this.execute = execute;
        this.wait = wait;
    }

    public byte getAccessoryNumber() {
        return this.accessoryNumber;
    }

    public Integer getActiveAspect() {
        return this.activeAspect;
    }

    public byte getTotal() {
        return this.total;
    }

    public byte getExecute() {
        return this.execute;
    }

    public int getWait() {
        int remainingTime = 0;
        switch (this.wait & 0x80) {
            case 0: {
                remainingTime = (this.wait & 0x7F) * 100;
                break;
            }
            default: {
                remainingTime = (this.wait & 0x7F) * 1000;
            }
        }
        return remainingTime;
    }

    public boolean hasError() {
        return (this.execute & 0x80) == 128;
    }

    public boolean hasMoreErrors() {
        if (this.hasError()) {
            return (this.wait & 0x40) == 64;
        }
        return false;
    }

    public Integer getErrorCode() {
        if (this.hasError()) {
            return this.wait & 0x3F;
        }
        return null;
    }

    public String getErrorInformation() {
        if (this.hasError()) {
            StringBuilder sb = new StringBuilder();
            int errorVal = ByteUtils.getInt(this.wait);
            boolean moreErrorsAvailable = (errorVal & 0x40) == 64;
            sb.append("Error detected: ");
            switch (errorVal & 0x3F) {
                case 0: {
                    sb.append("0x00: no error (remaining)");
                    break;
                }
                case 1: {
                    sb.append("0x01: command was not executable / unknown command / unknown aspect.");
                    break;
                }
                case 2: {
                    sb.append("0x02: power consumption too high.");
                    break;
                }
                case 3: {
                    sb.append("0x03: power supply below limits, function not garanteed.");
                    break;
                }
                case 4: {
                    sb.append("0x04: fuse blown.");
                    break;
                }
                case 5: {
                    sb.append("0x05: temperature too high.");
                    break;
                }
                case 6: {
                    sb.append("0x06: feedback error / unwanted change of position.");
                    break;
                }
                case 7: {
                    sb.append("0x07: manual control (eg. with local button)");
                    break;
                }
                case 16: {
                    sb.append("0x10: bulb out of order.");
                    break;
                }
                case 32: {
                    sb.append("0x20: servo out of order.");
                    break;
                }
                case 63: {
                    sb.append("0x3F: internal error (eg. selftest, checksum error, ..).");
                    break;
                }
                default: {
                    sb.append("Unknown error: ").append(ByteUtils.byteToHex(errorVal & 0x3F));
                }
            }
            sb.append(", more errors pending: ").append(moreErrorsAvailable);
            return sb.toString();
        }
        if (this.activeAspect == 255) {
            return "Unknown aspect state. Check previous errors.";
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[ ");
        sb.append(this.getClass().getSimpleName());
        sb.append(", accessoryNumber: ").append(ByteUtils.getInt(this.accessoryNumber));
        sb.append(", aspect: ").append(this.activeAspect);
        sb.append(", total: ").append(ByteUtils.getInt(this.total));
        sb.append(", execute: ").append(ByteUtils.getInt(this.execute));
        boolean errorDetected = false;
        if (this.hasError()) {
            sb.append(" => Error detected.");
            errorDetected = true;
        } else if (this.activeAspect == 255) {
            sb.append("=> Unknown aspect state. Check previous errors.");
        } else {
            sb.append("[");
            sb.append(AccessoryStateUtils.getOperationResult(this.execute));
            sb.append("]");
        }
        if (!errorDetected) {
            int remainingTime = 0;
            switch (this.wait & 0x80) {
                case 0: {
                    remainingTime = (this.wait & 0x7F) * 100;
                    break;
                }
                default: {
                    remainingTime = (this.wait & 0x7F) * 1000;
                }
            }
            sb.append(", remaing wait time: ").append(remainingTime).append("ms");
        } else {
            int errorVal = ByteUtils.getInt(this.wait);
            boolean moreErrorsAvailable = (errorVal & 0x40) == 64;
            sb.append(", more errors pending: ").append(moreErrorsAvailable).append(", error: ");
            switch (errorVal & 0x3F) {
                case 0: {
                    sb.append("no error (remaining)");
                    break;
                }
                case 1: {
                    sb.append("command was not executable / unknown command / unknown aspect.");
                    break;
                }
                case 2: {
                    sb.append("power consumption too high.");
                    break;
                }
                case 3: {
                    sb.append("power supply below limits, function not garanteed.");
                    break;
                }
                case 4: {
                    sb.append("fuse blown.");
                    break;
                }
                case 5: {
                    sb.append("temperature too high.");
                    break;
                }
                case 6: {
                    sb.append("feedback error / unwanted change of position.");
                    break;
                }
                case 7: {
                    sb.append("manual control (eg. with local button)");
                    break;
                }
                case 16: {
                    sb.append("bulb out of order.");
                    break;
                }
                case 32: {
                    sb.append("servo out of order.");
                    break;
                }
                case 63: {
                    sb.append("internal error (eg. selftest, checksum error, ..).");
                    break;
                }
                default: {
                    sb.append("Unknown error: ").append(ByteUtils.byteToHex(errorVal));
                }
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

