/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;
import org.bidib.jbidibc.messages.accessory.ByteOptionsValue;
import org.bidib.jbidibc.messages.accessory.OptionsValue;
import org.bidib.jbidibc.messages.enums.AccessoryStateOptionsKeys;
import org.bidib.jbidibc.messages.logger.Logger;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class AccessoryStateOptions {
    private final byte[] optionsData;

    public AccessoryStateOptions(byte[] data, int offset) {
        this.optionsData = ByteUtils.subArray(data, offset);
    }

    public byte[] getOptionsData() {
        return this.optionsData;
    }

    public Options getOptions(Logger logger) {
        Options options = null;
        if (this.optionsData.length > 0) {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(this.optionsData);){
                options = new Options();
                while (bais.available() > 0) {
                    byte pEnum = ByteUtils.getLowByte(bais.read());
                    if ((pEnum & 0x80) == 128 || (pEnum & 0x40) == 64) continue;
                    byte[] byteVal = new byte[1];
                    bais.read(byteVal);
                    Byte byteValue = byteVal[0];
                    options.values.put(pEnum, new ByteOptionsValue(byteValue));
                }
            }
            catch (Exception ex) {
                logger.warn("Read content of accessory state options failed.", ex);
            }
        }
        return options;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[ ");
        sb.append(this.getClass().getSimpleName());
        sb.append("optionsData: ").append(ByteUtils.bytesToHex(this.optionsData));
        sb.append("]");
        return sb.toString();
    }

    public static class Options {
        private Map<Byte, OptionsValue<?>> values = new HashMap();

        public <T> T getOptionsValue(Byte key) {
            return (T)this.values.get(key).getValue();
        }

        public <T> T getOptionsValue(AccessoryStateOptionsKeys optionsKey) {
            return (T)this.values.get(optionsKey.getType());
        }
    }
}

