/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages;

import java.util.Arrays;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.enums.PortType;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class BidibPort {
    private byte[] values;

    public BidibPort(byte[] values) {
        if (values == null || values.length != 2) {
            throw new IllegalArgumentException("BidibPort accepts only 2 byte values. Provided values: " + values);
        }
        this.values = values;
    }

    public byte[] getValues() {
        return this.values;
    }

    public byte getLowValue() {
        return this.values[0];
    }

    public byte getHighValue() {
        return this.values[1];
    }

    public static BidibPort prepareBidibPort(int portNumber) {
        return new BidibPort(new byte[]{ByteUtils.getLowByte(portNumber), ByteUtils.getHighByte(portNumber)});
    }

    public static BidibPort prepareBidibPort(byte lowByte, byte highByte) {
        return new BidibPort(new byte[]{lowByte, highByte});
    }

    public static BidibPort prepareBidibPortNa() {
        return BidibPort.prepareBidibPort((byte)-1, (byte)-1);
    }

    public static BidibPort prepareBidibPort(PortModelEnum portModelEnum, LcOutputType lcOutputType, int port) {
        BidibPort bidibPort = null;
        bidibPort = portModelEnum == PortModelEnum.type ? new BidibPort(new byte[]{lcOutputType.getType(), ByteUtils.getLowByte(port)}) : new BidibPort(new byte[]{ByteUtils.getLowByte(port), ByteUtils.getHighByte(port)});
        return bidibPort;
    }

    public static BidibPort prepareBidibPort(PortModelEnum portModelEnum, PortType portType, int port) {
        BidibPort bidibPort = null;
        bidibPort = portModelEnum == PortModelEnum.type ? new BidibPort(new byte[]{portType.getType(), ByteUtils.getLowByte(port)}) : new BidibPort(new byte[]{ByteUtils.getLowByte(port), ByteUtils.getHighByte(port)});
        return bidibPort;
    }

    public static BidibPort prepareSystemFunctionBidibPort(PortModelEnum portModel, byte lowByte, byte highByte) {
        BidibPort bidibPort = null;
        bidibPort = portModel == PortModelEnum.type ? BidibPort.prepareBidibPort((byte)0, lowByte) : BidibPort.prepareBidibPort(lowByte, highByte);
        return bidibPort;
    }

    public LcOutputType getPortType(PortModelEnum portModel) {
        LcOutputType outputType = null;
        switch (portModel) {
            case flat_extended: 
            case flat: {
                outputType = LcOutputType.SWITCHPORT;
                break;
            }
            default: {
                outputType = LcOutputType.valueOf(this.values[0]);
            }
        }
        return outputType;
    }

    public int getPortNumber(PortModelEnum portModel) {
        int portNumber = -1;
        switch (portModel) {
            case flat_extended: {
                portNumber = ByteUtils.getInt(this.values[0], ByteUtils.getLowByte(this.values[1], 127));
                break;
            }
            case flat: {
                portNumber = ByteUtils.getInt(this.values[0]);
                break;
            }
            default: {
                portNumber = ByteUtils.getInt(this.values[1], 127);
            }
        }
        return portNumber;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BidibPort) {
            BidibPort other = (BidibPort)obj;
            return Arrays.equals(this.values, other.values);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BidibPort[low=");
        sb.append(ByteUtils.getInt(this.values[0])).append(",high=").append(ByteUtils.getInt(this.values[1])).append("]");
        return sb.toString();
    }
}

