/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages;

import org.bidib.jbidibc.messages.DccAInfoIndexed;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class DccAInfoShortInfo
extends DccAInfoIndexed {
    public DccAInfoShortInfo(int index, byte[] data) {
        super(index, data);
    }

    public DecoderType getDecoderType() {
        int decoderTypeValue = ByteUtils.getBit(this.data[0], 7);
        return DecoderType.values()[decoderTypeValue];
    }

    public DecoderTypeAddInfo getDecoderTypeAddInfo() {
        DecoderType decoderType = this.getDecoderType();
        int decoderTypeAddInfoValue = ByteUtils.getBit(this.data[0], 6);
        switch (decoderType) {
            case accessory: {
                decoderTypeAddInfoValue += 2;
                break;
            }
        }
        return DecoderTypeAddInfo.values()[decoderTypeAddInfoValue];
    }

    public int getDemandedLocoAddressHigh() {
        int addrHigh = ByteUtils.getInt(this.data[0], 63);
        return addrHigh;
    }

    public int getDemandedLocoAddressLow() {
        int addrLow = ByteUtils.getInt(this.data[1]);
        return addrLow;
    }

    public int getDemandedLocoAddress() {
        int addrHigh = ByteUtils.getInt(this.data[0], 63);
        int addrLow = ByteUtils.getInt(this.data[1]);
        return addrHigh << 8 | addrLow;
    }

    public boolean isMotorLoadControlled() {
        return ByteUtils.isBitSetEqual(this.data[2], 1, 6);
    }

    public boolean isConsistAddressActive() {
        return ByteUtils.isBitSetEqual(this.data[2], 1, 5);
    }

    public int getFunctionsCount() {
        int functionsCount = ByteUtils.getInt(this.data[2], 31);
        return functionsCount;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[DccAInfoShortInfo, index: ");
        sb.append(this.index).append(", data: ").append(ByteUtils.bytesToHex(this.data));
        sb.append("]");
        return sb.toString();
    }

    public static enum DecoderTypeAddInfo {
        motorDecoder,
        functionDecoder,
        accessoryStandard,
        accessoryExtended;

    }

    public static enum DecoderType {
        loco,
        accessory;

    }
}

