/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class DccATidData {
    private final int cid;
    private final int sid;

    public DccATidData(int cid, int sid) {
        this.cid = cid;
        this.sid = sid;
    }

    public int getCid() {
        return this.cid;
    }

    public int getSid() {
        return this.sid;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[cid=" + this.cid + ", sid=" + this.sid + "]";
    }

    public void writeToStream(ByteArrayOutputStream out) {
        out.write(ByteUtils.getLowByte(this.cid));
        out.write(ByteUtils.getHighByte(this.cid));
        out.write((byte)this.sid & 0xFF);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DccATidData) {
            DccATidData other = (DccATidData)obj;
            if (this.sid == other.sid && this.cid == other.cid) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hc = 17;
        int hashMultiplier = 59;
        hc = hc * hashMultiplier + this.cid;
        hc = hc * hashMultiplier + this.sid;
        return hc;
    }

    public static DccATidData fromByteArray(byte[] data, int offset) {
        if (data.length < offset + 3) {
            throw new IllegalArgumentException("The size of the provided data does not meet the expected length (>=5). Provided length: " + data.length);
        }
        int cid = ByteUtils.getWORD(data, offset);
        int sid = ByteUtils.getInt(data[offset + 2]);
        DccATidData tidData = new DccATidData(cid, sid);
        return tidData;
    }
}

